/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.pc.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.tsc.common.vo.KResumeBO;
import kd.tsc.tsirm.business.domain.pc.factory.PCServiceFactory;
import kd.tsc.tsirm.business.domain.pc.service.AbstractEmpCVService;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import org.apache.commons.lang3.ObjectUtils;

public class EmpCVHelper {
    private static final AbstractEmpCVService empCVService = PCServiceFactory.getEmpCVService();

    public static Long saveEmpCV(KResumeBO KResumeBO2) {
        DynamicObject empCV = KResumeBO2.getData();
        Long rsmId = EmpCVHelper.getRsmId(KResumeBO2);
        if (empCV != null) {
            String entityNumebr = empCV.getDataEntityType().getName();
            HRBaseServiceHelper serviceHelper = EmpCVHelper.getServiceHelper(entityNumebr);
            serviceHelper.saveOne(empCV);
        }
        Map dynCollMap = KResumeBO2.getDynCollMap();
        dynCollMap.forEach((entityNumber, obj) -> {
            HRBaseServiceHelper serviceHelper = EmpCVHelper.getServiceHelper(entityNumber);
            serviceHelper.deleteByFilter(new QFilter[]{new QFilter("rsm", "=", (Object)rsmId)});
            serviceHelper.save(obj);
        });
        return rsmId;
    }

    public static void saveEmpCVRel(DynamicObject rel) {
        HRBaseServiceHelper serviceHelper = EmpCVHelper.getServiceHelper("tsirm_empcvrel");
        serviceHelper.saveOne(rel);
    }

    public static Long getEmpCVId(Long userId) {
        DynamicObject rel = EmpCVHelper.queryEmpCVRel("account", userId);
        if (HRObjectUtils.isEmpty((Object)rel)) {
            return 0L;
        }
        DynamicObjectCollection entryentity = rel.getDynamicObjectCollection("entryentity");
        return entryentity != null && entryentity.size() > 0 ? ((DynamicObject)entryentity.stream().findFirst().get()).getLong("cvid") : 0L;
    }

    private static Long getRsmId(KResumeBO KResumeBO2) {
        DynamicObject empCV = KResumeBO2.getData();
        Long rsmId = 0L;
        if (empCV != null) {
            rsmId = empCV.getLong("id");
        } else {
            Map dynCollMap = KResumeBO2.getDynCollMap();
            if (!dynCollMap.isEmpty()) {
                Collection obj = dynCollMap.values();
                DynamicObjectCollection dynColl = (DynamicObjectCollection)obj;
                rsmId = ((DynamicObject)dynColl.stream().findFirst().get()).getLong("rsm");
            }
        }
        return rsmId;
    }

    public static DynamicObject queryEmpCVRel(String prop, Long objId) {
        QFilter qFilter = new QFilter(prop, "=", (Object)objId);
        HRBaseServiceHelper serviceHelper = EmpCVHelper.getServiceHelper("tsirm_empcvrel");
        return serviceHelper.loadDynamicObject(new QFilter[]{qFilter});
    }

    public static HRBaseServiceHelper getServiceHelper(String entityNumber) {
        return ServiceHelperCache.getHrBaseServiceHelper((String)entityNumber);
    }

    public static void setBaseFields(DynamicObject dyn) {
        DataEntityPropertyCollection properties = dyn.getDataEntityType().getProperties();
        List props = properties.stream().map(prop -> prop.getName()).collect(Collectors.toList());
        Long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        if (props.contains("creator") && dyn.get("creator") == null) {
            dyn.set("creator", (Object)currUserId);
        }
        if (props.contains("modifier")) {
            dyn.set("modifier", (Object)currUserId);
        }
        if (props.contains("createtime") && dyn.get("createtime") == null) {
            dyn.set("createtime", (Object)date);
        }
        if (props.contains("modifytime")) {
            dyn.set("modifytime", (Object)date);
        }
    }

    public static DynamicObject queryEmpDelivBill(String prop, Long objId) {
        QFilter qFilter = new QFilter(prop, "=", (Object)objId);
        HRBaseServiceHelper serviceHelper = EmpCVHelper.getServiceHelper("tsirm_empdelivbill");
        return serviceHelper.loadDynamicObject(new QFilter[]{qFilter});
    }

    public static List<Long> getEmpCVIds(Long userId) {
        DynamicObjectCollection entryentity;
        List<Long> empCVIdList = new ArrayList<Long>(8);
        DynamicObject rel = EmpCVHelper.queryEmpCVRel("account", userId);
        if (ObjectUtils.isNotEmpty((Object)rel) && ObjectUtils.isNotEmpty((Object)(entryentity = rel.getDynamicObjectCollection("entryentity")))) {
            empCVIdList = entryentity.stream().map(dynamicObject -> dynamicObject.getLong("cvid")).collect(Collectors.toList());
        }
        return empCVIdList;
    }
}

