/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.pc.helper;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class EmpDeliveryHelper {
    public static List<DynamicObject> getDeliveryRecords(Long cvId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_empdelivery");
        QFilter qFilter = new QFilter("cv.id", "=", (Object)cvId);
        return Arrays.asList(serviceHelper.query(qFilter.toArray()));
    }

    public static void saveDeliveryRecord(DynamicObject record) {
        OperationServiceImpl operationService = new OperationServiceImpl();
        operationService.invokeOperation("save", new DynamicObject[]{record}, OperateOption.create());
    }

    public static List<DynamicObject> getDeliveryRecords(List<Long> cvIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_empdelivery");
        QFilter qFilter = new QFilter("cv.id", "in", cvIds);
        qFilter.and("isnewappfile", "=", (Object)true);
        qFilter.and("delivtype", "=", (Object)"A");
        return Arrays.asList(serviceHelper.query("cv, appfile, advert, applytime", qFilter.toArray(), "applytime desc"));
    }

    public static DynamicObject getLatestDeliveryRecordByAdvertId(List<Long> cvIds, Long advertId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_empdelivery");
        QFilter qFilter = new QFilter("cv.id", "in", cvIds);
        qFilter.and("advert", "=", (Object)advertId);
        qFilter.and("isnewappfile", "=", (Object)true);
        DynamicObject[] deliveryRecords = serviceHelper.query("appfile, appfile.filestatus, appfile.eliminatetime", qFilter.toArray(), "createtime desc");
        if (ObjectUtils.isNotEmpty((Object)deliveryRecords)) {
            return deliveryRecords[0];
        }
        return null;
    }
}

