/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.pc.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.service.business.datamodel.DynamicFormModelProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.common.constants.ChannelConstants;
import kd.tsc.tsrbs.business.domain.base.BaseHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class RsmPubScopeHelper {
    private static HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("");

    public static List<Map<String, String>> getAdvertList() {
        hrBaseServiceHelper.setEntityName("tsirm_advertdetailex");
        QFilter qFilter = new QFilter("enable", "=", (Object)"1").and("advertstatus", "=", (Object)"S").and("channel", "=", (Object)ChannelConstants.INTRECO_CHANNEL_ID);
        DynamicObject[] adverts = hrBaseServiceHelper.query("id, fullname, adminorgsdpt", qFilter.toArray(), "istop desc,isurgent desc,refreshtime desc", 3);
        return Arrays.stream(adverts).map(advert -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            DynamicObjectCollection orgList = advert.getDynamicObjectCollection("adminorgsdpt");
            List orgNameList = orgList.stream().map(org -> org.getString("fbasedataid.name")).collect(Collectors.toList());
            map.put("id", String.valueOf(advert.getLong("id")));
            map.put("name", advert.getString("fullname"));
            map.put("org", StringUtils.join(orgNameList, (String)";"));
            return map;
        }).collect(Collectors.toList());
    }

    public static void insertRsmPubScope(DynamicObject[] rsmPubScopes) {
        BaseHelper.insert((DynamicObject[])rsmPubScopes, (String)"tsirm_rsmpubscopetpl");
    }

    public static void updateEmpCv(DynamicObject empCv) {
        BaseHelper.update((DynamicObject)empCv, (String)"tsirm_empcv");
    }

    public static DynamicObject selectEmpCvPosOrgRel(Long empCvId) {
        QFilter qFilter = new QFilter("rsm", "=", (Object)empCvId).and("isprimary", "=", (Object)Boolean.TRUE);
        List posOrgRelList = BaseHelper.selectByFilter((QFilter[])qFilter.toArray(), (String)"tsirm_rsmposorgreltpl");
        return CollectionUtils.isEmpty((Collection)posOrgRelList) ? null : (DynamicObject)posOrgRelList.get(0);
    }

    public static DynamicObject selectEmpCvById(Long empCvId) {
        return BaseHelper.selectById((Long)empCvId, (String)"tsirm_empcv");
    }

    public static DynamicObject generateRsmPubScope() {
        DynamicFormModelProxy modelProxy = new DynamicFormModelProxy("tsirm_rsmpubscopetpl", UUID.randomUUID().toString(), new HashMap());
        return (DynamicObject)modelProxy.createNewData();
    }

    public static List<DynamicObject> selectRsmPubScopeListByEmpCvId(Long empCvId) {
        QFilter qFilter = new QFilter("rsm", "=", (Object)empCvId);
        return BaseHelper.selectByFilter((String)"org", (QFilter[])qFilter.toArray(), (String)"tsirm_rsmpubscopetpl");
    }

    public static void deleteRsmPubScopeByEmpCvId(Long empCvId) {
        QFilter qFilter = new QFilter("rsm", "=", (Object)empCvId);
        BaseHelper.deleteByFilter((QFilter[])qFilter.toArray(), (String)"tsirm_rsmpubscopetpl");
    }
}

