/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.pc.helper;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.common.enums.pc.UserAdvertRelTypeEnum;

public class UserAdvertRelHelper {
    private static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_useradvertrel");

    public static void saveUserAdvertRel(Long userId, Long advertId, UserAdvertRelTypeEnum typeEnum) {
        DynamicObject dyn = serviceHelper.generateEmptyDynamicObject();
        dyn.set("advert", (Object)advertId);
        dyn.set("user", (Object)userId);
        dyn.set("type", (Object)typeEnum.getType());
        dyn.set("createtime", (Object)new Date());
        serviceHelper.saveOne(dyn);
    }

    public static void deleteUserAdvertRel(Long userId, Long advertId, UserAdvertRelTypeEnum typeEnum) {
        QFilter advertFilter = new QFilter("advert", "=", (Object)advertId);
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        QFilter typeFilter = new QFilter("type", "=", (Object)typeEnum.getType());
        serviceHelper.deleteByFilter(new QFilter[]{advertFilter, userFilter, typeFilter});
    }

    public static DynamicObject[] getUserAdvertRels(Long userId, UserAdvertRelTypeEnum typeEnum) {
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        QFilter typeFilter = new QFilter("type", "=", (Object)typeEnum.getType());
        return serviceHelper.queryOriginalArray("id,user,advert,type,createtime", new QFilter[]{userFilter, typeFilter});
    }

    public static boolean collectionAdvert(Long advertId) {
        UserAdvertRelHelper.unCollectionAdvert(advertId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_advertdetailex");
        QFilter qFilter = new QFilter("id", "=", (Object)advertId);
        DynamicObject advert = serviceHelper.queryOriginalOne("advertstatus", new QFilter[]{qFilter});
        if (advert == null || !HRStringUtils.equals((String)advert.getString("advertstatus"), (String)"S")) {
            return false;
        }
        long userId = RequestContext.get().getCurrUserId();
        UserAdvertRelHelper.saveUserAdvertRel(userId, advertId, UserAdvertRelTypeEnum.COLLECTION);
        return true;
    }

    public static void unCollectionAdvert(Long advertId) {
        long userId = RequestContext.get().getCurrUserId();
        UserAdvertRelHelper.deleteUserAdvertRel(userId, advertId, UserAdvertRelTypeEnum.COLLECTION);
    }

    public static List<Long> getCollectionAdvert() {
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject[] userAdvertRels = UserAdvertRelHelper.getUserAdvertRels(userId, UserAdvertRelTypeEnum.COLLECTION);
        return Arrays.stream(userAdvertRels).map(rel -> rel.getLong("advert")).collect(Collectors.toList());
    }
}

