/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.pc.service;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.tsc.common.vo.BizResult;
import kd.sdk.tsc.common.vo.KResumeBO;
import kd.sdk.tsc.tsirm.extpoint.cv.DeliveryParam;
import kd.sdk.tsc.tsirm.extpoint.cv.EmpDeliveryTypeEnum;
import kd.sdk.tsc.tsirm.extpoint.cv.IEmpCVdeliveryService;
import kd.sdk.tsc.tsirm.extpoint.cv.IEmpCVdeliveryValidator;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.business.domain.operationmanage.CreateOperationManageService;
import kd.tsc.tsirm.business.domain.operationmanage.helper.OperationManageRecordServiceHelper;
import kd.tsc.tsirm.business.domain.operationmanage.helper.OperationManageServiceHelper;
import kd.tsc.tsirm.business.domain.pc.dto.CVEntityNumberVO;
import kd.tsc.tsirm.business.domain.pc.factory.PCServiceFactory;
import kd.tsc.tsirm.business.domain.pc.helper.AddCandidateHelper;
import kd.tsc.tsirm.business.domain.pc.helper.EmpCVHelper;
import kd.tsc.tsirm.business.domain.pc.helper.EmpDeliveryHelper;
import kd.tsc.tsirm.business.domain.pc.helper.PersonInfoHelper;
import kd.tsc.tsirm.business.domain.pc.service.DefaultEmpCVDeliveryService;
import kd.tsc.tsirm.business.domain.pc.service.DefaultEmpCVDeliveryValidator;
import kd.tsc.tsirm.business.domain.pc.service.ICVService;
import kd.tsc.tsirm.business.domain.pc.service.IPersonInfoService;
import kd.tsc.tsirm.business.domain.rsm.sr.service.AddResumeHandleService;
import kd.tsc.tsirm.business.domain.stdrsm.enums.ModelType;
import kd.tsc.tsirm.business.domain.stdrsm.factory.RsmPrototypeFactory;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.StdRsmCommonService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsirm.common.enums.operationmanage.ActivationStatus;
import kd.tsc.tsirm.common.enums.operationmanage.OperatevalEnum;
import kd.tsc.tsirm.common.enums.pc.PCServiceErrorStatusEnum;
import kd.tsc.tsrbd.business.domain.common.entity.BizResults;
import kd.tsc.tsrbd.business.domain.common.service.HRUserService;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractEmpCVService
implements ICVService {
    private static final Log logger = LogFactory.getLog(AbstractEmpCVService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final BizResult bindAccount(Long userId) {
        BizResult finalResult;
        block10: {
            logger.info("AbstractEmpCVService.bindAccount.userId->{}", (Object)userId);
            finalResult = new BizResult();
            try (TXHandle txHandle = TX.required();){
                Long empId = PersonInfoHelper.getEmpId(userId);
                CreateOperationManageService.Singleton.INSTANCE.getInstance().addOperationManage(empId);
                BizResult validatorResult = this.bindAccountValidator(userId);
                logger.info("AbstractEmpCVService.bindAccount.validatorResult.getSuccess->{}", (Object)validatorResult.getSuccess());
                if (validatorResult.getSuccess().booleanValue()) {
                    DynamicObject rel = this.assambleAccountRel(userId);
                    KResumeBO KResumeBO2 = this.assambleEmpCVBO(rel);
                    this.syncEmpCV2Rel(rel, KResumeBO2);
                    this.saveAccountRel(rel);
                    this.saveEmpCv(KResumeBO2);
                    DynamicObject empCV = KResumeBO2.getData();
                    AbstractEmpCVService empCVService = PCServiceFactory.getEmpCVService();
                    empCVService.updateCVFormPersonInfo(empCV.getLong("id"));
                    BizResult deliveryResult = empCVService.deliveryCV(new DeliveryParam(EmpDeliveryTypeEnum.RESUME_CREATE, userId));
                    SaveCandidateResult saveCandidateResult = (SaveCandidateResult)deliveryResult.getData();
                    String certState = saveCandidateResult.getCertState();
                    if ("TRUE".equals(certState)) {
                        finalResult.setSuccess(Boolean.TRUE);
                    } else if ("FALSE".equals(certState)) {
                        finalResult.setSuccess(Boolean.FALSE);
                        finalResult.setMessage(saveCandidateResult.getMessage());
                    }
                    finalResult.setData((Object)saveCandidateResult);
                    break block10;
                }
                Integer code = validatorResult.getCode();
                logger.info("AbstractEmpCVService.bindAccount.code->{}", (Object)code);
                if (PCServiceErrorStatusEnum.ACCOUNT_BINDING.getStatus() == code.intValue()) {
                    this.handleBindAccount(userId, finalResult);
                    break block10;
                }
                BizResult bizResult = validatorResult;
                return bizResult;
            }
        }
        logger.info("AbstractEmpCVService.bindAccount.finalResult->{}", (Object)finalResult.getSuccess());
        logger.info("AbstractEmpCVService.bindAccount.finalResult->{}", finalResult.getData());
        return finalResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final BizResult updateCV(KResumeBO KResumeBO2) {
        try (TXHandle txHandle = TX.required();){
            BizResult result = this.updateCVValidator(KResumeBO2);
            if (!result.getSuccess().booleanValue()) {
                BizResult bizResult = result;
                return bizResult;
            }
            Long rsmId = this.saveEmpCv(KResumeBO2);
            DynamicObject rel = EmpCVHelper.queryEmpCVRel("entryentity.cvid", rsmId);
            if (rel.getBoolean("isopen")) {
                Long userId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)rel, (String)"account");
                DeliveryParam deliveryParam = new DeliveryParam(EmpDeliveryTypeEnum.DELIVTYPE_UPDATE, userId);
                this.deliveryCV(deliveryParam);
            }
        }
        return BizResults.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BizResult updateCVFormPersonInfo(Long cvId) {
        DynamicObject empCvRel;
        long userId;
        IPersonInfoService personInfoService = PCServiceFactory.getPersonInfoService();
        BizResult personInfoResult = personInfoService.getPersonInfo(userId = (empCvRel = EmpCVHelper.queryEmpCVRel("entryentity.cvid", cvId)).getLong("account.id"));
        if (personInfoResult.getSuccess() != Boolean.TRUE) {
            if (personInfoResult.getCode().intValue() == PCServiceErrorStatusEnum.ACCOUNT_NOTEXIST.getStatus() || personInfoResult.getCode().intValue() == PCServiceErrorStatusEnum.ACCOUNT_NOTBINDING.getStatus()) {
                return BizResults.failed((String)ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5c1a\u672a\u7ed1\u5b9a\u8d26\u53f7\uff0c\u8bf7\u5148\u7ed1\u5b9a\u5458\u5de5\u8d26\u53f7", (String)"TsirmSmpleResumePlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            }
            if (personInfoResult.getCode().intValue() == PCServiceErrorStatusEnum.ACCOUNT_NOTFINDPERSON.getStatus()) {
                return BizResults.failed((String)ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u672a\u5165\u804c", (String)"AbstractEmpCVService_0", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            }
        } else {
            try (TXHandle txHandle = TX.required();){
                AbstractEmpCVService empCVService = PCServiceFactory.getEmpCVService();
                KResumeBO empCVOld = empCVService.getEmpCV(cvId);
                DynamicObject empCVDyOld = empCVOld.getData();
                String rsmPubScope = empCVDyOld.getString("rsmpubscope");
                KResumeBO personInfo = (KResumeBO)personInfoResult.getData();
                HRDynamicObjectUtils.copy((DynamicObject)personInfo.getData(), (DynamicObject)empCVDyOld);
                empCVDyOld.set("id", (Object)cvId);
                empCVDyOld.set("rsmupdatetime", (Object)new Date());
                empCVDyOld.set("rsmpubscope", (Object)rsmPubScope);
                empCVOld.setData(empCVDyOld);
                empCVOld.setDynCollMap(personInfo.getDynCollMap());
                EmpCVHelper.saveEmpCV(empCVOld);
                if (!"C".equals(rsmPubScope)) {
                    DeliveryParam deliveryParam = new DeliveryParam(EmpDeliveryTypeEnum.DELIVTYPE_UPDATE, Long.valueOf(userId));
                    this.deliveryCV(deliveryParam);
                }
            }
        }
        return BizResults.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final BizResult deliveryCV(DeliveryParam param) {
        SaveCandidateResult saveCandidateResult = new SaveCandidateResult();
        try (TXHandle txHandle = TX.required();){
            Boolean isSuccess;
            BizResult bizResult;
            HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)new DefaultEmpCVDeliveryValidator(), IEmpCVdeliveryValidator.class, (String)"kd.sdk.tsc.tsirm.extpoint.cv.IEmpCVdeliveryValidator", null);
            List data = proxy.callReplaceIfPresent(sevice -> sevice.deleveryCVValidator(param));
            logger.info("[extPoint]kd.tsc.tsirm.business.domain.pc.service.AbstractEmpCVService->deliveryCV callReplaceIfPresent deleveryCVValidator");
            BizResult result = (BizResult)data.get(0);
            if (!result.getSuccess().booleanValue()) {
                BizResult bizResult2 = result;
                return bizResult2;
            }
            this.deliveryParamHandler(param);
            KResumeBO delivCV = this.assembleDelivCV(param);
            DynamicObject delivRecord = this.assembleDelivRecord(param, delivCV);
            DynamicObject rel = EmpCVHelper.queryEmpCVRel("account", param.getUserId());
            rel.set("isopen", (Object)true);
            EmpCVHelper.saveEmpCVRel(rel);
            EmpCVHelper.saveEmpCV(delivCV);
            boolean ifNeedAudit = false;
            if (param.getDeliveryType() == EmpDeliveryTypeEnum.DELIVTYPE_POSITION) {
                List flagList = proxy.callReplaceIfPresent(plugin -> plugin.shouldCreateDeliveryBill(param, delivCV));
                logger.info("[extPoint]kd.tsc.tsirm.business.domain.pc.service.AbstractEmpCVService->deliveryCV callReplaceIfPresent shouldCreateDeliveryBill");
                if (((Boolean)flagList.get(0)).booleanValue()) {
                    HRPluginProxy empCVdeleveryService = HRPlugInProxyFactory.create((Object)new DefaultEmpCVDeliveryService(), IEmpCVdeliveryService.class, (String)"kd.sdk.tsc.tsirm.extpoint.cv.IEmpCVdeliveryService", null);
                    List list = empCVdeleveryService.callReplaceIfPresent(plugin -> plugin.deliveryBillHandler(param, delivCV, delivRecord));
                    logger.info("[extPoint]kd.tsc.tsirm.business.domain.pc.service.AbstractEmpCVService->deliveryCV callReplaceIfPresent deliveryBillHandler");
                    ifNeedAudit = true;
                    bizResult = this.setStdRsmId(param);
                    if (null != bizResult) {
                        saveCandidateResult = (SaveCandidateResult)bizResult.getData();
                        saveCandidateResult.setSuccess(true);
                    }
                } else {
                    bizResult = this.createCandidate(param, delivCV);
                }
            } else {
                bizResult = this.createCandidate(param, delivCV);
            }
            if (bizResult != null && !ifNeedAudit) {
                saveCandidateResult = (SaveCandidateResult)bizResult.getData();
                isSuccess = (Boolean)saveCandidateResult.get((Object)"isSuccess");
                delivRecord.set("appfile", (Object)saveCandidateResult.getAppFileId());
            } else {
                isSuccess = Boolean.FALSE;
            }
            if (isSuccess.booleanValue()) {
                delivRecord.set("isnewappfile", (Object)true);
            } else {
                delivRecord.set("isnewappfile", (Object)false);
            }
            EmpDeliveryHelper.saveDeliveryRecord(delivRecord);
            this.updateUsedCertCount(saveCandidateResult, param);
        }
        return BizResults.success((Object)saveCandidateResult);
    }

    private BizResult setStdRsmId(DeliveryParam param) {
        List<DynamicObject> empCvRelList = TsrbsHelper.selectByFilter(new QFilter[]{new QFilter("account", "=", (Object)param.getUserId())}, "tsirm_empcvrel");
        if (!CollectionUtils.isEmpty(empCvRelList)) {
            DynamicObject dynamicObject = empCvRelList.get(0);
            long empId = dynamicObject.getLong("empid");
            List<DynamicObject> stdRsmList = TsrbsHelper.selectByFilter("id", new QFilter[]{new QFilter("empid", "=", (Object)empId), new QFilter("iscurrentversion", "=", (Object)"1")}, "tsirm_stdrsm");
            if (!CollectionUtils.isEmpty(stdRsmList)) {
                long stdRsmId = stdRsmList.get(0).getLong("id");
                SaveCandidateResult candidateResult = new SaveCandidateResult();
                candidateResult.setStdRsmId(Long.valueOf(stdRsmId));
                return BizResults.success((Object)candidateResult);
            }
        }
        return null;
    }

    @Override
    public final KResumeBO getEmpCV(Long cvId) {
        KResumeBO kResumeBO = new KResumeBO();
        HRBaseServiceHelper empcvServiceHelper = EmpCVHelper.getServiceHelper("tsirm_empcv");
        kResumeBO.setData(empcvServiceHelper.queryOne((Object)cvId));
        List<CVEntityNumberVO> cvEntitys = this.getCVEntity();
        for (CVEntityNumberVO cventity : cvEntitys) {
            String empCVNumber = cventity.getEmpCVNumber();
            HRBaseServiceHelper serviceHelper = EmpCVHelper.getServiceHelper(empCVNumber);
            QFilter qFilter = new QFilter("rsm", "=", (Object)cvId);
            DynamicObjectCollection dynColl = new DynamicObjectCollection();
            dynColl.addAll(Arrays.asList(serviceHelper.loadDynamicObjectArray(qFilter.toArray())));
            kResumeBO.putDynColl(empCVNumber, dynColl);
        }
        return kResumeBO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final BizResult unPublishedCV(Long userId) {
        try (TXHandle txHandle = TX.required();){
            BizResult result = this.unPublishValidator(userId);
            if (!result.getSuccess().booleanValue()) {
                BizResult bizResult = result;
                return bizResult;
            }
            DynamicObject rel = EmpCVHelper.queryEmpCVRel("account", userId);
            rel.set("isopen", (Object)false);
            Long empId = rel.getLong("empid");
            EmpCVHelper.saveEmpCVRel(rel);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_stdrsm");
            QFilter empFilter = new QFilter("empid", "=", (Object)empId);
            DynamicObject stdRsm = serviceHelper.queryOne("isopen", new QFilter[]{empFilter});
            if (HRObjectUtils.isEmpty((Object)stdRsm)) {
                BizResult bizResult = BizResults.success();
                return bizResult;
            }
            stdRsm.set("isopen", (Object)false);
            serviceHelper.saveOne(stdRsm);
        }
        return BizResults.success();
    }

    @Override
    public final BizResult createCandidate(final DeliveryParam param, KResumeBO KResumeBO2) {
        AppResumeBo appResumeBo = AddCandidateHelper.getAppResumeBo(param, KResumeBO2);
        AddCandidateHelper.setAppResumeBoInfo(appResumeBo, param);
        DynamicObject positionDy = AddCandidateHelper.getPosition(param);
        final SaveCandidateResult result = AddResumeHandleService.getInstance().handle(appResumeBo, positionDy, false, ResumeTypeEnum.FROM);
        ThreadPools.executeOnce((String)"tsirm_empcv", (Runnable)new Runnable(){

            @Override
            public void run() {
                StdRsmCommonService.getInstance().uploadStdRsmAttachment("tsirm_empcv", param.getCVId(), "attachmentpanelap", result.getStdRsmId());
            }
        });
        return BizResults.success((Object)result);
    }

    @Override
    public final DynamicObject[] getEmpCVs(Long userId) {
        List<Long> empCVIds = EmpCVHelper.getEmpCVIds(userId);
        HRBaseServiceHelper empcvServiceHelper = EmpCVHelper.getServiceHelper("tsirm_empcv");
        DynamicObject[] empCVDys = empcvServiceHelper.loadDynamicObjectArray(empCVIds.toArray());
        return empCVDys;
    }

    protected abstract List<CVEntityNumberVO> getCVEntity();

    protected abstract BizResult updateCVValidator(KResumeBO var1);

    protected abstract KResumeBO assembleDelivCV(DeliveryParam var1);

    protected abstract DynamicObject assembleDelivRecord(DeliveryParam var1, KResumeBO var2);

    protected abstract void deliveryParamHandler(DeliveryParam var1);

    protected abstract BizResult bindAccountValidator(Long var1);

    protected abstract BizResult unPublishValidator(Long var1);

    protected abstract DynamicObject assambleAccountRel(Long var1);

    protected abstract KResumeBO assambleEmpCVBO(DynamicObject var1);

    protected abstract void saveAccountRel(DynamicObject var1);

    protected abstract Long saveEmpCv(KResumeBO var1);

    protected abstract void syncEmpCV2Rel(DynamicObject var1, KResumeBO var2);

    public void updateUsedCertCount(SaveCandidateResult saveCandidateResult, DeliveryParam param) {
        Long stdRsmId = saveCandidateResult.getStdRsmId();
        if (null == stdRsmId || 0L == stdRsmId) {
            logger.error("AbstractEmpCVService.updateUsedCertCount  stdRsmId  empty  ", (Object)stdRsmId);
            return;
        }
        DynamicObject stdRsmDy = StandardResumeDataHelper.queryOne(stdRsmId);
        String status = stdRsmDy.getString("status");
        logger.info("AbstractEmpCVService.updateUsedCertCount.status->{}", (Object)status);
        if ("A".equals(status)) {
            Long personId = PersonInfoHelper.getPersonId(param.getUserId());
            Map<String, Object> updateUsedCertCountMap = TSIRMCertCommonHelper.updateUsedCertCount("2+TXFE9NU13A", "tsirm_stdrsm", HRUserService.getPersonPid((List)ImmutableList.of((Object)personId)));
            logger.info("AbstractEmpCVService.updateUsedCertCount.updateUsedCertCountMap->{}", updateUsedCertCountMap);
            String state = (String)updateUsedCertCountMap.get("STATE");
            saveCandidateResult.setCertState(state);
            DynamicObject operationMngDy = OperationManageServiceHelper.Singleton.INSTANCE.getInstance().loadDynamicObject(new QFilter("employee", "=", (Object)PersonInfoHelper.getEmpId(param.getUserId())));
            DynamicObject operationManagerdDy = null;
            if ("TRUE".equals(state)) {
                HashMap<String, Object> updateMap = new HashMap<String, Object>(1);
                updateMap.put("status", "B");
                Object resumeService = RsmPrototypeFactory.getResumeService(ModelType.MAIN_RSM_DEFAULT_SERVICE);
                resumeService.updateStdRsmWithNoHistory(stdRsmId, updateMap);
                operationMngDy.set("activationstatus", (Object)ActivationStatus.B);
                operationMngDy.set("failreasoncombo", (Object)"1");
                operationManagerdDy = CreateOperationManageService.Singleton.INSTANCE.getInstance().buildOperationmanagerd(operationMngDy, ActivationStatus.B, OperatevalEnum.A);
            } else if ("FALSE".equals(state)) {
                operationMngDy.set("activationstatus", (Object)ActivationStatus.C);
                Map dataMap = (Map)updateUsedCertCountMap.get("DATA");
                String message = (String)dataMap.get("message");
                operationMngDy.set("failreason", (Object)message);
                operationMngDy.set("failreasoncombo", (Object)"0");
                saveCandidateResult.setMessage(message);
                operationManagerdDy = CreateOperationManageService.Singleton.INSTANCE.getInstance().buildOperationmanagerd(operationMngDy, ActivationStatus.C, OperatevalEnum.A);
            }
            OperationManageServiceHelper.Singleton.INSTANCE.getInstance().updateDataOne(operationMngDy);
            if (ObjectUtils.isNotEmpty(operationManagerdDy)) {
                OperationManageRecordServiceHelper.Singleton.INSTANCE.getInstance().saveOne(operationManagerdDy);
            }
        }
    }

    private BizResult handleBindAccount(Long currUserId, BizResult result) {
        result.setSuccess(Boolean.TRUE);
        AbstractEmpCVService empCVService = PCServiceFactory.getEmpCVService();
        DynamicObject relDy = EmpCVHelper.queryEmpCVRel("account", currUserId);
        Long empId = relDy.getLong("empid");
        logger.info("BindAccountPlugin.handleBindAccount.empId->{}", (Object)empId);
        DynamicObject stdRsmDy = StandardResumeDataHelper.queryStdRsmByEmpId(empId);
        String status = stdRsmDy.getString("status");
        logger.info("BindAccountPlugin.afterCreateNewData.status->{}", (Object)status);
        SaveCandidateResult saveCandidateResult = new SaveCandidateResult();
        saveCandidateResult.setStdRsmId(Long.valueOf(stdRsmDy.getLong("id")));
        if ("A".equals(status)) {
            DeliveryParam param = new DeliveryParam();
            param.setUserId(currUserId);
            empCVService.updateUsedCertCount(saveCandidateResult, param);
            String certState = saveCandidateResult.getCertState();
            if ("FALSE".equals(certState)) {
                result.setSuccess(Boolean.FALSE);
                result.setMessage(saveCandidateResult.getMessage());
            }
        } else if ("B".equals(status)) {
            Long personId = PersonInfoHelper.getPersonId(currUserId);
            Map<String, Object> verifyCertMap = TSIRMCertCommonHelper.verifyCertByPid("2+TXFE9NU13A", "tsirm_stdrsm", HRUserService.getPersonPid((List)ImmutableList.of((Object)personId)));
            logger.info("BindAccountPlugin.afterCreateNewData.verifyCertMap->{}", verifyCertMap);
            String state = (String)verifyCertMap.get("STATE");
            saveCandidateResult.setCertState(state);
            if ("FAIL".equals(state)) {
                Map data = (Map)verifyCertMap.get("DATA");
                String infoType = (String)data.get("infoType");
                if (!HRCertPromptInfoTypeEnum.FORBIDDEN.getName().equals(infoType)) {
                    result.setSuccess(Boolean.FALSE);
                }
            }
        } else if ("C".equals(status)) {
            saveCandidateResult.setStdRsmStatus("C");
            result.setSuccess(Boolean.FALSE);
        }
        result.setData((Object)saveCandidateResult);
        return result;
    }
}

