/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.pc.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.tsc.common.vo.BizResult;
import kd.sdk.tsc.common.vo.KResumeBO;
import kd.sdk.tsc.tsirm.extpoint.cv.DeliveryParam;
import kd.tsc.tsirm.business.domain.pc.dto.CVEntityNumberVO;
import kd.tsc.tsirm.business.domain.pc.helper.EmpCVHelper;
import kd.tsc.tsirm.business.domain.pc.helper.PersonInfoHelper;
import kd.tsc.tsirm.business.domain.pc.service.AbstractEmpCVService;
import kd.tsc.tsirm.common.enums.RsmTypeEnum;
import kd.tsc.tsirm.common.enums.pc.PCServiceErrorStatusEnum;
import kd.tsc.tsrbd.business.domain.common.entity.BizResults;
import kd.tsc.tsrbd.business.domain.rsmmetadata.service.ResumeMetadataService;
import org.apache.commons.lang3.StringUtils;

public class DefEmpCVService
extends AbstractEmpCVService {
    private static HRBaseServiceHelper EMPCVREL_SERVICEHELPER = new HRBaseServiceHelper("tsirm_empcvrel");
    private static HRBaseServiceHelper EMPCV_SERVICEHELPER = new HRBaseServiceHelper("tsirm_empcv");

    @Override
    protected List<CVEntityNumberVO> getCVEntity() {
        ArrayList cvEntityNumberVOS = Lists.newArrayListWithCapacity((int)16);
        Map entryKeyMap = ResumeMetadataService.getEntryKeyMap((String)"tsirm_empcv", (String)"tsirm_delivcv");
        for (Map.Entry entry : entryKeyMap.entrySet()) {
            cvEntityNumberVOS.add(new CVEntityNumberVO((String)entry.getKey(), (String)entry.getValue()));
        }
        return cvEntityNumberVOS;
    }

    @Override
    protected BizResult updateCVValidator(KResumeBO kResumeBO) {
        return BizResults.success();
    }

    @Override
    protected KResumeBO assembleDelivCV(DeliveryParam param) {
        Long cvId = param.getCVId();
        KResumeBO KResumeBO2 = this.getEmpCV(cvId);
        DynamicObject empCV = KResumeBO2.getData();
        KResumeBO delivCVBO = new KResumeBO();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_delivcv");
        DynamicObject delivCV = serviceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)empCV, (DynamicObject)delivCV);
        Long delivCVId = ORM.create().genLongId("tsirm_delivcv");
        delivCV.set("id", (Object)delivCVId);
        delivCVBO.setData(delivCV);
        Map dynCollMap = KResumeBO2.getDynCollMap();
        List<CVEntityNumberVO> cvEntitys = this.getCVEntity();
        Map<String, String> entityMap = cvEntitys.stream().collect(Collectors.toMap(cvEntity -> cvEntity.getEmpCVNumber(), cvEntity -> cvEntity.getDelivCVNumber()));
        dynCollMap.forEach((key, dynColl) -> {
            String delivEntity = (String)entityMap.get(key);
            HRBaseServiceHelper delivService = new HRBaseServiceHelper(delivEntity);
            DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
            for (DynamicObject dyn : dynColl) {
                DynamicObject delivDyn = delivService.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)delivDyn);
                delivDyn.set("rsm", (Object)delivCVId);
                dynamicObjects.add((Object)delivDyn);
            }
            delivCVBO.putDynColl(delivEntity, dynamicObjects);
        });
        return delivCVBO;
    }

    @Override
    protected DynamicObject assembleDelivRecord(DeliveryParam param, KResumeBO delivCVBO) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_empdelivery");
        DynamicObject dyn = serviceHelper.generateEmptyDynamicObject();
        Long delivRecordId = ORM.create().genLongId("tsirm_empdelivery");
        dyn.set("id", (Object)delivRecordId);
        dyn.set("applytime", (Object)param.getApplytime());
        dyn.set("deliveryper", (Object)param.getDeliveryPerId());
        dyn.set("cv", (Object)param.getCVId());
        dyn.set("position", (Object)param.getPositionId());
        dyn.set("delivtype", (Object)param.getDeliveryType().getDelivType());
        dyn.set("delivcv", (Object)delivCVBO.getData().getLong("id"));
        dyn.set("advert", (Object)param.getAdvertId());
        dyn.set("status", (Object)"A");
        return dyn;
    }

    @Override
    protected void deliveryParamHandler(DeliveryParam param) {
        Long cvId;
        Date date = new Date();
        Long currUserId = RequestContext.get().getCurrUserId();
        param.setApplytime(date);
        if (param.getDeliveryPerId() == null) {
            param.setDeliveryPerId(currUserId);
        }
        if ((cvId = param.getCVId()) == null || cvId.equals(0L)) {
            Long empCVId = EmpCVHelper.getEmpCVId(param.getUserId());
            param.setCvId(empCVId);
        }
    }

    @Override
    protected BizResult bindAccountValidator(Long currUserId) {
        DynamicObject rel = EmpCVHelper.queryEmpCVRel("account", currUserId);
        if (rel != null) {
            return BizResults.failed((int)PCServiceErrorStatusEnum.ACCOUNT_BINDING.getStatus(), (String)"Account number has been binding!", (Object)rel);
        }
        if (!PersonInfoHelper.isExistUser(currUserId)) {
            return BizResults.failed((int)PCServiceErrorStatusEnum.ACCOUNT_NOTEXIST.getStatus(), (String)"Account not exist!", (Object)rel);
        }
        Map<String, Long> personModelIdByUserId = PersonInfoHelper.getPersonModelIdByUserId(currUserId);
        if (CollectionUtils.isEmpty(personModelIdByUserId)) {
            return BizResults.failed((int)PCServiceErrorStatusEnum.ACCOUNT_NOTFINDPERSON.getStatus(), (String)"Account not exist!", (Object)rel);
        }
        return BizResults.success();
    }

    @Override
    protected BizResult unPublishValidator(Long currUserId) {
        DynamicObject rel = EmpCVHelper.queryEmpCVRel("account", currUserId);
        if (rel == null) {
            return BizResults.failed((int)PCServiceErrorStatusEnum.ACCOUNT_NOTBINDING.getStatus(), (String)"Account number has not been binding!", (Object)rel);
        }
        if (!PersonInfoHelper.isExistUser(currUserId)) {
            return BizResults.failed((int)PCServiceErrorStatusEnum.ACCOUNT_NOTEXIST.getStatus(), (String)"Account not exist!", (Object)rel);
        }
        Map<String, Long> personModelIdByUserId = PersonInfoHelper.getPersonModelIdByUserId(currUserId);
        if (CollectionUtils.isEmpty(personModelIdByUserId)) {
            return BizResults.failed((int)PCServiceErrorStatusEnum.ACCOUNT_NOTFINDPERSON.getStatus(), (String)"Account not exist!", (Object)rel);
        }
        return BizResults.success();
    }

    @Override
    protected DynamicObject assambleAccountRel(Long userId) {
        DynamicObject relDyn = EMPCVREL_SERVICEHELPER.generateEmptyDynamicObject();
        Long empId = PersonInfoHelper.getEmpId(userId);
        relDyn.set("account", (Object)userId);
        relDyn.set("empid", (Object)empId);
        relDyn.set("isopen", (Object)false);
        relDyn.set("createtime", (Object)new Date());
        EmpCVHelper.setBaseFields(relDyn);
        return relDyn;
    }

    @Override
    protected void saveAccountRel(DynamicObject rel) {
        EMPCVREL_SERVICEHELPER.saveOne(rel);
    }

    @Override
    protected KResumeBO assambleEmpCVBO(DynamicObject rel) {
        KResumeBO empCVBo = new KResumeBO();
        Long userId = rel.getLong("account");
        Map<String, String> simpleCVFiles = this.getSimpleCVFiles();
        DynamicObject simplePersonInfo = PersonInfoHelper.getSimplePersonInfo(userId, StringUtils.join(simpleCVFiles.values(), (String)","));
        DynamicObject empCV = EMPCV_SERVICEHELPER.generateEmptyDynamicObject();
        simpleCVFiles.forEach((cvField, fromField) -> empCV.set(cvField, simplePersonInfo.get(fromField)));
        if (simpleCVFiles.values().contains("gender")) {
            String genderEnum = simplePersonInfo.getString("gender");
            if (HRStringUtils.equals((String)genderEnum, (String)"1")) {
                empCV.set("gender", (Object)1010L);
            } else if (HRStringUtils.equals((String)genderEnum, (String)"2")) {
                empCV.set("gender", (Object)1020L);
            } else {
                empCV.set("gender", (Object)1030L);
            }
        }
        empCV.set("id", (Object)ORM.create().genLongId("tsirm_empcv"));
        empCV.set("type", (Object)RsmTypeEnum.TYPE_EMPCV.getType());
        empCV.set("rsmpubscope", (Object)"C");
        empCV.set("isshldctorg", (Object)Boolean.TRUE);
        empCV.set("rsmupdatetime", (Object)new Date());
        EmpCVHelper.setBaseFields(empCV);
        empCVBo.setData(empCV);
        return empCVBo;
    }

    @Override
    protected Long saveEmpCv(KResumeBO KResumeBO2) {
        return EmpCVHelper.saveEmpCV(KResumeBO2);
    }

    @Override
    protected void syncEmpCV2Rel(DynamicObject rel, KResumeBO kResumeBO) {
        DynamicObject empCV = kResumeBO.getData();
        Long cvid = empCV.getLong("id");
        DynamicObjectCollection entryentity = rel.getDynamicObjectCollection("entryentity");
        DynamicObject dynamicObject = entryentity.addNew();
        dynamicObject.set("cvid", (Object)cvid);
    }

    protected Map<String, String> getSimpleCVFiles() {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        result.put("fullname", "name");
        result.put("gender", "gender");
        result.put("phone", "phone");
        result.put("email", "email");
        return result;
    }

    protected KResumeBO getDeliveryCV(Long deliveryCVId) {
        KResumeBO KResumeBO2 = new KResumeBO();
        HRBaseServiceHelper empcvServiceHelper = EmpCVHelper.getServiceHelper("tsirm_delivcv");
        KResumeBO2.setData(empcvServiceHelper.queryOne((Object)deliveryCVId));
        List<CVEntityNumberVO> cvEntitys = this.getCVEntity();
        for (CVEntityNumberVO cventity : cvEntitys) {
            String empCVNumber = cventity.getDelivCVNumber();
            HRBaseServiceHelper serviceHelper = EmpCVHelper.getServiceHelper(empCVNumber);
            QFilter qFilter = new QFilter("rsm", "=", (Object)deliveryCVId);
            DynamicObjectCollection dynColl = new DynamicObjectCollection();
            dynColl.addAll(Arrays.asList(serviceHelper.loadDynamicObjectArray(qFilter.toArray())));
            KResumeBO2.putDynColl(empCVNumber, dynColl);
        }
        return KResumeBO2;
    }
}

