/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.pc.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.tsc.common.vo.BizResult;
import kd.sdk.tsc.common.vo.KResumeBO;
import kd.tsc.tsirm.business.domain.pc.dto.PersonInfoKeyPairVO;
import kd.tsc.tsirm.business.domain.pc.dto.PersonInfoServiceVO;
import kd.tsc.tsirm.business.domain.pc.helper.EmpCVHelper;
import kd.tsc.tsirm.business.domain.pc.helper.PersonInfoHelper;
import kd.tsc.tsirm.business.domain.pc.service.IPersonInfoService;
import kd.tsc.tsirm.common.enums.pc.PCServiceErrorStatusEnum;
import kd.tsc.tsirm.common.enums.pc.PersonModelEnum;
import kd.tsc.tsrbd.business.domain.common.entity.BizResults;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;

public class PersonInfoService
implements IPersonInfoService {
    @Override
    public BizResult getPersonInfo(Long userId) {
        BizResult bizResult = this.getPersonInfoValidator(userId);
        if (!bizResult.getSuccess().booleanValue()) {
            return bizResult;
        }
        Map<String, Long> personModelIdMap = PersonInfoHelper.getPersonModelIdByUserId(userId);
        if (personModelIdMap == null) {
            return BizResults.failed((int)PCServiceErrorStatusEnum.ACCOUNT_NOTFINDPERSON.getStatus());
        }
        Long empCVId = EmpCVHelper.getEmpCVId(userId);
        DynamicObject empCV = this.assembleEmpCV(personModelIdMap);
        empCV.set("id", (Object)empCVId);
        KResumeBO kResumeBO = new KResumeBO();
        kResumeBO.setData(empCV);
        this.setEmpCVAttachs(personModelIdMap, kResumeBO);
        return BizResults.success((Object)kResumeBO);
    }

    protected BizResult getPersonInfoValidator(Long userId) {
        if (!PersonInfoHelper.isExistUser(userId)) {
            return BizResults.failed((int)PCServiceErrorStatusEnum.ACCOUNT_NOTEXIST.getStatus(), (String)"Account not exist!");
        }
        DynamicObject rel = EmpCVHelper.queryEmpCVRel("account", userId);
        if (rel == null) {
            return BizResults.failed((int)PCServiceErrorStatusEnum.ACCOUNT_NOTBINDING.getStatus(), (String)"Account number has not been binding!", (Object)rel);
        }
        return BizResults.success();
    }

    protected DynamicObject assembleEmpCV(Map<String, Long> personModelIdMap) {
        PersonInfoServiceVO baseInfoServicePair = this.getBaseInfoServicePair();
        Map personBaseInfo = (Map)this.invokeMService(baseInfoServicePair, personModelIdMap);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_empcv");
        DynamicObject empCV = serviceHelper.generateEmptyDynamicObject();
        this.setBaseInfoValue(baseInfoServicePair.getKeyPairVO(), empCV, personBaseInfo);
        List<PersonInfoServiceVO> otherInfoServiceVOList = this.getOtherBaseInfoServiceVO();
        for (PersonInfoServiceVO otherInfoServiceVO : otherInfoServiceVOList) {
            List result;
            PersonInfoKeyPairVO keyPairVO = otherInfoServiceVO.getKeyPairVO();
            if (!HRStringUtils.equals((String)"tsirm_empcv", (String)keyPairVO.getPageTo()) || CollectionUtils.isEmpty((Collection)(result = (List)this.invokeMService(otherInfoServiceVO, personModelIdMap)))) continue;
            for (Map objectMap : result) {
                this.setBaseInfoValue(keyPairVO, empCV, objectMap);
            }
        }
        empCV.set("nativeplace", null);
        this.setBaseInfoValue(baseInfoServicePair.getKeyPairVO(), empCV, personBaseInfo);
        this.setBaseInfoSpecialValue(empCV);
        return empCV;
    }

    protected void setEmpCVAttachs(Map<String, Long> personModelIdMap, KResumeBO kResumeBO) {
        List<PersonInfoServiceVO> empCVAttachsServiceVO = this.getEmpCVAttachsServiceVO();
        DynamicObject empCV = kResumeBO.getData();
        Long cvId = empCV.getLong("id");
        for (PersonInfoServiceVO personInfoServiceVO : empCVAttachsServiceVO) {
            List result = (List)this.invokeMService(personInfoServiceVO, personModelIdMap);
            PersonInfoKeyPairVO keyPairVO = personInfoServiceVO.getKeyPairVO();
            DynamicObjectCollection dynColl = new DynamicObjectCollection();
            for (Object attachInfo : result) {
                DynamicObject attachDyn = this.assembleAttachDyn(keyPairVO, attachInfo);
                attachDyn.set("rsm", (Object)cvId);
                dynColl.add((Object)attachDyn);
            }
            kResumeBO.putDynColl(keyPairVO.getPageTo(), dynColl);
        }
        this.setPosOrgRel(personModelIdMap, cvId, kResumeBO);
    }

    protected void setPosOrgRel(Map<String, Long> personModelIdMap, Long cvId, KResumeBO kResumeBO) {
        PersonInfoKeyPairVO posorgrel = new PersonInfoKeyPairVO();
        posorgrel.setPageFrom("hrpi_empposorgrel");
        posorgrel.setPageTo("tsirm_empcvposorgrel");
        posorgrel.setKeyPair("startdate", "startdate");
        posorgrel.setKeyPair("enddate", "endingdate");
        posorgrel.setKeyPair("company_id", "company");
        posorgrel.setKeyPair("adminorg_id", "adminorg");
        posorgrel.setKeyPair("position_id", "position");
        posorgrel.setKeyPair("postype_id", "postype");
        posorgrel.setKeyPair("servicelength", "duration");
        posorgrel.setKeyPair("isprimary", "isprimary");
        posorgrel.setKeyPair("businessstatus", "businessstatus");
        ArrayList<String> fields = new ArrayList<String>(posorgrel.getKeyPairMap().keySet());
        StringBuilder sb = new StringBuilder();
        for (String field : fields) {
            sb.append(field).append(",");
        }
        String selectFields = HRStringUtils.substringBeforeLast((String)sb.toString(), (String)",");
        Long personId = personModelIdMap.get(PersonModelEnum.PERSON_MODEL_PERSON.getPersonModel());
        QFilter qFilter = new QFilter("person", "=", (Object)personId);
        DynamicObject[] hrPersonList = this.listFieldsFilterInfo(selectFields, qFilter, posorgrel.getPageFrom());
        DynamicObjectCollection dynColl = new DynamicObjectCollection();
        for (DynamicObject attachInfo : hrPersonList) {
            DynamicObject attachDyn = this.assembleAttachDyn(posorgrel, attachInfo);
            attachDyn.set("rsm", (Object)cvId);
            dynColl.add((Object)attachDyn);
        }
        kResumeBO.putDynColl(posorgrel.getPageTo(), dynColl);
    }

    private DynamicObject[] listFieldsFilterInfo(String selectFields, QFilter custFilter, String entityName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        if (custFilter == null) {
            return new DynamicObject[0];
        }
        QFilter[] qfilters = new QFilter[]{custFilter, new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("datastatus", "=", (Object)"1")};
        return serviceHelper.query(selectFields, qfilters);
    }

    protected <T> T invokeMService(PersonInfoServiceVO serviceVO, Map<String, Long> personModelIdMap) {
        Object param = serviceVO.getParam();
        if (param == null) {
            return (T)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)serviceVO.getServiceName(), (String)serviceVO.getMethodName(), (Object[])new Object[]{personModelIdMap.get(serviceVO.getModelEnum().getPersonModel())});
        }
        return (T)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)serviceVO.getServiceName(), (String)serviceVO.getMethodName(), (Object[])new Object[]{personModelIdMap.get(serviceVO.getModelEnum().getPersonModel()), param});
    }

    protected DynamicObject assembleAttachDyn(PersonInfoKeyPairVO keyPairVO, Object attachInfo) {
        DynamicObject attachDyn;
        block7: {
            block6: {
                String pageTo = keyPairVO.getPageTo();
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(pageTo);
                attachDyn = serviceHelper.generateEmptyDynamicObject();
                if (!(attachInfo instanceof Map)) break block6;
                Map attachInfoMap = (Map)attachInfo;
                for (Map.Entry<String, String> entry : keyPairVO.getKeyPairMap().entrySet()) {
                    String ishighestdegree;
                    String keyFrom = entry.getKey();
                    String keyTo = entry.getValue();
                    Object val = attachInfoMap.get(keyFrom);
                    if (HRStringUtils.equals((String)"ishighestdegree", (String)keyFrom)) {
                        ishighestdegree = (String)val;
                        attachDyn.set(keyTo, (Object)HRStringUtils.equals((String)"1", (String)ishighestdegree));
                        continue;
                    }
                    if (HRStringUtils.equals((String)"isprimary", (String)keyFrom)) {
                        ishighestdegree = (String)val;
                        attachDyn.set(keyTo, (Object)HRStringUtils.equals((String)"1", (String)ishighestdegree));
                        continue;
                    }
                    attachDyn.set(keyTo, val);
                }
                break block7;
            }
            if (!(attachInfo instanceof DynamicObject)) break block7;
            DynamicObject attachInfoDyn = (DynamicObject)attachInfo;
            HRDynamicObjectUtils.copy((DynamicObject)attachInfoDyn, (DynamicObject)attachDyn);
            for (Map.Entry<String, String> entry : keyPairVO.getKeyPairMap().entrySet()) {
                String keyFrom = entry.getKey();
                String keyTo = entry.getValue();
                Object val = attachInfoDyn.get(keyFrom);
                if (HRStringUtils.equals((String)"isprimary", (String)keyFrom)) {
                    boolean businessStatus = attachInfoDyn.getBoolean("businessstatus");
                    if (businessStatus) {
                        attachDyn.set(keyTo, (Object)"1");
                        continue;
                    }
                    attachDyn.set(keyTo, (Object)"0");
                    continue;
                }
                if (HRStringUtils.equals((String)"businessstatus", (String)keyTo)) continue;
                attachDyn.set(keyTo, val);
            }
        }
        return attachDyn;
    }

    private void putValueMap2Dyn(Map<String, Object> valueMap, DynamicObject dyn) {
        List props = dyn.getDataEntityType().getProperties().stream().map(prop -> prop.getName()).collect(Collectors.toList());
        List<String> baseInfoIgnoreFields = this.getBaseInfoIgnoreFields();
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            String key = entry.getKey();
            if (baseInfoIgnoreFields.contains(key)) continue;
            Object val = valueMap.get(key + "_id");
            if (HRObjectUtils.isEmpty((Object)val)) {
                val = entry.getValue();
            }
            if (!props.contains(key)) continue;
            dyn.set(key, val);
        }
    }

    protected List<String> getBaseInfoIgnoreFields() {
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)16);
        fields.add("birthplace");
        return fields;
    }

    protected void setBaseInfoSpecialValue(DynamicObject empCV) {
        empCV.set("age", (Object)this.ageCaculator(empCV.getDate("birthday")));
        empCV.set("workingyears", (Object)this.showworkingyearsCaculator(empCV.getDate("partwt")));
    }

    protected PersonInfoServiceVO getBaseInfoServicePair() {
        PersonInfoKeyPairVO keyPair = new PersonInfoKeyPairVO();
        keyPair.setKeyPair("birthday", "birthday");
        keyPair.setKeyPair("nationality_id", "natreg_id");
        keyPair.setKeyPair("folk_id", "nation_id");
        keyPair.setKeyPair("healthstatus_id", "healthstatus_id");
        keyPair.setKeyPair("beginservicedate", "partwt");
        keyPair.setKeyPair("name", "fullname");
        keyPair.setKeyPair("gender_id", "gender_id");
        keyPair.setKeyPair("gender", "gender");
        keyPair.setKeyPair("number", "employeenum");
        keyPair.setKeyPair("headsculpture", "photo");
        return new PersonInfoServiceVO("IHRPIPersonService", "getPersonBaseInfo", PersonModelEnum.PERSON_MODEL_PERSON, null, keyPair);
    }

    protected List<PersonInfoServiceVO> getOtherBaseInfoServiceVO() {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        PersonInfoKeyPairVO perregion = new PersonInfoKeyPairVO();
        perregion.setPageFrom("hrpi_perregion");
        perregion.setPageTo("tsirm_empcv");
        perregion.setKeyPair("nativeplace", "nativeplacetext");
        perregion.setKeyPair("birthplace", "birthplace");
        perregion.setKeyPair("regresidence", "rgstprmtrsd");
        perregion.setKeyPair("politicalstatus_id", "politicsstatus_id");
        list.add(new PersonInfoServiceVO("IHRPIPersonService", "listPersonAttachs", PersonModelEnum.PERSON_MODEL_PERSON, "hrpi_perregion", perregion));
        PersonInfoKeyPairVO percre = new PersonInfoKeyPairVO();
        percre.setPageFrom("hrpi_percre");
        percre.setPageTo("tsirm_empcv");
        percre.setKeyPair("credentialstype_id", "certificatetype_id");
        percre.setKeyPair("number", "certificatenumber");
        list.add(new PersonInfoServiceVO("IHRPIPersonService", "listPersonAttachs", PersonModelEnum.PERSON_MODEL_PERSON, "hrpi_percre", percre));
        PersonInfoKeyPairVO percontact = new PersonInfoKeyPairVO();
        percontact.setPageFrom("hrpi_percontact");
        percontact.setPageTo("tsirm_empcv");
        percontact.setKeyPair("phone", "phone");
        percontact.setKeyPair("peremail", "email");
        list.add(new PersonInfoServiceVO("IHRPIPersonService", "listPersonAttachs", PersonModelEnum.PERSON_MODEL_PERSON, "hrpi_percontact", percontact));
        return list;
    }

    protected List<PersonInfoServiceVO> getEmpCVAttachsServiceVO() {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        PersonInfoKeyPairVO eduExp = new PersonInfoKeyPairVO();
        eduExp.setPageFrom("hrpi_pereduexp");
        eduExp.setPageTo("tsirm_empcveduexp");
        eduExp.setKeyPair("admissiondate", "startdate");
        eduExp.setKeyPair("gradutiondate", "endingdate");
        eduExp.setKeyPair("graduateschool_id", "schoolname");
        eduExp.setKeyPair("schoolrecord", "othschname");
        eduExp.setKeyPair("major", "specialtyname");
        eduExp.setKeyPair("education_id", "education");
        eduExp.setKeyPair("edunature_id", "educationform");
        eduExp.setKeyPair("ishighestdegree", "ishighestedu");
        list.add(new PersonInfoServiceVO("IHRPIPersonService", "listPersonAttachs", PersonModelEnum.PERSON_MODEL_PERSON, "hrpi_pereduexp", eduExp));
        return list;
    }

    protected void setBaseInfoValue(PersonInfoKeyPairVO keyPairVO, DynamicObject empCV, Map<String, Object> baseInfoMap) {
        this.putValueMap2Dyn(baseInfoMap, empCV);
        for (Map.Entry<String, String> entry : keyPairVO.getKeyPairMap().entrySet()) {
            String keyFrom = entry.getKey();
            String keyTo = entry.getValue();
            Object val = baseInfoMap.get(keyFrom + "_id");
            if (HRObjectUtils.isEmpty((Object)val)) {
                val = baseInfoMap.get(keyFrom);
            }
            empCV.set(keyTo, val);
        }
    }

    protected int ageCaculator(Date birthday) {
        return ResumeAnalysisHelper.calculateAge((Date)birthday);
    }

    protected int showworkingyearsCaculator(Date beginservicedate) {
        return ResumeAnalysisHelper.calMonthByStartDate((Date)beginservicedate);
    }
}

