/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.pc.service;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.tsc.common.vo.BizResult;
import kd.sdk.tsc.common.vo.KResumeBO;
import kd.sdk.tsc.tsirm.extpoint.cv.DeliveryParam;
import kd.sdk.tsc.tsirm.extpoint.cv.EmpDeliveryTypeEnum;
import kd.sdk.tsc.tsirm.extpoint.cv.IEmpCVService;
import kd.sdk.tsc.tsirm.extpoint.cv.IEmpFileQueryService;
import kd.tsc.tsirm.business.domain.pc.helper.EmpCVHelper;
import kd.tsc.tsirm.business.domain.pc.helper.EmpDeliveryHelper;
import kd.tsc.tsirm.business.domain.pc.service.DefEmpCVService;
import kd.tsc.tsirm.business.domain.pc.service.ICVService;
import kd.tsc.tsirm.business.domain.pc.service.IPersonInfoService;
import kd.tsc.tsirm.business.domain.pc.service.PersonInfoService;
import kd.tsc.tsirm.common.enums.pc.PCServiceErrorStatusEnum;
import kd.tsc.tsrbd.business.domain.common.entity.BizResults;

public class PersonalCenterService
implements ICVService,
IPersonInfoService {
    private static final Log logger = LogFactory.getLog(PersonalCenterService.class);
    private ICVService defCvService = new DefEmpCVService();

    private PersonalCenterService() {
    }

    public static PersonalCenterService getInstance() {
        return Instance.INSTANCE;
    }

    public ICVService getDefCvService() {
        return this.defCvService;
    }

    public BizResult bindAccount() {
        Long currUserId = RequestContext.get().getCurrUserId();
        return this.bindAccount(currUserId);
    }

    @Override
    public BizResult bindAccount(Long userId) {
        HRPluginProxy<IEmpCVService> serviceProxy = this.getCVServiceProxy();
        serviceProxy.callAfter(service -> {
            if (service != null) {
                service.beforeBindAccount(userId);
            }
            return null;
        });
        BizResult bizResult = this.getDefCvService().bindAccount(userId);
        logger.info("[extPoint]kd.tsc.tsirm.business.domain.pc.service.PersonalCenterService->bindAccount userId = {}", (Object)userId);
        serviceProxy.callAfter(service -> {
            if (service != null) {
                service.afterBindAccount(userId, bizResult);
            }
            return null;
        });
        return bizResult;
    }

    @Override
    public BizResult updateCV(KResumeBO kResumeBO) {
        HRPluginProxy<IEmpCVService> serviceProxy = this.getCVServiceProxy();
        serviceProxy.callBefore(service -> {
            if (service != null) {
                service.beforeUpdateCV(kResumeBO);
            }
            return null;
        });
        BizResult bizResult = this.getDefCvService().updateCV(kResumeBO);
        logger.info("[extPoint]kd.tsc.tsirm.business.domain.pc.service.PersonalCenterService->bindAccount updateCV");
        serviceProxy.callAfter(service -> {
            if (service != null) {
                service.afterUpdateCV(kResumeBO, bizResult);
            }
            return null;
        });
        return bizResult;
    }

    @Override
    public BizResult deliveryCV(DeliveryParam param) {
        HRPluginProxy<IEmpCVService> serviceProxy = this.getCVServiceProxy();
        serviceProxy.callBefore(service -> {
            if (service != null) {
                service.beforeDeliveryCV(param);
            }
            return null;
        });
        BizResult bizResult = this.getDefCvService().deliveryCV(param);
        logger.info("[extPoint]kd.tsc.tsirm.business.domain.pc.service.PersonalCenterService->deliveryCV");
        serviceProxy.callAfter(service -> {
            if (service != null) {
                service.afterDeliveryCV(param, bizResult);
            }
            return null;
        });
        return bizResult;
    }

    @Override
    public KResumeBO getEmpCV(Long cvId) {
        HRPluginProxy<IEmpCVService> serviceProxy = this.getCVServiceProxy();
        KResumeBO kResumeBO = this.getDefCvService().getEmpCV(cvId);
        serviceProxy.callAfter(service -> {
            if (service != null) {
                service.afterGetEmpCV(cvId, kResumeBO);
            }
            return null;
        });
        logger.info("[extPoint]kd.tsc.tsirm.business.domain.pc.service.PersonalCenterService->getEmpCV cVid={}", (Object)cvId);
        return kResumeBO;
    }

    @Override
    public BizResult unPublishedCV(Long userId) {
        HRPluginProxy<IEmpCVService> serviceProxy = this.getCVServiceProxy();
        serviceProxy.callBefore(service -> {
            if (service != null) {
                service.beforeUnPublishedCV(userId);
            }
            return null;
        });
        BizResult bizResult = this.getDefCvService().unPublishedCV(userId);
        logger.info("[extPoint]kd.tsc.tsirm.business.domain.pc.service.PersonalCenterService->unPublishedCV userId={}", (Object)userId);
        serviceProxy.callAfter(service -> {
            if (service != null) {
                service.afterUnPublishedCV(userId, bizResult);
            }
            return null;
        });
        return bizResult;
    }

    @Override
    public BizResult createCandidate(DeliveryParam param, KResumeBO KResumeBO2) {
        HRPluginProxy<IEmpCVService> serviceProxy = this.getCVServiceProxy();
        serviceProxy.callBefore(service -> {
            if (service != null) {
                service.beforeCreateCandidate(param, KResumeBO2);
            }
            return null;
        });
        BizResult bizResult = this.getDefCvService().createCandidate(param, KResumeBO2);
        logger.info("[extPoint]kd.tsc.tsirm.business.domain.pc.service.PersonalCenterService->createCandidate");
        serviceProxy.callAfter(service -> {
            if (service != null) {
                service.afterCreateCandidate(param, KResumeBO2, bizResult);
            }
            return null;
        });
        return bizResult;
    }

    @Override
    public BizResult getPersonInfo(Long userId) {
        BizResult empFile = new PersonInfoService().getPersonInfo(userId);
        KResumeBO kResumeBO = (KResumeBO)empFile.getData();
        HRPluginProxy<IEmpFileQueryService> empFileQueryService = this.getPersonInfoServiceProxy();
        empFileQueryService.callAfter(service -> {
            if (service != null) {
                service.afterLoadEmpFile(userId, kResumeBO);
            }
            return null;
        });
        logger.info("[extPoint]kd.tsc.tsirm.business.domain.pc.service.PersonalCenterService->getPersonInfo userId={}", (Object)userId);
        return empFile;
    }

    @Override
    public DynamicObject[] getEmpCVs(Long userId) {
        HRPluginProxy<IEmpCVService> serviceProxy = this.getCVServiceProxy();
        DynamicObject[] dos = this.getDefCvService().getEmpCVs(userId);
        serviceProxy.callAfter(service -> {
            if (service != null) {
                service.afterGetEmpCVs(userId, dos);
            }
            return null;
        });
        logger.info("[extPoint]kd.tsc.tsirm.business.domain.pc.service.PersonalCenterService->getEmpCVs userId={}", (Object)userId);
        return dos;
    }

    @Override
    public BizResult updateCVFormPersonInfo(Long cvId) {
        HRPluginProxy<IEmpCVService> serviceProxy = this.getCVServiceProxy();
        serviceProxy.callBefore(service -> {
            if (service != null) {
                service.beforeUpdateCVFormPersonInfo(cvId);
            }
            return null;
        });
        BizResult bizResult = this.getDefCvService().updateCVFormPersonInfo(cvId);
        logger.info("[extPoint]kd.tsc.tsirm.business.domain.pc.service.PersonalCenterService->updateCVFormPersonInfo cvId={}", (Object)cvId);
        serviceProxy.callAfter(service -> {
            if (service != null) {
                service.afterUpdateCVFormPersonInfo(cvId, bizResult);
            }
            return null;
        });
        return bizResult;
    }

    public BizResult deliveryCV(Long advertId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_advertpublish");
        DynamicObject advert = serviceHelper.queryOne("position", (Object)advertId);
        if (advert == null) {
            return BizResults.failed((int)PCServiceErrorStatusEnum.ADVERT_WITHOUTPOS.getStatus(), (String)"advert has not position");
        }
        Long positionId = advert.getLong("position.id");
        long currUserId = RequestContext.get().getCurrUserId();
        Long cvId = EmpCVHelper.getEmpCVId(currUserId);
        DeliveryParam deliveryParam = new DeliveryParam(Long.valueOf(currUserId), positionId, advertId, cvId, EmpDeliveryTypeEnum.DELIVTYPE_POSITION);
        return this.deliveryCV(deliveryParam);
    }

    public List<DynamicObject> getDeliveryRecords() {
        Long cvId = EmpCVHelper.getEmpCVId(RequestContext.get().getCurrUserId());
        return EmpDeliveryHelper.getDeliveryRecords(cvId);
    }

    public BizResult getPersonInfo() {
        Long currUserId = RequestContext.get().getCurrUserId();
        return this.getPersonInfo(currUserId);
    }

    public KResumeBO getEmpCV() {
        Long currUserId = RequestContext.get().getCurrUserId();
        Long cvId = EmpCVHelper.getEmpCVId(currUserId);
        return this.getEmpCV(cvId);
    }

    public BizResult unPublishedCV() {
        Long currUserId = RequestContext.get().getCurrUserId();
        return this.unPublishedCV(currUserId);
    }

    public BizResult createCandidate(Long delivBillId) {
        DynamicObject empDelivBillDy = EmpCVHelper.queryEmpDelivBill("id", delivBillId);
        DynamicObject delivCVDy = empDelivBillDy.getDynamicObject("delivcv");
        DynamicObject deliveryDy = empDelivBillDy.getDynamicObject("delivery");
        DeliveryParam deliveryParam = new DeliveryParam();
        deliveryParam.setDeliveryBillId(delivBillId);
        if (deliveryDy.getDynamicObject("position") != null) {
            deliveryParam.setPositionId(Long.valueOf(deliveryDy.getDynamicObject("position").getLong("id")));
        }
        deliveryParam.setDeliveryCVId(Long.valueOf(delivCVDy.getLong("id")));
        if (deliveryDy.getDynamicObject("deliveryper") != null) {
            deliveryParam.setDeliveryPerId(Long.valueOf(deliveryDy.getDynamicObject("deliveryper").getLong("id")));
        }
        deliveryParam.setCvId(Long.valueOf(deliveryDy.getDynamicObject("cv").getLong("id")));
        if (deliveryDy.getDynamicObject("advert") != null) {
            deliveryParam.setAdvertId(Long.valueOf(deliveryDy.getDynamicObject("advert").getLong("id")));
        }
        String delivtype = empDelivBillDy.getString("delivery.delivtype");
        deliveryParam.setDeliveryType(EmpDeliveryTypeEnum.getEmpDeliveryTypeEnum((String)delivtype));
        DefEmpCVService defEmpCVService = new DefEmpCVService();
        KResumeBO KResumeBO2 = defEmpCVService.getDeliveryCV(deliveryParam.getDeliveryCVId());
        return this.createCandidate(deliveryParam, KResumeBO2);
    }

    private HRPluginProxy<IEmpCVService> getCVServiceProxy() {
        return HRPlugInProxyFactory.create(null, IEmpCVService.class, (String)"kd.sdk.tsc.tsirm.extpoint.cv.IEmpCVService", null);
    }

    private HRPluginProxy<IEmpFileQueryService> getPersonInfoServiceProxy() {
        return HRPlugInProxyFactory.create(null, IEmpFileQueryService.class, (String)"kd.sdk.tsc.tsirm.extpoint.cv.IEmpFileQueryService", null);
    }

    private static class Instance {
        private static PersonalCenterService INSTANCE = new PersonalCenterService();

        private Instance() {
        }
    }
}

