/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class HbssJobAdapter {
    private static String JOB_ENTITY = "hbjm_jobhr";
    private static String JOB_LEVEL_ENTITY = "hbjm_joblevelhr";
    private static String JOB_GRADE_ENTITY = "hbjm_jobgradehr";
    private static String JOB_LEVEL_SEQ = "joblevelseq";
    private static String JOB_GRADE_SEQ = "jobgradeseq";

    public static DynamicObject queryJobDymById(long id) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(JOB_ENTITY);
        String selectFields = "lowjoblevel,highjoblevel,lowjobgrade,highjobgrade";
        return hrBaseServiceHelper.queryOriginalOne(selectFields, (Object)id);
    }

    public static List<Long> getJobLevelRangeByLevelId(long lowId, long highId) {
        return HbssJobAdapter.getRangeIdsBySeq(JOB_LEVEL_ENTITY, JOB_LEVEL_SEQ, lowId, highId);
    }

    public static List<Long> getJobGradeRangeByGradeId(long lowId, long highId) {
        return HbssJobAdapter.getRangeIdsBySeq(JOB_GRADE_ENTITY, JOB_GRADE_SEQ, lowId, highId);
    }

    public static List<Long> getRangeIdsBySeq(String entityName, String seqName, long lowId, long highId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
        String scmFlag = JOB_LEVEL_ENTITY.equals(entityName) ? "joblevelscm" : "jobgradescm";
        DynamicObject dym = hrBaseServiceHelper.queryOne(scmFlag, (Object)lowId);
        if (dym == null || dym.getDynamicObject(scmFlag) == null) {
            return new ArrayList<Long>();
        }
        long scmFlagId = dym.getDynamicObject(scmFlag).getLong("id");
        DynamicObject lowDym = hrBaseServiceHelper.queryOne(seqName, (Object)lowId);
        int lowSeq = lowDym.getInt(seqName);
        DynamicObject highDym = hrBaseServiceHelper.queryOne(seqName, (Object)highId);
        int highSeq = highDym.getInt(seqName);
        QFilter qFilter = new QFilter(seqName, ">=", (Object)lowSeq);
        qFilter.and(new QFilter(seqName, "<=", (Object)highSeq));
        qFilter.and(new QFilter(scmFlag, "=", (Object)scmFlagId));
        DynamicObject[] jobDynamicObjects = hrBaseServiceHelper.query(new QFilter[]{qFilter});
        return Arrays.asList(jobDynamicObjects).stream().map(map -> map.getLong("id")).collect(Collectors.toList());
    }
}

