/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.hr.hbp.common.util.HRStringUtils;

public class PosPortraitConvertHelper {
    private static final Map<String, Function<String, List<String>>> SECTITLE_CONVERT_MAP = Maps.newHashMapWithExpectedSize((int)31);
    private static final List<String> ORDER_FIR_TITLES = Lists.newArrayListWithExpectedSize((int)6);
    private static final Map<String, List<String>> ORDER_SEC_TITLES = Maps.newHashMapWithExpectedSize((int)31);
    private static final Map<String, String> CODE2_NAME = Maps.newHashMapWithExpectedSize((int)40);

    public PosPortraitConvertHelper() {
        ORDER_FIR_TITLES.add("positions");
        ORDER_FIR_TITLES.add("educations");
        ORDER_FIR_TITLES.add("employments");
        ORDER_FIR_TITLES.add("skills");
        ORDER_FIR_TITLES.add("ability_quality");
        ORDER_FIR_TITLES.add("others");
        ArrayList<String> positions = new ArrayList<String>();
        positions.add("job_similar");
        positions.add("job_category");
        positions.add("job_level");
        positions.add("work_address");
        positions.add("position_type");
        ORDER_SEC_TITLES.put("positions", positions);
        ArrayList<String> educations = new ArrayList<String>();
        educations.add("school_title");
        educations.add("school_type");
        educations.add("benchmark_school");
        educations.add("minimum_education");
        educations.add("major");
        educations.add("first_education");
        educations.add("is_oversea_education");
        educations.add("is_full_time");
        ORDER_SEC_TITLES.put("educations", educations);
        ArrayList<String> employments = new ArrayList<String>();
        employments.add("industry");
        employments.add("benchmark_company");
        employments.add("work_duration");
        employments.add("salary");
        employments.add("project");
        employments.add("project_count");
        employments.add("is_oversea_employment");
        employments.add("is_management");
        ORDER_SEC_TITLES.put("employments", employments);
        ArrayList<String> skills = new ArrayList<String>();
        skills.add("job_skill");
        skills.add("language_skill");
        ORDER_SEC_TITLES.put("skills", skills);
        ArrayList<String> ability_quality = new ArrayList<String>();
        ability_quality.add("ability");
        ability_quality.add("quality");
        ORDER_SEC_TITLES.put("ability_quality", ability_quality);
        ArrayList<String> others = new ArrayList<String>();
        others.add("age");
        others.add("duty_time");
        others.add("is_avoid_relatives");
        others.add("avoid_company");
        others.add("bonus");
        ORDER_SEC_TITLES.put("others", others);
    }

    public List<String> getOrderFirTitles() {
        return ORDER_FIR_TITLES;
    }

    public Map<String, List<String>> getOrderSecTitles() {
        return ORDER_SEC_TITLES;
    }

    public Map<String, String> getCode2Name() {
        return CODE2_NAME;
    }

    public List<String> viewConvert(String key, String value) {
        Function<String, List<String>> function = SECTITLE_CONVERT_MAP.get(key);
        if (null == function || HRStringUtils.isEmpty((String)key)) {
            return Collections.emptyList();
        }
        return function.apply(value);
    }
}

