/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.tsc.common.vo.BizResult;
import kd.tsc.tsirm.business.domain.position.service.PositionLabelServiceHelper;
import kd.tsc.tsirm.business.domain.position.service.enums.PosPortraitOperateEnum;
import kd.tsc.tsrbd.business.domain.common.entity.BizResults;

public class PosPortraitHelper {
    private DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    public static final String CACHE_KEY_PREFIX_PORTRAIT_POS_ID = "portrait_id_";
    public static final String CACHE_KEY_PREFIX_PORTRAIT_STATUS = "portrait_status_";
    public static final Integer CODE_SAVE_PORTRAIT_FIRST = -10;
    public static final Integer CODE_HAVE_PORTRAIT = 20;
    public static final Integer CODE_NO_PORTRAIT = -20;

    public BizResult operate(Long positionId, String positionInfo, PosPortraitOperateEnum posPortraitOperateEnum) {
        JSONObject completeTag;
        if (HRStringUtils.equals((String)posPortraitOperateEnum.getCode(), (String)PosPortraitOperateEnum.POS_PORTRAIT_BTN.getCode()) && null != (completeTag = PositionLabelServiceHelper.getInstance().getLabelByPositionInfo(positionInfo))) {
            String data = completeTag.toJSONString();
            this.cache.put(CACHE_KEY_PREFIX_PORTRAIT_POS_ID + positionId, (Object)data, Integer.MAX_VALUE, TimeUnit.DAYS);
            BizResult bizResult = BizResults.success();
            bizResult.setData((Object)data);
            return bizResult;
        }
        if (this.saveOperate(posPortraitOperateEnum, positionId)) {
            return BizResults.failed((int)CODE_SAVE_PORTRAIT_FIRST, (String)"please save portrait first");
        }
        if (HRStringUtils.equals((String)posPortraitOperateEnum.getCode(), (String)PosPortraitOperateEnum.COMMIT.getCode())) {
            this.commitOperate(positionId, positionInfo, posPortraitOperateEnum);
        }
        return BizResults.success();
    }

    public BizResult operates(Map<Long, String> positionMap, PosPortraitOperateEnum posPortraitOperateEnum) {
        for (Map.Entry<Long, String> entry : positionMap.entrySet()) {
            Long positionId = entry.getKey();
            String positionInfo = entry.getValue();
            if (HRStringUtils.equals((String)posPortraitOperateEnum.getCode(), (String)PosPortraitOperateEnum.POS_PORTRAIT_BTN.getCode())) {
                this.updatePorCache(positionId, positionInfo);
            }
            if (this.saveOperate(posPortraitOperateEnum, positionId)) {
                return BizResults.failed((int)CODE_SAVE_PORTRAIT_FIRST, (String)"please save portrait first");
            }
            if (!HRStringUtils.equals((String)posPortraitOperateEnum.getCode(), (String)PosPortraitOperateEnum.COMMIT.getCode())) continue;
            this.commitOperate(positionId, positionInfo, posPortraitOperateEnum);
        }
        return BizResults.success();
    }

    private void updatePorCache(Long positionId, String positionInfo) {
        JSONObject completeTag = PositionLabelServiceHelper.getInstance().getLabelByPositionInfo(positionInfo);
        if (null != completeTag) {
            String data = completeTag.toJSONString();
            this.cache.put(CACHE_KEY_PREFIX_PORTRAIT_POS_ID + positionId, (Object)data, Integer.MAX_VALUE, TimeUnit.DAYS);
        }
    }

    private void commitOperate(Long positionId, String positionInfo, PosPortraitOperateEnum posPortraitOperateEnum) {
        String porInfo = (String)this.cache.get(CACHE_KEY_PREFIX_PORTRAIT_POS_ID + positionId);
        if (HRStringUtils.isNotEmpty((String)porInfo)) {
            PositionLabelServiceHelper.getInstance().savePositionLabelToAi(positionId, porInfo, Boolean.FALSE);
        } else {
            PositionLabelServiceHelper.getInstance().savePositionLabelToAi(positionId, positionInfo, Boolean.TRUE);
            this.updatePorCache(positionId, positionInfo);
        }
    }

    private boolean saveOperate(PosPortraitOperateEnum posPortraitOperateEnum, Long positionId) {
        if (HRStringUtils.equals((String)posPortraitOperateEnum.getCode(), (String)PosPortraitOperateEnum.SAVE.getCode())) {
            String status = (String)this.cache.get(CACHE_KEY_PREFIX_PORTRAIT_STATUS + positionId);
            if (HRStringUtils.equals((String)"edit", (String)status)) {
                return true;
            }
            String porInfo = (String)this.cache.get(CACHE_KEY_PREFIX_PORTRAIT_POS_ID + positionId);
            if (HRStringUtils.isNotEmpty((String)porInfo)) {
                PositionLabelServiceHelper.getInstance().savePositionLabelToAi(positionId, porInfo, Boolean.FALSE);
            }
        }
        return false;
    }

    public BizResult getPortraitStatus(Long positionId) {
        JSONObject resultJson;
        if (null == positionId) {
            return BizResults.failed((int)CODE_NO_PORTRAIT, (String)"no portrait");
        }
        String porInfo = (String)this.cache.get(CACHE_KEY_PREFIX_PORTRAIT_POS_ID + positionId);
        if (HRStringUtils.isNotEmpty((String)porInfo)) {
            resultJson = JSONObject.parseObject((String)porInfo);
        } else {
            resultJson = PositionLabelServiceHelper.getInstance().getLabelByPositionId(positionId);
            this.cache.put(CACHE_KEY_PREFIX_PORTRAIT_POS_ID + positionId, (Object)resultJson.toJSONString(), Integer.MAX_VALUE, TimeUnit.DAYS);
        }
        if (resultJson != null && !resultJson.isEmpty()) {
            return BizResults.success((Integer)CODE_HAVE_PORTRAIT, (String)"have portrait");
        }
        return BizResults.failed((int)CODE_NO_PORTRAIT, (String)"no portrait");
    }
}

