/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class PositionBillDataHelper {
    public static List<Object> submitBill(String billPageNumber, List<Long> positionSnapIdList, List<Long> positionIds, Map<Long, DynamicObject> map, OperateOption option) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(billPageNumber);
        int tag = 0;
        Long userId = TSCRequestContext.getUserId();
        Date dataNow = new Date();
        ArrayList billDys = Lists.newArrayListWithCapacity((int)positionSnapIdList.size());
        ArrayList numberList = Lists.newArrayListWithCapacity((int)positionSnapIdList.size());
        for (Long positionSnapId : positionSnapIdList) {
            DynamicObject billDyn = serviceHelper.generateEmptyDynamicObject();
            String number = CodeRuleServiceHelper.readNumber((String)billPageNumber, (DynamicObject)billDyn, null);
            numberList.add(number);
            billDyn.set("billno", (Object)number);
            billDyn.set("billstatus", (Object)"A");
            billDyn.set("creator", (Object)userId);
            billDyn.set("createtime", (Object)dataNow);
            billDyn.set("auditstatus", (Object)"A");
            billDyn.set("isexistsworkflow", (Object)Boolean.TRUE);
            billDyn.set("positionsnap", (Object)positionSnapId);
            Long id = positionIds.get(tag);
            billDyn.set("position", (Object)map.get(id));
            billDyn.set("datastatus", (Object)"2");
            billDys.add(billDyn);
            ++tag;
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"tsirm_positionbill", (DynamicObject[])billDys.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            option.setVariableValue("errorMessage", ((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage());
            numberList.clear();
        } else {
            option.setVariableValue("errorMessage", "");
        }
        return numberList;
    }

    public static List<Object> submiteffectBill(String billPageNumber, List<Long> positionSnapIdList, List<Long> positionIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(billPageNumber);
        int tag = 0;
        Long userId = TSCRequestContext.getUserId();
        Date dataNow = new Date();
        ArrayList billDys = Lists.newArrayListWithCapacity((int)positionSnapIdList.size());
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)billPageNumber, (DynamicObject)dynamicObject, null, (int)positionSnapIdList.size());
        for (int index = 0; index < positionSnapIdList.size(); ++index) {
            Long positionSnapId = positionSnapIdList.get(index);
            DynamicObject billDyn = serviceHelper.generateEmptyDynamicObject();
            billDyn.set("billno", (Object)batchNumber[index]);
            billDyn.set("billstatus", (Object)"H");
            billDyn.set("creator", (Object)userId);
            billDyn.set("createtime", (Object)dataNow);
            billDyn.set("auditstatus", (Object)"C");
            billDyn.set("isexistsworkflow", (Object)Boolean.TRUE);
            billDyn.set("positionsnap", (Object)positionSnapId);
            billDyn.set("position", (Object)positionIds.get(tag));
            billDyn.set("datastatus", (Object)"1");
            billDys.add(billDyn);
            ++tag;
        }
        serviceHelper.save(billDys.toArray(new DynamicObject[0]));
        return Arrays.stream(batchNumber).collect(Collectors.toList());
    }

    public static DynamicObject[] getPositionBillByBillNo(String billPageNumber, List<String> billNoList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(billPageNumber);
        QFilter billNoFilter = new QFilter("billno", "in", billNoList);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{billNoFilter});
    }

    public static DynamicObject getPositionBillByBillId(String billPageNumber, Long billId) {
        return PositionBillDataHelper.getPositionBillByBillId(billPageNumber, billId, null);
    }

    public static DynamicObject getPositionBillByBillId(String billPageNumber, Long billId, String properties) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(billPageNumber);
        QFilter qFilter = new QFilter("id", "=", (Object)billId);
        if (HRStringUtils.isEmpty((String)properties)) {
            return serviceHelper.loadDynamicObject(qFilter);
        }
        return serviceHelper.queryOne(properties, qFilter);
    }

    public static void updatePositionBill(String billPageNumber, List<Long> billIdList, Map<String, List<Object>> valueMap) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(billPageNumber);
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(billIdList.toArray());
        for (Map.Entry<String, List<Object>> entry : valueMap.entrySet()) {
            String key = entry.getKey();
            List<Object> valueList = entry.getValue();
            int index = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set(key, valueList.get(index));
                ++index;
            }
        }
        serviceHelper.save(dynamicObjects);
    }

    public static DynamicObject[] getPositionBillByPositionId(Long positionId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_positionbill");
        QFilter positionFilter = new QFilter("position", "=", (Object)positionId);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{positionFilter});
    }

    public static DynamicObject getPositionBillByBillNo(Long positionId, String billNo) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_positionbill");
        QFilter positionFilter = new QFilter("position", "=", (Object)positionId);
        positionFilter.and("billno", "=", (Object)billNo);
        return serviceHelper.loadDynamicObject(new QFilter[]{positionFilter});
    }

    public static Boolean checkSubmitPerm() {
        long currUserId = RequestContext.get().getCurrUserId();
        boolean superUser = PermissionServiceHelper.isSuperUser((long)currUserId);
        if (!superUser) {
            return PermissionServiceHelper.checkPermission((Long)currUserId, (String)"tsirm", (String)"tsirm_positionbill", (String)"804f6478000000ac");
        }
        return true;
    }

    public static Boolean checkCommitPerm() {
        long currUserId = RequestContext.get().getCurrUserId();
        boolean superUser = PermissionServiceHelper.isSuperUser((long)currUserId);
        if (!superUser) {
            return PermissionServiceHelper.checkPermission((Long)currUserId, (String)"tsirm", (String)"tsirm_positionbill", (String)"0A3CBG6XWQC5");
        }
        return true;
    }
}

