/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.advert.service.AdvertUpadteHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionBillDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionManageService;

public class PositionBillService {
    private static final Log LOGGER = LogFactory.getLog(PositionBillService.class);

    private PositionBillService() {
    }

    public static PositionBillService getInstance() {
        return new PositionBillService();
    }

    public void openPositionBillPage(String billPageNumber, DynamicObject positionBillDyn, IFormView view) {
        long positionBillId = positionBillDyn.getLong("id");
        String billStatus = positionBillDyn.getString("billstatus");
        Map<String, BillOperationStatus> billStatusMap = this.getStatusMap();
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId((Object)positionBillId);
        billShowParameter.setFormId(billPageNumber);
        String positionName = positionBillDyn.getDynamicObject("position").getString("name");
        billShowParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u62db\u8058\u804c\u4f4d\u7533\u8bf7\u5355-%s", (String)"PositionBillService_2", (String)"tsc-tsirm-business", (Object[])new Object[0]), positionName));
        billShowParameter.setBillStatus(billStatusMap.get(billStatus));
        billShowParameter.setStatus(OperationStatus.VIEW);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String positionId = positionBillDyn.getDynamicObject("position").getString("id");
        billShowParameter.setPageId(this.getPageId(positionId, positionBillDyn.getString("billno")));
        view.showForm((FormShowParameter)billShowParameter);
    }

    public void openPositionBillEditPage(String billPageNumber, DynamicObject positionBillDyn, IFormView view) {
        long positionBillId = positionBillDyn.getLong("id");
        String billStatus = positionBillDyn.getString("billstatus");
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId((Object)positionBillId);
        billShowParameter.setFormId(billPageNumber);
        DynamicObject positionDyn = view.getModel().getDataEntity(true);
        billShowParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u62db\u8058\u804c\u4f4d\u7533\u8bf7\u5355-%s", (String)"PositionBillService_2", (String)"tsc-tsirm-business", (Object[])new Object[0]), positionDyn.getString("name")));
        Map<String, BillOperationStatus> billStatusMap = this.getStatusMap();
        billShowParameter.setBillStatus(billStatusMap.get(billStatus));
        billShowParameter.setStatus(OperationStatus.EDIT);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setPageId(this.getPageId(positionDyn.getString("id"), positionBillDyn.getString("billno")) + "edit");
        view.showForm((FormShowParameter)billShowParameter);
    }

    public void openNewPositionBillPage(String billPageNumber, Map<String, Object> parms, IFormView view) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(billPageNumber);
        DynamicObject positionDyn = view.getModel().getDataEntity(true);
        if (!"bos_list".equals(positionDyn.getDataEntityType().getName())) {
            DynamicObject positionNewDyn = PositionDataHelper.getPositionObjByPositionId(positionDyn.getLong("id"));
            billShowParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u62db\u8058\u804c\u4f4d\u7533\u8bf7\u5355-%s", (String)"PositionBillService_2", (String)"tsc-tsirm-business", (Object[])new Object[0]), positionNewDyn.getString("name")));
            billShowParameter.setPageId(this.getPageId(positionDyn.getString("id"), positionNewDyn.getString("billno")) + "new");
        }
        billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        billShowParameter.setStatus(OperationStatus.ADDNEW);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.getCustomParams().putAll(parms);
        view.showForm((FormShowParameter)billShowParameter);
    }

    public void openPositionPage(String formId, String targetKey, IFormView view, BillOperationStatus billStatus, OperationStatus status, Long pkId) {
        this.openPositionPage(formId, targetKey, view, billStatus, status, pkId, null);
    }

    public void openPositionPage(String formId, String targetKey, IFormView view, BillOperationStatus billStatus, OperationStatus status, Long pkId, Map<String, Object> parms) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setTargetKey(targetKey);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        if (billStatus != null) {
            parameter.setBillStatus(billStatus);
        }
        if (status != null) {
            parameter.setStatus(status);
        }
        if (pkId != null) {
            parameter.setPkId((Object)pkId);
        }
        if (parms != null) {
            parameter.getCustomParams().putAll(parms);
        }
        String pageId = parameter.getPageId();
        view.showForm((FormShowParameter)parameter);
        view.getPageCache().put(formId, pageId);
    }

    public void savePositionBill(IFormView view, DynamicObject billDyn, DynamicObject positionDyn) {
        List<Long> positionSnapIds;
        long positionId = positionDyn.getLong("id");
        if (positionId == 0L) {
            positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)billDyn, (String)"position");
        }
        long positionBillId = billDyn.getLong("id");
        List<Long> positionIdList = Collections.singletonList(positionId);
        Object positionSnap = billDyn.get("positionsnap");
        if (positionSnap == null) {
            positionSnapIds = PositionDataHelper.syncUpdatePositionSnapshot(new DynamicObject[]{positionDyn}, positionIdList, "2");
            HashMap valueMap = Maps.newHashMapWithExpectedSize((int)16);
            valueMap.put("positionsnap", Collections.singletonList(positionSnapIds));
            PositionBillDataHelper.updatePositionBill("tsirm_positionbill", Collections.singletonList(positionBillId), valueMap);
        } else {
            positionSnapIds = Collections.singletonList(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)billDyn, (String)"positionsnap"));
            PositionDataHelper.syncUpdatePositionSnapshotBySnapIds(new DynamicObject[]{positionDyn}, positionSnapIds);
        }
        if (positionSnap == null) {
            this.saveNewBillAttachs(view, positionSnapIds.get(0));
        } else {
            this.saveBillAttachs(view, positionSnapIds.get(0));
        }
        PositionBillService.getInstance().syncUpdatePosition(billDyn, positionDyn, positionSnapIds.get(0));
        String billNo = billDyn.getString("billno");
        String billStatus = billDyn.getString("billstatus");
        if (!"G".equals(billStatus)) {
            HashMap positionValueMap = Maps.newHashMapWithExpectedSize((int)16);
            positionValueMap.put("billno", Collections.singletonList(billNo));
            positionValueMap.put("status", Collections.singletonList("A"));
            positionValueMap.put("billstatus", Collections.singletonList("A"));
            PositionDataHelper.updatePositionInfo("tsirm_position", positionIdList, (Map<String, List<Object>>)positionValueMap);
        }
    }

    public void saveBillAttachs(IFormView view, Long snapId) {
        String pageId = view.getPageCache().get("tsirm_position_billview");
        IFormView childView = view.getView(pageId);
        AttachmentPanel panel = (AttachmentPanel)childView.getControl("attachmentpanelap");
        List attachmentData = panel.getAttachmentData();
        List attachmentDb = AttachmentServiceHelper.getAttachments((String)"tsirm_positionsnaptpl", (Object)snapId, (String)"attachmentpanelap");
        List attachmentDataUids = attachmentData.stream().map(pos -> String.valueOf(pos.get("uid"))).collect(Collectors.toList());
        for (Map attach : attachmentDb) {
            String uid = String.valueOf(attach.get("uid"));
            if (attachmentDataUids.contains(uid)) continue;
            AttachmentServiceHelper.remove((String)"tsirm_positionsnaptpl", (Object)snapId, (Object)uid);
        }
        HashMap<String, List> attachmentDataMap = new HashMap<String, List>(16);
        attachmentDataMap.put("attachmentpanelap", attachmentData);
        AttachmentServiceHelper.saveTempAttachments((String)"tsirm_positionsnaptpl", (Object)snapId, (String)view.getFormShowParameter().getAppId(), attachmentDataMap);
    }

    public void saveNewBillAttachs(IFormView view, Long snapId) {
        String pageId = view.getPageCache().get("tsirm_position_billview");
        IFormView childView = view.getView(pageId);
        AttachmentPanel panel = (AttachmentPanel)childView.getControl("attachmentpanelap");
        List attachmentData = panel.getAttachmentData();
        DynamicObjectCollection attachObjects = new DynamicObjectCollection();
        HRBaseServiceHelper attachServiceHelper = new HRBaseServiceHelper("bos_attachment");
        for (Map attach : attachmentData) {
            String uid;
            if (AttachmentServiceHelper.isTempAttachment((Map)attach) || !(uid = String.valueOf(attach.get("uid"))).contains("newid")) continue;
            DynamicObject attachmentObj = AttachmentServiceHelper.getAttCreatorByUID((String)this.decipId(uid));
            attachObjects.add((Object)PositionHelper.saveAttachment(snapId, String.valueOf(attach.get("name")), attachmentObj.getString("fdescription"), attachmentObj.getString("ffileid"), String.valueOf(attach.get("size")), "tsirm_positionsnaptpl"));
        }
        HashMap<String, List> attachmentDataMap = new HashMap<String, List>(16);
        attachmentDataMap.put("attachmentpanelap", attachmentData);
        try (TXHandle tx = TX.requiresNew();){
            try {
                attachServiceHelper.save(attachObjects);
                AttachmentServiceHelper.saveTempAttachments((String)"tsirm_positionsnaptpl", (Object)snapId, (String)view.getFormShowParameter().getAppId(), attachmentDataMap);
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error((Throwable)e);
            }
        }
    }

    public void updateBillAttachsToPos(Long positionId, Long snapId) {
        AttachmentServiceHelper.remove((String)"tsirm_positiontpl", (Object)positionId);
        PositionHelper.updateAttachment("tsirm_positionsnaptpl", "tsirm_positiontpl", snapId, positionId);
    }

    public void submitPositionBill(IFormView view, DynamicObject billDyn, DynamicObject positionDyn) {
        Object positionSnap = billDyn.get("positionsnap");
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)billDyn, (String)"position");
        List<Long> positionIdList = Collections.singletonList(positionId);
        if (positionSnap == null) {
            this.savePositionBill(view, billDyn, positionDyn);
        } else {
            List<Long> snapIds = Collections.singletonList(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)billDyn, (String)"positionsnap"));
            PositionDataHelper.syncUpdatePositionSnapshotBySnapIds(new DynamicObject[]{positionDyn}, snapIds);
            this.saveBillAttachs(view, snapIds.get(0));
            PositionBillService.getInstance().syncUpdatePosition(billDyn, positionDyn, snapIds.get(0));
        }
        if (this.positionStatusIsOpenOrClose(positionId)) {
            this.setPositionStatus(positionIdList, "B", null);
        } else {
            this.setPositionStatus(positionIdList, "B", "E");
        }
    }

    public void submitEffectPositionBill(IFormView view, DynamicObject billDyn, DynamicObject positionDyn) {
        Object positionSnap = billDyn.get("positionsnap");
        if (positionSnap == null) {
            this.savePositionBill(view, billDyn, positionDyn);
        } else {
            List<Long> snapIds = Collections.singletonList(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)billDyn, (String)"positionsnap"));
            PositionDataHelper.syncUpdatePositionSnapshotBySnapIds(new DynamicObject[]{positionDyn}, snapIds);
            this.saveBillAttachs(view, snapIds.get(0));
        }
        this.auditPositionBill(billDyn.getLong("id"), true);
    }

    public void updatePositionStatus(DynamicObject billDyn, DynamicObject positionDyn) {
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)billDyn, (String)"position");
        List<Long> positionIdList = Collections.singletonList(positionId);
        DynamicObject position = PositionDataHelper.queryOneByPositionId(positionId);
        String positionStatus = position.getString("positionstatus");
        if ("E".equals(positionStatus)) {
            this.setPositionStatus(positionIdList, null, "D");
        }
    }

    private void setPositionStatus(List<Long> positionIdList, String status, String positionstatus) {
        HashMap positionValueMap = Maps.newHashMapWithExpectedSize((int)16);
        if (HRStringUtils.isNotEmpty((String)status)) {
            positionValueMap.put("status", Collections.singletonList(status));
            positionValueMap.put("billstatus", Collections.singletonList(status));
        }
        if (HRStringUtils.isNotEmpty((String)positionstatus)) {
            positionValueMap.put("positionstatus", Collections.singletonList(positionstatus));
            if ("G".equals(positionstatus) || "D".equals(positionstatus)) {
                positionValueMap.put("positionpriority", Collections.singletonList(0));
            } else {
                positionValueMap.put("positionpriority", Collections.singletonList(1));
            }
        }
        PositionDataHelper.updatePositionInfo("tsirm_position", positionIdList, (Map<String, List<Object>>)positionValueMap);
    }

    public void auditPositionBill(Long positionBillId, boolean isSubmitEffectPositionBill) {
        DynamicObject positionBillDyn = PositionBillDataHelper.getPositionBillByBillId("tsirm_positionbill", positionBillId);
        Long postionSnapId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionBillDyn, (String)"positionsnap");
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionBillDyn, (String)"position");
        if (isSubmitEffectPositionBill) {
            positionBillDyn.set("billstatus", (Object)(isSubmitEffectPositionBill ? "H" : "C"));
        }
        this.setBillDataStatus(positionBillDyn);
        PositionDataHelper.syncUpdatePositionFromPostionSnap(postionSnapId);
        PositionBillService.getInstance().updateBillAttachsToPos(positionId, postionSnapId);
        if (this.positionStatusIsOpenOrClose(positionId)) {
            this.setPositionStatus(Collections.singletonList(positionId), isSubmitEffectPositionBill ? "H" : "C", null);
        } else {
            this.setPositionStatus(Collections.singletonList(positionId), isSubmitEffectPositionBill ? "H" : "C", "A");
        }
        try {
            new AdvertUpadteHelper().updateAdvertisementByPositionId(positionId);
        }
        catch (Exception ex) {
            LOGGER.error("\u804c\u4f4d\u5ba1\u6838\u5931\u8d25", (Throwable)ex);
        }
    }

    public void submitedPositionBill(Long positionBillId) {
        DynamicObject positionBillDyn = PositionBillDataHelper.getPositionBillByBillId("tsirm_positionbill", positionBillId);
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionBillDyn, (String)"position");
        LOGGER.info("submitedPositionBill param billid {}, positionId {} ", (Object)positionBillId, (Object)positionId);
        if (this.positionStatusIsOpenOrClose(positionId)) {
            LOGGER.info("submitedPositionBill param billid {}, positionId {},ing or close ", (Object)positionBillId, (Object)positionId);
            this.setPositionStatus(Collections.singletonList(positionId), "D", null);
        } else {
            LOGGER.info("submitedPositionBill param billid {}, positionId {},update AUDITSTATUS_AUDITING ", (Object)positionBillId, (Object)positionId);
            this.setPositionStatus(Collections.singletonList(positionId), "D", "E");
        }
    }

    public void unSubmitedPositionBill(Long positionBillId) {
        DynamicObject positionBillDyn = PositionBillDataHelper.getPositionBillByBillId("tsirm_positionbill", positionBillId, "position");
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionBillDyn, (String)"position");
        this.setPositionStatus(Collections.singletonList(positionId), "A", this.positionStatusIsOpenOrClose(positionId) ? null : "B");
    }

    public void discarPositionBill(Long positionBillId) {
        DynamicObject positionBillDyn = PositionBillDataHelper.getPositionBillByBillId("tsirm_positionbill", positionBillId);
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionBillDyn, (String)"position");
        positionBillDyn.set("datastatus", (Object)"0");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_positionbill");
        serviceHelper.saveOne(positionBillDyn);
        this.setPositionStatus(Collections.singletonList(positionId), "F", this.positionStatusIsOpenOrClose(positionId) ? null : "D");
    }

    private boolean positionStatusIsOpenOrClose(Long positionId) {
        if (Objects.isNull(positionId)) {
            return false;
        }
        DynamicObject[] positions = PositionDataHelper.findPositions(Collections.singletonList(positionId), "positionstatus");
        String positionStatus = positions[0].getString("positionstatus");
        return "A".equals(positionStatus) || "C".equals(positionStatus);
    }

    public void auditNotPassPositionBill(Long positionBillId) {
        DynamicObject position;
        DynamicObject positionBillDyn = PositionBillDataHelper.getPositionBillByBillId("tsirm_positionbill", positionBillId);
        positionBillDyn.set("datastatus", (Object)"0");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_positionbill");
        serviceHelper.saveOne(positionBillDyn);
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionBillDyn, (String)"position");
        List<Long> positionIdList = Collections.singletonList(positionId);
        DynamicObject[] positions = PositionDataHelper.getPositionObjByPositionIds(positionIdList);
        String positionStatus = null;
        if (positions.length != 0 && "E".equals((position = positions[0]).getString("positionstatus"))) {
            positionStatus = "D";
        }
        this.setPositionStatus(Collections.singletonList(positionId), "E", positionStatus);
    }

    public void rejectPositionBill(Long positionBillId, String operationKey) {
        DynamicObject positionBillDyn = PositionBillDataHelper.getPositionBillByBillId("tsirm_positionbill", positionBillId);
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionBillDyn, (String)"position");
        if (HRStringUtils.equals((String)"rejecttosubmit", (String)operationKey)) {
            String status = "G";
            this.setPositionStatus(Collections.singletonList(positionId), status, this.positionStatusIsOpenOrClose(positionId) ? null : "E");
        } else {
            String status = "B";
            this.setPositionStatus(Collections.singletonList(positionId), status, this.positionStatusIsOpenOrClose(positionId) ? null : "E");
        }
    }

    private void setBillDataStatus(DynamicObject positionBillDyn) {
        Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)positionBillDyn, (String)"position");
        DynamicObject[] positionBills = PositionBillDataHelper.getPositionBillByPositionId(positionId);
        List<DynamicObject> billList = Arrays.stream(positionBills).filter(positionBill -> HRStringUtils.equals((String)positionBill.getString("datastatus"), (String)"1")).collect(Collectors.toList());
        billList.forEach(bill -> bill.set("datastatus", (Object)"0"));
        positionBillDyn.set("datastatus", (Object)"1");
        billList.add(positionBillDyn);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_positionbill");
        serviceHelper.save(billList.toArray(new DynamicObject[0]));
    }

    public void setBillStatusLbl(IFormView view, String billStatus) {
        if (HRStringUtils.equals((String)"A", (String)billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"status1"});
            view.setVisible(Boolean.FALSE, new String[]{"status2", "status3", "status4", "status5", "status6", "status7", "status8"});
        } else if (HRStringUtils.equals((String)"B", (String)billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"status3"});
            view.setVisible(Boolean.FALSE, new String[]{"status2", "status1", "status4", "status5", "status6", "status7", "status8"});
        } else if (HRStringUtils.equals((String)"F", (String)billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"status5"});
            view.setVisible(Boolean.FALSE, new String[]{"status2", "status1", "status4", "status3", "status6", "status7", "status8"});
        } else if (HRStringUtils.equals((String)"G", (String)billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"status2"});
            view.setVisible(Boolean.FALSE, new String[]{"status5", "status1", "status4", "status3", "status6", "status7", "status8"});
        } else if (HRStringUtils.equals((String)"C", (String)billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"status6"});
            view.setVisible(Boolean.FALSE, new String[]{"status5", "status1", "status4", "status3", "status2", "status7", "status8"});
        } else if (HRStringUtils.equals((String)"E", (String)billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"status7"});
            view.setVisible(Boolean.FALSE, new String[]{"status5", "status1", "status4", "status3", "status2", "status6", "status8"});
        } else if (HRStringUtils.equals((String)"D", (String)billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"status4"});
            view.setVisible(Boolean.FALSE, new String[]{"status5", "status1", "status7", "status3", "status2", "status6", "status8"});
        } else if (HRStringUtils.equals((String)"H", (String)billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"status8"});
            view.setVisible(Boolean.FALSE, new String[]{"status5", "status1", "status7", "status3", "status2", "status6", "status4"});
        }
    }

    public void setButtonVisable(IFormView view, String billStatus, Long positionId) {
        BillShowParameter billShowParameter = (BillShowParameter)view.getFormShowParameter();
        BillOperationStatus operationStatus = billShowParameter.getBillStatus();
        if (HRStringUtils.equals((String)"E", (String)billStatus) || HRStringUtils.equals((String)"C", (String)billStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"baritemap"});
        } else if (HRStringUtils.equals((String)"F", (String)billStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"baritemap", "bar_modify", "bar_submit", "bar_submiteffect"});
        } else if (HRStringUtils.equals((String)"G", (String)billStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_discard", "bar_submiteffect"});
            if (BillOperationStatus.VIEW.equals((Object)operationStatus)) {
                view.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_discard"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_modify"});
            } else if (BillOperationStatus.EDIT.equals((Object)operationStatus)) {
                view.setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_discard"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_modify"});
            }
            String positionStatus = this.getPositionStatus(positionId);
            if ("E".equals(positionStatus)) {
                view.setVisible(Boolean.FALSE, new String[]{"bar_modify"});
            }
        } else if (HRStringUtils.equals((String)"A", (String)billStatus)) {
            String positionStatus = this.getPositionStatus(positionId);
            if (BillOperationStatus.VIEW.equals((Object)operationStatus)) {
                view.setVisible(Boolean.TRUE, new String[]{"bar_modify"});
            } else if (BillOperationStatus.EDIT.equals((Object)operationStatus)) {
                view.setVisible(Boolean.FALSE, new String[]{"bar_modify"});
            }
            if ("E".equals(positionStatus)) {
                view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_save"});
            }
        } else if (HRStringUtils.equals((String)"H", (String)billStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_save", "bar_submit", "bar_submiteffect", "bar_del", "bar_discard", "baritemap"});
        }
    }

    public void setButtonVisableNew(IFormView view, String billStatus, Long positionId) {
        BillShowParameter billShowParameter = (BillShowParameter)view.getFormShowParameter();
        BillOperationStatus operationStatus = billShowParameter.getBillStatus();
        String positionStatus = this.getPositionStatus(positionId);
        if ("A".equals(billStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_submiteffect", "bar_discard", "baritemap", "bar_viewflowchart"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_modify"});
            this.setEditOrSave(view, operationStatus);
            view.setVisible(Boolean.FALSE, new String[]{"flexpanelap6"});
        } else if ("B".equals(billStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_save", "bar_submit", "bar_submiteffect", "bar_del", "bar_discard"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_viewflowchart", "baritemap"});
            view.setVisible(Boolean.TRUE, new String[]{"flexpanelap6"});
        } else if ("G".equals(billStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_submiteffect", "bar_del", "baritemap"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_viewflowchart", "bar_modify", "bar_discard"});
            this.setEditOrSave2(view, operationStatus);
            view.setVisible(Boolean.FALSE, new String[]{"flexpanelap6"});
        } else if ("D".equals(billStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_save", "bar_submit", "bar_submiteffect", "bar_del", "bar_discard", "baritemap"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_viewflowchart"});
            view.setVisible(Boolean.TRUE, new String[]{"flexpanelap6"});
        } else if ("H".equals(billStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_save", "bar_submit", "bar_submiteffect", "bar_del", "bar_discard", "baritemap", "bar_viewflowchart"});
            view.setVisible(Boolean.FALSE, new String[]{"flexpanelap6"});
        } else if ("F".equals(billStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_save", "bar_submit", "bar_submiteffect", "bar_del", "bar_discard", "baritemap"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_viewflowchart"});
            view.setVisible(Boolean.TRUE, new String[]{"flexpanelap6"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_save", "bar_submit", "bar_submiteffect", "bar_del", "bar_discard", "baritemap"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_viewflowchart"});
            view.setVisible(Boolean.TRUE, new String[]{"flexpanelap6"});
        }
    }

    private void setEditOrSave(IFormView view, BillOperationStatus operationStatus) {
        if (BillOperationStatus.VIEW.equals((Object)operationStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_save"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_modify", "bar_del"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_del"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_submiteffect"});
        }
    }

    private void setEditOrSave2(IFormView view, BillOperationStatus operationStatus) {
        if (BillOperationStatus.VIEW.equals((Object)operationStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_save"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_modify", "bar_discard"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_submiteffect", "bar_discard"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit"});
        }
    }

    private String getPositionStatus(Long positionId) {
        List<Long> positionIdList = Collections.singletonList(positionId);
        DynamicObject[] positions = PositionDataHelper.getPositionObjByPositionIds(positionIdList);
        String positionStatus = null;
        if (positions.length != 0) {
            DynamicObject position = positions[0];
            positionStatus = position.getString("positionstatus");
        }
        return positionStatus;
    }

    private Map<String, BillOperationStatus> getStatusMap() {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        result.put("A", BillOperationStatus.VIEW);
        result.put("B", BillOperationStatus.SUBMIT);
        result.put("C", BillOperationStatus.AUDIT);
        result.put("D", BillOperationStatus.AUDIT);
        result.put("E", BillOperationStatus.AUDIT);
        result.put("F", BillOperationStatus.AUDIT);
        result.put("G", BillOperationStatus.VIEW);
        result.put("H", BillOperationStatus.AUDIT);
        return result;
    }

    private String getPageId(String positionId, String billNumber) {
        long currUserId = RequestContext.get().getCurrUserId();
        String localSessionId = RequestContext.get().getGlobalSessionId();
        return localSessionId + positionId + billNumber + currUserId;
    }

    public void deletePosition(DynamicObject positionBill) {
        long positionId = positionBill.getDynamicObject("position").getLong("id");
        DynamicObject position = PositionDataHelper.queryOneByPositionId(positionId);
        if ("B".equals(position.getString("positionstatus"))) {
            PositionDataHelper.deletePosition(Collections.singletonList(positionId));
            PositionManageService.getInstance().deletePositionManageByPositionIds(Collections.singletonList(positionId));
            long positionSnapId = positionBill.getDynamicObject("positionsnap").getLong("id");
            PositionDataHelper.deletePositionSnapDynById(positionSnapId);
        } else if (this.positionStatusIsOpenOrClose(positionId)) {
            DynamicObject[] positionBillByPositionIds = PositionBillDataHelper.getPositionBillByPositionId(positionId);
            String billNo = Arrays.stream(positionBillByPositionIds).filter(positionBills -> positionBills.getLong("id") != positionBill.getLong("id")).max(Comparator.comparing(positionBillDyn -> positionBillDyn.getDate("createtime"))).get().getString("billno");
            DynamicObject positionBillByBillNo = PositionBillDataHelper.getPositionBillByBillNo(positionId, billNo);
            long positionSnapId = positionBill.getDynamicObject("positionsnap").getLong("id");
            PositionDataHelper.deletePositionSnapDynById(positionSnapId);
            long oldPositionSnapId = positionBillByBillNo.getDynamicObject("positionsnap").getLong("id");
            position.set("billno", (Object)billNo);
            position.set("status", (Object)positionBillByBillNo.getString("billstatus"));
            position.set("billstatus", (Object)positionBillByBillNo.getString("billstatus"));
            PositionDataHelper.updateOne(position);
            DynamicObject positionSnap = PositionDataHelper.getPositionSnapDynById(oldPositionSnapId);
            positionSnap.set("isabandon", (Object)"1");
            PositionDataHelper.updatePositionSnap(positionSnap);
        }
    }

    public void syncUpdatePosition(DynamicObject billDyn, DynamicObject positionData, Long snapId) {
        HRBaseServiceHelper positionServerHelper = new HRBaseServiceHelper("tsirm_position");
        long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)billDyn, (String)"position");
        QFilter positionIdFilter = new QFilter("id", "=", (Object)positionId);
        DynamicObject positionDyn = positionServerHelper.loadDynamicObject(positionIdFilter);
        String positionStatus = positionDyn.getString("positionstatus");
        if ("B".equals(positionStatus) || "E".equals(positionStatus)) {
            PositionDataHelper.syncUpdatePositionFromPostionSnap(snapId);
            PositionBillService.getInstance().updateBillAttachsToPos(positionId, snapId);
        }
    }

    public String encryId(String id) {
        return id + "newid";
    }

    public String decipId(String id) {
        if (HRStringUtils.isNotEmpty((String)id) && id.contains("newid")) {
            return id.substring(0, id.lastIndexOf("newid"));
        }
        return id;
    }
}

