/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.position.service.HbssJobAdapter;
import kd.tsc.tsirm.business.domain.position.service.PositionBillDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionModelAdapter;
import kd.tsc.tsirm.business.domain.position.service.enums.PositionPermEnum;
import kd.tsc.tsirm.business.domain.position.service.permission.PositionPermService;
import kd.tsc.tsirm.common.constants.position.PositionConstants;
import kd.tsc.tsirm.common.entity.advert.HandlerResult;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbd.business.domain.offer.service.helper.JobFamilyScmHelper;
import kd.tsc.tsrbd.common.enums.DatePeriodEnum;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class PositionDataHelper {
    private static final Log LOGGER = LogFactory.getLog(PositionDataHelper.class);
    private static final String VALID_STATUS = "0";
    private static final String INVALID_STATUS = "1";
    private static final Long EMPTY_BASE_DATA = 0L;
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("tsirm_positiontpl");
    private static final HRBaseServiceHelper SNAPHELPER = new HRBaseServiceHelper("tsirm_positionsnaptpl");
    private static final HRBaseServiceHelper BILLHELPER = new HRBaseServiceHelper("tsirm_positionbill");

    private PositionDataHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static Long queryDefaultRecProcByRecType(long recTypeId, long createOrgId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        QFilter qFilter = new QFilter("group", "=", (Object)recTypeId);
        qFilter.and("enable", "=", (Object)INVALID_STATUS);
        qFilter.and("createorg", "=", (Object)createOrgId);
        qFilter.and("isdefault", "=", (Object)INVALID_STATUS);
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.query(new QFilter[]{qFilter});
        if (dynamicObjects.length == 0) {
            return null;
        }
        return dynamicObjects[0].getLong("id");
    }

    public static boolean isProcessMatchWithCategory(DynamicObject recProcDym, long recTypeId, long createOrgId) {
        if (recProcDym == null) {
            return false;
        }
        long recProcId = recProcDym.getLong("id");
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        QFilter qFilter = new QFilter("group", "=", (Object)recTypeId);
        qFilter.and("enable", "=", (Object)INVALID_STATUS);
        qFilter.and("createorg", "=", (Object)createOrgId);
        qFilter.and("id", "=", (Object)recProcId);
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.query(new QFilter[]{qFilter});
        return dynamicObjects.length != 0;
    }

    public static List<Long> getParentPosCategoryId() {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_poscat");
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", PositionDataHelper.getAllPosCategoryId())};
        DynamicObject[] result = hrBaseServiceHelper.queryOriginalArray("id,parent", filters);
        return Stream.of(result).map(object -> object.getLong("parent")).filter(object -> !EMPTY_BASE_DATA.equals(object)).distinct().collect(Collectors.toList());
    }

    public static List<Long> getAllPosCategoryId() {
        String selectProperties = "id,poscategory";
        QFilter[] filters = new QFilter[]{new QFilter("id", "is not null", null)};
        DynamicObject[] result = HELPER.queryOriginalArray(selectProperties, filters);
        return Stream.of(result).map(object -> object.getLong("poscategory")).filter(object -> !EMPTY_BASE_DATA.equals(object)).distinct().collect(Collectors.toList());
    }

    public static List<Long> getAllWorkCountryId(IFormView iFormView) {
        String selectProperties = "id,workcountry";
        QFilter[] filters = PositionDataHelper.getUseOrgFilters(iFormView);
        DynamicObject[] result = HELPER.queryOriginalArray(selectProperties, filters);
        return Stream.of(result).map(object -> object.getLong("workcountry")).filter(object -> !EMPTY_BASE_DATA.equals(object)).distinct().collect(Collectors.toList());
    }

    public static QFilter[] getUseOrgFilters(IFormView iFormView) {
        String useOrgId = iFormView.getPageCache().get("useOrgIdCache");
        QFilter qFilter = !HRStringUtils.isEmpty((String)useOrgId) ? new QFilter("createorg", "=", (Object)Long.valueOf(useOrgId)) : new QFilter("id", "is not null", null);
        return new QFilter[]{qFilter};
    }

    public static List<Object> getAllWorkCityId(IFormView iFormView) {
        QFilter[] filters = PositionDataHelper.getUseOrgFilters(iFormView);
        DynamicObject[] result = HELPER.loadDynamicObjectArray(filters);
        List<DynamicObject> positionList = Arrays.asList(result);
        ArrayList poitList = new ArrayList();
        for (DynamicObject position : positionList) {
            DynamicObjectCollection works = position.getDynamicObjectCollection("workaddr");
            poitList.addAll(works);
        }
        List citys = poitList.stream().map(object -> object.get("fbasedataid.city.id")).distinct().collect(Collectors.toList());
        HRBaseServiceHelper cityHelper = new HRBaseServiceHelper("bd_admindivision");
        ArrayList<Object> isCityCitys = new ArrayList<Object>(citys.size());
        for (Object city : citys) {
            DynamicObject cityDyn;
            if (city == null || !(cityDyn = cityHelper.queryOne("iscity", city)).getBoolean("iscity")) continue;
            isCityCitys.add(city);
        }
        return isCityCitys;
    }

    public static List<Long> getAllRecProcId(Long useOrgId) {
        QFilter[] filters;
        String selectProperties = "id,manageinfo.recruproc";
        if (useOrgId == 0L) {
            filters = new QFilter[]{};
        } else {
            QFilter qFilter = new QFilter("createorg", "=", (Object)useOrgId);
            filters = new QFilter[]{qFilter};
        }
        DynamicObject[] result = HELPER.queryOriginalArray(selectProperties, filters);
        return Stream.of(result).map(object -> object.getLong("manageinfo.recruproc")).distinct().collect(Collectors.toList());
    }

    public static void setFilterTimeRange(QFilter qFilter, String timeRangeType, boolean isOwner) {
        LocalDate startDate;
        if (!StringUtils.isEmpty((String)timeRangeType) && (startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)timeRangeType))) != null) {
            qFilter.and("createtime", ">", (Object)startDate);
        }
        if (isOwner) {
            Long userId = TSCRequestContext.getUserId();
            qFilter.and(new QFilter("creator", "=", (Object)userId).or("posprin.fbasedataid", "=", (Object)userId));
        }
    }

    public static List<Long> getChildPosCategoryId(List<Long> ids) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_poscat");
        QFilter[] filters = new QFilter[]{new QFilter("parent", "in", ids)};
        DynamicObject[] result = hrBaseServiceHelper.queryOriginalArray("id,name", filters);
        return Stream.of(result).map(object -> object.getLong("id")).filter(object -> !EMPTY_BASE_DATA.equals(object)).distinct().collect(Collectors.toList());
    }

    public static long getPositionUseOrgIdByPositionId(Long positionId) {
        DynamicObject dynamicObject = HELPER.queryOriginalOne("createorg", (Object)positionId);
        return dynamicObject.getLong("createorg");
    }

    public static long getEntryJobIdByPositionId(Long positionId) {
        DynamicObject dynamicObject = HELPER.queryOriginalOne("entryjob", (Object)positionId);
        return dynamicObject == null ? 0L : dynamicObject.getLong("entryjob");
    }

    public static DynamicObject[] getPositionObjByPositionIds(List<Long> positionIds) {
        return HELPER.loadDynamicObjectArray(positionIds.toArray());
    }

    public static DynamicObject getPositionObjByPositionId(Long positionId) {
        return HELPER.loadSingle((Object)positionId);
    }

    public static DynamicObject getPositionSnapDynById(Long positionSnapId) {
        return SNAPHELPER.loadSingle((Object)positionSnapId);
    }

    public static DynamicObject getPositionBill(DynamicObject position) {
        if (position == null) {
            return null;
        }
        Long positionId = (Long)position.getPkValue();
        String billNo = position.getString("billno");
        if (positionId == null || StringUtils.isBlank((String)billNo)) {
            return null;
        }
        return PositionBillDataHelper.getPositionBillByBillNo(positionId, billNo);
    }

    public static void deletePositionBills(DynamicObject[] positions) {
        if (positions == null) {
            return;
        }
        QFilter qFilter = new QFilter("position", "in", Arrays.stream(positions).map(wa -> wa.getLong("id")).collect(Collectors.toList()));
        BILLHELPER.deleteByFilter(qFilter.toArray());
    }

    public static void commitPosition(DynamicObject[] dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("positionstatus", (Object)"A");
            DynamicObject positionBill = PositionDataHelper.getPositionBill(dynamicObject);
            if (positionBill == null) {
                dynamicObject.set("status", (Object)"C");
            }
            dynamicObject.set("positionpriority", (Object)1);
            dynamicObject.set("modifytime", (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        }
        HELPER.update(dynamicObjects);
    }

    public static void abandonPositionSnapshot(List<Long> positionIds) {
        DynamicObject[] dynamicObjects;
        QFilter filter = new QFilter("positionId", "in", positionIds);
        QFilter isAbandonFilter = new QFilter("isabandon", "=", (Object)VALID_STATUS);
        QFilter[] filters = new QFilter[]{filter, isAbandonFilter};
        for (DynamicObject dynamicObject : dynamicObjects = SNAPHELPER.loadDynamicObjectArray(filters)) {
            dynamicObject.set("isabandon", (Object)INVALID_STATUS);
        }
        SNAPHELPER.update(dynamicObjects);
    }

    public static List<Long> syncUpdatePositionSnapshot(DynamicObject[] dynamicObjects, List<Long> positionIds) {
        return PositionDataHelper.syncUpdatePositionSnapshot(dynamicObjects, positionIds, VALID_STATUS);
    }

    public static List<Long> syncUpdatePositionSnapshot(DynamicObject[] dynamicObjects, List<Long> positionIds, String status) {
        ArrayList<Long> positionSnapshotIds = new ArrayList<Long>(10);
        DynamicObjectCollection posSnapObjs = new DynamicObjectCollection();
        long[] posSnapPkIds = ORM.create().genLongIds("tsirm_positionsnaptpl", dynamicObjects.length);
        int index = 0;
        for (DynamicObject posObj : dynamicObjects) {
            DynamicObject posSnapObj = SNAPHELPER.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)posObj, (DynamicObject)posSnapObj, PositionDataHelper.getIgnoreKey());
            posSnapObj.set("id", (Object)posSnapPkIds[index]);
            posSnapObj.set("positionid", (Object)positionIds.get(index));
            posSnapObj.set("isabandon", (Object)status);
            posSnapObjs.add((Object)posSnapObj);
            positionSnapshotIds.add(posSnapPkIds[index]);
            ++index;
        }
        SNAPHELPER.save(posSnapObjs);
        return positionSnapshotIds;
    }

    public static List<DynamicObject> syncUpdatePositionSnapshotAfterSave(DynamicObject[] dynamicObjects, List<Long> positionIds, String status) {
        ArrayList<DynamicObject> positionSnapshotIds = new ArrayList<DynamicObject>(10);
        long[] posSnapPkIds = ORM.create().genLongIds("tsirm_positionsnaptpl", dynamicObjects.length);
        int index = 0;
        for (DynamicObject posObj : dynamicObjects) {
            DynamicObject posSnapObj = SNAPHELPER.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)posObj, (DynamicObject)posSnapObj, PositionDataHelper.getIgnoreKey());
            posSnapObj.set("id", (Object)posSnapPkIds[index]);
            posSnapObj.set("positionid", (Object)positionIds.get(index));
            posSnapObj.set("isabandon", (Object)status);
            positionSnapshotIds.add(posSnapObj);
            ++index;
        }
        return positionSnapshotIds;
    }

    public static void syncUpdatePositionSnapshotBySnapIds(DynamicObject[] dynamicObjects, List<Long> positionSnapIds) {
        DynamicObject[] positionSnapDys = SNAPHELPER.loadDynamicObjectArray(positionSnapIds.toArray());
        int index = 0;
        for (DynamicObject posObj : dynamicObjects) {
            DynamicObject positionSnapDyn = positionSnapDys[index];
            long positionSnapId = positionSnapDyn.getLong("id");
            HRDynamicObjectUtils.copy((DynamicObject)posObj, (DynamicObject)positionSnapDyn, PositionDataHelper.getIgnoreKey());
            positionSnapDyn.set("id", (Object)positionSnapId);
            ++index;
        }
        SNAPHELPER.save(positionSnapDys);
    }

    public static void syncUpdatePositionFromPostionSnap(Long positionSnapId) {
        QFilter idFilter = new QFilter("id", "=", (Object)positionSnapId);
        DynamicObject posSnapDyn = SNAPHELPER.loadDynamicObject(idFilter);
        if (posSnapDyn == null) {
            LOGGER.error("positionSnapId is: {}", (Object)positionSnapId);
            return;
        }
        HRBaseServiceHelper positionServerHelper = new HRBaseServiceHelper("tsirm_position");
        Long positionId = posSnapDyn.getLong("positionid");
        QFilter positionIdFilter = new QFilter("id", "=", (Object)positionId);
        DynamicObject positionDyn = positionServerHelper.loadDynamicObject(positionIdFilter);
        if (positionDyn == null) {
            LOGGER.error("positionSnapId is: {}", (Object)positionSnapId);
            LOGGER.error("positionId is: {}", (Object)positionId);
            return;
        }
        HRDynamicObjectUtils.copy((DynamicObject)posSnapDyn, (DynamicObject)positionDyn, PositionDataHelper.getIgnoreKey());
        positionDyn.set("id", (Object)positionId);
        positionServerHelper.saveOne(positionDyn);
        posSnapDyn.set("isabandon", (Object)VALID_STATUS);
        PositionDataHelper.abandonPositionSnapshot(Collections.singletonList(positionId));
        SNAPHELPER.saveOne(posSnapDyn);
    }

    public static Set<String> getIgnoreKey() {
        HashSet keyList = Sets.newHashSetWithExpectedSize((int)16);
        keyList.add("creator");
        keyList.add("createtime");
        keyList.add("modifier");
        keyList.add("modifytime");
        keyList.add("positionstatus");
        keyList.add("status");
        keyList.add("billstatus");
        return keyList;
    }

    public static void updatePositionVId(DynamicObject[] dynamicObjects, List<Long> positionSnapIds) {
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("vid", (Object)positionSnapIds.get(index));
            ++index;
        }
        HELPER.update(dynamicObjects);
    }

    public static void updatePositionInfo(String positionPageNumber, List<Long> positionIds, Map<String, List<Object>> valueMap) {
        if (CollectionUtils.isEmpty(valueMap) || CollectionUtils.isEmpty(positionIds)) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(positionPageNumber);
        String properties = String.join((CharSequence)",", valueMap.keySet());
        DynamicObject[] dynamicObjects = serviceHelper.query(properties, new QFilter[]{new QFilter("id", "in", positionIds)});
        PositionDataHelper.updatePositionInfo(positionPageNumber, dynamicObjects, valueMap);
    }

    public static void updatePositionInfo(String positionPageNumber, DynamicObject[] dynamicObjects, Map<String, List<Object>> valueMap) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(positionPageNumber);
        for (Map.Entry<String, List<Object>> entry : valueMap.entrySet()) {
            String key = entry.getKey();
            List<Object> valueList = entry.getValue();
            int index = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set(key, valueList.get(index));
                ++index;
            }
        }
        hrBaseServiceHelper.update(dynamicObjects);
    }

    public static DynamicObject queryOneByPositionId(Long positionId) {
        return HELPER.queryOne((Object)positionId);
    }

    public static DynamicObject loadOneByPositionId(Long positionId) {
        return HELPER.loadSingle((Object)positionId);
    }

    public static void updatePositionStatusByPositionId(Long positionId, String positionStatus) {
        DynamicObject dynamicObject = HELPER.queryOne((Object)positionId);
        dynamicObject.set("positionstatus", (Object)positionStatus);
        dynamicObject.set("modifytime", (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        if ("D".equals(positionStatus) || "G".equals(positionStatus)) {
            dynamicObject.set("positionpriority", (Object)0);
        }
        HELPER.updateOne(dynamicObject);
    }

    public static DynamicObject[] findPositions(List<Long> ids, String prop) {
        QFilter qFilter = new QFilter("id", "in", ids);
        return HELPER.query(prop, qFilter.toArray());
    }

    public static DynamicObject findPostionByName(String positionName, String prop) {
        QFilter qFilter = new QFilter("name", "=", (Object)positionName);
        DynamicObject[] positions = HELPER.query(prop, qFilter.toArray());
        if (positions != null && positions.length > 0) {
            return positions[0];
        }
        return null;
    }

    public static void updateCandidateNumByPositionId(Long positionId, Long candidateNum) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsirm_position");
        QFilter filter = new QFilter("id", "=", (Object)positionId);
        DynamicObject dynamicObject = hrBaseServiceHelper.loadDynamicObject(new QFilter[]{filter});
        dynamicObject.set("candidatornum", (Object)candidateNum);
        hrBaseServiceHelper.updateOne(dynamicObject);
    }

    public static boolean hasPositionPerm(Long positionId) {
        List<Long> hashPermPositionIds = PositionDataHelper.getHashPermPositionIds();
        return hashPermPositionIds.contains(positionId);
    }

    public static List<Long> getHashPermPositionIds() {
        List<QFilter> positionPermFilter = PositionDataHelper.getPositionPermFilter();
        DataSet dataSet = HELPER.queryDataSet("PositionDataHelper.getHashPermPositionIds", "id", positionPermFilter.toArray(new QFilter[0]));
        ArrayList<Long> positionIdList = new ArrayList<Long>(100);
        for (Row row : dataSet) {
            positionIdList.add(row.getLong("id"));
        }
        return positionIdList;
    }

    private static List<QFilter> getPositionPermFilter() {
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)16);
        ImmutableList positionPermEnums = ImmutableList.of((Object)((Object)PositionPermEnum.ADMIN_ORG), (Object)((Object)PositionPermEnum.ORG), (Object)((Object)PositionPermEnum.SEV_LEVEL));
        filters.add(PositionPermService.getInstance((List<PositionPermEnum>)positionPermEnums).getHavePermPositionQFilter());
        return filters;
    }

    public static List<Long> getEnableBosOrgStructure() {
        HRBaseServiceHelper bosOrgStructureHelper = new HRBaseServiceHelper("bos_org_structure");
        QFilter viewFilter = new QFilter("view.id", "=", (Object)24L);
        QFilter enableFilter = new QFilter("enable", "=", (Object)INVALID_STATUS);
        DynamicObject[] orgStructs = bosOrgStructureHelper.query("id,org.id", new QFilter[]{viewFilter.and(enableFilter)}, "level asc");
        ArrayList orgIdList = Lists.newArrayListWithExpectedSize((int)orgStructs.length);
        for (DynamicObject orgStruct : orgStructs) {
            Long orgId = orgStruct.getLong("org.id");
            orgIdList.add(orgId);
        }
        return orgIdList;
    }

    public static DynamicObject[] getWorkAddrByIds(List<Long> addrIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_workaddr");
        QFilter idFilter = new QFilter("id", "in", addrIds);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
    }

    public static HashMap<String, QFilter> generateQFilterMap(IDataModel dataModel) {
        DynamicObject dataEntity = dataModel.getDataEntity();
        HashMap<String, QFilter> QFILTER_PROPERTYMAP = new HashMap<String, QFilter>(16);
        QFILTER_PROPERTYMAP.put("holdofftyp", new QFilter("enable", "=", (Object)INVALID_STATUS));
        QFILTER_PROPERTYMAP.put("poscategory", new QFilter("level", "=", (Object)3));
        QFILTER_PROPERTYMAP.put("workcountry", new QFilter("id", "is not null", (Object)""));
        AuthorizedOrgResult authorizedOrgResult = TSCBizDataPermService.getUserAdminOrgs((Long)RequestContext.get().getCurrUserId(), (String)"tsirm", (String)"tsirm_position", (String)"47150e89000000ac", (String)"adminorg", null);
        if (!authorizedOrgResult.isHasAllOrgPerm()) {
            QFILTER_PROPERTYMAP.put("adminorg", new QFilter("id", "in", (Object)authorizedOrgResult.getHasPermOrgs()));
        }
        QFILTER_PROPERTYMAP.put("posprin", new QFilter("source", "=", (Object)"HR"));
        PositionDataHelper.putOrgFilter(QFILTER_PROPERTYMAP);
        PositionDataHelper.putWorkCityFilter(dataEntity, QFILTER_PROPERTYMAP);
        PositionDataHelper.putRecProcFilter(dataEntity, QFILTER_PROPERTYMAP);
        PositionDataHelper.putJobFilter(dataEntity, QFILTER_PROPERTYMAP);
        return QFILTER_PROPERTYMAP;
    }

    private static void putWorkCityFilter(DynamicObject dataEntity, HashMap<String, QFilter> QFILTER_PROPERTYMAP) {
        QFilter qFilter = new QFilter("level", "=", (Object)2);
        qFilter.and("country", "=", (Object)1000001);
        QFilter qOutSideChinaFileter = new QFilter("level", "=", (Object)1);
        qOutSideChinaFileter.and("country", "!=", (Object)1000001);
        qFilter.or(qOutSideChinaFileter);
        DynamicObject dynamicObject = dataEntity.getDynamicObject("workcountry");
        if (dynamicObject != null) {
            qFilter.and("country", "=", (Object)dynamicObject.getLong("id"));
        }
        QFILTER_PROPERTYMAP.put("workcity", qFilter);
    }

    private static void putOrgFilter(HashMap<String, QFilter> QFILTER_PROPERTYMAP) {
        QFilter qFilter;
        boolean superUser = PermissionServiceHelper.isSuperUser((long)TSCRequestContext.getUserId());
        if (superUser) {
            qFilter = new QFilter("id", "is not null", null);
        } else {
            List<Long> orgs = PositionPermService.getInstance(null).getPositionHasPermOrgs();
            qFilter = new QFilter("id", "in", orgs);
        }
        QFILTER_PROPERTYMAP.put("createorg", qFilter);
    }

    private static void putRecProcFilter(DynamicObject dataEntity, HashMap<String, QFilter> QFILTER_PROPERTYMAP) {
        DynamicObject createOrg;
        DynamicObject recruitCategory = dataEntity.getDynamicObject("reccategory");
        QFilter qFilter = new QFilter("enable", "=", (Object)INVALID_STATUS);
        if (recruitCategory != null) {
            qFilter.and("group", "=", (Object)recruitCategory.getLong("id"));
        }
        if ((createOrg = dataEntity.getDynamicObject("createorg")) != null) {
            qFilter.and("createorg", "=", (Object)createOrg.getLong("id"));
        }
        QFILTER_PROPERTYMAP.put("recruproc", qFilter);
    }

    private static void putJobFilter(DynamicObject dataEntity, HashMap<String, QFilter> QFILTER_PROPERTYMAP) {
        DynamicObject jobScm = dataEntity.getDynamicObject("jobscm");
        QFilter jobScmFilter = JobFamilyScmHelper.getJobScmFilter((DynamicObject)jobScm);
        QFILTER_PROPERTYMAP.put("jobscm", jobScmFilter);
        Optional.ofNullable(jobScm).ifPresent(jobScmDy -> {
            Long jobScmId = jobScm.getLong("id");
            QFilter jobFilter = new QFilter("jobscm", "=", (Object)jobScmId);
            QFILTER_PROPERTYMAP.put("entryjob", jobFilter);
        });
        DynamicObject jobDynamicObject = dataEntity.getDynamicObject("entryjob");
        if (jobDynamicObject != null) {
            long jobId = jobDynamicObject.getLong("id");
            DynamicObject jobDym = HbssJobAdapter.queryJobDymById(jobId);
            PositionDataHelper.putJobLevelFilter(dataEntity, QFILTER_PROPERTYMAP, jobDym);
            PositionDataHelper.putJobGradeFilter(dataEntity, QFILTER_PROPERTYMAP, jobDym);
        }
    }

    public static void putJobLevelFilter(DynamicObject dataEntity, HashMap<String, QFilter> QFILTER_PROPERTYMAP, DynamicObject jobDym) {
        long lowJobLevel = jobDym.getLong("lowjoblevel");
        long highJobLevel = jobDym.getLong("highjoblevel");
        if (lowJobLevel != 0L && highJobLevel != 0L) {
            long highJobLevelChoose = highJobLevel;
            DynamicObject HighJobLevelDynamicObject = dataEntity.getDynamicObject("highjoblevel");
            if (HighJobLevelDynamicObject != null) {
                highJobLevelChoose = HighJobLevelDynamicObject.getLong("id");
            }
            QFILTER_PROPERTYMAP.put("lowjoblevel", new QFilter("id", "in", HbssJobAdapter.getJobLevelRangeByLevelId(lowJobLevel, highJobLevelChoose)));
            long lowJobLevelChoose = lowJobLevel;
            DynamicObject lowJobLevelDynamicObject = dataEntity.getDynamicObject("lowjoblevel");
            if (lowJobLevelDynamicObject != null) {
                lowJobLevelChoose = lowJobLevelDynamicObject.getLong("id");
            }
            QFILTER_PROPERTYMAP.put("highjoblevel", new QFilter("id", "in", HbssJobAdapter.getJobLevelRangeByLevelId(lowJobLevelChoose, highJobLevel)));
        }
    }

    public static void putJobGradeFilter(DynamicObject dataEntity, HashMap<String, QFilter> QFILTER_PROPERTYMAP, DynamicObject jobDym) {
        long lowJobGrade = jobDym.getLong("lowjobgrade");
        long highJobGrade = jobDym.getLong("highjobgrade");
        if (lowJobGrade != 0L && highJobGrade != 0L) {
            long highJobGradeChoose = highJobGrade;
            DynamicObject HighJobGradeDynamicObject = dataEntity.getDynamicObject("highjobgrade");
            if (HighJobGradeDynamicObject != null) {
                highJobGradeChoose = HighJobGradeDynamicObject.getLong("id");
            }
            QFILTER_PROPERTYMAP.put("lowjobgrade", new QFilter("id", "in", HbssJobAdapter.getJobGradeRangeByGradeId(lowJobGrade, highJobGradeChoose)));
            long lowJobGradeChoose = lowJobGrade;
            DynamicObject lowJobGradeDynamicObject = dataEntity.getDynamicObject("lowjobgrade");
            if (lowJobGradeDynamicObject != null) {
                lowJobGradeChoose = lowJobGradeDynamicObject.getLong("id");
            }
            QFILTER_PROPERTYMAP.put("highjobgrade", new QFilter("id", "in", HbssJobAdapter.getJobGradeRangeByGradeId(lowJobGradeChoose, highJobGrade)));
        }
    }

    public static Map<Long, String> generatePositionInfosJsonString(List<Long> positionIds) {
        DynamicObject[] positionObjs = PositionDataHelper.getPositionObjByPositionIds(positionIds);
        return Arrays.stream(positionObjs).collect(Collectors.toMap(position -> position.getLong("id"), PositionDataHelper::generatePositionJsonString));
    }

    public static String generatePositionJsonString(DynamicObject position) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("title", (Object)position.getString("name"));
        DynamicObject posCategory = position.getDynamicObject("poscategory");
        HashMap categoryMap = Maps.newHashMapWithExpectedSize((int)16);
        if (posCategory == null) {
            categoryMap.put("first_class", "");
            categoryMap.put("second_class", "");
            categoryMap.put("third_class", "");
        } else {
            String posCategoryName = posCategory.getString("name");
            String parentName = posCategory.getString("parent.name");
            Long parentId = posCategory.getLong("parent.id");
            String firstName = PositionDataHelper.getPoscatParentName(parentId);
            categoryMap.put("first_class", firstName);
            categoryMap.put("second_class", parentName);
            categoryMap.put("third_class", posCategoryName);
        }
        jsonObject.put("job_category", (Object)categoryMap);
        jsonObject.put("job_level", (Object)"");
        jsonObject.put("job_similar", Collections.emptyList());
        DynamicObjectCollection workaddrs = position.getDynamicObjectCollection("workaddr");
        ArrayList workAddrList = Lists.newArrayListWithCapacity((int)workaddrs.size());
        HashSet citySet = Sets.newHashSetWithExpectedSize((int)workaddrs.size());
        for (DynamicObject workaddr : workaddrs) {
            HashMap workAddrMap = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObject workAddr = workaddr.getDynamicObject("fbasedataid");
            String city = workAddr.getLocaleString("city.name").getLocaleValue();
            if (citySet.contains(city)) continue;
            String country = workAddr.getLocaleString("country.name").getLocaleValue();
            workAddrMap.put("country", country);
            workAddrMap.put("city", city);
            workAddrList.add(workAddrMap);
            citySet.add(city);
        }
        jsonObject.put("work_address", (Object)workAddrList);
        String holdfftyp = position.getString("holdofftyp.name");
        if (null != holdfftyp) {
            holdfftyp = holdfftyp.replace(ResManager.loadKDString((String)"\u4efb\u804c", (String)"PositionDataHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]), "");
        }
        jsonObject.put("position_type", (Object)holdfftyp);
        jsonObject.put("school_title", Collections.emptyList());
        jsonObject.put("school_type", Collections.emptyList());
        jsonObject.put("is_oversea_education", (Object)"");
        jsonObject.put("benchmark_school", Collections.emptyList());
        String mineducation = position.getString("education.name");
        jsonObject.put("minimum_education", (Object)mineducation);
        jsonObject.put("first_education", (Object)"");
        jsonObject.put("major", Collections.emptyList());
        Long holdfftypeId = position.getLong("holdofftyp.id");
        if (holdfftypeId.equals(1010L)) {
            jsonObject.put("is_full_time", (Object)"Y");
        } else {
            jsonObject.put("is_full_time", (Object)"N");
        }
        PositionDataHelper.putSalaryMap(position, jsonObject);
        jsonObject.put("benchmark_company", Collections.emptyList());
        HashMap workDurationMap = Maps.newHashMapWithExpectedSize((int)16);
        workDurationMap.put("down", String.valueOf(position.get("workexpdown")));
        workDurationMap.put("up", String.valueOf(position.get("workexpup")));
        workDurationMap.put("is_unlimited", String.valueOf(position.getBoolean("isworkexplimit")));
        jsonObject.put("work_duration", (Object)workDurationMap);
        jsonObject.put("industry", Collections.emptyList());
        jsonObject.put("is_management", (Object)"");
        jsonObject.put("is_oversea_employment", (Object)"");
        jsonObject.put("project", Collections.emptyList());
        jsonObject.put("project_count", (Object)"");
        jsonObject.put("job_skill", Collections.emptyList());
        jsonObject.put("language_skill", Collections.emptyList());
        jsonObject.put("ability", Collections.emptyList());
        jsonObject.put("quality", Collections.emptyList());
        jsonObject.put("certificate", (Object)"");
        jsonObject.put("domain", (Object)"");
        jsonObject.put("duty_time", (Object)"");
        HashMap ageMap = Maps.newHashMapWithExpectedSize((int)16);
        ageMap.put("down", String.valueOf(position.get("agedown")));
        ageMap.put("up", String.valueOf(position.get("ageup")));
        ageMap.put("is_unlimited", String.valueOf(position.getBoolean("isagelimit")));
        jsonObject.put("age", (Object)ageMap);
        jsonObject.put("bonus", Collections.emptyList());
        jsonObject.put("is_avoid_relatives", (Object)"");
        jsonObject.put("avoid_company", Collections.emptyList());
        jsonObject.put("raw_text", (Object)position.getString("anoposrequirement"));
        String posInfo = jsonObject.toJSONString();
        return posInfo;
    }

    private static void putSalaryMap(DynamicObject position, JSONObject jsonObject) {
        HashMap salaryMap = Maps.newHashMapWithExpectedSize((int)16);
        salaryMap.put("down", String.valueOf(position.get("salarydown")));
        salaryMap.put("up", String.valueOf(position.get("salaryup")));
        salaryMap.put("is_unlimited", String.valueOf(position.getBoolean("issalarynego")));
        jsonObject.put("salary", (Object)salaryMap);
    }

    private static String getPoscatParentName(Long poscatId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_poscat");
        DynamicObject poscat = serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)poscatId));
        return poscat.getString("parent.name");
    }

    public static HashMap<String, QFilter> generatePositionListFilterMap(IFormView view) {
        HashMap<String, QFilter> FILTERMAP = new HashMap<String, QFilter>(16);
        FILTERMAP.put("poscategory.id", new QFilter("id", "in", PositionDataHelper.getParentPosCategoryId()).and("level", "=", (Object)2));
        AuthorizedOrgResult authorizedOrgResult = TSCBizDataPermService.getUserAdminOrgs((Long)RequestContext.get().getCurrUserId(), (String)"tsirm", (String)"tsirm_position", (String)"47150e89000000ac", (String)"adminorg", null);
        if (!authorizedOrgResult.isHasAllOrgPerm()) {
            FILTERMAP.put("adminorg.id", new QFilter("id", "in", (Object)authorizedOrgResult.getHasPermOrgs()));
            QFilter qFilter = new QFilter("id", "in", (Object)authorizedOrgResult.getHasPermOrgs());
            FILTERMAP.put("adminorg.id", qFilter);
        }
        FILTERMAP.put("workcountry.id", new QFilter("id", "in", PositionDataHelper.getAllWorkCountryId(view)));
        FILTERMAP.put("workcity.id", new QFilter("id", "in", PositionDataHelper.getAllWorkCityId(view)));
        String useOrgIdCache = view.getPageCache().get("useOrgIdCache");
        Long useOrgId = HRStringUtils.isEmpty((String)useOrgIdCache) ? 0L : Long.parseLong(useOrgIdCache);
        QFilter idFilter = new QFilter("id", "in", PositionDataHelper.getAllRecProcId(useOrgId));
        idFilter.and("group", "in", (Object)new Long[]{PositionConstants.RECRUTYP_HIG, PositionConstants.RECRUTYP_NOR});
        FILTERMAP.put("manageinfo.recruproc.id", idFilter);
        return FILTERMAP;
    }

    public static String getPageId(String positionId) {
        return PositionDataHelper.getPageId(positionId, "tsirm");
    }

    public static String getPageId(String positionId, String appid) {
        long currUserId = RequestContext.get().getCurrUserId();
        String globalSessionId = RequestContext.get().getGlobalSessionId();
        StringBuilder pageId = new StringBuilder(String.valueOf(currUserId));
        pageId.append(positionId);
        pageId.append(globalSessionId);
        pageId.append(appid);
        return pageId.toString();
    }

    public static void updatePubCountByPositionId(Map<Long, HandlerResult> positionAdvCounts, List<Long> positionIds) {
        DynamicObject[] positions;
        String props = "id,erradvcount,succadvcount,stopadvcount,modifytime";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_position_view");
        for (DynamicObject position : positions = serviceHelper.query(props, new QFilter("id", "in", positionIds).toArray())) {
            long positionId = position.getLong("id");
            HandlerResult handlerResult = positionAdvCounts.get(positionId);
            position.set("erradvcount", (Object)handlerResult.getErrorCount());
            position.set("succadvcount", (Object)handlerResult.getSuccessCount());
            position.set("stopadvcount", (Object)handlerResult.getStopCount());
            position.set("modifytime", (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        }
        HELPER.save(positions);
    }

    public static DynamicObject[] getPositionDts(List<Map<String, Object>> searchFieldsList) {
        List<Long> positionIds = PositionDataHelper.getHashPermPositionIds();
        QFilter qFilter = new QFilter("id", "in", positionIds);
        if (searchFieldsList != null) {
            for (Map<String, Object> searchFieldsMap : searchFieldsList) {
                String value = ((ArrayList)searchFieldsMap.get("value")).get(0).toString();
                ArrayList fieldNameList = (ArrayList)searchFieldsMap.get("fieldName");
                if (fieldNameList.contains("creatorname")) {
                    qFilter.and(new QFilter("number", "like", (Object)("%" + value + "%")).or(new QFilter("name", "like", (Object)("%" + value + "%"))).or(new QFilter("creator", "in", PositionDataHelper.getUserIds(value))));
                    continue;
                }
                qFilter.and(new QFilter("number", "like", (Object)("%" + value + "%")).or(new QFilter("name", "like", (Object)("%" + value + "%"))));
            }
        }
        return HELPER.loadDynamicObjectArray(qFilter.toArray());
    }

    public static List<Map<String, Object>> getRecruprocData(Long positionId) {
        DynamicObject manageInfo = PositionManageServiceHelper.getManageInfoByPositionBo(Long.valueOf(positionId.toString()));
        if (manageInfo == null) {
            return null;
        }
        DynamicObject dynamicObject = manageInfo.getDynamicObject("recruproc");
        if (dynamicObject == null) {
            return null;
        }
        Long recruprocId = dynamicObject.getLong("id");
        HRBaseServiceHelper dbServiceRqmtproc = new HRBaseServiceHelper("tsrbd_rqmtproc");
        DynamicObject recruitmentProcessDyn = dbServiceRqmtproc.queryOne((Object)recruprocId);
        DynamicObjectCollection recruitmentStageDyns = recruitmentProcessDyn.getDynamicObjectCollection("entryentity");
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(10);
        Map<Long, Integer> stageCountMap = PositionModelAdapter.getRecruitmentStageCountByPositionId(Long.valueOf(positionId.toString()));
        for (DynamicObject recruitment : recruitmentStageDyns) {
            if (recruitment.getDynamicObject("rqmtstg") == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("nodename", recruitment.getDynamicObject("rqmtstg").getString("name"));
            Long recruitStageId = recruitment.getDynamicObject("rqmtstg").getLong("id");
            map.put("id", recruitStageId.toString());
            map.put("isHasColor", Boolean.TRUE);
            Integer count = stageCountMap.get(recruitStageId);
            map.put("number", count != null ? count.toString() : " 0");
            data.add(map);
        }
        return data;
    }

    public static List<Long> getPositionIdsByPosprin(Long posprinId) {
        QFilter qFilter = new QFilter("manageinfo.posprin.fbasedataid", "=", (Object)posprinId);
        DynamicObject[] dynamicObjects = HELPER.query("id", new QFilter[]{qFilter});
        return Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> getUserIds(String name) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_user");
        QFilter qFilter = new QFilter("name", "like", (Object)("%" + name + "%"));
        DynamicObject[] userDts = serviceHelper.query("id", qFilter.toArray());
        ArrayList<Long> userIds = new ArrayList<Long>(userDts.length);
        for (DynamicObject userDt : userDts) {
            userIds.add(userDt.getLong("id"));
        }
        return userIds;
    }

    public static DynamicObject[] queryPositionByQFilter(QFilter[] qFilters) {
        return HELPER.query(qFilters);
    }

    public static void deletePosition(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        HELPER.delete(ids.toArray());
    }

    public static void updateOne(DynamicObject position) {
        if (!Objects.isNull(position)) {
            HELPER.updateOne(position);
        }
    }

    public static String recruitnumTras(long recruitnum, boolean islimit) {
        if (islimit) {
            return ResManager.loadKDString((String)"\u82e5\u5e72", (String)"PositionDataHelper_1", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        }
        return String.valueOf(recruitnum);
    }

    public static String ageTras(long ageDown, long ageUp, boolean isLimit) {
        Object text = !isLimit && ageDown != 0L && ageUp != 0L ? String.format(Locale.ROOT, ResManager.loadKDString((String)"%d~%d\u5468\u5c81", (String)"PositionDataHelper_2", (String)"tsc-tsirm-business", (Object[])new Object[0]), ageDown, ageUp) : (isLimit ? ResManager.loadKDString((String)"\u4e0d\u9650", (String)"PositionDataHelper_3", (String)"tsc-tsirm-business", (Object[])new Object[0]) : (ageDown == 0L && ageUp == 0L ? null : (ageUp == 0L ? String.format(Locale.ROOT, ResManager.loadKDString((String)"%d\u5468\u5c81\u4ee5\u4e0a", (String)"PositionDataHelper_4", (String)"tsc-tsirm-business", (Object[])new Object[0]), ageDown) : String.format(Locale.ROOT, ResManager.loadKDString((String)"%d\u5468\u5c81\u4ee5\u4e0b", (String)"PositionDataHelper_5", (String)"tsc-tsirm-business", (Object[])new Object[0]), ageUp))));
        return text;
    }

    public static String eduTras(DynamicObject eduDyn, boolean islimit) {
        if (islimit) {
            return ResManager.loadKDString((String)"\u4e0d\u9650", (String)"PositionDataHelper_3", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        }
        return eduDyn == null ? null : eduDyn.getString("name");
    }

    public static String workexpTras(long workExpDown, long workExpUp, boolean isLimit) {
        Object text = !isLimit && workExpDown != 0L && workExpUp != 0L ? String.format(Locale.ROOT, ResManager.loadKDString((String)"%d~%d\u5e74", (String)"PositionDataHelper_6", (String)"tsc-tsirm-business", (Object[])new Object[0]), workExpDown, workExpUp) : (isLimit ? ResManager.loadKDString((String)"\u4e0d\u9650", (String)"PositionDataHelper_3", (String)"tsc-tsirm-business", (Object[])new Object[0]) : (workExpDown == 0L && workExpUp == 0L ? null : (workExpUp == 0L ? String.format(Locale.ROOT, ResManager.loadKDString((String)"%d\u5e74\u4ee5\u4e0a", (String)"PositionDataHelper_7", (String)"tsc-tsirm-business", (Object[])new Object[0]), workExpDown) : String.format(Locale.ROOT, ResManager.loadKDString((String)"%d\u5e74\u4ee5\u4e0b", (String)"PositionDataHelper_8", (String)"tsc-tsirm-business", (Object[])new Object[0]), workExpUp))));
        return text;
    }

    public static boolean hasAdvFromPosition(Long positionId) {
        HRBaseServiceHelper advService = new HRBaseServiceHelper("tsirm_advertdetailex");
        QFilter qFilter = new QFilter("position.id", "=", (Object)positionId);
        return advService.isExists(qFilter);
    }

    public static void setPubAdvNum(IFormView view) {
        Label pubAdvLabel = (Label)view.getControl("labelispubadv");
        DynamicObject positionDyn = PositionDataHelper.getPositionObjByPositionId(view.getModel().getDataEntity(true).getLong("id"));
        long pubAdvNum = positionDyn.getLong("succadvcount");
        HashMap<String, String> labelDataMap = new HashMap<String, String>(3);
        labelDataMap.put("fc", pubAdvNum > 0L ? "#5582f3" : "#999999");
        pubAdvLabel.setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e2a", (String)"PositionDataHelper_9", (String)"tsc-tsirm-business", (Object[])new Object[0]), pubAdvNum));
        view.updateControlMetadata("labelispubadv", labelDataMap);
    }

    public static void deletePositionSnapDynById(Long positionSnapId) {
        SNAPHELPER.deleteOne((Object)positionSnapId);
    }

    public static void updatePositionSnap(DynamicObject positionSnap) {
        SNAPHELPER.updateDataOne(positionSnap);
    }

    public static String positionJobGradeDesc(DynamicObject position) {
        StringBuilder jobName = new StringBuilder();
        Optional.ofNullable(position).filter(p -> position.getDynamicObject("lowjobgrade") != null || position.getDynamicObject("highjobgrade") != null).ifPresent(p -> {
            DynamicObject lowJobGrade = position.getDynamicObject("lowjobgrade");
            Optional.ofNullable(lowJobGrade).ifPresent(low -> jobName.append(low.getString("name")));
            DynamicObject highJobGrade = position.getDynamicObject("highjobgrade");
            Optional.ofNullable(highJobGrade).ifPresent(high -> {
                jobName.append("-");
                jobName.append(high.getString("name"));
            });
        });
        return jobName.toString();
    }

    public static DynamicObject[] getHisPositionBills(DynamicObject positionObjByPositionId, Long recentBillId) {
        QFilter qFilter = new QFilter("position", "=", (Object)positionObjByPositionId.getLong("id"));
        if (null != recentBillId && recentBillId != 0L) {
            qFilter.and("id", "!=", (Object)recentBillId);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_positionbill");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }
}

