/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang3.ObjectUtils;

public class PositionHelper {
    private static final String[] SPECHAR = new String[]{"+", "/", "?", "%", "#", "&", "="};
    private static final String[] SPESYMBOL = new String[]{"%", "=", "+"};
    private static final Log logger = LogFactory.getLog(PositionHelper.class);
    private static final HRBaseServiceHelper POSITION_HELPER = new HRBaseServiceHelper("tsirm_positiontpl");

    private PositionHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void setAttachment(Long copyPkId, Long pkId, List<Object> deleteAttachmentsUidList) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String formId = "tsirm_positiontpl";
        List attachments = AttachmentServiceHelper.getAttachments((String)formId, (Object)copyPkId, (String)"attachmentpanelap");
        if (!attachments.isEmpty()) {
            int attachSize = attachments.size();
            FileItem[] fileItems = new FileItem[attachSize];
            DynamicObject[] attachObjects = new DynamicObject[attachSize];
            HRBaseServiceHelper attachServiceHelper = new HRBaseServiceHelper("bos_attachment");
            try {
                for (int i = 0; i < attachSize; ++i) {
                    Map attach = (Map)attachments.get(i);
                    Object uid = attach.get("uid");
                    if (deleteAttachmentsUidList.contains(uid)) continue;
                    String attachmentName = (String)attach.get("name");
                    String path = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)"tsirm", (String)formId, (Object)PositionHelper.replaceSpeChar(String.valueOf(pkId)), (String)PositionHelper.replaceSpeSymbol(attachmentName));
                    URL url = new URL((String)attach.get("url"));
                    fileItems[i] = new FileItem(attachmentName, path, url.openStream());
                    attachObjects[i] = PositionHelper.newAttachObject(attachServiceHelper, attach, formId, path, pkId);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            try (TXHandle tx = TX.requiresNew();){
                try {
                    service.upload(fileItems);
                    attachServiceHelper.save(attachObjects);
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error((Throwable)e);
                }
            }
        }
    }

    public static void updateAttachment(String fromFormId, String toFormId, Long fromPkId, Long toPkId) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        List attachments = AttachmentServiceHelper.getAttachments((String)fromFormId, (Object)fromPkId, (String)"attachmentpanelap");
        if (attachments.size() != 0) {
            int attachSize = attachments.size();
            FileItem[] fileItems = new FileItem[attachSize];
            DynamicObject[] attachObjects = new DynamicObject[attachSize];
            HRBaseServiceHelper attachServiceHelper = new HRBaseServiceHelper("bos_attachment");
            try {
                for (int index = 0; index < attachSize; ++index) {
                    Map attach = (Map)attachments.get(index);
                    String attachmentName = (String)attach.get("name");
                    String path = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)"tsirm", (String)toFormId, (Object)PositionHelper.replaceSpeChar(String.valueOf(toPkId)), (String)PositionHelper.replaceSpeSymbol(attachmentName));
                    URL url = new URL((String)attach.get("url"));
                    fileItems[index] = new FileItem(attachmentName, path, url.openStream());
                    DynamicObject attachmentObj = AttachmentServiceHelper.getAttCreatorByUID((String)attach.get("uid").toString());
                    long userId = attachmentObj.getLong("FCREATEMEN.id");
                    attachObjects[index] = PositionHelper.newAttachObject(attachServiceHelper, attach, toFormId, path, toPkId, userId);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            try (TXHandle tx = TX.requiresNew();){
                try {
                    service.upload(fileItems);
                    attachServiceHelper.save(attachObjects);
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error((Throwable)e);
                }
            }
        }
    }

    private static String replaceSpeChar(String str) {
        for (String string : SPECHAR) {
            if (!str.contains(string)) continue;
            str = str.replace(string, "");
        }
        return str;
    }

    private static String replaceSpeSymbol(String str) {
        for (String speSymbol : SPESYMBOL) {
            if (!str.contains(speSymbol)) continue;
            str = str.replace(speSymbol, "_");
        }
        return str;
    }

    public static DynamicObject newAttachObject(HRBaseServiceHelper attachServiceHelper, Map<String, Object> attach, String formId, String path, Object pkId) {
        DynamicObject attachObject = attachServiceHelper.generateEmptyDynamicObject();
        String attacmentName = (String)attach.get("name");
        Long id = ORM.create().genLongId("bos_attachment");
        attachObject.set("id", (Object)id);
        attachObject.set("FNUMBER", attach.get("uid"));
        attachObject.set("FBillType", (Object)formId);
        attachObject.set("FInterID", pkId);
        Date today = PositionHelper.nowDateTime();
        attachObject.set("FModifyTime", (Object)today);
        attachObject.set("fcreatetime", (Object)today);
        attachObject.set("FaliasFileName", (Object)attacmentName);
        attachObject.set("FAttachmentName", (Object)attacmentName);
        attachObject.set("FExtName", (Object)attacmentName.substring(attacmentName.lastIndexOf(46) + 1));
        attachObject.set("FATTACHMENTSIZE", attach.get("size"));
        attachObject.set("FFileId", (Object)path);
        attachObject.set("FCREATEMEN", (Object)TSCRequestContext.getUserId());
        attachObject.set("fattachmentpanel", (Object)"attachmentpanelap");
        attachObject.set("fbillstatus", (Object)"1");
        return attachObject;
    }

    public static DynamicObject newAttachObject(HRBaseServiceHelper attachServiceHelper, Map<String, Object> attach, String formId, String path, Object pkId, Long userId) {
        DynamicObject attachObject = attachServiceHelper.generateEmptyDynamicObject();
        String attacmentName = (String)attach.get("name");
        Long id = ORM.create().genLongId("bos_attachment");
        attachObject.set("id", (Object)id);
        attachObject.set("FNUMBER", attach.get("uid"));
        attachObject.set("FBillType", (Object)formId);
        attachObject.set("FInterID", pkId);
        Date today = PositionHelper.nowDateTime();
        attachObject.set("FModifyTime", (Object)today);
        attachObject.set("fcreatetime", (Object)today);
        attachObject.set("FaliasFileName", (Object)attacmentName);
        attachObject.set("FAttachmentName", (Object)attacmentName);
        attachObject.set("FExtName", (Object)attacmentName.substring(attacmentName.lastIndexOf(46) + 1));
        attachObject.set("FATTACHMENTSIZE", attach.get("size"));
        attachObject.set("FFileId", (Object)path);
        attachObject.set("FCREATEMEN", (Object)userId);
        attachObject.set("fattachmentpanel", (Object)"attachmentpanelap");
        attachObject.set("fbillstatus", (Object)"1");
        return attachObject;
    }

    public static DynamicObject saveAttachment(Object pkId, String fileName, String desc, String url, String fileSize, String formId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_attachment");
        Date today = PositionHelper.nowDateTime();
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        Long attachId = ID.genLongId();
        dynamicObject.set("id", (Object)attachId);
        dynamicObject.set("FNUMBER", (Object)attachId);
        dynamicObject.set("FBillType", (Object)formId);
        dynamicObject.set("FInterID", pkId);
        dynamicObject.set("FModifyTime", (Object)today);
        dynamicObject.set("fcreatetime", (Object)today);
        dynamicObject.set("FaliasFileName", (Object)fileName);
        dynamicObject.set("FAttachmentName", (Object)fileName);
        dynamicObject.set("FExtName", (Object)fileName.substring(fileName.lastIndexOf(46) + 1));
        dynamicObject.set("FATTACHMENTSIZE", (Object)fileSize);
        dynamicObject.set("FCREATEMEN", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("fattachmentpanel", (Object)"attachmentpanelap");
        dynamicObject.set("fdescription", (Object)(desc == null ? "" : desc));
        dynamicObject.set("FFileId", (Object)url);
        return dynamicObject;
    }

    public static Date nowDateTime() {
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static boolean isPositionSimpleView(IFormView view) {
        String formId = view.getFormShowParameter().getFormId();
        Boolean isSimpleView = null;
        if (formId.equals("tsirm_position_view")) {
            isSimpleView = (Boolean)view.getFormShowParameter().getCustomParam("isSimpleView");
        } else {
            IFormView parentView = view.getParentView();
            if (ObjectUtils.isNotEmpty((Object)parentView)) {
                isSimpleView = (Boolean)parentView.getFormShowParameter().getCustomParam("isSimpleView");
            }
        }
        return null != isSimpleView && isSimpleView != false;
    }

    public static void setMulAttrToLbl(IFormView view, String key, String keyLbl) {
        Long positionId = (Long)view.getModel().getValue("id");
        DynamicObject manageInfo = PositionManageServiceHelper.getManageInfoByPositionBo(positionId);
        Label lbl = (Label)view.getControl(keyLbl);
        if (manageInfo == null) {
            lbl.setText(ResManager.loadKDString((String)"\u65e0", (String)"PositionHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection mulBaseData = manageInfo.getDynamicObjectCollection(key);
        if (mulBaseData != null && !mulBaseData.isEmpty()) {
            lbl.setText(mulBaseData.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(dy -> dy.getString("name")).collect(Collectors.joining(";")));
        } else {
            lbl.setText(ResManager.loadKDString((String)"\u65e0", (String)"PositionHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        }
    }

    public static List<String> getNeedCopyFields() {
        return Arrays.asList("createorg", "adminorg", "recruscene", "recruitnum", "isrecnumlimit", "arrivaltime", "holdofftyp", "posrespon", "anoposrequirement", "education", "isedulimit", "agedown", "ageup", "isagelimit", "workexpdown", "workexpup", "isworkexplimit");
    }

    public static List<String> getJobField() {
        return Arrays.asList("jobscm", "jobseq", "jobfamily", "jobclass", "lowjobgrade", "highjobgrade", "lowjoblevel", "highjoblevel");
    }

    public static DynamicObject queryOne(Object pkId) {
        return POSITION_HELPER.queryOne(pkId);
    }
}

