/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileHomePageHelper;
import kd.tsc.tsirm.business.domain.position.service.permission.PositionPermService;
import kd.tsc.tsirm.common.format.Numformat;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbd.common.constants.DateFormatConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class PositionHomeDataHelper {
    private static final Long EMPTY_BASE_DATA = 0L;
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("tsirm_position");
    private static final String SELECT_POSITION_NUM = "id,positionstatus,recruitnum,isrecnumlimit,createorg,adminorgs,manageinfo.recruproc";

    private PositionHomeDataHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static List<Map<String, String>> queryPositionAllUseOrg(List<Long> hasPermViewOrgs) {
        QFilter qFilter = null;
        qFilter = new QFilter("id", "in", hasPermViewOrgs);
        DynamicObjectCollection orgCollect = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])qFilter.toArray(), (String)"id");
        ArrayList useOrgList = Lists.newArrayList();
        if (orgCollect != null) {
            for (DynamicObject dynamicObject : orgCollect) {
                HashMap idMap = Maps.newHashMapWithExpectedSize((int)2);
                idMap.put("id", dynamicObject.getString("id"));
                idMap.put("name", dynamicObject.getString("name"));
                useOrgList.add(idMap);
            }
        }
        return useOrgList;
    }

    public static List<Map<String, String>> getUserOrg(Long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObjectCollection orgCollect = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])qFilter.toArray(), (String)"id");
        ArrayList useOrgList = Lists.newArrayList();
        if (orgCollect != null) {
            for (DynamicObject dynamicObject : orgCollect) {
                HashMap idMap = Maps.newHashMapWithExpectedSize((int)2);
                idMap.put("id", dynamicObject.getString("id"));
                idMap.put("name", dynamicObject.getString("name"));
                useOrgList.add(idMap);
            }
        }
        return useOrgList;
    }

    public static List<Long> getHasPermViewOrgs(FormShowParameter formShowParameter) {
        AppInfo appInfo;
        String appNumber;
        String entityName = formShowParameter.getFormId();
        String appId = formShowParameter.getAppId();
        if (HRStringUtils.isEmpty((String)appId) && HRStringUtils.isNotEmpty((String)(appNumber = formShowParameter.getAppId())) && (appInfo = AppMetadataCache.getAppInfo((String)appNumber)) != null) {
            appId = appInfo.getId();
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        long userId = TSCRequestContext.getUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"24", (String)appId, (String)"tsirm_position", (String)"47150e89000000ac");
        List createOrgIds = result.hasAllOrgPerm() ? OrgUnitServiceHelper.getAllOrg((String)"24") : result.getHasPermOrgs();
        return createOrgIds;
    }

    public static List<Long> queryPositionRecruitProc(boolean isOwner, List<Long> orgIds) {
        QFilter qFilter;
        AuthorizedOrgResult authorizedOrgResult = TSCBizDataPermService.getUserAdminOrgs((Long)RequestContext.get().getCurrUserId(), (String)"tsirm", (String)"tsirm_position", (String)"47150e89000000ac", (String)"adminorg", null);
        if (authorizedOrgResult.isHasAllOrgPerm()) {
            qFilter = new QFilter("createorg", "in", orgIds).and("reccategory", "=", (Object)1030L);
        } else {
            QFilter adminOrgFilter = new QFilter("adminorg", "in", (Object)authorizedOrgResult.getHasPermOrgs());
            qFilter = new QFilter("createorg", "in", orgIds).and("reccategory", "=", (Object)1030L).and(adminOrgFilter);
        }
        PositionHomeDataHelper.setFilterTimeRange(qFilter, null, isOwner);
        DynamicObject[] dynamicObjects = HELPER.queryOriginalArray(SELECT_POSITION_NUM, new QFilter[]{qFilter});
        return Stream.of(dynamicObjects).map(object -> object.getLong("manageinfo.recruproc")).filter(object -> !EMPTY_BASE_DATA.equals(object)).distinct().collect(Collectors.toList());
    }

    public static Map<String, Integer> queryPositionNum(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        QFilter qFilter = new QFilter("positionstatus", "=", (Object)"A");
        if (recruitProcId != 0L) {
            qFilter.and("manageinfo.recruproc", "=", (Object)recruitProcId);
        }
        PositionHomeDataHelper.setFilterTimeRange(qFilter, timeRangeType, isOwner);
        qFilter.and(new QFilter("createorg", "in", orgIds));
        AuthorizedOrgResult authorizedOrgResult = PositionPermService.getInstance(null).getPositionHasPermAdminOrgs();
        if (!authorizedOrgResult.isHasAllOrgPerm()) {
            qFilter.and(new QFilter("adminorg", "in", (Object)authorizedOrgResult.getHasPermOrgs()));
        }
        DynamicObject[] dynamicObjects = HELPER.queryOriginalArray(SELECT_POSITION_NUM, new QFilter[]{qFilter});
        int totalNum = Stream.of(dynamicObjects).filter(object -> !object.getBoolean("isrecnumlimit")).mapToInt(object -> object.getInt("recruitnum")).sum();
        result.put("totalNum", dynamicObjects.length);
        result.put("statusOpenNum", totalNum);
        return result;
    }

    public static Map<String, Integer> queryPositionNum(boolean isOwner, List<Long> orgIds) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        QFilter qFilter = new QFilter("positionstatus", "=", (Object)"A");
        if (isOwner) {
            Long userId = TSCRequestContext.getUserId();
            String key = "manageinfo.posprin.fbasedataid";
            qFilter.and(new QFilter(key, "=", (Object)userId));
        }
        qFilter.and(new QFilter("createorg", "in", orgIds));
        AuthorizedOrgResult authorizedOrgResult = PositionPermService.getInstance(null).getPositionHasPermAdminOrgs();
        if (!authorizedOrgResult.isHasAllOrgPerm()) {
            qFilter.and(new QFilter("adminorg", "in", (Object)authorizedOrgResult.getHasPermOrgs()));
        }
        DynamicObject[] dynamicObjects = HELPER.queryOriginalArray(SELECT_POSITION_NUM, new QFilter[]{qFilter});
        int totalNum = Stream.of(dynamicObjects).filter(object -> !object.getBoolean("isrecnumlimit")).mapToInt(object -> object.getInt("recruitnum")).sum();
        result.put("totalNum", dynamicObjects.length);
        result.put("statusOpenNum", totalNum);
        return result;
    }

    public static void setFilterTimeRange(QFilter qFilter, String timeRangeType, boolean isOwner) {
        if (!StringUtils.isEmpty((String)timeRangeType)) {
            Map<String, String> timeRange = AppFileHomePageHelper.coversTimePeriod(timeRangeType);
            if (HRStringUtils.isNotEmpty((String)timeRange.get("startdate"))) {
                qFilter.and("createtime", ">", (Object)LocalDateTime.parse(timeRange.get("startdate"), DateFormatConstants.NORM_DATETIME_FORM));
            }
            if (HRStringUtils.isNotEmpty((String)timeRange.get("enddate"))) {
                qFilter.and("createtime", "<", (Object)LocalDateTime.parse(timeRange.get("enddate"), DateFormatConstants.NORM_DATETIME_FORM));
            }
        }
        if (isOwner) {
            Long userId = TSCRequestContext.getUserId();
            String key = "manageinfo.posprin.fbasedataid";
            qFilter.and(new QFilter(key, "=", (Object)userId));
        }
    }

    public static void setHomeLabelValue(IFormView view, String labelName, int num) {
        Label label = (Label)view.getControl(labelName);
        label.setText(Numformat.excessNumShowAdd((int)num, (int)9999));
        HashMap<String, String> map = new HashMap<String, String>(3);
        if (num == 0) {
            map.put("fc", "#BBB");
        } else {
            map.put("fc", "#5582F3");
        }
        view.updateControlMetadata(labelName, map);
    }
}

