/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.tsc.tsrbs.business.domain.base.BaseHelper;
import org.apache.commons.collections4.CollectionUtils;

public class PositionJobHelper {
    public static void jobSetGradeLevelHandle(DynamicObject obj) {
        if (Objects.isNull(obj.get("highjobgrade"))) {
            obj.set("highjobgrade", obj.get("lowjobgrade"));
        }
        if (Objects.isNull(obj.get("lowjobgrade"))) {
            obj.set("lowjobgrade", obj.get("highjobgrade"));
        }
        if (Objects.isNull(obj.get("highjoblevel"))) {
            obj.set("highjoblevel", obj.get("lowjoblevel"));
        }
        if (Objects.isNull(obj.get("lowjoblevel"))) {
            obj.set("lowjoblevel", obj.get("highjoblevel"));
        }
    }

    public static List<Long> getJobSeqIdListByJobScm(DynamicObject jobScm) {
        if (Objects.isNull(jobScm)) {
            return null;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        List jobScmSeqList = BaseHelper.selectByFilter((QFilter[])(qFilter = qFilter.and("jobscm.id", "=", (Object)jobScm.getLong("id"))).toArray(), (String)"hbjm_jobseqscm");
        if (CollectionUtils.isEmpty((Collection)jobScmSeqList)) {
            return null;
        }
        return jobScmSeqList.stream().map(jobScmSeq -> jobScmSeq.getLong("jobseq.id")).collect(Collectors.toList());
    }

    public static List<Long> getJobFamilyIdListByJobScm(DynamicObject jobSeq) {
        return PositionJobHelper.getJobIdList(jobSeq, "jobseq.id", "hbjm_jobfamilyhr");
    }

    public static List<Long> getJobClassIdListByJobFamily(DynamicObject jobFamily) {
        return PositionJobHelper.getJobIdList(jobFamily, "jobfamily.id", "hbjm_jobclasshr");
    }

    public static List<Long> getJobGradeIdListByJobScmAndJobClass(DynamicObject jobScm, DynamicObject jobFamily, DynamicObject jobClass) {
        return PositionJobHelper.getJobGradeOrLevelIdList(jobScm, jobFamily, jobClass, "hbjm_jobgradehr");
    }

    private static List<Long> getJobGradeOrLevelIdListHandle(List<DynamicObject> jobGradeOrLevelList, String entityName) {
        return jobGradeOrLevelList.stream().sorted(Comparator.comparing(jobGradeOrLevel -> "hbjm_jobgradehr".equals(entityName) ? jobGradeOrLevel.getInt("jobgradeseq") : jobGradeOrLevel.getInt("joblevelseq"))).map(jobGradeOrLevel -> jobGradeOrLevel.getLong("id")).collect(Collectors.toList());
    }

    private static List<DynamicObject> getJobClassScmListHandle(DynamicObject jobClass, QFilter qFilter) {
        qFilter = qFilter.and("jobclass.id", "=", (Object)jobClass.getLong("id"));
        return BaseHelper.selectByFilter((QFilter[])qFilter.toArray(), (String)"hbjm_jobclassscm");
    }

    private static List<Long> getJobGradeOrLevelIdListHandle(List<DynamicObject> jobGradeOrLevelList, DynamicObject jobClassScm, String entityName) {
        if ("hbjm_jobgradehr".equals(entityName)) {
            return jobGradeOrLevelList.stream().filter(jobGradeOrLevel -> PositionJobHelper.getJobGradeFilterHandle(jobGradeOrLevel, jobClassScm)).sorted(Comparator.comparing(jobGrade -> jobGrade.getInt("jobgradeseq"))).map(jobGradeOrLevel -> jobGradeOrLevel.getLong("id")).collect(Collectors.toList());
        }
        return jobGradeOrLevelList.stream().filter(jobGradeOrLevel -> PositionJobHelper.getJobLevelFilterHandle(jobGradeOrLevel, jobClassScm)).sorted(Comparator.comparing(jobGrade -> jobGrade.getInt("joblevelseq"))).map(jobGradeOrLevel -> jobGradeOrLevel.getLong("id")).collect(Collectors.toList());
    }

    private static Boolean getJobLevelFilterHandle(DynamicObject jobGradeOrLevel, DynamicObject jobClassScm) {
        if (Objects.isNull(jobClassScm.getDynamicObject("lowjoblevel"))) {
            return Boolean.TRUE;
        }
        if (jobGradeOrLevel.getInt("joblevelseq") >= jobClassScm.getInt("lowjoblevel.joblevelseq") && jobGradeOrLevel.getInt("joblevelseq") <= jobClassScm.getInt("highjoblevel.joblevelseq")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Boolean getJobGradeFilterHandle(DynamicObject jobGradeOrLevel, DynamicObject jobClassScm) {
        if (Objects.isNull(jobClassScm.getDynamicObject("lowjobgrade"))) {
            return Boolean.TRUE;
        }
        if (jobGradeOrLevel.getInt("jobgradeseq") >= jobClassScm.getInt("lowjobgrade.jobgradeseq") && jobGradeOrLevel.getInt("jobgradeseq") <= jobClassScm.getInt("highjobgrade.jobgradeseq")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static List<DynamicObject> getJobGradeOrLevelListHandle(DynamicObject jobFamilyScm, DynamicObject jobScm, String entityName) {
        QFilter jobGradeOrLevelFilter = new QFilter("enable", "=", (Object)"1");
        if ("hbjm_jobgradehr".equals(entityName)) {
            long jobGradeScmId = 0L == jobFamilyScm.getLong("jobgradescm.id") ? jobScm.getLong("jobgradescm.id") : jobFamilyScm.getLong("jobgradescm.id");
            jobGradeOrLevelFilter.and("jobgradescm.id", "=", (Object)jobGradeScmId);
        } else {
            long jobLevelScmId = 0L == jobFamilyScm.getLong("joblevelscm.id") ? jobScm.getLong("joblevelscm.id") : jobFamilyScm.getLong("joblevelscm.id");
            jobGradeOrLevelFilter.and("joblevelscm.id", "=", (Object)jobLevelScmId);
        }
        return BaseHelper.selectByFilter((QFilter[])jobGradeOrLevelFilter.toArray(), (String)entityName);
    }

    private static DynamicObject getJobFamilyScmHandle(QFilter qFilter) {
        List jobFamilyScmList = BaseHelper.selectByFilter((QFilter[])qFilter.toArray(), (String)"hbjm_jobfamilyscm");
        if (CollectionUtils.isEmpty((Collection)jobFamilyScmList)) {
            return null;
        }
        return (DynamicObject)jobFamilyScmList.get(0);
    }

    private static List<Long> getJobGradeOrLevelIdList(DynamicObject jobScm, DynamicObject jobFamily, DynamicObject jobClass, String entityName) {
        DynamicObject jobClassScm;
        List<DynamicObject> jobClassScmList;
        if (Objects.isNull(jobScm) || Objects.isNull(jobFamily)) {
            return null;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1").and("jobscm.id", "=", (Object)jobScm.getLong("id")).and("jobfamily.id", "=", (Object)jobFamily.getLong("id"));
        DynamicObject jobFamilyScm = PositionJobHelper.getJobFamilyScmHandle(qFilter);
        if (Objects.isNull(jobFamilyScm)) {
            return null;
        }
        List<DynamicObject> jobGradeOrLevelList = PositionJobHelper.getJobGradeOrLevelListHandle(jobFamilyScm, jobScm, entityName);
        if (Objects.nonNull(jobClass) && !CollectionUtils.isEmpty(jobClassScmList = PositionJobHelper.getJobClassScmListHandle(jobClass, qFilter)) && Objects.nonNull(jobClassScm = jobClassScmList.get(0))) {
            return PositionJobHelper.getJobGradeOrLevelIdListHandle(jobGradeOrLevelList, jobClassScm, entityName);
        }
        return PositionJobHelper.getJobGradeOrLevelIdListHandle(jobGradeOrLevelList, entityName);
    }

    public static List<Long> getJobLevelIdListByJobScmAndJobClass(DynamicObject jobScm, DynamicObject jobFamily, DynamicObject jobClass) {
        return PositionJobHelper.getJobGradeOrLevelIdList(jobScm, jobFamily, jobClass, "hbjm_joblevelhr");
    }

    public static List<Long> getJobIdList(DynamicObject jobObj, String filterStr, String entityName) {
        List<DynamicObject> selJobList = PositionJobHelper.getJobList(jobObj, filterStr, entityName);
        if (selJobList == null) {
            return null;
        }
        return selJobList.stream().map(selJob -> selJob.getLong("id")).collect(Collectors.toList());
    }

    public static List<DynamicObject> getJobList(DynamicObject jobObj, String filterStr, String entityName) {
        if (Objects.isNull(jobObj)) {
            return null;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter = qFilter.and(filterStr, "=", (Object)jobObj.getLong("id"));
        return BaseHelper.selectByFilter((QFilter[])qFilter.toArray(), (String)entityName);
    }
}

