/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.constant.Constable;
import java.util.HashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tsrbd.business.domain.common.service.TscDispatchServiceHelper;

public class PositionLabelServiceHelper {
    private static PositionLabelServiceHelper positionRuleServiceHelper = new PositionLabelServiceHelper();
    private static final Log logger = LogFactory.getLog(PositionLabelServiceHelper.class);

    private PositionLabelServiceHelper() {
    }

    public static PositionLabelServiceHelper getInstance() {
        return positionRuleServiceHelper;
    }

    public JSONObject getLabelByPositionInfo(String inputParam) {
        HashMap<String, JSONObject> body = new HashMap<String, JSONObject>(1);
        body.put("data", JSONObject.parseObject((String)inputParam));
        JSONObject resultJson = TscDispatchServiceHelper.invokeBizServiceByMap((String)"getJDTag", body);
        if (null == resultJson) {
            return null;
        }
        JSONObject json = resultJson.getJSONObject("result");
        if (json == null || json.isEmpty() || json.get((Object)"complete_tag") == null) {
            return null;
        }
        JSONObject tag = resultJson.getJSONObject("result").getJSONObject("complete_tag");
        return tag;
    }

    public JSONObject getLabelByPositionId(Long positionId) {
        HashMap<String, Long> body = new HashMap<String, Long>(1);
        body.put("portrait_id", positionId);
        JSONObject resultJson = TscDispatchServiceHelper.invokeBizServiceByMap((String)"queryJDPortrait", body);
        if (resultJson != null && "1000".equals(resultJson.getString("statusCode"))) {
            resultJson.getJSONObject("data");
        }
        return new JSONObject();
    }

    public String savePositionLabelToAi(Long positionId, String inputParam, Boolean isGetTag) {
        String statusCode;
        HashMap<String, Constable> body = new HashMap<String, Constable>(3);
        body.put("portrait_id", positionId);
        body.put("is_get_tag", isGetTag);
        body.put("data", (Constable)JSONObject.parseObject((String)inputParam));
        try {
            JSONObject resultJson = TscDispatchServiceHelper.invokeBizServiceByMap((String)"saveJDPortrait", body);
            statusCode = resultJson.get((Object)"statusCode").toString();
        }
        catch (Exception ex) {
            logger.error("PositionLabelAPI.savePositionLabelToAi exception", (Throwable)ex);
            return "-10000";
        }
        return statusCode;
    }

    public JSONArray getLabelByPCode(String typeCode, String keyWord, String queryField, String title, Integer count, String jobThirdClass) {
        HashMap<String, Object> body = new HashMap<String, Object>(3);
        body.put("tag_type", typeCode);
        body.put("key_word", keyWord);
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("query_field", queryField);
        params.put("title", title);
        params.put("count", count);
        params.put("job_third_class", jobThirdClass);
        body.put("params", params);
        String inputParam = JSON.toJSONString(body);
        JSONObject resultJson = TscDispatchServiceHelper.invokeBizServiceByMap((String)"queryTag", body);
        JSONArray data_tag = resultJson.getJSONArray("data");
        return data_tag;
    }
}

