/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.util.Date;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.position.service.entity.PositionLockInfo;

public class PositionLockService {
    private static final Log logger = LogFactory.getLog(PositionLockService.class);
    private static final DistributeSessionlessCache FLOWLOCK_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("tsc_region");
    private static final String CACHE_KEY_FIX = "[tscposition11]";
    private static int OUT_SECONDS = 600;
    private static int OUT_TRY_LOCK = 5000;

    public static PositionLockService getInstance() {
        return new PositionLockService();
    }

    public boolean positionTokenIsExist(Long positionId) {
        PositionLockInfo positionLockInfo = this.getLockVal(positionId);
        if (positionLockInfo == null) {
            return false;
        }
        Date invalidTime = positionLockInfo.getInvalidTime();
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        if (now.after(invalidTime)) {
            FLOWLOCK_CACHE.remove(this.genCacheKey(positionId));
            return false;
        }
        return true;
    }

    public void releaseLock(Long positionId) {
        FLOWLOCK_CACHE.remove(this.genCacheKey(positionId));
    }

    private PositionLockInfo getLockVal(Long positionId) {
        String key = this.genCacheKey(positionId);
        String val = (String)FLOWLOCK_CACHE.get(key);
        if (HRStringUtils.isEmpty((String)val)) {
            return null;
        }
        return (PositionLockInfo)JSON.parseObject((String)val, PositionLockInfo.class);
    }

    private String genCacheKey(Long positionId) {
        return CACHE_KEY_FIX + positionId;
    }
}

