/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionResumeRuleHelper;
import kd.tsc.tsrbd.business.domain.config.service.BizConfigParamHelper;
import org.apache.commons.collections4.CollectionUtils;

public class PositionManageService {
    private static final BizConfigParamHelper BIZ_CONFIG = new BizConfigParamHelper();

    private PositionManageService() {
    }

    public static PositionManageService getInstance() {
        return new PositionManageService();
    }

    public void openPositionManagePage(String formId, String targetKey, IFormView view, Map<String, Object> customParams) {
        this.openPositionManagePage(formId, targetKey, view, null, null, null, customParams);
    }

    public void openPositionManagePage(String formId, String targetKey, IFormView view, BillOperationStatus billStatus, OperationStatus status, Long pkId, Map<String, Object> customParams) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setTargetKey(targetKey);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        if (billStatus != null) {
            parameter.setBillStatus(billStatus);
        }
        if (status != null) {
            parameter.setStatus(status);
        }
        if (pkId != null) {
            parameter.setPkId((Object)pkId);
        }
        if (customParams != null) {
            customParams.forEach((key, val) -> parameter.setCustomParam(key, val));
        }
        String pageId = parameter.getPageId();
        view.showForm((FormShowParameter)parameter);
        view.getPageCache().put(formId, pageId);
    }

    public void savePositionManage(DynamicObject[] dys) {
        Arrays.stream(dys).forEach(dynamicObject -> {
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dynamicObject, (String)"position");
            if (entryentity.size() == 0) {
                PositionResumeRuleHelper.statusChange(positionId, "A", false);
            } else {
                PositionResumeRuleHelper.statusChange(positionId, "A", true);
            }
        });
    }

    public static DynamicObject[] savePositionManageInfo(DynamicObject[] manageDyns) {
        HRBaseServiceHelper POSITIONMANAGE_HELPER = new HRBaseServiceHelper("tsirm_positionmanage");
        return (DynamicObject[])POSITIONMANAGE_HELPER.save(manageDyns);
    }

    public void setPositionManageToPosition(Long positionId) {
        DynamicObject manageInfo = PositionManageServiceHelper.getManageInfoByPositionBo(positionId);
        if (manageInfo == null) {
            return;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        map.put("manageinfo", Collections.singletonList(manageInfo.getLong("id")));
        PositionDataHelper.updatePositionInfo("tsirm_position", Collections.singletonList(positionId), (Map<String, List<Object>>)map);
    }

    public void deletePositionManages(DynamicObject[] positions) {
        if (positions == null) {
            return;
        }
        HRBaseServiceHelper manageService = new HRBaseServiceHelper("tsirm_positionmanage");
        QFilter qFilter = new QFilter("position", "in", Arrays.stream(positions).map(wa -> wa.getLong("id")).collect(Collectors.toList()));
        manageService.deleteByFilter(qFilter.toArray());
    }

    public void deletePositionManageByPositionIds(List<Long> positionIds) {
        if (CollectionUtils.isEmpty(positionIds)) {
            return;
        }
        HRBaseServiceHelper manageService = new HRBaseServiceHelper("tsirm_positionmanage");
        manageService.deleteByFilter(new QFilter("position", "in", positionIds).toArray());
    }

    public void recCategoryChanged(Long recCategoryId, Long recruscene, IFormView childView, IDataModel model) {
        if (childView == null || recCategoryId.equals(0L)) {
            return;
        }
        IDataModel childModel = childView.getModel();
        this.recPorcChange(recCategoryId, recruscene, childModel, model);
    }

    private void recPorcChange(Long recCategoryId, Long recruscene, IDataModel model, IDataModel parentModel) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        QFilter filter = PositionManageServiceHelper.generateQFilterMap(parentModel).get("recruproc");
        DynamicObject[] recPorcs = serviceHelper.query("id", filter.toArray());
        if (recPorcs.length == 1) {
            model.setValue("recruproc", (Object)recPorcs[0].getLong("id"));
        } else {
            model.setValue("recruproc", null);
        }
    }

    public void setDefaultRecCategory(IFormView view) {
        String pageIdCache = view.getPageCache().get("tsirm_positionmanage");
        IFormView childView = view.getView(pageIdCache);
        Long recCatrgory = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)view.getModel().getDataEntity(), (String)"reccategory");
        Long recruscene = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)view.getModel().getDataEntity(), (String)"recruscene");
        view.sendFormAction(childView);
    }

    public Long getPositionId(IFormView formView) {
        Object position = formView.getModel().getValue("position");
        Long positionId = position instanceof DynamicObject ? Long.valueOf(((DynamicObject)position).getLong("id")) : (Long)position;
        return positionId;
    }
}

