/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;

public class PositionModelAdapter {
    private static final Log LOGGER = LogFactory.getLog(PositionModelAdapter.class);

    private PositionModelAdapter() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<Long, Integer> getRecruitmentStageCountByPositionId(Long positionId) {
        if (positionId == null) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        HRBaseServiceHelper dbServiceAppFile = new HRBaseServiceHelper("tsirm_appfilemdl");
        try (DataSet dataSet = dbServiceAppFile.queryDataSet("getRecruitmentStageCountByPositionId_0", "recrustg.id", new QFilter("position.id", "=", (Object)positionId).toArray());
             DataSet groupSet = dataSet.groupBy(new String[]{"recrustg.id"}).count().finish();){
            for (Row row : groupSet) {
                row.getLong("count");
                result.put(row.getLong("recrustg.id"), row.getInteger("count"));
            }
        }
        return result;
    }

    public static Map<Long, Integer> getCountByPositionId(List<Long> positionIds) {
        if (positionIds == null || positionIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        positionIds.forEach(positionId -> result.put(positionId, 0));
        HRBaseServiceHelper dbServiceAppFile = new HRBaseServiceHelper("tsirm_appfilemdl");
        try (DataSet dataSet = dbServiceAppFile.queryDataSet("getCountByPositionId_0", "position.id", new QFilter("position.id", "in", positionIds).toArray());
             DataSet groupSet = dataSet.groupBy(new String[]{"position.id"}).count().finish();){
            LOGGER.info("queryDataSet finished");
            for (Row row : groupSet) {
                result.put(row.getLong("position.id"), row.getInteger("count"));
            }
        }
        return result;
    }

    public static Map<Long, Integer> getChangedCountByPositionIds(List<Long> positionIds) {
        if (positionIds == null || positionIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        positionIds.forEach(positionId -> result.put(positionId, 0));
        HRBaseServiceHelper dbServiceAppFile = new HRBaseServiceHelper("tsirm_appfilemdl");
        QFilter[] qFilters = new QFilter("position.id", "in", positionIds).and(new QFilter("filestatus", "=", (Object)AppFileConstants.APP_FILE_STATUS_INVALID)).toArray();
        DynamicObject[] dynamicObjects = dbServiceAppFile.query("position.id", qFilters);
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            return result;
        }
        Map<Long, List<DynamicObject>> collect = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("position.id")));
        LOGGER.info("{} stream2 groupingBy {}", (Object)dynamicObjects.length, (Object)collect.size());
        collect.forEach((positionId, appFileList) -> result.put(positionId, appFileList.size()));
        return result;
    }

    public static Long getCountBySinglePositionId(Long positionId) {
        if (positionId == null) {
            return 0L;
        }
        Long result = 0L;
        HRBaseServiceHelper dbServiceAppFile = new HRBaseServiceHelper("tsirm_appfilemdl");
        try (DataSet dataSet = dbServiceAppFile.queryDataSet("getCountBySinglePositionId_0", "position.id", new QFilter("position.id", "=", (Object)positionId).toArray());
             DataSet groupSet = dataSet.groupBy(new String[]{"position.id"}).count().finish();){
            for (Row row : groupSet) {
                result = row.getLong("count");
            }
        }
        return result;
    }

    public static Long getChangedCountBySinglePositionId(Long positionId) {
        if (positionId == null) {
            return 0L;
        }
        Long result = 0L;
        HRBaseServiceHelper dbServiceAppFile = new HRBaseServiceHelper("tsirm_appfilemdl");
        QFilter[] qFilters = new QFilter("position.id", "=", (Object)positionId).and(new QFilter("filestatus", "=", (Object)AppFileConstants.APP_FILE_STATUS_INVALID)).toArray();
        try (DataSet dataSet = dbServiceAppFile.queryDataSet("getChangedCountBySinglePositionId_0", "position.id", qFilters);
             DataSet groupSet = dataSet.groupBy(new String[]{"position.id"}).count().finish();){
            for (Row row : groupSet) {
                result = row.getLong("count");
            }
        }
        return result;
    }
}

