/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.position.service.PosPortraitHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionBillDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionJobHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionResumeRuleHelper;
import kd.tsc.tsirm.business.domain.position.service.bo.PosResumeRuleParamBO;
import kd.tsc.tsirm.business.domain.position.service.enums.PosPortraitOperateEnum;
import kd.tsc.tsirm.common.constants.position.PositionConstants;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class PositionOperateService {
    private static final Log logger = LogFactory.getLog(PositionOperateService.class);
    private static final HRBaseServiceHelper SNAPHELPER = new HRBaseServiceHelper("tsirm_positionsnaptpl");

    private PositionOperateService() {
    }

    public static PositionOperateService getInstance() {
        return new PositionOperateService();
    }

    public void afterPositionEffect(DynamicObject[] positionDys) {
        ArrayList posResumeRuleParams = Lists.newArrayListWithCapacity((int)positionDys.length);
        List<Long> positionIds = Arrays.stream(positionDys).map(position -> position.getLong("id")).collect(Collectors.toList());
        DynamicObject[] manageInfos = PositionManageServiceHelper.getManageInfoByPositionIds(positionIds);
        Map<Long, DynamicObject> manageInfoMap = Arrays.stream(manageInfos).collect(Collectors.toMap(manageInfo -> HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)manageInfo, (String)"position"), manageInfo -> manageInfo));
        Map<Long, List<Long>> mailInfoIdMap = PositionManageServiceHelper.getMailInfoIdByPositionBo(positionIds);
        for (DynamicObject positionDyn : positionDys) {
            Long positionId = positionDyn.getLong("id");
            if (manageInfoMap.get(positionId) == null) continue;
            String number = positionDyn.getString("number");
            String positionName = positionDyn.getString("name");
            DynamicObjectCollection workaddrs = positionDyn.getDynamicObjectCollection("workaddr");
            StringBuilder sb = new StringBuilder();
            for (DynamicObject workaddr : workaddrs) {
                String city = workaddr.getDynamicObject("fbasedataid").getLocaleString("city.name").getLocaleValue();
                sb.append("\u3001").append(city);
            }
            String workCityString = sb.toString();
            String workCity = "";
            if (HRStringUtils.isNotEmpty((String)workCityString)) {
                workCity = workCityString.substring(1);
            }
            PosResumeRuleParamBO posResumeRuleParamBO = new PosResumeRuleParamBO();
            posResumeRuleParamBO.setPositionId(positionId);
            posResumeRuleParamBO.setPositionCode(number);
            posResumeRuleParamBO.setPositionName(positionName);
            posResumeRuleParamBO.setPositionCity(Optional.of(workCity));
            List<Long> mailInfoList = mailInfoIdMap.get(positionId);
            posResumeRuleParamBO.setHasEmail(mailInfoList != null && mailInfoList.size() > 0);
            posResumeRuleParams.add(posResumeRuleParamBO);
        }
        if (posResumeRuleParams.size() > 0) {
            PositionResumeRuleHelper.addWhenPositionCreate(posResumeRuleParams);
        }
        DynamicObject[] dys = PositionDataHelper.getPositionObjByPositionIds(positionIds);
        this.doPosPortraitOperate(dys, PosPortraitOperateEnum.COMMIT);
    }

    public void afterSubmitPositionBatch(DynamicObject[] positionDys, OperateOption option) {
        List<Long> positionIds = Arrays.stream(positionDys).map(positionDyn -> positionDyn.getLong("id")).collect(Collectors.toList());
        List<DynamicObject> posSnapDynamicObjects = PositionDataHelper.syncUpdatePositionSnapshotAfterSave(positionDys, positionIds, "2");
        List posSnapPkIds = posSnapDynamicObjects.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        ArrayList<DynamicObject> otherList = new ArrayList<DynamicObject>(1);
        ArrayList<Long> otherSnapPkIds = new ArrayList<Long>(1);
        for (int i = 0; i < positionDys.length; ++i) {
            DynamicObject positionDy = positionDys[i];
            Long snapPkId = (Long)posSnapPkIds.get(i);
            String positionStatus = positionDy.getString("positionstatus");
            if ("E".equals(positionStatus)) continue;
            otherList.add(positionDy);
            otherSnapPkIds.add(snapPkId);
        }
        if (otherList.size() > 0) {
            boolean b = this.afterSubmitPosition(otherList.toArray(new DynamicObject[0]), otherSnapPkIds, option);
            if (!b) {
                return;
            }
            SNAPHELPER.save(posSnapDynamicObjects.toArray(new DynamicObject[0]));
        }
        for (int index = 0; index < positionIds.size(); ++index) {
            PositionHelper.updateAttachment("tsirm_positiontpl", "tsirm_positionsnaptpl", positionIds.get(index), (Long)posSnapPkIds.get(index));
        }
    }

    public boolean afterSubmitPosition(DynamicObject[] positionDys, List<Long> posSnapPkIds, OperateOption option) {
        DynamicObject[] dynamicObjects;
        Map<Long, DynamicObject> map;
        List<Long> positionIds = Arrays.stream(positionDys).map(positionDyn -> positionDyn.getLong("id")).collect(Collectors.toList());
        List<Object> billNoList = PositionBillDataHelper.submitBill("tsirm_positionbill", posSnapPkIds, positionIds, map = Arrays.stream(positionDys).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject, (v1, v2) -> v1)), option);
        if (CollectionUtils.isEmpty(billNoList)) {
            return false;
        }
        for (DynamicObject dynamicObject2 : dynamicObjects = PositionDataHelper.getPositionObjByPositionIds(positionIds)) {
            dynamicObject2.set("status", (Object)"B");
            dynamicObject2.set("billstatus", (Object)"B");
            dynamicObject2.set("positionstatus", (Object)"E");
            dynamicObject2.set("positionpriority", (Object)1);
            PositionJobHelper.jobSetGradeLevelHandle(dynamicObject2);
        }
        HashMap valueMap = Maps.newHashMapWithExpectedSize((int)16);
        valueMap.put("vid", Collections.singletonList(posSnapPkIds));
        valueMap.put("billno", billNoList);
        PositionDataHelper.updatePositionInfo("tsirm_position", dynamicObjects, (Map<String, List<Object>>)valueMap);
        this.doPosPortraitOperate(dynamicObjects, PosPortraitOperateEnum.COMMIT);
        return true;
    }

    public void afterSubmitEffectPosition(DynamicObject[] positionDys, List<Long> posSnapPkIds) {
        DynamicObject[] dynamicObjects;
        List<Long> positionIds = Arrays.stream(positionDys).map(positionDyn -> positionDyn.getLong("id")).collect(Collectors.toList());
        List<Object> billNoList = PositionBillDataHelper.submiteffectBill("tsirm_positionbill", posSnapPkIds, positionIds);
        for (DynamicObject dynamicObject : dynamicObjects = PositionDataHelper.getPositionObjByPositionIds(positionIds)) {
            dynamicObject.set("status", (Object)"H");
            dynamicObject.set("billstatus", (Object)"H");
            dynamicObject.set("positionstatus", (Object)"A");
            dynamicObject.set("positionpriority", (Object)1);
        }
        HashMap valueMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList<Long> posSnapPkIdList = new ArrayList<Long>(16);
        if (ObjectUtils.isNotEmpty(posSnapPkIds)) {
            for (Long posSnapPkId : posSnapPkIds) {
                posSnapPkIdList.add(posSnapPkId);
            }
        }
        valueMap.put("vid", posSnapPkIdList);
        valueMap.put("billno", billNoList);
        PositionDataHelper.updatePositionInfo("tsirm_position", dynamicObjects, (Map<String, List<Object>>)valueMap);
        this.doPosPortraitOperate(dynamicObjects, PosPortraitOperateEnum.COMMIT);
    }

    public void savePosition(DynamicObject[] positionDys) {
        this.doPosPortraitOperate(positionDys, PosPortraitOperateEnum.SAVE);
        this.saveSnapPositionIfModify(positionDys);
    }

    public void saveSnapPositionIfModify(DynamicObject[] positionDys) {
        ArrayList<DynamicObject> dys = new ArrayList<DynamicObject>(1);
        ArrayList<Long> vids = new ArrayList<Long>(1);
        for (DynamicObject positionDy : positionDys) {
            Long vid = positionDy.getLong("vid");
            String positionStatus = positionDy.getString("positionstatus");
            if (!"E".equals(positionStatus) || vid == null || vid == 0L) continue;
            dys.add(positionDy);
            vids.add(vid);
        }
        if (dys.size() == 0) {
            return;
        }
        PositionDataHelper.syncUpdatePositionSnapshotBySnapIds(dys.toArray(new DynamicObject[0]), vids);
    }

    private void doPosPortraitOperate(DynamicObject[] positionDys, PosPortraitOperateEnum operateEnum) {
        if (PositionConstants.IS_SHOW_PORTRAIT.booleanValue()) {
            Map<Long, String> positionJsonMap = Arrays.stream(positionDys).collect(Collectors.toMap(dyn -> dyn.getLong("id"), PositionDataHelper::generatePositionJsonString));
            PosPortraitHelper posPortraitHelper = new PosPortraitHelper();
            posPortraitHelper.operates(positionJsonMap, operateEnum);
        }
    }

    public void afterStatusPosition(DynamicObject[] positionDys, String status) {
        List<Long> positionIdList = Arrays.stream(positionDys).map(position -> position.getLong("id")).collect(Collectors.toList());
        Map<Long, List<Long>> mailIdMap = PositionManageServiceHelper.getMailInfoIdByPositionBo(positionIdList);
        for (DynamicObject positionDyn : positionDys) {
            Long positionId = positionDyn.getLong("id");
            List<Long> list = mailIdMap.get(positionId);
            if (list != null && !list.isEmpty()) {
                PositionResumeRuleHelper.statusChange(positionId, status, Boolean.TRUE);
                continue;
            }
            PositionResumeRuleHelper.statusChange(positionId, status, Boolean.FALSE);
        }
    }

    public void showOperationResult(OperationResult operationResult, IFormView view, IFormPlugin plugin) {
        operationResult.setShowMessage(false);
        boolean isSuccess = operationResult.isSuccess();
        Map billNos = operationResult.getBillNos();
        List successPkIds = operationResult.getSuccessPkIds();
        ValidateResultCollection validateResult = operationResult.getValidateResult();
        List validateErrors = validateResult.getValidateErrors();
        ArrayList errorMessage = Lists.newArrayListWithExpectedSize((int)validateErrors.size());
        for (Object validateError : validateErrors) {
            List allErrorInfo = validateError.getAllErrorInfo();
            List collect = allErrorInfo.stream().map(errorInfo -> errorInfo.getMessage()).collect(Collectors.toList());
            errorMessage.addAll(collect);
        }
        StringBuilder sb = new StringBuilder();
        for (String message : errorMessage) {
            sb.append(message).append(System.lineSeparator());
        }
        int allNo = billNos.size();
        int successNo = successPkIds.size();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("successNo", (Object)successNo);
        showParameter.setCustomParam("allNo", (Object)allNo);
        showParameter.setCustomParam("isSuccess", (Object)isSuccess);
        showParameter.setCustomParam("successPkIds", (Object)successPkIds);
        showParameter.setCustomParam("errorMessage", (Object)sb.toString());
        showParameter.setFormId("tsirm_posstopopresult");
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "posstopopresult_callback"));
        showParameter.setCaption(ResManager.loadKDString((String)"\u63d0\u793a", (String)"PositionOperateService_0", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }
}

