/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.tsc.common.vo.BizResult;
import kd.tsc.tsirm.business.domain.position.service.bo.PosResumeRuleParamBO;
import kd.tsc.tsrbd.business.domain.common.entity.BizResults;
import kd.tsc.tsrbs.common.enums.rsm.RsmAssignTypeEnum;
import kd.tsc.tsrbs.common.utils.PublishMsgUtil;

public class PositionResumeRuleHelper {
    private static HRBaseServiceHelper positionRuleService = new HRBaseServiceHelper("tsirm_positionrule");
    private static String selects = "distrimode,keyword,enable";
    private static String ruleSelects = "distrimode,keyword,positionid,enable";
    public static final Integer KEYWORD_REPEAT_CODE = -10;
    public static final Integer KEYWORD_INCLUDE_CODE = -20;
    public static final Integer KEYWORD_INCLUDED_CODE = -30;

    private PositionResumeRuleHelper() {
        throw new IllegalStateException("PositionResumeRuleHelper class");
    }

    public static BizResult statusChange(Long positionId, String positionStatus, boolean hasEmail) {
        if (null == positionId || HRStringUtils.isBlank((CharSequence)positionStatus)) {
            return BizResults.failed((String)"no rules");
        }
        QFilter filter = new QFilter("positionid", "=", (Object)positionId);
        DynamicObject[] dynamicObjects = positionRuleService.query(ruleSelects, new QFilter[]{filter});
        if (dynamicObjects.length == 0) {
            return BizResults.failed((String)"no rules");
        }
        String statusDB = dynamicObjects[0].getString("enable");
        String status = PositionResumeRuleHelper.changeStatus(positionStatus, hasEmail, dynamicObjects, statusDB);
        if (HRStringUtils.isEmpty((String)status)) {
            return BizResults.failed((String)"status no change");
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("enable", (Object)status);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        return BizResults.success((String)("status change to " + status));
    }

    private static String changeStatus(String positionStatus, boolean hasEmail, DynamicObject[] dynamicObjects, String statusDB) {
        String status = "";
        if (hasEmail && HRStringUtils.equals((String)"A", (String)positionStatus) && HRStringUtils.equals((String)statusDB, (String)"0")) {
            status = "1";
            PublishMsgUtil.positionRulePublishMsg((DynamicObject[])dynamicObjects, (int)2);
        }
        if ((!hasEmail || HRStringUtils.equals((String)"E", (String)positionStatus) || HRStringUtils.equals((String)"D", (String)positionStatus)) && HRStringUtils.equals((String)statusDB, (String)"1")) {
            status = "0";
        }
        return status;
    }

    public static BizResult addWhenPositionCreate(List<PosResumeRuleParamBO> posResumeRuleParams) {
        ArrayList dynamicObjects = Lists.newArrayListWithExpectedSize((int)(posResumeRuleParams.size() * 2));
        for (PosResumeRuleParamBO posResumeRuleParam : posResumeRuleParams) {
            Long positionId = posResumeRuleParam.getPositionId();
            String positionCode = posResumeRuleParam.getPositionCode();
            String positionName = posResumeRuleParam.getPositionName();
            Optional<String> positionCity = posResumeRuleParam.getPositionCity();
            if (null == positionId || HRStringUtils.isBlank((CharSequence)positionCode) || HRStringUtils.isBlank((CharSequence)positionName)) continue;
            ArrayList dynamicObjs = Lists.newArrayListWithExpectedSize((int)2);
            String status = "0";
            if (null != posResumeRuleParam.getHasEmail() && posResumeRuleParam.getHasEmail().booleanValue()) {
                status = "1";
            }
            DynamicObject codeDynamic = BusinessDataServiceHelper.newDynamicObject((String)"tsirm_positionrule");
            long codeId = ID.genLongId();
            codeDynamic.set("id", (Object)codeId);
            codeDynamic.set("status", (Object)"A");
            codeDynamic.set("masterid", (Object)codeId);
            codeDynamic.set("positionid", (Object)positionId);
            codeDynamic.set("distrimode", (Object)RsmAssignTypeEnum.NUMBER.getCode());
            codeDynamic.set("keyword", (Object)positionCode);
            codeDynamic.set("enable", (Object)status);
            codeDynamic.set("issyspreset", (Object)Character.valueOf('1'));
            dynamicObjects.add(codeDynamic);
            dynamicObjs.add(codeDynamic);
            StringBuilder keyword = new StringBuilder(positionName);
            if (positionCity.isPresent()) {
                String city = positionCity.get();
                String[] citys = city.split("\u3001");
                HashSet citySet = Sets.newHashSetWithExpectedSize((int)city.length());
                for (String cityItem : citys) {
                    if (citySet.contains(cityItem)) continue;
                    citySet.add(cityItem);
                    keyword.append("\u3001");
                    keyword.append(cityItem);
                }
            }
            DynamicObject themeDynamic = BusinessDataServiceHelper.newDynamicObject((String)"tsirm_positionrule");
            long themeId = ID.genLongId();
            themeDynamic.set("id", (Object)themeId);
            themeDynamic.set("status", (Object)"A");
            themeDynamic.set("masterid", (Object)themeId);
            themeDynamic.set("positionid", (Object)positionId);
            themeDynamic.set("distrimode", (Object)RsmAssignTypeEnum.EMAIL.getCode());
            themeDynamic.set("keyword", (Object)keyword.toString());
            themeDynamic.set("enable", (Object)status);
            themeDynamic.set("issyspreset", (Object)Character.valueOf('0'));
            dynamicObjects.add(themeDynamic);
            dynamicObjs.add(themeDynamic);
            if (!HRStringUtils.equals((String)status, (String)"1")) continue;
            PublishMsgUtil.positionRulePublishMsg((DynamicObject[])dynamicObjs.toArray(new DynamicObject[0]), (int)2);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        return BizResults.success();
    }

    public static BizResult addOneAfterPositionExist(Long positionId, RsmAssignTypeEnum distriMode, String keyword) {
        if (null == positionId || null == distriMode || HRStringUtils.isBlank((CharSequence)keyword)) {
            return BizResults.failed((String)"no rules");
        }
        QFilter positionFilter = new QFilter("positionid", "=", (Object)positionId);
        DynamicObject[] dynamicObjects = positionRuleService.query(selects, new QFilter[]{positionFilter});
        if (dynamicObjects.length == 0) {
            return BizResults.failed((String)"no rules");
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            BizResult bizResult;
            if (!HRStringUtils.equals((String)distriMode.getCode(), (String)dynamicObject.getString("distrimode")) || (bizResult = PositionResumeRuleHelper.checkKeywordInclude(keyword, dynamicObject.getString("keyword"))).getSuccess().booleanValue()) continue;
            return bizResult;
        }
        DynamicObject dynamic = BusinessDataServiceHelper.newDynamicObject((String)"tsirm_positionrule");
        long id = ORM.create().genLongId("tsirm_positionrule");
        dynamic.set("id", (Object)id);
        dynamic.set("status", (Object)"A");
        dynamic.set("masterid", (Object)id);
        dynamic.set("positionid", (Object)positionId);
        dynamic.set("distrimode", (Object)distriMode.getCode());
        dynamic.set("keyword", (Object)keyword);
        String statusDB = dynamicObjects[0].getString("enable");
        dynamic.set("enable", (Object)statusDB);
        dynamic.set("issyspreset", (Object)Character.valueOf('0'));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamic});
        if (HRStringUtils.equals((String)statusDB, (String)"1")) {
            PublishMsgUtil.positionRulePublishMsg((DynamicObject[])new DynamicObject[]{dynamic}, (int)2);
        }
        return BizResults.success();
    }

    public static BizResult checkKeywordInclude(String newKeyword, String oldKeyword) {
        int i;
        if (null == newKeyword || null == oldKeyword) {
            return BizResults.failed((int)KEYWORD_REPEAT_CODE, (String)"keyword repeat");
        }
        String[] newKeywords = newKeyword.split("\u3001");
        String[] oldKeywords = oldKeyword.split("\u3001");
        if (HRStringUtils.equals((String)newKeyword, (String)oldKeyword)) {
            return BizResults.failed((int)KEYWORD_REPEAT_CODE, (String)"keyword repeat");
        }
        if (newKeywords.length <= oldKeywords.length) {
            boolean include = true;
            for (i = 0; i < newKeywords.length; ++i) {
                if (PositionResumeRuleHelper.isInclude(newKeywords[i], oldKeywords)) continue;
                include = false;
                break;
            }
            if (include) {
                BizResult bizResult = BizResults.failed((int)KEYWORD_INCLUDE_CODE, (String)"keyword include");
                bizResult.setData((Object)oldKeyword);
                return bizResult;
            }
        }
        if (newKeywords.length > oldKeywords.length) {
            boolean included = true;
            for (i = 0; i < oldKeywords.length; ++i) {
                if (PositionResumeRuleHelper.isInclude(oldKeywords[i], newKeywords)) continue;
                included = false;
                break;
            }
            if (included) {
                BizResult bizResult = BizResults.failed((int)KEYWORD_INCLUDED_CODE, (String)"keyword included");
                bizResult.setData((Object)oldKeyword);
                return bizResult;
            }
        }
        return BizResults.success();
    }

    private static boolean isInclude(String keyword, String[] keywords) {
        boolean include = false;
        for (int i = 0; i < keywords.length; ++i) {
            if (!HRStringUtils.equals((String)keywords[i], (String)keyword)) continue;
            include = true;
            break;
        }
        return include;
    }
}

