/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.tsc.common.vo.BizResult;
import kd.tsc.tsirm.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionResumeRuleHelper;
import kd.tsc.tsrbd.business.domain.common.entity.BizResults;

public class PositionRuleHelper {
    private HRBaseServiceHelper positionRuleService = new HRBaseServiceHelper("tsirm_positionrule");
    private String selects = "keyword,enable";
    private String ruleSelects = "distrimode,keyword,positionid,enable";
    public static final Integer STATUS_HAS_DISABLED_CODE = -10;
    public static final Integer STATUS_HAS_ENABLED_CODE = -20;
    public static final Integer NO_EMAIL_CODE = -30;

    public BizResult setStatus(Long positionId, String status) {
        QFilter filter = new QFilter("positionid", "=", (Object)positionId);
        DynamicObject[] dynamicObjects = this.positionRuleService.query(this.selects, new QFilter[]{filter});
        if (dynamicObjects.length == 0) {
            return BizResults.failed((String)"no rules");
        }
        String statusDB = dynamicObjects[0].getString("enable");
        if (HRStringUtils.equals((String)"0", (String)status) && HRStringUtils.equals((String)statusDB, (String)status)) {
            return BizResults.failed((int)STATUS_HAS_DISABLED_CODE, (String)"status has disabled");
        }
        boolean hasEmail = false;
        ArrayList<Long> positionList = new ArrayList<Long>();
        positionList.add(positionId);
        Map<Long, List<Long>> mailInfo = PositionManageServiceHelper.getMailInfoIdByPositionBo(positionList);
        if (!mailInfo.isEmpty()) {
            hasEmail = true;
        }
        if (HRStringUtils.equals((String)"1", (String)status)) {
            if (!hasEmail) {
                return BizResults.failed((int)NO_EMAIL_CODE, (String)"no email");
            }
            if (HRStringUtils.equals((String)statusDB, (String)status)) {
                return BizResults.failed((int)STATUS_HAS_ENABLED_CODE, (String)"status has enabled");
            }
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("enable", (Object)status);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        return BizResults.success((String)("status change to " + status));
    }

    public BizResult saveCheck(Long id, String distriMode, String keyword, Long positionId) {
        QFilter positionFilter = new QFilter("positionid", "=", (Object)positionId);
        QFilter distriModeFilter = new QFilter("distrimode", "=", (Object)distriMode);
        DynamicObject[] dynamicObjects = this.positionRuleService.query(this.selects, new QFilter[]{positionFilter, distriModeFilter});
        if (dynamicObjects.length == 0) {
            return BizResults.failed((String)"no rules");
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            BizResult bizResult;
            if (id.equals(dynamicObject.getLong("id")) || (bizResult = PositionResumeRuleHelper.checkKeywordInclude(keyword, dynamicObject.getString("keyword"))).getSuccess().booleanValue()) continue;
            return bizResult;
        }
        return BizResults.success();
    }

    public DynamicObject[] listByPosition(Long position) {
        if (null == position) {
            return new DynamicObject[0];
        }
        QFilter filter = new QFilter("positionid", "=", (Object)position);
        return this.positionRuleService.query(this.ruleSelects, new QFilter[]{filter});
    }
}

