/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import org.apache.commons.lang3.ArrayUtils;

public class PositionRuleServiceHelper {
    private static PositionRuleServiceHelper positionRuleServiceHelper = new PositionRuleServiceHelper();
    private static HRBaseServiceHelper ruleServiceHelper = new HRBaseServiceHelper("tsirm_positionrule");
    private static HRBaseServiceHelper rsmServiceHelper = new HRBaseServiceHelper("tsirm_rsm");
    private static HRBaseServiceHelper positionServiceHelper = new HRBaseServiceHelper("tsirm_positiontpl");

    private PositionRuleServiceHelper() {
    }

    public static PositionRuleServiceHelper getInstance() {
        return positionRuleServiceHelper;
    }

    public void deleteById(Long positionRuleId) {
        if (Objects.isNull(positionRuleId)) {
            return;
        }
        ruleServiceHelper.deleteOne((Object)positionRuleId);
    }

    public List<DynamicObject> selectPositionRuleByPositionId(Long positionId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_positionrule");
        QFilter qFilter = new QFilter("positionid", "=", (Object)positionId);
        Object[] dynamicObjects = serviceHelper.query(qFilter.toArray());
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(dynamicObjects.length);
        return Collections.addAll(list, dynamicObjects) ? list : Collections.emptyList();
    }

    public List<Long> rsmAssignPositionAuto(AppResumeBo bo) {
        ArrayList<Long> emailIds = new ArrayList<Long>(1);
        Long emailSource = bo.getDelivery().getLong("emailsource");
        emailIds.add(emailSource);
        List<Long> positionIds = PositionManageServiceHelper.getPositionBoByMailId(emailIds);
        DynamicObject[] rulePresetObjs = this.getRuleObjs(positionIds, "1");
        DynamicObject[] ruleUnPresetObjs = this.getRuleObjs(positionIds, "0");
        DynamicObject delivery = bo.getDelivery();
        List<Long> ids = this.rsmAssignRule(delivery, rulePresetObjs);
        if (!ids.isEmpty()) {
            return ids;
        }
        ids = this.rsmAssignRule(delivery, ruleUnPresetObjs);
        return ids;
    }

    public List<Long> rsmAssignRule(DynamicObject deliveryObj, DynamicObject[] ruleObjs) {
        ArrayList<Long> ids = new ArrayList<Long>(ruleObjs.length);
        String emailTitle = deliveryObj.getString("emailtitle");
        String attachName = deliveryObj.getString("attachname");
        String postPosition = deliveryObj.getString("postposition");
        Long tmpId = 0L;
        for (DynamicObject ruleObj : ruleObjs) {
            String distriMode = ruleObj.getString("distrimode");
            String keywordStr = ruleObj.getString("keyword");
            Long positionId = ruleObj.getLong("positionid");
            if (tmpId.longValue() == positionId.longValue()) continue;
            if ("A".equals(distriMode) && this.assignKeywords(postPosition, keywordStr).booleanValue()) {
                ids.add(positionId);
                return ids;
            }
            if ("B".equals(distriMode) && this.assignKeywords(emailTitle, keywordStr).booleanValue()) {
                tmpId = positionId;
                ids.add(positionId);
                continue;
            }
            if (!"C".equals(distriMode) || !this.assignKeywords(attachName, keywordStr).booleanValue()) continue;
            tmpId = positionId;
            ids.add(positionId);
        }
        return ids;
    }

    public DynamicObject[] getRuleObjs(List<Long> positionIds, String issyspreset) {
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter distriMode = new QFilter("issyspreset", "=", (Object)issyspreset);
        QFilter[] filters = new QFilter[]{enable, distriMode};
        return ruleServiceHelper.loadDynamicObjectArray(filters);
    }

    public DynamicObject[] getRsmObjsByPositionId(Long positionId) {
        ArrayList<Long> positionIds = new ArrayList<Long>(1);
        positionIds.add(positionId);
        Map<Long, List<Long>> emailMaps = PositionManageServiceHelper.getMailInfoIdByPositionBo(positionIds);
        if (emailMaps == null) {
            return null;
        }
        List<Long> emailIds = emailMaps.get(positionId);
        QFilter emailId = new QFilter("delivery.emailsource.id", "in", emailIds);
        QFilter assignStatus = new QFilter("delivery.assignstatus", "=", (Object)"0");
        QFilter[] filters = new QFilter[]{emailId, assignStatus};
        return rsmServiceHelper.loadDynamicObjectArray(filters);
    }

    public Boolean assignKeywords(String str, String keywordStr) {
        String[] keywords;
        if (StringUtils.isEmpty((CharSequence)keywordStr) || StringUtils.isEmpty((CharSequence)str)) {
            return Boolean.FALSE;
        }
        for (String keyword : keywords = keywordStr.split("\u3001")) {
            if (!StringUtils.isNotEmpty((CharSequence)keyword) || str.contains(keyword)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void sendMessage(String contentCn) {
        MessageInfo message = new MessageInfo();
        LocaleString title = new LocaleString();
        title.setLocaleValue_en("");
        title.setLocaleValue_zh_CN(ResManager.loadKDString((String)"\u7b80\u5386\u5206\u914d\u89c4\u5219\u6267\u884c\u7ed3\u679c", (String)"PositionRuleServiceHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        title.setLocaleValue_zh_TW("");
        LocaleString content = new LocaleString();
        content.setLocaleValue_en("");
        content.setLocaleValue_zh_CN(contentCn);
        content.setLocaleValue_zh_TW("");
        ArrayList<Long> receivers = new ArrayList<Long>();
        receivers.add(Long.parseLong(RequestContext.get().getUserId()));
        LocaleString tag = new LocaleString();
        tag.setLocaleValue(ResManager.loadKDString((String)"\u91cd\u8981", (String)"PositionRuleServiceHelper_1", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        message.setMessageTitle((ILocaleString)title);
        message.setMessageContent((ILocaleString)content);
        message.setMessageTag((ILocaleString)tag);
        message.setUserIds(receivers);
        message.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        message.setSenderName(ResManager.loadKDString((String)"\u4eba\u624d\u4f9b\u5e94\u4e91", (String)"PositionRuleServiceHelper_2", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        message.setType("notice");
        message.setEntityNumber("tsirm_positionrule");
        message.setNotifyType("sysnotice");
        message.setToAll(false);
        HashMap param = new HashMap(16);
        HashMap<String, Integer> systemNotice = new HashMap<String, Integer>(16);
        systemNotice.put("showType", 2);
        param.put("systemNotice", systemNotice);
        message.setParams(param);
        MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }
}

