/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.position.service.permission;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.business.domain.position.service.enums.PositionPermEnum;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;

public class PositionPermService {
    public List<PositionPermEnum> positionPermEnums;
    public QFilter qFilter;
    private static final HashMap<String, Consumer<Map<String, Object>>> PERMISSION_MAP = new HashMap(8);

    public QFilter getHavePermPositionQFilter() {
        long currUserId;
        boolean superUser;
        boolean isOnlyContainsDelivery;
        boolean bl = isOnlyContainsDelivery = this.positionPermEnums.contains((Object)PositionPermEnum.DELIVERY) && this.positionPermEnums.size() == 1;
        if (!isOnlyContainsDelivery && (superUser = PermissionServiceHelper.isSuperUser((long)(currUserId = RequestContext.get().getCurrUserId())))) {
            return null;
        }
        for (PositionPermEnum permEnum : this.positionPermEnums) {
            String permItem = permEnum.getPermItem();
            Optional.ofNullable(PERMISSION_MAP.get(permItem)).ifPresent(con -> con.accept(new HashMap(0)));
        }
        return this.qFilter;
    }

    public List<Long> listHavePermPosition(QFilter qFilter) {
        DynamicObject[] dynamicObjects = PositionDataHelper.queryPositionByQFilter(new QFilter[]{qFilter});
        List<Long> positionIdList = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        return positionIdList;
    }

    public AuthorizedOrgResult getPositionHasPermAdminOrgs() {
        return TSCBizDataPermService.getUserAdminOrgs((Long)RequestContext.get().getCurrUserId(), (String)"tsirm", (String)"tsirm_position", (String)"47150e89000000ac", (String)"adminorg", null);
    }

    public List<Long> getPositionHasPermOrgs() {
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)currUserId, (boolean)false);
        return userHasPermOrgs.getHasPermOrgs();
    }

    private void setAdminOrgFilter() {
        AuthorizedOrgResult authorizedOrgResult = TSCBizDataPermService.getUserAdminOrgs((Long)RequestContext.get().getCurrUserId(), (String)"tsirm", (String)"tsirm_position", (String)"47150e89000000ac", (String)"adminorg", null);
        if (authorizedOrgResult.isHasAllOrgPerm()) {
            return;
        }
        QFilter qFilter = new QFilter("adminorg", "in", (Object)authorizedOrgResult.getHasPermOrgs());
        if (this.qFilter == null) {
            this.qFilter = qFilter;
        } else {
            this.qFilter.and(qFilter);
        }
    }

    private void setOrgFilter() {
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)currUserId, (boolean)false);
        QFilter qFilter = new QFilter("createorg", "in", (Object)userHasPermOrgs.getHasPermOrgs());
        if (this.qFilter == null) {
            this.qFilter = qFilter;
        } else {
            this.qFilter.and(qFilter);
        }
    }

    private void setDeliveryQFilter() {
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("manageinfo.posprin.fbasedataid", "=", (Object)currUserId).and("positionstatus", "!=", (Object)"B");
        if (this.qFilter == null) {
            this.qFilter = qFilter;
        } else {
            this.qFilter.or(qFilter);
        }
    }

    private PositionPermService(List<PositionPermEnum> positionPermEnums) {
        PERMISSION_MAP.put(PositionPermEnum.ADMIN_ORG.getPermItem(), map -> this.setAdminOrgFilter());
        PERMISSION_MAP.put(PositionPermEnum.ORG.getPermItem(), map -> this.setOrgFilter());
        PERMISSION_MAP.put(PositionPermEnum.DELIVERY.getPermItem(), map -> this.setDeliveryQFilter());
        this.positionPermEnums = positionPermEnums;
    }

    private PositionPermService() {
        PERMISSION_MAP.put(PositionPermEnum.ADMIN_ORG.getPermItem(), map -> this.setAdminOrgFilter());
        PERMISSION_MAP.put(PositionPermEnum.ORG.getPermItem(), map -> this.setOrgFilter());
        PERMISSION_MAP.put(PositionPermEnum.DELIVERY.getPermItem(), map -> this.setDeliveryQFilter());
        this.positionPermEnums = ImmutableList.of((Object)((Object)PositionPermEnum.ADMIN_ORG), (Object)((Object)PositionPermEnum.ORG), (Object)((Object)PositionPermEnum.SEV_LEVEL), (Object)((Object)PositionPermEnum.DELIVERY));
    }

    public static PositionPermService getInstance(List<PositionPermEnum> positionPermEnums) {
        if (CollectionUtils.isEmpty(positionPermEnums)) {
            return new PositionPermService();
        }
        return new PositionPermService(positionPermEnums);
    }
}

