/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.resumefilter.service;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileService;
import kd.tsc.tsirm.business.domain.intv.service.calendar.SetAbleInterviewTimeFormHelper;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumerFilterBiz;
import kd.tsc.tsirm.business.domain.resumefilter.service.TSCNoRecommendInfoException;
import kd.tsc.tsirm.common.constants.resumefilter.ResumeFilterConstants;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMessageService;
import kd.tsc.tsrbd.common.constants.DateFormatConstants;
import kd.tsc.tsrbd.common.enums.CfmMsgChannel;
import kd.tsc.tsrbd.common.enums.InterviewTimeWayEnum;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ResumeFilterHelper {
    private static final Log logger = LogFactory.getLog(ResumeFilterHelper.class);
    public static final HRBaseServiceHelper RESUME_FILTER_TASK_HELPER = new HRBaseServiceHelper("tsirm_resumefilter");
    public static final HRBaseServiceHelper TSTPM_RSM_HELPER = new HRBaseServiceHelper("tsirm_rsm");
    public static final HRBaseServiceHelper RESUME_RECOMM_HELPER = new HRBaseServiceHelper("tsirm_filterrecommend");
    private static final HRBaseServiceHelper BOS_USER_HELPER = new HRBaseServiceHelper("bos_user");

    private ResumeFilterHelper() {
    }

    public static ResumeFilterHelper getInstance() {
        return Instance.instance;
    }

    public DynamicObject[] queryResumeFilterTasksByPks(Object[] resumeFilterTasksPks) {
        QFilter qFilter = new QFilter("id", "in", (Object)resumeFilterTasksPks);
        String selectProperties = "id,filterfeedbackstatus,billno,filterfeedbackconclusion,filteropinion,filterfeedbackcontime,resscr,recruitmentposition,appfile.id,filterrecommender,billstatus";
        return RESUME_FILTER_TASK_HELPER.query(selectProperties, qFilter.toArray());
    }

    public static DynamicObject queryOneResumeFilterTaskByPk(Object resumeFilterTasksPk) {
        String selectProperties = "id,appfile,recruitmentposition,candidate";
        QFilter qFilter = new QFilter("id", "=", resumeFilterTasksPk);
        return RESUME_FILTER_TASK_HELPER.queryOne(selectProperties, qFilter.toArray());
    }

    public DynamicObject[] queryBosUserByQFilter(List<Long> userIds) {
        QFilter qFilter = new QFilter("id", "in", userIds);
        return BOS_USER_HELPER.query("id,name,email,phone,useropenid", qFilter.toArray());
    }

    public static DynamicObject[] queryResumeFilterTasks(List<Long> resscrTaskIds, String ... selectProperties) {
        QFilter filter = new QFilter("id", "in", resscrTaskIds);
        ArrayList<String> selectPropertyList = new ArrayList<String>(10);
        if (selectProperties == null || selectProperties.length == 0) {
            selectPropertyList.add("id");
        }
        if (null != selectProperties && selectProperties.length > 0) {
            for (String selectProperty : selectProperties) {
                selectPropertyList.add(selectProperty);
            }
        }
        String selectProperty = Joiner.on((char)',').skipNulls().join(selectPropertyList);
        return RESUME_FILTER_TASK_HELPER.query(selectProperty, filter.toArray());
    }

    public Object[] updateResumeFilterTask(DynamicObject[] resumeFilterTasks) {
        return RESUME_FILTER_TASK_HELPER.update(resumeFilterTasks);
    }

    public QFilter getFilterDataQFilterForCurrentUser() {
        long userId = TSCRequestContext.getUserId();
        QFilter qFilter = new QFilter("filterhandlepeople", "=", (Object)userId);
        return qFilter;
    }

    public DynamicObject[] getResumeFilterTask(String startTime, String endtime) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("filterhandlepeople", "=", (Object)TSCRequestContext.getUserId()));
        qFilters.add(new QFilter("filterfeedbackstatus", "in", (Object)new String[]{"1", "2"}));
        if (startTime != null) {
            qFilters.add(new QFilter("createtime", ">=", (Object)LocalDate.parse(startTime, DateFormatConstants.NORM_DATE_FORM)));
        }
        if (endtime != null) {
            qFilters.add(new QFilter("createtime", "<=", (Object)LocalDate.parse(endtime, DateFormatConstants.NORM_DATE_FORM)));
        }
        return RESUME_FILTER_TASK_HELPER.query("appfile", qFilters.toArray(new QFilter[0]));
    }

    public boolean verifyIfAllAreadyFeedBack(Object[] pkValues) {
        boolean flag = false;
        DynamicObject[] resumeFilterTasks = this.queryResumeFilterTasksByPks(pkValues);
        for (int i = 0; i < resumeFilterTasks.length; ++i) {
            if (!HRStringUtils.equals((String)resumeFilterTasks[i].getString("filterfeedbackstatus"), (String)"3")) {
                flag = false;
                break;
            }
            flag = true;
        }
        return flag;
    }

    public Tuple<List<DynamicObject>, List<String>> getAlreadyFeedbackAndNotFeedBackList(Map<String, String> feedBackMap, DynamicObject[] resumeFilterTasks) {
        String filterFeedbackConclusion = feedBackMap.get("filterfeedbackconclusion");
        String filterOpinion = feedBackMap.get("filteropinion");
        String filterFeedbackStatus = feedBackMap.get("filterfeedbackstatus");
        ArrayList<String> alreadyFeedBackList = new ArrayList<String>(resumeFilterTasks.length);
        ArrayList<DynamicObject> notFeedBackTaskList = new ArrayList<DynamicObject>(resumeFilterTasks.length);
        for (int i = 0; i < resumeFilterTasks.length; ++i) {
            if ("3".equals(resumeFilterTasks[i].get("filterfeedbackstatus"))) {
                alreadyFeedBackList.add(ResManager.loadKDString((String)"{0} : \u53cd\u9988\u5931\u8d25\uff0c\u53ea\u6709\u201c\u672a\u53cd\u9988/\u8d85\u671f\u672a\u53cd\u9988\u201d\u7684\u6570\u636e\u624d\u80fd\u8fdb\u884c\u53cd\u9988\u3002", (String)"ResumeFilterHelper_4", (String)"tsc-tsrbs-formplugin", (Object[])new Object[]{resumeFilterTasks[i].getString("billno")}));
                continue;
            }
            resumeFilterTasks[i].set("filterfeedbackconclusion", (Object)filterFeedbackConclusion);
            resumeFilterTasks[i].set("filteropinion", (Object)filterOpinion);
            resumeFilterTasks[i].set("filterfeedbackstatus", (Object)filterFeedbackStatus);
            resumeFilterTasks[i].set("filterfeedbackcontime", (Object)DateUtils.nowDateTime());
            resumeFilterTasks[i].set("billstatus", (Object)"C");
            notFeedBackTaskList.add(resumeFilterTasks[i]);
        }
        return Tuple.create(notFeedBackTaskList, alreadyFeedBackList);
    }

    public DynamicObject saveResumeFilterRecommend(DynamicObject resumeRecommend) throws Exception {
        resumeRecommend.set("dtfilterrecommendtime", (Object)DateUtils.nowDateTime());
        resumeRecommend.set("filterrecommender", (Object)TSCRequestContext.getUserId());
        DynamicObject dynamicObject = (DynamicObject)RESUME_RECOMM_HELPER.saveOne(resumeRecommend);
        if (dynamicObject == null) {
            throw new Exception("save resscr table error");
        }
        return dynamicObject;
    }

    public DynamicObject[] saveResumeFilterTask(List<Long> presenteeIds, List<Long> appFileIds, List<Long> notRepeatRecommendList, DynamicObject filterRecommend) throws TSCNoRecommendInfoException {
        List<DynamicObject> resumeFilterTaskList = this.generateTaskList(presenteeIds, appFileIds, filterRecommend, notRepeatRecommendList);
        if (resumeFilterTaskList.size() == 0) {
            throw new TSCNoRecommendInfoException();
        }
        DynamicObject[] resumeFilterArr = resumeFilterTaskList.toArray(new DynamicObject[resumeFilterTaskList.size()]);
        String[] numberArray = this.setBillNoToResumeFilterTasks(resumeFilterArr);
        try {
            RESUME_FILTER_TASK_HELPER.save(resumeFilterArr);
        }
        catch (Exception e) {
            this.recycleCodeRuleNumber(resumeFilterArr, numberArray);
            throw e;
        }
        return resumeFilterArr;
    }

    private Set<String> generateNotrepeatRecommendSet(List<Long> notRepeatRecommendList) {
        DynamicObject[] resumeFilterTasks = ResumeFilterHelper.queryResumeFilterTasks(notRepeatRecommendList, "appfile.id", "filterhandlepeople.id");
        HashSet<String> notRepeatRecommendSet = new HashSet<String>();
        if (notRepeatRecommendList != null && notRepeatRecommendList.size() > 0) {
            for (DynamicObject resumeFilterTask : resumeFilterTasks) {
                notRepeatRecommendSet.add(resumeFilterTask.get("filterhandlepeople.id") + String.valueOf(resumeFilterTask.get("appfile.id")));
            }
        }
        return notRepeatRecommendSet;
    }

    public List<DynamicObject> generateTaskList(List<Long> presenteeIdList, List<Long> appFileIds, DynamicObject filterRecommend, List<Long> notRepeatRecommendList) {
        ArrayList<DynamicObject> resumeFilterTaskList = new ArrayList<DynamicObject>(presenteeIdList.size() * appFileIds.size());
        Set<String> notRepeatRecommendSet = this.generateNotrepeatRecommendSet(notRepeatRecommendList);
        DynamicObject[] appFileArray = AppFileHelper.queryAppFiles(appFileIds, "appres,position,recrustg");
        for (Long presenteeId : presenteeIdList) {
            for (int j = 0; j < appFileArray.length; ++j) {
                if (notRepeatRecommendSet.contains(presenteeId + "" + appFileArray[j].getLong("id"))) continue;
                Long resscrId = filterRecommend.getLong("id");
                DynamicObject resumeFilterTask = this.generateResumeFilterTask(resscrId, presenteeId, appFileArray[j]);
                resumeFilterTaskList.add(resumeFilterTask);
            }
        }
        return resumeFilterTaskList;
    }

    private DynamicObject generateResumeFilterTask(Long resscrId, Long presenteeId, DynamicObject appFile) {
        Date nowDate = DateUtils.nowDateTime();
        DynamicObject resumeFilterList = RESUME_FILTER_TASK_HELPER.generateEmptyDynamicObject();
        resumeFilterList.set("appfile", (Object)appFile.getLong("id"));
        resumeFilterList.set("filterhandlepeople", (Object)presenteeId);
        resumeFilterList.set("candidate", (Object)appFile.getDynamicObject("appres").getLong("id"));
        resumeFilterList.set("recruitmentposition", (Object)appFile.getDynamicObject("position"));
        resumeFilterList.set("recruitmentstage", (Object)appFile.getDynamicObject("recrustg"));
        resumeFilterList.set("filterdeadline", (Object)DateUtils.afterNowDateTime((int)ResumeFilterConstants.DEADLINE_CALCURULE));
        resumeFilterList.set("filterfeedbackstatus", (Object)"1");
        resumeFilterList.set("filterrecommender", (Object)TSCRequestContext.getUserId());
        resumeFilterList.set("resscr", (Object)resscrId);
        resumeFilterList.set("createtime", (Object)nowDate);
        resumeFilterList.set("creator", (Object)TSCRequestContext.getUserId());
        resumeFilterList.set("modifier", (Object)TSCRequestContext.getUserId());
        resumeFilterList.set("modifytime", (Object)nowDate);
        return resumeFilterList;
    }

    public String[] setBillNoToResumeFilterTasks(DynamicObject[] dynamicObjects) throws KDBizException {
        String[] numberArr = CodeRuleServiceHelper.getBatchNumber((String)"tsirm_resumefilter", (DynamicObject)RESUME_FILTER_TASK_HELPER.generateEmptyDynamicObject(), null, (int)dynamicObjects.length);
        if (numberArr.length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7f16\u7801\u89c4\u5219\u3002", (String)"ResumeFilterHelper_2", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        }
        for (int j = 0; j < dynamicObjects.length; ++j) {
            dynamicObjects[j].set("billno", (Object)numberArr[j]);
        }
        return numberArr;
    }

    public void recycleCodeRuleNumber(DynamicObject[] dynamicObjects, String[] numberArray) {
        CodeRuleServiceHelper.recycleBatchNumber((String)"tsirm_resumefilter", (DynamicObject[])dynamicObjects, null, (String[])numberArray);
    }

    public void syncInfoToAppfile(List<Long> appFileIds) {
        String queryFields = "id,filestatus,modifier,modifytime,eliminatetime,isbinddelyrec,appres";
        DynamicObject[] appFiles = AppFileHelper.queryAppFiles(appFileIds, queryFields);
        AppFileHelper.bindAppFileResume(appFiles);
        AppFileDataHelper.updateAppFileLastFilterFKStartTime(appFileIds, DateUtils.nowDateTime());
        AppFileDataHelper.updateAppFileFilterFeedBackData(appFileIds);
    }

    public String getPresenteeWithoutEmail(DynamicObjectCollection presenteeList) {
        ArrayList<String> presenteeWithoutEmailList = new ArrayList<String>(presenteeList.size());
        for (DynamicObject presentee : presenteeList) {
            DynamicObject dynamicObject = (DynamicObject)presentee.get("fbasedataid");
            if (StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("email"))) continue;
            String name = dynamicObject.getString("name");
            presenteeWithoutEmailList.add(name);
        }
        String presenteeWithoutEmail = Joiner.on((char)' ').skipNulls().join(presenteeWithoutEmailList);
        return presenteeWithoutEmail;
    }

    public List<Long> generateRepeatRecommendList(List<Long> presenteeIdList, List<Long> appFileIds) {
        ArrayList<Long> repeatRecommendList = new ArrayList<Long>(presenteeIdList.size() * appFileIds.size());
        QFilter repeatRecommendQFilter = new QFilter("appfile", "in", appFileIds);
        repeatRecommendQFilter.and(new QFilter("filterhandlepeople", "in", presenteeIdList));
        String selectFields = "id,appfile,filterhandlepeople,recruitmentposition,filterfeedbackconclusion,createtime";
        DynamicObject[] dynamicObjects = RESUME_FILTER_TASK_HELPER.query(selectFields, repeatRecommendQFilter.toArray(), "createtime desc");
        Map<Object, List<DynamicObject>> resultMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getDynamicObject("appfile").getLong("id") + "" + dynamicObject.getDynamicObject("filterhandlepeople").getLong("id")));
        for (Map.Entry<Object, List<DynamicObject>> tempEntiy : resultMap.entrySet()) {
            List<DynamicObject> resumeFilterTaskList = tempEntiy.getValue();
            repeatRecommendList.add(resumeFilterTaskList.get(0).getLong("id"));
        }
        return repeatRecommendList;
    }

    public void sendTaskToPresentee(DynamicObject[] resumeFilterArr) {
        ResumerFilterBiz.init().sendTask(resumeFilterArr, "tsirm_resumefilterir", TSCRequestContext.getUserId());
    }

    public void sendTaskEmailToMsgTpl(DynamicObject filterRecommend, DynamicObject[] resumeFilterArr, String msgTplPageId) {
        long filterRecommendId = filterRecommend.getLong("id");
        List<Long> resumeFilterIdList = Arrays.stream(resumeFilterArr).map(rf -> rf.getLong("id")).collect(Collectors.toList());
        IFormView msgTplView = SessionManager.getCurrent().getView(msgTplPageId);
        if (HRObjectUtils.isEmpty((Object)msgTplView)) {
            return;
        }
        boolean sendEmail = CfgMessageService.isSendChannelMsg((IFormView)msgTplView, (CfmMsgChannel)CfmMsgChannel.EMAIL);
        boolean sendSms = CfgMessageService.isSendChannelMsg((IFormView)msgTplView, (CfmMsgChannel)CfmMsgChannel.SMS);
        boolean sendYunZhiJia = CfgMessageService.isSendChannelMsg((IFormView)msgTplView, (CfmMsgChannel)CfmMsgChannel.YUNZHIJIA);
        if (sendEmail || sendSms || sendYunZhiJia) {
            ResumerFilterBiz.init().sendTaskEmailToMsgTpl(filterRecommendId, resumeFilterIdList, msgTplPageId);
        }
    }

    public void lockRightResume(String feedbackResult, List<DynamicObject> resumefilterList) {
        try {
            if (!HRStringUtils.equals((String)feedbackResult, (String)"1")) {
                return;
            }
            List<DynamicObject> latestResumeTask = this.getLatestResumeTaskByAppfileId(resumefilterList);
            if (CollectionUtils.isEmpty(latestResumeTask)) {
                return;
            }
            HashMap lockerMapping = Maps.newHashMapWithExpectedSize((int)latestResumeTask.size());
            for (DynamicObject dynamicObject : latestResumeTask) {
                DynamicObject user = dynamicObject.getDynamicObject("filterrecommender");
                Long recommenderId = user.getLong("id");
                Long appfileId = dynamicObject.getDynamicObject("appfile").getLong("id");
                List appfileList = lockerMapping.getOrDefault(recommenderId, new ArrayList(resumefilterList.size()));
                appfileList.add(appfileId);
                lockerMapping.put(recommenderId, appfileList);
            }
            for (Map.Entry entry : lockerMapping.entrySet()) {
                AppFileService.getInstance().lockAppFiles((List)entry.getValue(), (Long)entry.getKey());
            }
        }
        catch (Exception e) {
            logger.error("\u63a8\u8350\u7b5b\u9009\u65f6\u7ed9\u5019\u9009\u4eba{}\u52a0\u9501\u5931\u8d25", resumefilterList, (Object)e);
        }
    }

    public DynamicObject getRsmById(Long rsmId) {
        return TSTPM_RSM_HELPER.queryOne((Object)rsmId);
    }

    public DynamicObject[] getRsmByIds(List<Long> rsmIdList) {
        QFilter qFilter = new QFilter("id", "in", rsmIdList);
        String selectProps = "id,fullname,gender,gender,highesteducation,highesteduschool,highestspecialty,workingyears,highestspecialty,highestspecialty,highestspecialty";
        return TSTPM_RSM_HELPER.query(selectProps, qFilter.toArray());
    }

    public Map<Long, DynamicObject> getCandidateMap(DynamicObject[] taskList) {
        List<Long> candidateIds = Arrays.stream(taskList).map(task -> task.getLong("candidate")).collect(Collectors.toList());
        candidateIds = candidateIds.stream().distinct().collect(Collectors.toList());
        DynamicObject[] candidates = this.getRsmByIds(candidateIds);
        HashMap candidateMap = Arrays.stream(candidates).collect(HashMap::new, (map, candidate) -> map.put(candidate.getLong("id"), candidate), HashMap::putAll);
        return candidateMap;
    }

    private List<DynamicObject> getLatestResumeTaskByAppfileId(List<DynamicObject> resumefilterList) {
        List ids = resumefilterList.stream().map(rf -> rf.getLong("id")).collect(Collectors.toList());
        HashSet appfileIds = Sets.newHashSetWithExpectedSize((int)resumefilterList.size());
        resumefilterList.forEach(rf -> appfileIds.add(rf.getDynamicObject("appfile").getLong("id")));
        QFilter appfileQfilter = new QFilter("appfile", "in", (Object)appfileIds);
        String selectProps = "id,appfile,createtime,filterrecommender";
        DynamicObject[] results = RESUME_FILTER_TASK_HELPER.query(selectProps, appfileQfilter.toArray());
        Map<Long, List<DynamicObject>> gourpByAppfile = Arrays.stream(results).collect(Collectors.groupingBy(rf -> rf.getDynamicObject("appfile").getLong("id")));
        Set<Map.Entry<Long, List<DynamicObject>>> entries = gourpByAppfile.entrySet();
        ArrayList latestSendData = Lists.newArrayListWithExpectedSize((int)entries.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : entries) {
            List<DynamicObject> values = entry.getValue();
            DynamicObject createTimeMaxObj = null;
            for (DynamicObject task : values) {
                if (null != createTimeMaxObj) {
                    Date preCreateTime;
                    Date createTime = task.getDate("createtime");
                    if (createTime.compareTo(preCreateTime = createTimeMaxObj.getDate("createtime")) <= 0 && (createTime.compareTo(preCreateTime) != 0 || !ids.contains(task.getLong("id")))) continue;
                    createTimeMaxObj = task;
                    continue;
                }
                createTimeMaxObj = task;
            }
            if (null == createTimeMaxObj || !ids.contains(createTimeMaxObj.getLong("id"))) continue;
            latestSendData.add(createTimeMaxObj);
        }
        return latestSendData;
    }

    public DynamicObject[] getWaitResumeFilterList() {
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("filterhandlepeople", "=", (Object)currUserId);
        qFilter.and(new QFilter("filterfeedbackstatus", "=", (Object)"2").or(new QFilter("filterfeedbackstatus", "=", (Object)"1")));
        return RESUME_FILTER_TASK_HELPER.query(qFilter.toArray());
    }

    public void showInterviewTimeForm(IFormView formView, String interviewTimeFormId, String noShowFormPopId, CloseCallBack closeCallBack) {
        boolean isShow = SetAbleInterviewTimeFormHelper.isShowInterviewTimePage(TSCRequestContext.getUserId());
        if (isShow) {
            SetAbleInterviewTimeFormHelper.openSetInterviewTimePage(formView, interviewTimeFormId, InterviewTimeWayEnum.ENTRANCE_SELECTED, closeCallBack);
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(noShowFormPopId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(closeCallBack);
            formView.showForm(showParameter);
        }
    }

    private static class Instance {
        private static ResumeFilterHelper instance = new ResumeFilterHelper();

        private Instance() {
        }
    }
}

