/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.resumefilter.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.util.DateUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileService;
import kd.tsc.tsirm.business.domain.operate.service.AppfileOpRecordService;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumeFilterHelper;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumerFilterBiz;
import kd.tsc.tsirm.business.domain.resumefilter.service.SelectedAppFileService;
import kd.tsc.tsirm.business.domain.resumefilter.service.TSCNoRecommendInfoException;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;
import kd.tsc.tsirm.common.constants.resumefilter.ResumeFilterConstants;
import kd.tsc.tsirm.common.util.CommonUtils;
import kd.tsc.tsirm.common.util.ContextUrlUtil;
import kd.tsc.tsrbd.common.constants.CfgMsgTemplateConstants;
import kd.tsc.tsrbd.common.enums.CfgMsgRecvType;
import kd.tsc.tsrbd.common.enums.CfgMsgScenes;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang3.tuple.Pair;

public final class ResumefilterBusinessHelper {
    private static final String MOUDLE = ResumefilterBusinessHelper.class.getName();
    private static final Log logger = LogFactory.getLog(ResumefilterBusinessHelper.class);
    private static ResumeFilterHelper resumeFilterHelper = ResumeFilterHelper.getInstance();

    private ResumefilterBusinessHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveModelAndClosePage(List<Long> notRepeatRecommendList, IFormView formView, List<Long> appFileIds) {
        Map returnMap;
        List<Long> presenteeIdList = ResumefilterBusinessHelper.getPresenteeIds(formView);
        boolean checkResult = ResumefilterBusinessHelper.checkFileStatusA(appFileIds);
        if (!checkResult) {
            String error = ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6d41\u7a0b\u4e2d\u7684\u5019\u9009\u4eba\u8fdb\u884c\u63a8\u8350\u7b5b\u9009", (String)(MOUDLE + "_4"), (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            formView.showTipNotification(error);
            return;
        }
        TXHandle txHandle = TX.requiresNew();
        DynamicObject filterRecommend = null;
        Object[] resumeFilterTasks = null;
        try {
            filterRecommend = resumeFilterHelper.saveResumeFilterRecommend(formView.getModel().getDataEntity());
            resumeFilterTasks = resumeFilterHelper.saveResumeFilterTask(presenteeIdList, appFileIds, notRepeatRecommendList, filterRecommend);
            ResumeFilterConstants.RECOM_SUCC.put("success", ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"ResumeFilterConstants_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
            returnMap = ResumeFilterConstants.RECOM_SUCC;
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
            cache.put("RESSCR_REFERENCES_ID:" + TSCRequestContext.getUserId(), (Object)(RequestContext.get().getOrgId() + ""), Integer.MAX_VALUE, TimeUnit.DAYS);
            HashSet<Long> appfileIdsSet = new HashSet<Long>(resumeFilterTasks.length);
            if (resumeFilterTasks != null) {
                for (Object resumeFilterTask : resumeFilterTasks) {
                    Long appFileId = Long.parseLong(resumeFilterTask.get("appfile").toString());
                    appfileIdsSet.add(appFileId);
                }
            }
            ArrayList<Long> appfileIdsList = new ArrayList<Long>(appfileIdsSet.size());
            appfileIdsList.addAll(appfileIdsSet);
            resumeFilterHelper.syncInfoToAppfile(appfileIdsList);
        }
        catch (TSCNoRecommendInfoException tscNoRecommendInfoException) {
            logger.error("FilterRecommendEdit.saveOperate fail\uff1a", (Throwable)tscNoRecommendInfoException);
            txHandle.markRollback();
            ResumeFilterConstants.RECOM_TIP.put("tip", ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u4f60\u5df2\u53d6\u6d88\u5c06\u6240\u6709\u5019\u9009\u4eba\u63a8\u8350\u7ed9\u9762\u8bd5\u5b98\u7b5b\u9009\u3002", (String)"ResumeFilterConstants_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
            returnMap = ResumeFilterConstants.RECOM_TIP;
        }
        catch (Exception e) {
            logger.error("FilterRecommendEdit.saveOperate fail\uff1a", (Throwable)e);
            txHandle.markRollback();
            ResumeFilterConstants.RECOM_FAIL.put("fail", ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"ResumeFilterConstants_2", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
            returnMap = ResumeFilterConstants.RECOM_FAIL;
        }
        finally {
            txHandle.close();
        }
        if (ArrayUtils.isNotEmpty((Object[])resumeFilterTasks)) {
            resumeFilterHelper.sendTaskToPresentee((DynamicObject[])resumeFilterTasks);
            String pageId = formView.getPageCache().get("cache_msg_tpl_page_id");
            resumeFilterHelper.sendTaskEmailToMsgTpl(filterRecommend, (DynamicObject[])resumeFilterTasks, pageId);
            AppfileOpRecordService.getInstance().addResumeFilter((DynamicObject[])resumeFilterTasks, presenteeIdList);
        }
        formView.returnDataToParent((Object)returnMap);
        formView.close();
    }

    public static void saveModelAndClosePage(List<Long> notRepeatRecommendList, IFormView formView) {
        List<Long> appFileIds = ResumefilterBusinessHelper.getAppFileIds(formView);
        if (!ResumefilterBusinessHelper.validateLicense(appFileIds, formView)) {
            return;
        }
        ResumefilterBusinessHelper.saveModelAndClosePage(notRepeatRecommendList, formView, appFileIds);
    }

    private static boolean validateLicense(List<Long> appFileIds, IFormView formView) {
        List<Long> pids = AppFileHelper.getAppFilePid(appFileIds);
        Map<String, Object> resultMap = TSIRMCertCommonHelper.verifyCertByPid("2+TXFE9NU13A", "tsirm_appfile_view", pids);
        if ("FAIL".equals(resultMap.get("STATE").toString())) {
            Map data = (Map)resultMap.get("DATA");
            String message = (String)data.get("infoType");
            if ("FORBIDDEN".equals(message)) {
                return true;
            }
            List nexistids = (List)resultMap.get("NEXISTID");
            List exceptids = (List)resultMap.get("EXCEPTID");
            ArrayList<Long> resultList = new ArrayList<Long>(16);
            if (nexistids != null && nexistids.size() != 0) {
                resultList.addAll(nexistids);
            }
            if (exceptids != null && exceptids.size() != 0) {
                resultList.addAll(exceptids);
            }
            Map<Long, DynamicObject> personByPids = TSIRMCertCommonHelper.getPersonByPids(resultList);
            StringBuilder sbd = new StringBuilder();
            for (Map.Entry<Long, DynamicObject> dynamicObjectEntry : personByPids.entrySet()) {
                DynamicObject person = dynamicObjectEntry.getValue();
                sbd.append(person.getString("name"));
                sbd.append("\u3001");
            }
            String nameTips = sbd.substring(0, sbd.length() - 1);
            formView.showErrorNotification(ResManager.loadKDString((String)"{0}\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"ResumeFilterBusinessHelper_1", (String)"tsc-tsirm-business", (Object[])new Object[]{nameTips}));
            return false;
        }
        return true;
    }

    public static List<Long> getAppFileIds(IFormView formView) {
        List<Long> appFileIds = Collections.emptyList();
        String selectedAppFilePageId = formView.getPageCache().get("tsirm_selectedappfile");
        if (HRStringUtils.isNotEmpty((String)selectedAppFilePageId)) {
            IFormView selectedAppFileView = formView.getView(selectedAppFilePageId);
            appFileIds = SelectedAppFileService.getInstance().getSelectedAppFileIds(selectedAppFileView);
        } else {
            FormShowParameter formShowParameter = formView.getFormShowParameter();
            String appFileIdsStr = (String)formShowParameter.getCustomParam("appfileids");
            if (HRStringUtils.isNotEmpty((String)appFileIdsStr)) {
                appFileIds = SerializationUtils.fromJsonStringToList((String)appFileIdsStr, Long.class);
            }
        }
        return appFileIds;
    }

    public static List<Long> getPresenteeIds(IFormView formView) {
        DynamicObjectCollection presenteeList = (DynamicObjectCollection)formView.getModel().getValue("presentee");
        if (presenteeList == null || presenteeList.isEmpty()) {
            return Collections.emptyList();
        }
        if (presenteeList.size() > 10) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u9009\u62e910\u4e2a\u8981\u63a8\u8350\u7ed9\u7684\u4eba", (String)(MOUDLE + "_3"), (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return null;
        }
        ArrayList<Long> presenteeIds = new ArrayList<Long>(presenteeList.size());
        for (DynamicObject presentee : presenteeList) {
            presenteeIds.add(presentee.getLong("fbasedataid_id"));
        }
        return presenteeIds;
    }

    public static FormShowParameter getSelectedAppFileShowParameter(List<Long> appFileIds) {
        FormShowParameter selectedAppfileParam = new FormShowParameter();
        selectedAppfileParam.setFormId("tsirm_selectedappfile");
        selectedAppfileParam.setShowTitle(false);
        selectedAppfileParam.getOpenStyle().setShowType(ShowType.InContainer);
        selectedAppfileParam.getOpenStyle().setTargetKey("flex_selectedappfile");
        selectedAppfileParam.setCustomParam("appFileIds", (Object)SerializationUtils.toJsonString(appFileIds));
        return selectedAppfileParam;
    }

    public static FormShowParameter getResumeFilterMsgTpl(List<Long> appFileIds) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("msg_tpl_flexpanelap");
        formShowParameter.setFormId(CfgMsgTemplateConstants.MSG_TEMPLATE_INTEGRATE);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("msgSceneType", CfgMsgScenes.RECOMMEND_FILTER.getBaseDataId());
        map.put("msgReceiverType", CfgMsgRecvType.RECOMMEND_FILTER_PROCESSOR.getBaseDataId());
        String processor = ResManager.loadKDString((String)"{\u7b5b\u9009\u5904\u7406\u4eba\u59d3\u540d}", (String)(MOUDLE + "_2"), (String)"tsc-tsirm-business", (Object[])new Object[0]);
        String mark = ResManager.loadKDString((String)"{\u63a8\u8350\u7559\u8a00}", (String)(MOUDLE + "_5"), (String)"tsc-tsirm-business", (Object[])new Object[0]);
        map.put("filterprocessor", processor);
        map.put("filtermark", mark);
        map.put("filterinitiator", RequestContext.get().getUserName());
        DynamicObject[] appFileInfos = AppFileDataHelper.queryAppFileNameAndPhoto(appFileIds);
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(appFileInfos.length);
        for (DynamicObject appFileInfo : appFileInfos) {
            DynamicObject candidate = appFileInfo.getDynamicObject("appres");
            Map<String, Object> tableDataMap = ResumerFilterBiz.init().setCandidateMap(candidate, appFileInfo.getDynamicObject("position"), null);
            dataList.add(tableDataMap);
        }
        String tableDataStr = JSON.toJSONString(dataList);
        map.put("filterrsmlist", tableDataStr);
        map.put("filterrsmcount", dataList.size());
        map.put("initiategroup", CommonUtils.getUserMainOrgName((Long)TSCRequestContext.getUserId()));
        map.put("filterlistref", ContextUrlUtil.getContextUrl() + "/index.html?billFormId=tsirm_resumefilterir&type=list&source=email");
        map.put("filterlistrefname", ResManager.loadKDString((String)"\u7acb\u5373\u767b\u5f55", (String)"ResumeFilterBusinessHelper_2", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        map.put("initiatetime", DateUtils.getDate((String)"yyyy-MM-dd"));
        map.put("businessId", String.valueOf(appFileIds.get(0)));
        map.put("fromType", "3");
        formShowParameter.setCustomParams(map);
        return formShowParameter;
    }

    public static boolean checkFileStatusA(List<Long> appFileIds) {
        for (Long appFileId : appFileIds) {
            DynamicObject appFile = AppFileDataHelper.queryAppFileById(appFileId);
            String fileStatus = appFile.getString("filestatus");
            if (AppFileConstants.APP_FILE_STATUS_IN.equals(fileStatus)) continue;
            return false;
        }
        return true;
    }

    public static Pair<List<Long>, List<Long>> checkFileGetEffectiveList(List<Long> appFileIds) {
        DynamicObject[] appFiles;
        ArrayList success = Lists.newArrayListWithCapacity((int)10);
        ArrayList fail = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject appFile : appFiles = AppFileHelper.getAppFileByIds(appFileIds)) {
            String fileStatus = appFile.getString("filestatus");
            if (!AppFileConstants.APP_FILE_STATUS_INVALID.equals(fileStatus)) {
                success.add(appFile.getLong("id"));
                continue;
            }
            fail.add(appFile.getLong("id"));
        }
        return Pair.of((Object)success, (Object)fail);
    }

    public static Pair<Boolean, Object> checkAppfileLocked(List<Long> appFileIds) {
        String opName = ResManager.loadKDString((String)"\u63a8\u8350\u7b5b\u9009", (String)(MOUDLE + "_1"), (String)"tsc-tsirm-business", (Object[])new Object[0]);
        ValidateResult validateResult = AppFileService.getInstance().validateAppFileInProcessAndLocked(appFileIds, opName);
        List successPkIds = validateResult.getSuccessPkIds();
        List allErrorInfo = validateResult.getAllErrorInfo();
        if (appFileIds.size() == 1) {
            boolean result = successPkIds.size() != 0;
            return Pair.of((Object)result, result ? null : ((OperateErrorInfo)allErrorInfo.get(0)).getMessage());
        }
        if (allErrorInfo.size() > 0) {
            ArrayList<String> failFeedBackList = new ArrayList<String>(allErrorInfo.size());
            for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                long id = Long.parseLong(operateErrorInfo.getPkValue().toString());
                DynamicObject appFile = AppFileHelper.queryOne(id, "number");
                String message = appFile.getString("number") + " \uff1a " + operateErrorInfo.getMessage();
                failFeedBackList.add(message);
            }
            String titleMsg = String.format(ResManager.loadKDString((String)"\u5171%s\u6761\u6570\u636e\uff0c\u53ef\u4ee5\u7ee7\u7eed\u8fdb\u884c%s\u6761\uff0c\u5931\u8d25\u7684%s\u6761", (String)"ResumeFilterBusinessHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]), appFileIds.size(), successPkIds.size(), allErrorInfo.size());
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("tsirm_fr_operationresult");
            formShowParameter.setShowTitle(false);
            formShowParameter.setCustomParam("title", (Object)titleMsg);
            formShowParameter.setCustomParam("errorMsg", failFeedBackList);
            formShowParameter.setCustomParam("successPkIds", (Object)successPkIds);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            return Pair.of((Object)Boolean.FALSE, (Object)formShowParameter);
        }
        return Pair.of((Object)Boolean.TRUE, null);
    }
}

