/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.resumefilter.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.dynprocess.freeflow.WFAuditTask;
import kd.bos.workflow.engine.dynprocess.freeflow.WFDecisionOption;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowNode;
import kd.bos.workflow.engine.dynprocess.freeflow.WFParticipantEntity;
import kd.bos.workflow.engine.dynprocess.freeflow.WFProcess;
import kd.bos.workflow.engine.dynprocess.freeflow.WFUserTask;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumeFilterHelper;
import kd.tsc.tsirm.common.entity.MultiLangEnumBridge;
import kd.tsc.tsirm.common.entity.resumefilter.ResFilterEmailDto;
import kd.tsc.tsirm.common.enums.resumefilter.EmailTemplateTag;
import kd.tsc.tsirm.common.enums.resumefilter.HtmlTag;
import kd.tsc.tsirm.common.util.CommonUtils;
import kd.tsc.tsirm.common.util.ContextUrlUtil;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMessageService;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.domain.config.service.ConfigSysCfgParamHelper;
import kd.tsc.tsrbd.business.domain.message.MessageCustomCommonService;
import kd.tsc.tsrbd.common.enums.CfgMsgRecvType;
import kd.tsc.tsrbd.common.enums.CfgMsgScenes;
import kd.tsc.tsrbd.common.enums.CfmMsgChannel;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFAuditInfo;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFProcessInfo;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFUserInfo;
import kd.tsc.tsrbs.business.domain.workflow.service.FreeFlowImpl;
import kd.tsc.tsrbs.business.domain.workflow.service.FreeFlowInterface;
import kd.tsc.tsrbs.common.utils.DynamicUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class ResumerFilterBiz {
    private static final int INT = 4;
    private static final int INDEX = 2;
    private static final Log log = LogFactory.getLog(ResumerFilterBiz.class);
    private static final ResumerFilterBiz RESUMER_FILTER_BIZ = new ResumerFilterBiz();
    private int maxThreads = 2 * Runtime.getRuntime().availableProcessors() + 1;
    private ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)(this.getClass().getName() + "_threadPool"), (int)this.maxThreads);
    public static final String CONSENT = "Consent";
    private static FreeFlowInterface freeFlow = FreeFlowImpl.freeFlowImpl;
    public static final String WF_HITASKINST = "wf_hitaskinst";
    public static final String FILTERHANDLEPEOPLE_ID = "filterhandlepeople_id";
    private static final String PROPERTIES = "properties";
    private static final String PROCESSINGMOBILEPAGE = "processingmobilepage";
    private static final String REQUEST_URL = ContextUrlUtil.getContextUrl() + "/index.html?formId=" + "tsirm_resumefilterir" + "&pkId=";
    private static String EMAIL_HTML;

    public ResumerFilterBiz() {
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append(HtmlTag.HTML_HEAD_START.getHtml());
        sbuilder.append(HtmlTag.HTML_BODY.getHtml());
        sbuilder.append(HtmlTag.HTML_BODY_TABLE.getHtml());
        sbuilder.append(HtmlTag.HTML_HEAD_END.getHtml());
        EMAIL_HTML = sbuilder.toString();
    }

    public static ResumerFilterBiz init() {
        return RESUMER_FILTER_BIZ;
    }

    public boolean sendTask(DynamicObject[] dynamicObjects, String entityName, long dealPersonId) {
        if (HRStringUtils.isBlank((CharSequence)entityName)) {
            return false;
        }
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return false;
        }
        try {
            this.threadPool.execute(() -> Arrays.stream(dynamicObjects).forEach(dynamicObject -> this.sendItemTask((DynamicObject)dynamicObject, entityName, dynamicObject.getString(FILTERHANDLEPEOPLE_ID))));
        }
        catch (RuntimeException e) {
            log.error(MessageFormat.format("ResumeFilterBiz sendTask method error: {0}", e));
            return false;
        }
        return true;
    }

    public void asyncSendEmail(ResFilterEmailDto resFilterEmailDto) {
        if (HRStringUtils.isBlank((CharSequence)resFilterEmailDto.getSendUserName()) || null == resFilterEmailDto.getSendUserId() || null == resFilterEmailDto.getResscrId() || null == resFilterEmailDto.getReceiverUserMap()) {
            return;
        }
        Map receiverUserMap = resFilterEmailDto.getReceiverUserMap();
        if (receiverUserMap.isEmpty()) {
            return;
        }
        ThreadPools.executeOnce((String)"asyncSendEmail", () -> this.syncSendEmail(resFilterEmailDto));
    }

    public void syncSendEmail(ResFilterEmailDto resFilterEmailDto) {
        if (HRStringUtils.isBlank((CharSequence)resFilterEmailDto.getSendUserName()) || null == resFilterEmailDto.getSendUserId() || null == resFilterEmailDto.getResscrId() || null == resFilterEmailDto.getReceiverUserMap()) {
            return;
        }
        Map receiverUserMap = resFilterEmailDto.getReceiverUserMap();
        if (receiverUserMap.isEmpty()) {
            return;
        }
        receiverUserMap.keySet().forEach(handlerId -> this.sendEmailItem(resFilterEmailDto, receiverUserMap, (Long)handlerId));
    }

    private void sendEmailItem(ResFilterEmailDto resFilterEmailDto, Map<Long, List<DynamicObject>> receiverUserMap, Long handlerId) {
        List<DynamicObject> dynamicObjects = receiverUserMap.get(handlerId);
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            return;
        }
        try {
            List<Long> resTaskIdList = receiverUserMap.get(handlerId).stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            String emailContent = this.getEmailContent(handlerId, resTaskIdList, resFilterEmailDto);
            if (HRStringUtils.isBlank((CharSequence)emailContent)) {
                return;
            }
            MessageInfo message = this.getMessageInfo(resFilterEmailDto.getSendUserName(), handlerId, emailContent);
            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
        }
        catch (RuntimeException e) {
            log.error(MessageFormat.format("ResumerFilterBiz sendEmailItem() method error ({0},{1})", handlerId, e));
        }
    }

    public MessageInfo getMessageInfo(String sendUserName, Long receiverUserId, String emailContent) {
        Map userInfoMap = UserServiceHelper.getUserInfoByID((long)receiverUserId);
        if (userInfoMap == null || userInfoMap.isEmpty()) {
            return null;
        }
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        params.put(MessageChannels.EMAIL.getNumber(), Collections.singletonList(userInfoMap.get(MessageChannels.EMAIL.getNumber())));
        MessageInfo message = new MessageInfo();
        message.setNotifyType(MessageChannels.EMAIL.getNumber());
        message.setParams((Map)params);
        String title = ResManager.loadKDString((String)"\u7b80\u5386\u7b5b\u9009\u901a\u77e5-\u6765\u81ea{0}", (String)"ResumerFilterBiz_1", (String)"tsc-tsirm-business", (Object[])new Object[]{sendUserName});
        message.setMessageTitle((ILocaleString)new LocaleString(title));
        message.setMessageContent((ILocaleString)LocaleString.fromMap((Map)ImmutableMap.of((Object)Lang.zh_CN.toString(), (Object)emailContent)));
        return message;
    }

    public String getEmailContent(Long handlerId, List<Long> resTaskIdList, ResFilterEmailDto resFilterEmailDto) {
        Document document = Jsoup.parse((String)EMAIL_HTML);
        Map handlerInfoMap = Optional.ofNullable(UserServiceHelper.getUserInfoByID((long)handlerId)).orElseGet(Maps::newHashMap);
        HRBaseServiceHelper filterCommendHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_filterrecommend");
        DynamicObject filterCommendObject = filterCommendHelper.loadSingle((Object)resFilterEmailDto.getResscrId());
        HRBaseServiceHelper resTaskHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_resumefilter");
        DynamicObject[] resTaskList = resTaskHelper.loadDynamicObjectArray(resTaskIdList.toArray());
        String callTitle = EmailTemplateTag.CALL_TITLE.getDesc().loadKDString();
        document.getElementById(EmailTemplateTag.CALL_TITLE.getTag()).html(handlerInfoMap.get("name") + callTitle);
        document.getElementById(EmailTemplateTag.DESCRIBE.getTag()).html(resFilterEmailDto.getSendUserName() + MessageFormat.format(EmailTemplateTag.DESCRIBE.getDesc().loadKDString(), resTaskIdList.size()));
        document.getElementById(EmailTemplateTag.FILTER_REMARKS.getTag()).html(EmailTemplateTag.FILTER_REMARKS.getDesc().loadKDString() + filterCommendObject.getString("txtfilterremarks"));
        document.getElementById(EmailTemplateTag.USER_NAME.getTag()).html(EmailTemplateTag.USER_NAME.getDesc().loadKDString());
        document.getElementById(EmailTemplateTag.POSITION_NAME.getTag()).html(EmailTemplateTag.POSITION_NAME.getDesc().loadKDString());
        document.getElementById(EmailTemplateTag.SEX.getTag()).html(EmailTemplateTag.SEX.getDesc().loadKDString());
        document.getElementById(EmailTemplateTag.EDUCATION.getTag()).html(EmailTemplateTag.EDUCATION.getDesc().loadKDString());
        document.getElementById(EmailTemplateTag.UNIVERSITY.getTag()).html(EmailTemplateTag.UNIVERSITY.getDesc().loadKDString());
        document.getElementById(EmailTemplateTag.MAJOR.getTag()).html(EmailTemplateTag.MAJOR.getDesc().loadKDString());
        document.getElementById(EmailTemplateTag.WORK_YEARS.getTag()).html(EmailTemplateTag.WORK_YEARS.getDesc().loadKDString());
        document.getElementById(EmailTemplateTag.OPT.getTag()).html(EmailTemplateTag.OPT.getDesc().loadKDString());
        Arrays.stream(resTaskList).forEach(dynamicObject -> document.getElementById(EmailTemplateTag.USER_LIST.getTag()).appendElement(HtmlTag.TR.getHtml()).html(this.assemblyEmailContent((DynamicObject)dynamicObject)));
        document.getElementById(EmailTemplateTag.TIP_MESSAGE.getTag()).html(EmailTemplateTag.TIP_MESSAGE.getDesc().loadKDString());
        document.getElementById(EmailTemplateTag.SIGN.getTag()).html(EmailTemplateTag.SIGN.getDesc().loadKDString());
        document.getElementById(EmailTemplateTag.SIGN.getTag()).attr("href", ContextUrlUtil.getContextUrl() + "/index.html?billFormId=tsirm_resumefilterir&type=list&source=email");
        document.getElementById(EmailTemplateTag.DEPARTMENT.getTag()).html(resFilterEmailDto.getDepartment());
        document.getElementById(EmailTemplateTag.SEND_DATE.getTag()).html(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        return document.toString();
    }

    public String assemblyEmailContent(DynamicObject dynamicObject) {
        StringBuilder sbuilder = new StringBuilder(5200);
        DynamicObject candidate = ResumeFilterHelper.getInstance().getRsmById(dynamicObject.getLong("candidate"));
        Object userName = DynamicUtils.getValue((DynamicObject)candidate, (String)"fullname", (Object)"");
        sbuilder.append(HtmlTag.getHtml((HtmlTag)HtmlTag.TD_A, (Object[])new Object[]{REQUEST_URL + dynamicObject.getString("id"), userName != null && userName.toString().length() > 4 ? userName.toString().substring(0, 4) + "..." : userName}));
        sbuilder.append(HtmlTag.getHtml((HtmlTag)HtmlTag.TD, (Object[])new Object[]{DynamicUtils.getValue((DynamicObject)dynamicObject.getDynamicObject("recruitmentposition"), (String)"name", (Object)"")}));
        SexType sexType = SexType.getSexType((String)DynamicUtils.getValue((DynamicObject)candidate, (String)"gender", (Object)""));
        String sex = sexType == null ? "" : ResManager.loadKDString((String)sexType.sexName.loadKDString(), (String)sexType.tag, (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
        sbuilder.append(HtmlTag.getHtml((HtmlTag)HtmlTag.TD, (Object[])new Object[]{sex}));
        sbuilder.append(HtmlTag.getHtml((HtmlTag)HtmlTag.TD, (Object[])new Object[]{this.getDynamicProperties(candidate, new String[]{"highesteducation", "name"}, 2, new DynamicObject(), "")}));
        sbuilder.append(HtmlTag.getHtml((HtmlTag)HtmlTag.TD, (Object[])new Object[]{this.getDynamicProperties(candidate, new String[]{"highesteduschool", "name"}, 2, new DynamicObject(), "")}));
        sbuilder.append(HtmlTag.getHtml((HtmlTag)HtmlTag.TD, (Object[])new Object[]{DynamicUtils.getValue((DynamicObject)candidate, (String)"highestspecialty", (Object)"")}));
        Integer workingMonth = (Integer)DynamicUtils.getValue((DynamicObject)candidate, (String)"workingyears", (Object)0);
        String workYearShow = ResumeAnalysisHelper.getWorkYearShow((int)workingMonth);
        sbuilder.append(HtmlTag.getHtml((HtmlTag)HtmlTag.TD, (Object[])new Object[]{workYearShow}));
        sbuilder.append(HtmlTag.getHtml((HtmlTag)HtmlTag.TD_A, (Object[])new Object[]{REQUEST_URL + dynamicObject.getString("id"), EmailTemplateTag.RESSCR_OPT_ITEM.getDesc().loadKDString()}));
        return sbuilder.toString();
    }

    public <T> Object getDynamicProperties(DynamicObject dynamicObject, String[] properties, int index, T ... types) {
        if (dynamicObject == null) {
            return "";
        }
        int size = properties.length;
        if (index < 0 || index > size) {
            return null;
        }
        Object obj = dynamicObject;
        for (int inx = 0; index != inx && obj != null; ++inx) {
            obj = DynamicUtils.getValue((DynamicObject)obj, (String)properties[inx], types[inx]);
        }
        return obj == null ? "" : obj;
    }

    public void completeTask(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return;
        }
        try {
            ResumerFilterBiz.init().completeTask(dynamicObject.getString("id"), dynamicObject.getString("flowtasknum"), TSCRequestContext.getUserId(), null, false);
        }
        catch (RuntimeException e) {
            log.error("\u5b8c\u6210\u4efb\u52a1\u8282\u70b9\u5f02\u5e38: ", (Throwable)e);
        }
        String updateSql = "update t_tsirm_resscrtask set FFILTERFEEDBACKSTATUS = ?, FFILTERFEEDBACKCONCLUSION = ?, FFILTEROPINION = ?, FFILTERFEEDBACKCONTIME = ?, FMODIFYTIME = ? where FID = ? and (FFILTERFEEDBACKSTATUS = ? OR FFILTERFEEDBACKSTATUS = ?)";
        Date nowDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        HRDBUtil.update((DBRoute)new DBRoute("tsci"), (String)updateSql, (Object[])new Object[]{dynamicObject.getString("filterfeedbackstatus"), dynamicObject.getString("filterfeedbackconclusion"), dynamicObject.getString("filteropinion"), nowDate, nowDate, dynamicObject.getLong("id"), "2", "1"});
    }

    public void completeOneTask(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            log.error("param is empty ");
            return;
        }
        ResumerFilterBiz.init().completeTask(dynamicObject.getString("id"), dynamicObject.getString("flowtasknum"), TSCRequestContext.getUserId(), null, false);
    }

    public void completeBatchTask(List<DynamicObject> dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            log.error("param is empty");
            return;
        }
        QFilter qFilter = new QFilter("businesskey", "in", dynamicObjects.stream().map(dynamicObject -> dynamicObject.getString("id")).collect(Collectors.toList()));
        DynamicObject[] taskNodeList = ServiceHelperCache.getHrBaseServiceHelper((String)WF_HITASKINST).loadDynamicObjectArray(qFilter.toArray());
        if (taskNodeList == null) {
            log.error("taskNodeList is null");
            return;
        }
        HashMap dynamicObjectMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.size());
        dynamicObjects.forEach(dynamicObject -> dynamicObjectMap.put(dynamicObject.getLong("id"), dynamicObject));
        HashMap variables = Maps.newHashMapWithExpectedSize((int)dynamicObjects.size());
        HashMap<String, String> policyMap = new HashMap<String, String>(8);
        policyMap.put("auditNumber", CONSENT);
        policyMap.put("auditMessage", "");
        policyMap.put("auditType", "approve");
        Arrays.stream(taskNodeList).filter(dynamicObject -> dynamicObjectMap.containsKey(dynamicObject.getLong("businesskey"))).forEach(dynamicObject -> variables.put(dynamicObject.getLong("id"), policyMap));
        WorkflowServiceHelper.batchCompleteCompositeTasks((Map)variables);
    }

    public Long getNodeIdByBusinesskey(Long bussinesskey) {
        if (bussinesskey == null) {
            return null;
        }
        return ServiceHelperCache.getHrBaseServiceHelper((String)WF_HITASKINST).queryOne((Object)bussinesskey).getLong("businesskey");
    }

    public static Map<String, Object> getExtProp(String mobileFormId) {
        Map extpropMap = (Map)JSON.parseObject((String)"{\"properties\": {\"processingPage\" : \"tsirm_resumefilterir\"}}", Map.class);
        if (!StringUtils.isEmpty((String)mobileFormId)) {
            ((Map)extpropMap.get(PROPERTIES)).put(PROCESSINGMOBILEPAGE, mobileFormId);
        }
        return extpropMap;
    }

    public void sendItemTask(DynamicObject dynamicObject, String entityName, String dealPersonId) {
        String taskName = ResManager.loadKDString((String)"%s\u7684\u7b80\u5386\u7b5b\u9009", (String)"ResumerFilterBiz_0", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        Long candidateId = dynamicObject.getLong("candidate");
        DynamicObject candidate = ResumeFilterHelper.getInstance().getRsmById(candidateId);
        taskName = String.format(Locale.ROOT, taskName, candidate.getString("fullname"));
        WFProcessInfo wfProcessInfo = WFProcessInfo.init().setEntraBill(dynamicObject.getString("billno")).setEntraBillId(dynamicObject.getString("id")).setEntraBillName(taskName);
        WFProcess wfProcess = freeFlow.initProcess(wfProcessInfo);
        WFUserTask wfUserTask = freeFlow.initWFUserTask(wfProcess, WFUserInfo.init());
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("processingPage", "tsirm_resumefiltertips");
        wfUserTask.setExtProps(map);
        wfProcess.addNextNode((WFFlowNode)wfUserTask);
        ArrayList<WFParticipantEntity> participant = new ArrayList<WFParticipantEntity>();
        participant.add(this.setParticipant(dealPersonId));
        WFAuditInfo wfAuditInfo = WFAuditInfo.init().setParticipant(participant).setFormKey(entityName).setExtProps(ResumerFilterBiz.getExtProp(null)).setDecisionOptions(this.initWFDecisionOptions());
        String mobileFormId = (String)ConfigSysCfgParamHelper.getTSRBDSystemParameter((String)"jumpmobilepage");
        if (!HRStringUtils.isEmpty((String)mobileFormId)) {
            wfAuditInfo.setMobilFormKey(mobileFormId);
            wfAuditInfo.setExtProps(ResumerFilterBiz.getExtProp(mobileFormId));
        }
        WFAuditTask wfAuditTask = freeFlow.initWFAuditTask(wfProcess, wfAuditInfo);
        wfUserTask.addNextNode((WFFlowNode)wfAuditTask);
        freeFlow.startFreeFlow(entityName, wfProcess.getEntraBillId(), wfProcess, "submit", (Map)Maps.newHashMap());
        dynamicObject.set("flowtasknum", (Object)wfAuditTask.getId());
        ResumeFilterHelper.RESUME_FILTER_TASK_HELPER.updateOne(dynamicObject);
    }

    public List<WFDecisionOption> initWFDecisionOptions() {
        ArrayList<WFDecisionOption> decisionOptions = new ArrayList<WFDecisionOption>();
        WFDecisionOption agreeOption = new WFDecisionOption();
        agreeOption.setAuditType("approve");
        agreeOption.setDefaultDecision(true);
        agreeOption.setNumber(CONSENT);
        LocaleString localeString = new LocaleString();
        localeString.put(Lang.zh_CN.name(), (Object)ResManager.loadKDString((String)"\u540c\u610f", (String)"", (String)"", (Object[])new Object[0]));
        agreeOption.setName(localeString);
        decisionOptions.add(agreeOption);
        return decisionOptions;
    }

    public void completeTask(String businessKey, String nodeId, Long userId, String auditMessage, boolean checkUser) {
        freeFlow.completeTask(businessKey, nodeId, userId, CONSENT, StringUtils.isEmpty((String)auditMessage) ? ResManager.loadKDString((String)"\u540c\u610f", (String)"ResumerFilterBiz_2", (String)"tsc-tsirm-business", (Object[])new Object[0]) : auditMessage, checkUser);
    }

    public WFParticipantEntity setParticipant(String dealPersonId) {
        WFParticipantEntity paritcipant = new WFParticipantEntity();
        paritcipant.setType(ParticipantType.PERSON_TYPE.type);
        paritcipant.setValue(dealPersonId);
        return paritcipant;
    }

    public void sendTaskEmailToMsgTpl(Long filterRecommendId, List<Long> resumeFilterIdList, String msgTplPageId) {
        IFormView msgTplView = SessionManager.getCurrent().getView(msgTplPageId);
        if (HRObjectUtils.isEmpty((Object)filterRecommendId) || CollectionUtils.isEmpty(resumeFilterIdList) || HRObjectUtils.isEmpty((Object)msgTplView)) {
            log.warn("\u8c03\u7528\u6d88\u606f\u6a21\u677f\u53d1\u9001\u6d88\u606f\u65f6\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a:filterRecommendId={},resumeFilterIdList={},msgTplPageId={}", new Object[]{filterRecommendId, JSONArray.toJSONString(resumeFilterIdList), msgTplPageId});
            return;
        }
        try {
            FormShowParameter paramMap = msgTplView.getFormShowParameter();
            DynamicObject[] taskList = ResumeFilterHelper.queryResumeFilterTasks(resumeFilterIdList, "candidate", "recruitmentposition", "id", "filterhandlepeople");
            Map<Long, DynamicObject> handlerPeoples = this.getHandlePeopleMapping(taskList);
            DynamicObject filterRecommend = this.genTextData(filterRecommendId, paramMap);
            Map<Long, DynamicObject> candidateMap = ResumeFilterHelper.getInstance().getCandidateMap(taskList);
            for (Map.Entry<Long, DynamicObject> handlerPeople : handlerPeoples.entrySet()) {
                DynamicObject people = handlerPeople.getValue();
                boolean optFlag = this.genHandlerPeopleData(people, msgTplView, filterRecommend);
                if (!optFlag) continue;
                this.genResumeTableData(handlerPeople.getKey(), taskList, paramMap, candidateMap);
                msgTplView.cacheFormShowParameter();
                this.toExtCustomParam(msgTplView, filterRecommendId);
                msgTplView.invokeOperation("sendmessage");
            }
        }
        catch (RuntimeException e) {
            log.error("\u63a8\u8350\u7b5b\u9009\u7ed9\u88ab\u63a8\u8350\u4eba\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u63a8\u8350\u7b5b\u9009\u6570\u636e\uff1a{}", (Object)filterRecommendId, (Object)e);
        }
    }

    private void toExtCustomParam(IFormView msgView, Long filterRecommendId) {
        Map customParams = msgView.getFormShowParameter().getCustomParams();
        customParams.put("businessId", String.valueOf(filterRecommendId));
        MessageCustomCommonService.toExtCustomParamOnSendMessage((List)Lists.newArrayList((Object[])new Map[]{customParams}), (IFormView)msgView, (String)"2");
    }

    public void genResumeTableData(Long handlerPeopleId, DynamicObject[] taskList, FormShowParameter paramMap, Map<Long, DynamicObject> candidateMap) {
        ArrayList tableList = Lists.newArrayListWithExpectedSize((int)taskList.length);
        for (DynamicObject task : taskList) {
            DynamicObject handlePeople = task.getDynamicObject("filterhandlepeople");
            long taskHandlerId = handlePeople.getLong("id");
            if (taskHandlerId != handlerPeopleId) continue;
            DynamicObject candidate = candidateMap.get(task.getLong("candidate"));
            DynamicObject position = task.getDynamicObject("recruitmentposition");
            Map<String, Object> dataMap = this.setCandidateMap(candidate, position, task.getLong("id"));
            tableList.add(dataMap);
        }
        String tableDataStr = JSON.toJSONString((Object)tableList);
        paramMap.setCustomParam("filterrsmlist", (Object)tableDataStr);
        paramMap.setCustomParam("filterrsmcount", (Object)tableList.size());
    }

    public Map<Long, DynamicObject> getHandlePeopleMapping(DynamicObject[] resumeFilterList) {
        HashMap<Long, DynamicObject> optFilterEmails = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject task : resumeFilterList) {
            DynamicObject handlePeople = task.getDynamicObject("filterhandlepeople");
            Long handlePeopleId = handlePeople.getLong("id");
            optFilterEmails.putIfAbsent(handlePeopleId, handlePeople);
        }
        return optFilterEmails;
    }

    public Map<String, Object> setCandidateMap(DynamicObject candidate, DynamicObject position, Long taskId) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        if (null == candidate) {
            return dataMap;
        }
        Object userName = DynamicUtils.getValue((DynamicObject)candidate, (String)"fullname", (Object)"");
        userName = userName != null && userName.toString().length() > 4 ? userName.toString().substring(0, 4) + "..." : userName;
        dataMap.put("filter_name", userName);
        Object positionName = DynamicUtils.getValue((DynamicObject)position, (String)"name", (Object)"");
        dataMap.put("filter_position", positionName);
        dataMap.put("filter_sex", this.getDynamicProperties(candidate, new String[]{"gender", "name"}, 2, new DynamicObject(), ""));
        dataMap.put("filter_degree", this.getDynamicProperties(candidate, new String[]{"highesteducation", "name"}, 2, new DynamicObject(), ""));
        dataMap.put("filter_school", this.getDynamicProperties(candidate, new String[]{"highesteduschool", "name"}, 2, new DynamicObject(), ""));
        dataMap.put("filter_major", DynamicUtils.getValue((DynamicObject)candidate, (String)"highestspecialty", (Object)""));
        Integer workingMonth = (Integer)DynamicUtils.getValue((DynamicObject)candidate, (String)"workingyears", (Object)0);
        String workYearShow = ResumeAnalysisHelper.getWorkYearShow((int)workingMonth);
        dataMap.put("filter_workyear", workYearShow);
        String optName = EmailTemplateTag.RESSCR_OPT_ITEM.getDesc().loadKDString();
        dataMap.put("filter_operation", optName + "," + REQUEST_URL + taskId);
        dataMap.put("id", candidate.getLong("id"));
        return dataMap;
    }

    private DynamicObject genTextData(Long filterRecommendId, FormShowParameter paramMap) {
        HRBaseServiceHelper filterCommendHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_filterrecommend");
        DynamicObject filterCommendObject = filterCommendHelper.loadSingle((Object)filterRecommendId);
        Object creatorName = DynamicUtils.getValue((DynamicObject)filterCommendObject.getDynamicObject("filterrecommender"), (String)"name", (Object)"");
        creatorName = creatorName != null && creatorName.toString().length() > 4 ? creatorName.toString().substring(0, 4) + "..." : creatorName;
        paramMap.setCustomParam("filterinitiator", creatorName);
        paramMap.setCustomParam("filterlistref", (Object)(ContextUrlUtil.getContextUrl() + "/index.html?billFormId=tsirm_resumefilterir&type=list&source=email"));
        paramMap.setCustomParam("filterlistrefname", (Object)ResManager.loadKDString((String)"\u7acb\u5373\u767b\u5f55", (String)"ResumeFilterBiz_0", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        Date startDate = filterCommendObject.getDate("dtfilterrecommendtime");
        paramMap.setCustomParam("initiatetime", (Object)HRInteDateTimeUtil.formatDate((String)"tsirm_intvgroup", (String)"intvdate", (Date)startDate));
        DynamicObject recommender = filterCommendObject.getDynamicObject("filterrecommender");
        paramMap.setCustomParam("initiategroup", (Object)CommonUtils.getUserMainOrgName((Long)recommender.getLong("id")));
        paramMap.setCustomParam("msgSceneType", (Object)CfgMsgScenes.RECOMMEND_FILTER.getBaseDataId());
        paramMap.setCustomParam("msgReceiverType", (Object)CfgMsgRecvType.RECOMMEND_FILTER_PROCESSOR.getBaseDataId());
        return filterCommendObject;
    }

    public boolean genHandlerPeopleData(DynamicObject people, IFormView msgTplView, DynamicObject filterRecommend) {
        String yunZhiJia;
        String phone;
        FormShowParameter paramMap = msgTplView.getFormShowParameter();
        paramMap.setCustomParam("email", (Object)"");
        paramMap.setCustomParam("phone", (Object)"");
        paramMap.setCustomParam("yunzhijia", (Object)0L);
        boolean optFlag = false;
        this.genHandlerPeopleName(people, paramMap);
        String email = people.getString("email");
        if (HRStringUtils.isNotEmpty((String)email) && CfgMessageService.isSendChannelMsg((IFormView)msgTplView, (CfmMsgChannel)CfmMsgChannel.EMAIL)) {
            paramMap.setCustomParam("email", (Object)email);
            optFlag = true;
        }
        if (HRStringUtils.isNotEmpty((String)(phone = people.getString("phone"))) && CfgMessageService.isSendChannelMsg((IFormView)msgTplView, (CfmMsgChannel)CfmMsgChannel.SMS)) {
            paramMap.setCustomParam("phone", (Object)phone);
            optFlag = true;
        }
        if (HRStringUtils.isNotEmpty((String)(yunZhiJia = people.getString("id"))) && CfgMessageService.isSendChannelMsg((IFormView)msgTplView, (CfmMsgChannel)CfmMsgChannel.YUNZHIJIA)) {
            paramMap.setCustomParam("yunzhijia", (Object)yunZhiJia);
            optFlag = true;
        }
        paramMap.setCustomParam("filtermark", (Object)filterRecommend.getString("txtfilterremarks"));
        return optFlag;
    }

    public void genHandlerPeopleName(DynamicObject people, FormShowParameter paramMap) {
        paramMap.setCustomParam("filterprocessor", (Object)people.getString("name"));
    }

    protected static enum SexType {
        MAN("0", "sex_0", new MultiLangEnumBridge("\u7537", "ResumerFilterBiz_4", "tsc-tsirm-business")),
        WOMEN("1", "sex_1", new MultiLangEnumBridge("\u5973", "ResumerFilterBiz_5", "tsc-tsirm-business")),
        OTHER("2", "sex_2", new MultiLangEnumBridge("\u672a\u77e5", "ResumerFilterBiz_6", "tsc-tsirm-business"));

        private String code;
        private String tag;
        private MultiLangEnumBridge sexName;

        private SexType(String code, String tag, MultiLangEnumBridge name) {
            this.code = code;
            this.tag = tag;
            this.sexName = name;
        }

        public String getTag() {
            return this.tag;
        }

        public MultiLangEnumBridge getSexName() {
            return this.sexName;
        }

        public static SexType getSexType(String code) {
            if (StringUtils.isEmpty((String)code)) {
                return null;
            }
            for (SexType sexType : SexType.values()) {
                if (!sexType.code.equals(code)) continue;
                return sexType;
            }
            return null;
        }
    }

    private static enum ParticipantType {
        PERSON_TYPE("person", new MultiLangEnumBridge("\u4eba\u5458", "ResumerFilterBiz_3", "tsc-tsirm-business"));

        private String type;
        private MultiLangEnumBridge name;

        private ParticipantType(String type, MultiLangEnumBridge name) {
            this.type = type;
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public MultiLangEnumBridge getName() {
            return this.name;
        }
    }
}

