/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.resumefilter.service;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;

public class SelectedAppFileService {
    private SelectedAppFileService() {
    }

    public static SelectedAppFileService getInstance() {
        return Instance.SELECTEDAPPFILE_INSTANCE;
    }

    public String getSelectedAppFileIdListStr(IFormView formView) {
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        String AppFileIdListStr = formView.getPageCache().get("appFileIds");
        if (HRStringUtils.isEmpty((String)AppFileIdListStr)) {
            AppFileIdListStr = formShowParameter.getCustomParam("appFileIds").toString();
        }
        return AppFileIdListStr;
    }

    public List<Long> getSelectedAppFileIds(IFormView formView) {
        String appFileIdListStr = this.getSelectedAppFileIdListStr(formView);
        if (HRStringUtils.isEmpty((String)appFileIdListStr)) {
            return Collections.emptyList();
        }
        List appFileIds = SerializationUtils.fromJsonStringToList((String)appFileIdListStr, Long.class);
        return appFileIds;
    }

    public DynamicObject[] getAppFileInfos(IFormView formView) {
        List<Long> appFileIds = this.getSelectedAppFileIds(formView);
        DynamicObject[] appFileInfos = AppFileDataHelper.queryAppFileNameAndPhoto(appFileIds);
        return appFileInfos;
    }

    public void initAppFileInfo(IFormView formView) {
        CardEntry cardEntry;
        DynamicObject[] appFileInfos = this.getAppFileInfos(formView);
        if (appFileInfos == null || appFileInfos.length == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)formView.getModel();
        int showNumber = appFileInfos.length;
        if (showNumber == 1) {
            cardEntry = (CardEntry)formView.getControl("entryentity");
            cardEntry.setChildVisible(false, 0, new String[]{"deleteap"});
        } else {
            cardEntry = (CardEntry)formView.getControl("entryentity");
            cardEntry.setChildVisible(true, 0, new String[]{"deleteap"});
        }
        if (HRStringUtils.equals((String)"tsirm_selectedappfile", (String)formView.getEntityId())) {
            showNumber = 10;
        }
        model.beginInit();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("picturefield", new Object[0]);
        tableValueSetter.addField("name", new Object[0]);
        tableValueSetter.addField("id", new Object[0]);
        for (int i = 0; i < appFileInfos.length && i < showNumber; ++i) {
            DynamicObject appFileInfo = appFileInfos[i];
            tableValueSetter.addRow(new Object[]{appFileInfo.get("appres.photo"), appFileInfo.get("name"), appFileInfo.get("id")});
        }
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        model.endInit();
        formView.updateView("entryentity");
    }

    public void deleteAppFiles(IFormView formView) {
        EntryGrid entryGrid = (EntryGrid)formView.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] dataEntitys = entryData.getDataEntitys();
        Long removeAppFileId = dataEntitys[selectRows[0]].getLong("id");
        formView.getModel().deleteEntryRows("entryentity", selectRows);
        List<Long> appFileIds = this.getSelectedAppFileIds(formView);
        appFileIds.remove(removeAppFileId);
        this.updateAppFileInfo(formView, SerializationUtils.toJsonString(appFileIds));
        formView.invokeOperation("refresh");
    }

    public void updateAppFileInfo(IFormView formView, String appFileIdStr) {
        formView.getPageCache().put("appFileIds", appFileIdStr);
    }

    private static class Instance {
        private static SelectedAppFileService SELECTEDAPPFILE_INSTANCE = new SelectedAppFileService();

        private Instance() {
        }
    }
}

