/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.api.helper;

import com.google.common.base.Joiner;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsrbs.business.domain.base.BaseHelper;
import kd.tsc.tsrbs.common.exception.TSCBizException;
import org.apache.commons.lang3.tuple.Pair;

public class RsmExpApiHelper {
    private static final Log LOGGER = LogFactory.getLog(RsmExpApiHelper.class);
    public static final String PAGE_API_SERVICE = "open_apiservice_new";
    private static final String RESPONSE_ENTITY = "respentryentity";
    private static final String RESPONSE_NAME = "respparamname";
    private static final String KEY_RSM = "rsm";

    private RsmExpApiHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static Pair<DynamicObjectCollection, DynamicObject[]> saveAndModifyRsmExpSortHandle(List<Map<String, Object>> dataList, List<String> timeColumnList, String pageNumber) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(pageNumber);
        ArrayList<Long> expIdLists = new ArrayList<Long>(dataList.size());
        DynamicObjectCollection saveDynCollection = new DynamicObjectCollection();
        HashMap<Long, Map<String, Object>> updateMap = new HashMap<Long, Map<String, Object>>(dataList.size());
        for (Map<String, Object> params : dataList) {
            Long expID = (Long)params.get("id");
            if (expID != null && expID != 0L) {
                expIdLists.add(expID);
                updateMap.put(expID, params);
                continue;
            }
            DynamicObject dynamicObject = BaseHelper.createDynamicObject((String)pageNumber);
            RsmExpApiHelper.loopHandleMap(timeColumnList, params, dynamicObject);
            saveDynCollection.add((Object)dynamicObject);
        }
        DynamicObject[] updateExp = new DynamicObject[expIdLists.size()];
        if (!expIdLists.isEmpty()) {
            for (DynamicObject updateDynObj : updateExp = hrBaseServiceHelper.loadDynamicObjectArray(expIdLists.toArray())) {
                Map stringObjectMap = (Map)updateMap.get(updateDynObj.getLong("id"));
                RsmExpApiHelper.loopHandleMap(timeColumnList, stringObjectMap, updateDynObj);
            }
        }
        return Pair.of((Object)saveDynCollection, (Object)updateExp);
    }

    private static void loopHandleMap(List<String> timeColumnList, Map<String, Object> params, DynamicObject dy) {
        DataEntityPropertyCollection dpc = dy.getDataEntityType().getProperties();
        Set allFields = dpc.stream().map(IMetadata::getName).collect(Collectors.toSet());
        try {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                if (!allFields.contains(key)) continue;
                Object value = entry.getValue();
                if (timeColumnList != null && timeColumnList.contains(entry.getKey())) {
                    value = HRDateTimeUtils.parseDate((String)String.valueOf(value));
                }
                dy.set(key, value);
            }
        }
        catch (ParseException pe) {
            LOGGER.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff01", (Throwable)pe);
            throw new TSCBizException((Throwable)pe);
        }
    }

    public static String queryConfigSelectFields(String number) {
        HRBaseServiceHelper apiService = new HRBaseServiceHelper(PAGE_API_SERVICE);
        QFilter filter = new QFilter("number", "=", (Object)number);
        DynamicObject openApiDy = apiService.loadDynamicObject(filter);
        DynamicObjectCollection resCollection = openApiDy.getDynamicObjectCollection(RESPONSE_ENTITY);
        List nameList = resCollection.stream().map(dy -> dy.getString(RESPONSE_NAME)).collect(Collectors.toList());
        return Joiner.on((String)",").join(nameList);
    }

    public static List<QFilter> getRsmSubInfoQFilter(Map<String, Object> params) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        QFilter qFilter = new QFilter(KEY_RSM, "=", (Object)Long.parseLong(params.get("id").toString()));
        qFilters.add(qFilter);
        return qFilters;
    }

    public static List<String> timeColumnList() {
        return Arrays.asList("startdate", "endingdate");
    }
}

