/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.common;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.domain.perm.PermissionHelper;
import kd.tsc.tsrbd.business.domain.rsmmetadata.service.ResumeMetadataService;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;

public class RsmCommonService {
    public static final String KEY_CANDPIC = "candpic";
    public static final String KEY_REG = "reg";
    private static final RsmCommonService rsmCommonService = new RsmCommonService();

    private RsmCommonService() {
    }

    public static RsmCommonService getInstance() {
        return rsmCommonService;
    }

    public static void updateAppFileDeliveryByAppResume(DynamicObject appFile, AppResumeBo resumeBo) {
        DynamicObject delivery = RsmCommonService.getDelivery(resumeBo);
        appFile.set("deliveryrec", (Object)delivery);
        appFile.set("applytime", delivery.get("applytime"));
        appFile.set("resacqmthd", delivery.get("resacqmthd"));
        appFile.set("recruchnlnm", delivery.get("recruchnlnm"));
    }

    public static void updateAppFileByAppResume(DynamicObject appFile, AppResumeBo resumeBo) {
        DynamicObject rsm = resumeBo.getRsm();
        appFile.set("name", rsm.get("fullname"));
        appFile.set("phone", rsm.get("phone"));
        appFile.set("email", rsm.get("email"));
        appFile.set("jobstatus", rsm.get("jobstatus"));
        appFile.set("highesteduschool", rsm.get("highesteduschool"));
        appFile.set("highesteducation", rsm.get("highesteducation"));
        appFile.set("birthday", rsm.get("birthday"));
        appFile.set("highestspecialty", rsm.get("highestspecialty"));
    }

    public static DynamicObject getDelivery(AppResumeBo resumeBo) {
        DynamicObject delivery = resumeBo.getDelivery();
        if (delivery == null) {
            delivery = RsmCommonService.getDelivery(resumeBo.getRsm());
            resumeBo.setDelivery(delivery);
        }
        return delivery;
    }

    public static DynamicObject getDelivery(DynamicObject rsmDt) {
        long deliveryId = rsmDt.getLong("delivery.id");
        HRBaseServiceHelper deliveryHelper = new HRBaseServiceHelper("tsirm_srrdelivery");
        return deliveryHelper.queryOne((Object)deliveryId);
    }

    public static AppResumeBo getAppResumeBo(Long rsmId) {
        DynamicObject rsmDt = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_rsm").queryOne((Object)rsmId);
        if (rsmDt != null) {
            return new AppResumeBo(rsmDt, RsmCommonService.getDelivery(rsmDt));
        }
        return null;
    }

    public static void loadAllListData(AppResumeBo resumeBo) {
        for (String subpage : ResumeMetadataService.getAllEntry((String)"tsirm_srrsm", (String)"3")) {
            resumeBo.setEntry(subpage, RsmCommonService.getRsmList(resumeBo, subpage));
        }
    }

    public static DynamicObjectCollection getRsmList(AppResumeBo resumeBo, String pageNum) {
        DynamicObject rsm = resumeBo.getRsm();
        if (rsm == null || rsm.getLong("id") == 0L || !rsm.getDataEntityState().getFromDatabase()) {
            return new DynamicObjectCollection();
        }
        long rsmId = rsm.getLong("id");
        QFilter qFilter = new QFilter("rsm", "=", (Object)rsmId);
        DynamicObject[] eduExps = ServiceHelperCache.getHrBaseServiceHelper((String)pageNum).loadDynamicObjectArray(pageNum, qFilter.toArray());
        DynamicObjectCollection eduExpList = new DynamicObjectCollection();
        eduExpList.addAll(Arrays.asList(eduExps));
        return eduExpList;
    }

    public static String getOpenAppFileEntityId(Object appFileId) {
        boolean hasAppFileRight = PermissionHelper.hasOpPerm((String)"tssrm_appfile_viewm", (String)"47150e89000000ac", (Object)appFileId);
        String entityId = "tssrm_appfile_viewm";
        if (!hasAppFileRight) {
            hasAppFileRight = PermissionHelper.hasOpPerm((String)"tssrm_appfile_viewc", (String)"47150e89000000ac", (Object)appFileId);
            entityId = "tssrm_appfile_viewc";
        }
        if (!hasAppFileRight) {
            entityId = "";
        }
        return entityId;
    }
}

