/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tsirm.business.domain.rsm.sr.service.AddResumeService;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class RDeliveryHelper {
    private static final HRBaseServiceHelper DELIVERYDAO = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_srrdelivery");

    private RDeliveryHelper() {
    }

    public static DynamicObject getDeliveryById(long id) {
        return DELIVERYDAO.queryOne((Object)id);
    }

    public static void saveDelivery(DynamicObject deliveryDy) {
        if (null != deliveryDy) {
            DELIVERYDAO.saveOne(deliveryDy);
        }
    }

    public static DynamicObject getLastDeliveryByStdRsmId(long stdRsmId) {
        DynamicObject[] rsmDyArr = RsmHelper.findRsmByStdRsmIds(Lists.newArrayList((Object[])new Long[]{stdRsmId}));
        Long resacqmthdId = 1080L;
        Long recruchnlMediaId = 1010L;
        Long appmthdId = 1010L;
        Long recruchnlnmId = 0L;
        if (null != rsmDyArr && rsmDyArr.length > 0) {
            DynamicObject rsmDy = rsmDyArr[0];
            DynamicObject deliveryDy = rsmDy.getDynamicObject("delivery");
            long deliveryId = deliveryDy.getLong("id");
            DynamicObject lastDeliveryDy = RDeliveryHelper.getDeliveryById(deliveryId);
            recruchnlnmId = lastDeliveryDy.getLong("recruchnlnm.id");
        }
        DynamicObject deliveryDt = AddResumeService.generateDeliveryDt(recruchnlMediaId, appmthdId, resacqmthdId, recruchnlnmId);
        deliveryDt.set("assignstatus", (Object)"2");
        deliveryDt.set("isfiledisplay", (Object)Boolean.FALSE);
        deliveryDt.set("id", (Object)ID.genLongId());
        return deliveryDt;
    }

    public static DynamicObject getStdRsmDeliverDelivery() {
        Long resacqmthdId = 1080L;
        Long recruchnlMediaId = 1010L;
        Long appmthdId = 1010L;
        Long recruchnlnmId = 1180L;
        DynamicObject deliveryDt = AddResumeService.generateDeliveryDt(recruchnlMediaId, appmthdId, resacqmthdId, recruchnlnmId);
        deliveryDt.set("assignstatus", (Object)"2");
        deliveryDt.set("isfiledisplay", (Object)Boolean.TRUE);
        return deliveryDt;
    }

    public static DynamicObject[] getDeliveryListByAppFileId(Long appFileId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsirm_rsm");
        QFilter qFilter = new QFilter("appfile", "=", (Object)appFileId);
        DynamicObject[] resumeDatas = hrBaseServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        List<DynamicObject> resumeDataList = Arrays.asList(resumeDatas);
        ArrayList<Long> deliveryIdList = new ArrayList<Long>();
        for (DynamicObject dynamicObject : resumeDataList) {
            if (dynamicObject.getDynamicObject("delivery") == null) continue;
            deliveryIdList.add((Long)dynamicObject.getDynamicObject("delivery").get("id"));
        }
        QFilter eduqFilter = new QFilter("id", "in", deliveryIdList);
        String orderByTime = "applytime desc";
        String queryProp = "id,applytime,deliveryper,recruchnlmedia,appmthd,resacqmthd,recruchnlnm,isfiledisplay";
        return DELIVERYDAO.query(queryProp, eduqFilter.toArray(), orderByTime);
    }
}

