/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.rsm.common.RsmCommonService;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mhelper.RsmAppFileHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeExpSortHelper;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.domain.rsmmetadata.service.ResumeMetadataService;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import org.apache.commons.lang3.ObjectUtils;

public class ResumeBoHelper {
    private static final HRBaseServiceHelper RSM_HELPER = new HRBaseServiceHelper("tsirm_rsm");

    private ResumeBoHelper() {
    }

    public static AppResumeBo getAppResumeBo(Long rsmId) {
        return RsmCommonService.getAppResumeBo(rsmId);
    }

    public static void setDeliveryIsDisplayNew(long appFileId, AppResumeBo resumeBo) {
        DynamicObject[] deliveryDyArr;
        DynamicObject appFile = null;
        if (appFileId != 0L) {
            appFile = RsmAppFileHelper.queryOneById(appFileId, "id,name,number,deliveryrec,isbinddelyrec");
        }
        if (appFileId == 0L || HRObjectUtils.isEmpty((Object)appFile)) {
            ResumeBoHelper.setDeliveryDisplayFalse(resumeBo);
            resumeBo.getRsm().set("appfile", null);
            return;
        }
        resumeBo.getRsm().set("appfile", appFile.get("id"));
        DynamicObject delivery = resumeBo.getDelivery();
        if (delivery == null) {
            return;
        }
        QFilter appFileQFilter = new QFilter("appfile", "=", (Object)appFileId);
        DynamicObject[] rsmArr = ResumeUtilsHelper.getServiceHelper("tsirm_rsm").query("id,appfile,delivery", new QFilter[]{appFileQFilter});
        ArrayList deliveryIdList = Lists.newArrayListWithExpectedSize((int)rsmArr.length);
        for (DynamicObject dy : rsmArr) {
            DynamicObject deliveryDy = dy.getDynamicObject("delivery");
            if (deliveryDy == null) continue;
            deliveryIdList.add(deliveryDy.getLong("id"));
        }
        if (deliveryIdList == null || deliveryIdList.isEmpty()) {
            return;
        }
        HRBaseServiceHelper serviceHelper = ResumeUtilsHelper.getServiceHelper("tsirm_srrdelivery");
        QFilter idQFilter = new QFilter("id", "in", (Object)deliveryIdList);
        for (DynamicObject deliveryDy : deliveryDyArr = serviceHelper.query("id,isfiledisplay", new QFilter[]{idQFilter})) {
            deliveryDy.set("isfiledisplay", (Object)Boolean.FALSE);
        }
        serviceHelper.update(deliveryDyArr);
    }

    public static void setDeliveryDisplayFalse(AppResumeBo resumeBo) {
        DynamicObject deliveryDy = resumeBo.getDelivery();
        if (null != deliveryDy) {
            deliveryDy.set("isfiledisplay", (Object)Boolean.FALSE);
        }
    }

    public static void save(AppResumeBo resumeBo) {
        DynamicObject rsm = resumeBo.getRsm();
        DynamicObject delivery = resumeBo.getDelivery();
        try (TXHandle txHandle = TX.required();){
            if (delivery != null) {
                RSM_HELPER.saveOne(delivery);
            }
            ResumeBoHelper.beforeSaveOpRsm(resumeBo);
            ResumeBoHelper.saveOneRsm(rsm);
            ResumeBoHelper.handlerAppFile(resumeBo);
            ResumeBoHelper.handlerSubForm(resumeBo);
        }
    }

    public static void handlerSubForm(AppResumeBo resumeBo) {
        DynamicObject rsm = resumeBo.getRsm();
        if (null == rsm) {
            return;
        }
        String[] SUBPAGES = ResumeMetadataService.getAllEntry((String)"tsirm_srrsm", (String)"3").toArray(new String[0]);
        for (String pagekey : SUBPAGES) {
            ServiceHelperCache.getHrBaseServiceHelper((String)pagekey).deleteByFilter(new QFilter[]{new QFilter("rsm", "=", (Object)rsm.getLong("id"))});
        }
        for (DynamicObjectCollection coll : resumeBo.getDyoCollMap().values()) {
            if (coll == null || coll.isEmpty()) continue;
            ArrayList<DynamicObject> collect = new ArrayList<DynamicObject>((Collection<DynamicObject>)coll);
            String entityName = ((DynamicObject)coll.get(0)).getDataEntityType().getName();
            if ("tsirm_srrsmposorgrel".equals(entityName)) {
                RsmCommonHelper.getAllExpSortList(rsm.getLong("id"), collect, entityName);
            }
            RSM_HELPER.save(collect.toArray(new DynamicObject[0]));
        }
    }

    public static void batchHandlerSubForm(List<AppResumeBo> resumeBoList, String[] rsmEntryName) {
        if (CollectionUtils.isEmpty(resumeBoList = resumeBoList.stream().filter(resumeBo -> resumeBo.getRsm() != null).collect(Collectors.toList()))) {
            return;
        }
        List rsmIdList = resumeBoList.stream().map(bo -> bo.getRsm().getLong("id")).collect(Collectors.toList());
        for (String pagekey : rsmEntryName) {
            ServiceHelperCache.getHrBaseServiceHelper((String)pagekey).deleteByFilter(new QFilter[]{new QFilter("rsm", "in", rsmIdList)});
        }
        HashMap<String, List> map = new HashMap<String, List>();
        resumeBoList.forEach(resumeBo -> {
            Collection values = resumeBo.getDyoCollMap().values();
            if (values.isEmpty()) {
                return;
            }
            DynamicObject rsm = resumeBo.getRsm();
            values.forEach(coll -> {
                ArrayList<DynamicObject> collect = new ArrayList<DynamicObject>((Collection<DynamicObject>)coll);
                String entityName = ((DynamicObject)coll.get(0)).getDataEntityType().getName();
                ArrayList<DynamicObject> entryList = (ArrayList<DynamicObject>)map.get(entityName);
                if (CollectionUtils.isEmpty((Collection)entryList)) {
                    entryList = new ArrayList<DynamicObject>();
                }
                if ("tsirm_srrsmposorgrel".equals(entityName)) {
                    List<DynamicObject> allExpSortList = RsmCommonHelper.getAllExpSortList(rsm.getLong("id"), collect, entityName);
                    entryList.addAll(allExpSortList);
                } else {
                    entryList.addAll(collect);
                }
                map.put(entityName, entryList);
            });
        });
        map.forEach((entryName, entryList) -> RSM_HELPER.save(entryList.toArray(new DynamicObject[0])));
    }

    public static void beforeSaveOpRsm(AppResumeBo resumeBo) {
        DynamicObject rsm = resumeBo.getRsm();
        DynamicObject delivery = resumeBo.getDelivery();
        if (null != delivery) {
            rsm.set("delivery", (Object)delivery.getLong("id"));
            rsm.set("delivery_id", (Object)delivery.getLong("id"));
        }
        for (DynamicObjectCollection coll : resumeBo.getDyoCollMap().values()) {
            List highesteduList;
            if (!ObjectUtils.isNotEmpty((Object)coll)) continue;
            ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>((Collection<DynamicObject>)coll);
            String entityName = ((DynamicObject)coll.get(0)).getDataEntityType().getName();
            if ("tsirm_srrsmposorgrel".equals(entityName)) {
                List filterResult = entryList.stream().filter(dynamicObject -> dynamicObject.getDynamicObject("postype").getLong("id") == 1010L).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(filterResult)) {
                    List<DynamicObject> allExpSortList = RsmCommonHelper.getAllExpSortList(rsm.getLong("id"), entryList, entityName);
                    filterResult = allExpSortList.stream().filter(dynamicObject -> dynamicObject.getDynamicObject("postype").getLong("id") == 1010L).collect(Collectors.toList());
                }
                DynamicObject recentPosOrgRelDy = ObjectUtils.isEmpty(filterResult) ? null : (DynamicObject)filterResult.get(0);
                ResumeExpSortHelper.setRecentPosOrgRelInfo(recentPosOrgRelDy, rsm);
                continue;
            }
            if (!"tsirm_srrsmeduexp".equals(entityName) || !ObjectUtils.isNotEmpty(highesteduList = entryList.stream().filter(dynamicObject -> dynamicObject.getBoolean("ishighestedu")).collect(Collectors.toList()))) continue;
            DynamicObject highestEduDy = (DynamicObject)highesteduList.get(0);
            rsm.set("highesteduschool", highestEduDy.get("schoolname"));
            rsm.set("highesteducation", highestEduDy.get("education"));
            rsm.set("highestspecialty", highestEduDy.get("specialtyname"));
        }
    }

    private static void handlerAppFile(AppResumeBo resumeBo) {
        DynamicObject rsm = resumeBo.getRsm();
        long appFileId = ResumeUtilsHelper.getId(rsm, "appfile");
        if (appFileId != 0L) {
            DynamicObject appFile = RsmAppFileHelper.queryOneById(appFileId);
            RsmCommonService.updateAppFileByAppResume(appFile, resumeBo);
            if (!appFile.getBoolean("isbinddelyrec")) {
                RsmCommonService.updateAppFileDeliveryByAppResume(appFile, resumeBo);
                appFile.set("appres", (Object)resumeBo.getRsm());
            }
            AppFileMService.saveOne(appFile);
        }
    }

    public static AppResumeBo copy(AppResumeBo resumeBo) {
        DynamicObject rsm = resumeBo.getRsm();
        Date currDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        HashSet rsmIgnoreKeys = Sets.newHashSet();
        ResumeBoHelper.handleIgnoreKeys(rsmIgnoreKeys);
        rsmIgnoreKeys.add("appfile");
        rsmIgnoreKeys.add("delivery");
        rsmIgnoreKeys.add("appfile_id");
        rsmIgnoreKeys.add("delivery_id");
        DynamicObject newRsm = RSM_HELPER.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)rsm, (DynamicObject)newRsm, (Set)rsmIgnoreKeys);
        ResumeBoHelper.handleDyo(newRsm, currDate);
        HashSet deliveryIgnoreKeys = Sets.newHashSet();
        ResumeBoHelper.handleIgnoreKeys(deliveryIgnoreKeys);
        DynamicObject delivery = ResumeBoHelper.getDelivery(resumeBo);
        DynamicObject newDelivery = RSM_HELPER.generateEmptyDynamicObject(delivery.getDataEntityType().getName());
        HRDynamicObjectUtils.copy((DynamicObject)delivery, (DynamicObject)newDelivery, (Set)deliveryIgnoreKeys);
        ResumeBoHelper.handleDyo(newDelivery, currDate);
        newDelivery.set("applytime", (Object)currDate);
        AppResumeBo newAppResumeBo = new AppResumeBo(newRsm, newDelivery);
        ResumeBoHelper.loadAllListData(resumeBo);
        Map dyoCollMap = resumeBo.getDyoCollMap();
        for (Map.Entry entry : dyoCollMap.entrySet()) {
            DynamicObjectCollection oldColl = (DynamicObjectCollection)entry.getValue();
            if (oldColl == null || oldColl.isEmpty()) continue;
            DynamicObjectCollection newColl = new DynamicObjectCollection();
            for (DynamicObject oldDyo : oldColl) {
                DynamicObject newDyo = RSM_HELPER.generateEmptyDynamicObject((String)entry.getKey());
                HashSet<String> dyoIgnoreKeys = new HashSet<String>();
                dyoIgnoreKeys.add("rsm");
                ResumeBoHelper.handleIgnoreKeys(dyoIgnoreKeys);
                HRDynamicObjectUtils.copy((DynamicObject)oldDyo, (DynamicObject)newDyo, dyoIgnoreKeys);
                newDyo.set("rsm", (Object)newRsm.getLong("id"));
                ResumeBoHelper.handleDyo(newDyo, currDate);
                newColl.add((Object)newDyo);
            }
            newAppResumeBo.setEntry((String)entry.getKey(), newColl);
        }
        return newAppResumeBo;
    }

    private static void handleIgnoreKeys(Set<String> set) {
        set.add("id");
        set.add("createtime");
        set.add("creator");
        set.add("modifytime");
        set.add("modifier");
    }

    private static void handleDyo(DynamicObject dyo, Date time) {
        dyo.set("id", (Object)ID.genLongId());
        dyo.set("createtime", (Object)time);
        dyo.set("creator", (Object)TSCRequestContext.getUserId());
        dyo.set("modifytime", null);
        dyo.set("modifier", null);
    }

    public static void loadAllListData(AppResumeBo resumeBo) {
        RsmCommonService.loadAllListData(resumeBo);
    }

    public static DynamicObject[] getRsmByStdRsmIds(List<Long> stdRsmIds) {
        QFilter filter = new QFilter("stdrsm", "in", stdRsmIds);
        return RSM_HELPER.query("delivery, delivery.applytime, appfile,fullname,stdrsm", new QFilter[]{filter}, "delivery.applytime desc");
    }

    public static DynamicObject[] getAppFileNotNullOfRsmByStdRsmIds(List<Long> stdRsmIds) {
        QFilter filter = new QFilter("stdrsm", "in", stdRsmIds);
        filter.and("appfile", "!=", (Object)0L);
        return RSM_HELPER.query("delivery, appfile,fullname,stdrsm", new QFilter[]{filter}, "delivery.applytime desc");
    }

    public static void setResumeBoExp(AppResumeBo resumeBo, String expSubPage) {
        for (String subpage : ResumeMetadataService.getAllEntry((String)"tsirm_srrsm", (String)"3")) {
            if (subpage.equals(expSubPage)) continue;
            DynamicObjectCollection collection = RsmCommonService.getRsmList(resumeBo, subpage);
            resumeBo.setEntry(subpage, collection);
        }
    }

    public static void saveOneRsm(DynamicObject rsm) {
        if (null == rsm) {
            return;
        }
        String number = rsm.getString("number");
        if (HRStringUtils.isEmpty((String)number)) {
            String codeNumber = CodeRuleServiceHelper.getNumber((String)"tsirm_rsm", (DynamicObject)rsm, null);
            rsm.set("number", (Object)codeNumber);
        }
        RSM_HELPER.saveOne(rsm);
    }

    public static DynamicObject getDelivery(AppResumeBo resumeBo) {
        return RsmCommonService.getDelivery(resumeBo);
    }

    public static DynamicObject getDelivery(DynamicObject rsmDt) {
        return RsmCommonService.getDelivery(rsmDt);
    }

    public static DynamicObject getOne(Object pkId) {
        return RSM_HELPER.queryOne(pkId);
    }
}

