/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.rsm.common.RsmCommonService;
import kd.tsc.tsirm.business.domain.rsm.common.helper.ResumeBoHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmEduExpHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmPosOrgRelHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mhelper.RsmAppFileHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tsirm.business.domain.rsm.sr.service.AddResumeService;
import kd.tsc.tsirm.business.domain.rsm.sr.service.RsmApiService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tsirm.common.constants.rsm.sr.SrRsmKDString;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.utils.BizAttachmentUtil;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import org.apache.commons.lang3.StringUtils;

public class RsmCommonHelper {
    private static final Log LOG = LogFactory.getLog(RsmCommonHelper.class);
    private static final String FORMATSTR = "\u201c%s\u201d\u3001";
    private static final Set<String> KEY_FIELDS = Sets.newHashSet((Object[])new String[]{"phone", "email", "fullname", "highesteducation", "birthday", "partwt", "certificatenumber"});
    public static final HRBaseServiceHelper RSMDAO = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_rsm");

    private RsmCommonHelper() {
    }

    public static List<DynamicObject> getAllExpSortList(Long rsmId, List<DynamicObject> cacheData, String entityName) {
        List<Object> expSortList = null;
        switch (entityName) {
            case "tsirm_srrsmeduexp": {
                expSortList = RsmEduExpHelper.getAllEduExpSortList(rsmId, cacheData);
                break;
            }
            case "tsirm_srrsmposorgrel": {
                expSortList = RsmPosOrgRelHelper.getAllPosOrgRelSortList(rsmId, cacheData);
                break;
            }
            default: {
                expSortList = Lists.newArrayListWithExpectedSize((int)0);
            }
        }
        if (!expSortList.isEmpty()) {
            expSortList.forEach(exp -> exp.set("rsm", (Object)rsmId));
        }
        return expSortList;
    }

    public static final void setShowWorkYears(int totalMonth, IFormView view) {
        IDataModel model = view.getModel();
        model.setValue("showworkingyears", (Object)ResumeAnalysisHelper.getWorkYearShow(totalMonth));
        view.updateView("showworkingyears");
    }

    public static String checkAdminDivision(DynamicObject dataEntity, IFormView childView) {
        String rgstprmtrsdId = dataEntity.getString("rgstprmtrsd");
        if (HRStringUtils.isNotEmpty((String)rgstprmtrsdId) && !rgstprmtrsdId.equals("0") && !ResumeUtilsHelper.checkAdminDivision(Long.parseLong(rgstprmtrsdId), 3)) {
            String tips = SrRsmKDString.leastCountry();
            childView.showFieldTip(ResumeUtilsHelper.createFieldTip(tips, "rgstprmtrsd"));
            return tips;
        }
        return null;
    }

    public static String checkMustInput(DynamicObject dataEntity, IFormView view) {
        Date birthdayV;
        String tipMsgResult = SrRsmKDString.pleaseInputAs();
        String tips = SrRsmKDString.notNull();
        String tipMsg = "";
        String fullNameV = dataEntity.getString("fullname");
        if (HRStringUtils.isEmpty((String)fullNameV)) {
            FieldEdit fullNameF = (FieldEdit)view.getControl("fullname");
            String localName = fullNameF.getProperty().getDisplayName().getLocaleValue();
            tipMsg = String.format(Locale.ROOT, FORMATSTR, localName);
            view.showFieldTip(ResumeUtilsHelper.createFieldTip(tips, "fullname"));
        }
        if (null == (birthdayV = dataEntity.getDate("birthday"))) {
            DateEdit birthdayF = (DateEdit)view.getControl("birthday");
            String localName = birthdayF.getProperty().getDisplayName().getLocaleValue();
            tipMsg = tipMsg + String.format(Locale.ROOT, FORMATSTR, localName);
            view.showFieldTip(ResumeUtilsHelper.createFieldTip(tips, "birthday"));
        }
        if (HRStringUtils.isNotEmpty((String)tipMsg)) {
            tipMsg = StringUtils.removeEnd((String)tipMsg, (String)"\u3001");
            return String.format(Locale.ROOT, tipMsgResult, tipMsg);
        }
        return null;
    }

    public static String checkPhoneEmail(DynamicObject dataEntity, IFormView view, String phoneKey, String emailKey) {
        String phone = dataEntity.getString(phoneKey);
        String email = dataEntity.getString(emailKey);
        if (StringUtils.isBlank((CharSequence)phone) && StringUtils.isBlank((CharSequence)email)) {
            String tip = SrRsmKDString.phoneOrEmailMust();
            DeleteRule deleteRule = ResumeUtilsHelper.createDeleteRule(phoneKey, emailKey);
            FieldTip phoneFieldTip = ResumeUtilsHelper.createFieldTip(tip, phoneKey);
            FieldTip emailFieldTip = ResumeUtilsHelper.createFieldTip(tip, emailKey);
            phoneFieldTip.setDeleteRule(deleteRule);
            emailFieldTip.setDeleteRule(deleteRule);
            view.showFieldTip(phoneFieldTip);
            view.showFieldTip(emailFieldTip);
            return tip;
        }
        return null;
    }

    public static String validPhoneEmail(DynamicObject dataEntity, IFormView childView) {
        String phone = dataEntity.getString("phone");
        String email = dataEntity.getString("email");
        if (StringUtils.isNotBlank((CharSequence)phone) && !ResumeAnalysisHelper.checkPhone(phone)) {
            String tip = SrRsmKDString.phoneError();
            childView.showFieldTip(ResumeUtilsHelper.createFieldTip(tip, "phone"));
            return tip;
        }
        if (StringUtils.isNotBlank((CharSequence)email) && !ResumeAnalysisHelper.checkEmail(email)) {
            String tip = SrRsmKDString.emailError();
            childView.showFieldTip(ResumeUtilsHelper.createFieldTip(tip, "email"));
            return tip;
        }
        return null;
    }

    public static void copyResume(DynamicObject fromObj, DynamicObject toObj) {
        HashSet<String> ignoreKeys = new HashSet<String>(16);
        ignoreKeys.add("id");
        ignoreKeys.add("creator");
        ignoreKeys.add("createtime");
        ignoreKeys.add("appfile");
        ignoreKeys.add("delivery");
        ignoreKeys.add("rsmsource");
        ignoreKeys.add("stdrsm");
        ResumeUtilsHelper.copyObj(fromObj, toObj, ignoreKeys);
    }

    public static void showSimpleRsm(IFormView view, boolean isShow) {
        boolean visibleSim = isShow && view.getEntityId().equals("tsirm_srrsm");
        view.setVisible(Boolean.valueOf(!visibleSim), new String[]{"panel_perinfo", "panel_contactinfo", "advpanel_tkofcexp", "advpanel_eduexp", "advpanel_wordexp", "advpanel_prjexp", "panel_selfdesc", "advpanel_workrelaexp", "panel_jobintention", "advpanel_langexp"});
        view.setVisible(Boolean.valueOf(visibleSim), new String[]{"panel_candidateinfo"});
    }

    public static AppResumeBo getUpdateResumeBo(DynamicObject rsm, List<DynamicObject> expList, String entityId) {
        AppResumeBo resumeBo = new AppResumeBo(rsm);
        ResumeBoHelper.setResumeBoExp(resumeBo, entityId);
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            resumeBo.setEntry(entityId, expList);
        }
        return resumeBo;
    }

    public static boolean expDataIsChanged(IPageCache pageCache, List<DynamicObject> expList) {
        for (DynamicObject exp : expList) {
            if (!exp.getDataEntityState().getFromDatabase()) {
                return true;
            }
            DynamicObject oldExpCache = ResumeUtilsHelper.deserialize(pageCache, RsmCommonHelper.getCacheEntityKey(exp), exp.getDataEntityType().getName());
            if (!ResumeUtilsHelper.dataIsChanged(oldExpCache, exp, false)) continue;
            return true;
        }
        return false;
    }

    public static void executeUpdateExp(DynamicObject rsm, List<DynamicObject> expList, String entityId, IPageCache pageCache, boolean isDelete) {
        AppResumeBo resumeBo = RsmCommonHelper.getUpdateResumeBo(rsm, expList, entityId);
        boolean isDiffUpdateStdRsm = isDelete || RsmCommonHelper.expDataIsChanged(pageCache, expList);
        RsmCommonHelper.updateRsmInfo(rsm, resumeBo, Boolean.TRUE, isDiffUpdateStdRsm, pageCache);
    }

    public static boolean dataIsChanged(IPageCache pageCache, DynamicObject rsm) {
        DynamicObject oldRsm = ResumeUtilsHelper.deserialize(pageCache, RsmCommonHelper.getCacheEntityKey(rsm), rsm.getDataEntityType().getName());
        return ResumeUtilsHelper.dataIsChanged(oldRsm, rsm, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRsmInfo(DynamicObject rsm, AppResumeBo resumeBo, Boolean pubAiLabel, Boolean isDiffUpdateStdRsm, IPageCache pageCache) {
        Long stdrsmId = rsm.getLong("stdrsm");
        Long rsmId = rsm.getLong("id");
        DynamicObject oldRsm = RsmHelper.findRsmById(rsmId, "photo")[0];
        rsm.set("photo", (Object)oldRsm.getString("photo"));
        ResumeUtilsHelper.setModifierAndTime(rsm);
        try (TXHandle tx = TX.required();){
            DynamicObject appFile;
            RSMDAO.updateOne(rsm);
            if (Boolean.TRUE.equals(isDiffUpdateStdRsm)) {
                AddResumeService.diffUpdateStandResume(stdrsmId, resumeBo, ResumeTypeEnum.APP_FILE_UPDATE);
            }
            if ((appFile = RsmAppFileHelper.findAppFileByRsmId(rsmId)) != null) {
                RsmCommonService.updateAppFileByAppResume(appFile, resumeBo);
                appFile.set("isbinddelyrec", (Object)"1");
                AppFileMService.save(new DynamicObject[]{appFile});
                if (Boolean.TRUE.equals(isDiffUpdateStdRsm)) {
                    RsmCommonHelper.addRsmUpdateOpRecord(rsm, resumeBo, pageCache, appFile);
                }
            }
        }
        if (Boolean.TRUE.equals(isDiffUpdateStdRsm)) {
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("bos_attachment");
            List attachmentData = resumeBo.getAttachmentData();
            ArrayList uIdList = new ArrayList();
            if (null != attachmentData) {
                attachmentData.forEach(map -> {
                    Object url = map.get("uid");
                    if (null == url) {
                        return;
                    }
                    uIdList.add(url.toString());
                });
            }
            QFilter qFilter = new QFilter("fnumber", "in", uIdList);
            qFilter.and(new QFilter("fattachmentpanel", "=", (Object)"attachmentpanelap")).and(new QFilter("fbilltype", "=", (Object)"tsirm_stdrsm"));
            int deleteNum = hrBaseServiceHelper.deleteByFilter(qFilter.toArray());
            if (deleteNum == 0) {
                AttachmentServiceHelper.remove((String)"tsirm_stdrsm", (Object)stdrsmId);
            }
            List newAttachmentList = BizAttachmentUtil.copyAndSaveTempAttachments((List)resumeBo.getAttachmentData());
            BizAttachmentUtil.uploadAndSaveAttachments((String)"tsirm_stdrsm", (Object)stdrsmId, (String)"attachmentpanelap", (List)newAttachmentList);
        }
    }

    private static void addRsmUpdateOpRecord(DynamicObject rsm, AppResumeBo resumeBo, IPageCache pageCache, DynamicObject appFile) {
        Iterable bizChangedProperties = resumeBo.getRsm().getDataEntityState().getBizChangedProperties();
        Iterator<IDataEntityProperty> bizChangeProps = bizChangedProperties.iterator();
        ArrayList keyChangeList = Lists.newArrayList();
        DynamicObject originRsm = null;
        RsmCommonHelper.handleKeyFieldChange(rsm, pageCache, bizChangeProps, keyChangeList, originRsm);
        Map<String, List<Map<String, String>>> changeListMap = Collections.singletonMap(appFile.getString("id"), keyChangeList);
        AppFileMService.addRsmUpdateOpRecord(new DynamicObject[]{appFile}, changeListMap);
    }

    private static void handleKeyFieldChange(DynamicObject rsm, IPageCache pageCache, Iterator<IDataEntityProperty> bizChangeProps, List<Map<String, String>> keyChangeList, DynamicObject originRsm) {
        while (bizChangeProps.hasNext()) {
            IDataEntityProperty next = bizChangeProps.next();
            if (!KEY_FIELDS.contains(next.getName())) continue;
            if (originRsm == null) {
                originRsm = ResumeUtilsHelper.deserialize(pageCache, RsmCommonHelper.getCacheEntityKey(rsm), rsm.getDataEntityType().getName());
            }
            HashMap map = Maps.newHashMapWithExpectedSize((int)4);
            map.put("fieldkey", next.getName());
            map.put("fieldname", next.getDisplayName().getLocaleValue());
            RsmCommonHelper.setValue(next, rsm, map, originRsm);
            keyChangeList.add(map);
        }
    }

    private static void setValue(IDataEntityProperty next, DynamicObject rsm, Map<String, String> map, DynamicObject originRsm) {
        String newValue = "";
        String oldValue = "";
        if (next instanceof FieldProp) {
            Object oldValueObj;
            FieldProp fieldProp = (FieldProp)next;
            Object newValueObj = fieldProp.getBasePropDisplayValue((Object)rsm);
            if (newValueObj != null) {
                newValue = newValueObj.toString();
            }
            if ((oldValueObj = fieldProp.getBasePropDisplayValue((Object)originRsm)) != null) {
                oldValue = oldValueObj.toString();
            }
        } else {
            newValue = rsm.getString(next.getName());
            if (originRsm != null) {
                oldValue = originRsm.getString(next.getName());
            }
        }
        map.put("newvalue", newValue);
        map.put("oldvalue", oldValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void coverOldRsm(AppResumeBo resumeBo, ResumeTypeEnum resumeTypeEnum) {
        DynamicObject rsm = resumeBo.getRsm();
        ResumeUtilsHelper.setModifierAndTime(rsm);
        Long stdRsmId = rsm.getLong("stdrsm");
        try (TXHandle txHandle = TX.requiresNew();){
            ResumeBoHelper.save(resumeBo);
            AddResumeService.diffUpdateStandResume(stdRsmId, resumeBo, resumeTypeEnum);
        }
        RsmCommonHelper.outTransaction(rsm.getLong("id"), Boolean.TRUE);
    }

    public static void outTransaction(long rsmId, Boolean pubAiLabel) {
        if (Boolean.TRUE.equals(pubAiLabel)) {
            RsmApiService.publishRsmMsgToAILabel(rsmId);
        }
    }

    public static void showAppFile(IFormView view, Object appFileId, String msg) {
        String entityId = RsmCommonService.getOpenAppFileEntityId(appFileId);
        if (!HRStringUtils.isEmpty((String)entityId)) {
            view.showErrorNotification(SrRsmKDString.notHaveAppFileRight());
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(entityId);
        showParameter.setPkId(appFileId);
        showParameter.setCustomParam("successMsg", (Object)msg);
        view.showForm((FormShowParameter)showParameter);
    }

    public static String getCacheEntityKey(DynamicObject entity) {
        return "key_data_cache_prefix_" + entity.getPkValue();
    }
}

