/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmExpCommonHelper;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeExpSortHelper;

public class RsmEduExpHelper {
    public static final HRBaseServiceHelper EDUEXPSERVICEHELPER = new HRBaseServiceHelper("tsirm_srrsmeduexp");

    private RsmEduExpHelper() {
    }

    public static List<DynamicObject> findEduExps(Long rsmId, Object[] excludeIds) {
        return RsmExpCommonHelper.findRsmExpDyList(rsmId, excludeIds, EDUEXPSERVICEHELPER);
    }

    public static DynamicObject[] findEduExps(Object[] ids) {
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        return EDUEXPSERVICEHELPER.loadDynamicObjectArray(qFilter.toArray());
    }

    public static void saveRsmEduExp(List<DynamicObject> eduExpSorts, Long rsmId, IPageCache pageCache) {
    }

    public static List<DynamicObject> getAllEduExpSortList(Long rsmId, List<DynamicObject> cacheDataList) {
        ArrayList allExps = Lists.newArrayListWithExpectedSize((int)4);
        if (cacheDataList != null && !cacheDataList.isEmpty()) {
            allExps.addAll(cacheDataList);
        }
        if (rsmId != null && rsmId != 0L && cacheDataList != null) {
            ArrayList cacheIdList = Lists.newArrayListWithExpectedSize((int)cacheDataList.size());
            for (DynamicObject cacheData : cacheDataList) {
                long id = cacheData.getLong("id");
                if (id == 0L) continue;
                cacheIdList.add(id);
            }
            allExps.addAll(RsmEduExpHelper.findEduExps(rsmId, cacheIdList.toArray()));
        }
        if (!allExps.isEmpty()) {
            return ResumeExpSortHelper.sortRsmEduExp(allExps);
        }
        return Lists.newArrayListWithExpectedSize((int)49);
    }
}

