/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.common.helper;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.field.DateEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mhelper.RsmAppFileHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsirm.common.constants.rsm.sr.SrRsmKDString;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbs.business.domain.common.service.FormShowHelper;
import kd.tsc.tsrbs.common.enums.NeedDisposeEmptyFieldEnum;

public class RsmHelper {
    private static final String KEY_OPSTATUS = "operationstatus";
    private static final String LINEFEED = "\\\\r\\\\n";
    private static final String LINEFEED_REPLACE = "\r\n";
    public static final HRBaseServiceHelper rsmServiceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_rsm");
    public static final String RSM_QUERY_PROP = "id,highesteduschool,highesteducation,hestspecialtycat,highestspecialty,highestdegree,index,recentcompany,recentposition,stdrsm,fullname,gender,natreg,birthday,age,partwt,workingyears,jobstatus,phone,email";

    public static DynamicObject findOne(long id) {
        return rsmServiceHelper.queryOne((Object)id);
    }

    private RsmHelper() {
    }

    public static DynamicObject[] findRsmById(Long rsmId, String queryProp) {
        QFilter qFilter = new QFilter("id", "=", (Object)rsmId);
        if (HRStringUtils.isNotEmpty((String)queryProp)) {
            return rsmServiceHelper.query(queryProp, qFilter.toArray());
        }
        return rsmServiceHelper.loadDynamicObjectArray(qFilter.toArray());
    }

    public static DynamicObject[] findRsmByStdRsmIds(List<Long> stdRsmIds) {
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_rsm");
        QFilter qFilter = new QFilter("stdrsm", "in", stdRsmIds);
        return serviceHelper.query("id,fullname,createtime,modifytime,stdrsm,delivery", qFilter.toArray(), "createtime desc");
    }

    public static void handlerPartwtChange(Date date, IFormView view) {
        IDataModel model = view.getModel();
        model.beginInit();
        if (date != null) {
            int totalMonth = ResumeAnalysisHelper.calMonthByStartDate(date);
            model.setValue("workingyears", (Object)totalMonth);
            RsmCommonHelper.setShowWorkYears(totalMonth, view);
        } else {
            model.setValue("workingyears", null);
            model.setValue("showworkingyears", null);
        }
        model.endInit();
        view.updateView("workingyears");
        view.updateView("showworkingyears");
    }

    public static void setDataControlMinMax(Date startDate, Date endDate, IFormView view) {
        DateEdit startDateEdit = (DateEdit)view.getControl("startdate");
        DateEdit endDateEdit = (DateEdit)view.getControl("endingdate");
        if (null != startDate) {
            endDateEdit.setMinDate(startDate);
        }
        if (null != endDate) {
            startDateEdit.setMaxDate(endDate);
        }
    }

    public static boolean dealDateTime(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity();
        DataEntityPropertyCollection dpc = dataEntity.getDataEntityType().getProperties();
        Set allFields = dpc.stream().map(IMetadata::getName).collect(Collectors.toSet());
        return allFields.contains("startdate");
    }

    public static void handleExpEditPropertyChange(PropertyChangedArgs pde, IFormView view) {
    }

    public static void handleRsmExpAfterBindData(IFormView view) {
    }

    public static void setExpEditDataModel(BizDataEventArgs pde, IFormView view, String entityId) {
    }

    public static void deleteCacheData(IPageCache pageCache, long deleteExpId, String entityId) {
    }

    public static void showConfirmDeleteRsmExp(String billFormId, IFormView view) {
    }

    public static boolean showDataChangeForm(IFormView view, IFormView parentView, ConfirmCallBackListener confirmCallBacks) {
        return RsmHelper.showDataChangeForm(view, parentView, "", confirmCallBacks);
    }

    public static boolean showDataChangeForm(IFormView view, IFormView parentView, String cacheKey, ConfirmCallBackListener confirmCallBacks) {
        String changeDataMessage = view.getPageCache().get(cacheKey + view.getEntityId());
        if (HRStringUtils.isNotEmpty((String)changeDataMessage)) {
            String changeDataMessagePrefix = SrRsmKDString.billIsChange();
            String detailMsg = changeDataMessagePrefix + changeDataMessage;
            RsmHelper.showDataChangeForm(detailMsg, view, parentView, confirmCallBacks);
            return true;
        }
        return false;
    }

    public static void showDataChangeForm(String detailMsg, IFormView view, IFormView parentView, ConfirmCallBackListener confirmCallBacks) {
        String msg = SrRsmKDString.confirmSaveChange();
        msg = msg.replace(LINEFEED, LINEFEED_REPLACE);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), SrRsmKDString.returnUpdate());
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), SrRsmKDString.directQuit());
        if (null != parentView) {
            parentView.showConfirm(msg, detailMsg, options, ConfirmTypes.Save, confirmCallBacks, (Map)btnNameMaps);
        } else {
            view.showConfirm(msg, detailMsg, options, ConfirmTypes.Save, confirmCallBacks, (Map)btnNameMaps);
        }
    }

    public static void rsmExpListPackageData(PackageDataEvent pde, IFormView view) {
        Date endingDate;
        DynamicObject rowData = pde.getRowData();
        ColumnDesc source = (ColumnDesc)pde.getSource();
        String fieldKey = source.getFieldKey();
        RsmHelper.setSpecialValue(pde, rowData, source, fieldKey);
        if (HRStringUtils.equals((String)"schoolname.name", (String)fieldKey)) {
            String number = rowData.getString("schoolname.number");
            if (HRStringUtils.equals((String)"30000010_S", (String)number)) {
                pde.setFormatValue((Object)rowData.getString("othschname"));
            }
        } else if (HRStringUtils.equals((String)"langcertscore", (String)fieldKey)) {
            BigDecimal bigDecimal = rowData.getBigDecimal("langcertscore");
            if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                pde.setFormatValue((Object)"-");
            }
        } else if (HRStringUtils.equals((String)KEY_OPSTATUS, (String)fieldKey)) {
            pde.setFormatValue((Object)view.getFormShowParameter().getStatusValue());
        } else if (HRStringUtils.equals((String)"postypeid", (String)fieldKey)) {
            pde.setFormatValue((Object)rowData.getDynamicObject("postype").getLong("id"));
        } else if ("durationtext".equals(fieldKey)) {
            Date endingDate2 = rowData.getDate("endingdate");
            Date startDate = rowData.getDate("startdate");
            if (ResumeAnalysisHelper.isEndingDateUpToNow(endingDate2)) {
                String workYearShow = ResumeAnalysisHelper.getWorkYearShow(ResumeAnalysisHelper.calMonthByStartDate(startDate, new Date()));
                pde.setFormatValue((Object)workYearShow);
            } else {
                String workYearShow = ResumeAnalysisHelper.getWorkYearShow(ResumeAnalysisHelper.calMonthByStartDate(startDate, endingDate2));
                pde.setFormatValue((Object)workYearShow);
            }
        } else if ("istonow".equals(fieldKey) && ResumeAnalysisHelper.isEndingDateUpToNow(endingDate = rowData.getDate("endingdate"))) {
            pde.setFormatValue((Object)"1");
        }
    }

    private static void setSpecialValue(PackageDataEvent pde, DynamicObject rowData, ColumnDesc source, String fieldKey) {
        if (NeedDisposeEmptyFieldEnum.isExist((String)fieldKey)) {
            boolean isEmpty;
            boolean bl = isEmpty = rowData.get(fieldKey) == null || "".equals(pde.getFormatValue());
            if (isEmpty) {
                pde.setFormatValue((Object)"-");
            }
        }
    }

    public static boolean appFileValidCanEdit(IFormView view) {
        DynamicObject rsmDy = view.getModel().getDataEntity();
        long appFileId = rsmDy.getLong("appfile");
        if (appFileId == 0L) {
            return true;
        }
        if (!RsmAppFileHelper.appFileIsInProcess(appFileId)) {
            IFormView parentView = view.getParentView();
            parentView.showTipNotification(SrRsmKDString.editInProcess());
            view.sendFormAction(parentView);
            return false;
        }
        return true;
    }

    public static DynamicObject getAppFileByStdRsmMidAndPositionId(Long mid, Long positionId, Date applyTime) {
        return AppFileMService.getAppFileByStdRsmIdAndPositionId(mid, positionId, applyTime);
    }

    public static DynamicObject[] getAppFilesByStdMidAndPositionId(List<Long> midList, List<Long> positionIdList, Date applyTime) {
        return AppFileMService.getAppFilesByStdMidAndPositionId(midList, positionIdList, applyTime);
    }

    public static void reloadExpList(IFormView view) {
        Long rsmId = view.getModel().getDataEntity().getLong("id");
        RsmHelper.reloadRsmExpView("tsirm_srrsmeduexp", "flexpanelcontent_eduexp", rsmId, view);
        RsmHelper.reloadRsmExpView("tsirm_srrsmposorgrel", "flexpanelcontent_posorgre", rsmId, view);
    }

    public static void reloadRsmExpView(String pageKey, String containerKey, Long rsmId, IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        ListShowParameter expShowParameter = FormShowHelper.createListFormShowParameter((String)"tsirm_list_rsm", (String)containerKey, (String)pageKey, (ShowType)ShowType.InContainer, null);
        if (rsmId == null) {
            expShowParameter.setCustomParam("rsm_id", (Object)"0");
        } else {
            expShowParameter.setCustomParam("rsm_id", (Object)rsmId.toString());
        }
        String dataSource = (String)formShowParameter.getCustomParam("dataSource");
        expShowParameter.setCustomParam("dataSource", (Object)dataSource);
        expShowParameter.setStatus(formShowParameter.getStatus());
        view.showForm((FormShowParameter)expShowParameter);
    }

    public static DynamicObject[] getPosorgrelByRsmId(Object rsmId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_srrsmposorgrel");
        return serviceHelper.query("startdate,endingdate,company,adminorg,position", new QFilter[]{new QFilter("rsm", "=", rsmId)});
    }

    public static DynamicObject[] queryEducationByRsmId(Object rsmId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_srrsmeduexp");
        return serviceHelper.query("startdate,endingdate,schoolname,othschname,specialtyname,education,educationform", new QFilter[]{new QFilter("rsm", "=", rsmId)});
    }
}

