/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.common.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileStatusHelper;
import kd.tsc.tsirm.business.domain.appfile.form.AppFileFormHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileOpRecordService;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileRsmHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileStdRsmHelper;
import kd.tsc.tsirm.business.domain.appfile.service.header.AppFileHeaderService;
import kd.tsc.tsirm.business.domain.rsm.sr.service.AddResumeService;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsrbd.business.domain.headtemplate.HeaderService;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveAppFileResult;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;
import kd.tsc.tsrbs.common.enums.OpDefEnum;
import kd.tsc.tsrbs.common.exception.TSCBizException;

public class AppFileMService {
    private static final Log LOG = LogFactory.getLog(AppFileMService.class);
    private static final HRBaseServiceHelper APP_FILE_HELPER = new HRBaseServiceHelper("tsirm_appfilemdl");
    private static final String APPID = "tsirm";
    private static final String SERVICENAME = "appFileService";

    public static void updateOne(DynamicObject appFile) {
        AppFileMService.saveOne(appFile);
    }

    public static void update(DynamicObject[] appfiles) {
        AppFileMService.save(appfiles);
    }

    public static void saveOne(DynamicObject appfile) {
        AppFileMService.save(new DynamicObject[]{appfile});
    }

    private AppFileMService() {
        throw new IllegalStateException("Utility class");
    }

    public static void save(DynamicObject[] appFiles) {
        try {
            AppFileHelper.update(appFiles);
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tsirm.appFileService.updateAppFiles error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
    }

    public static void addRsmUpdateOpRecord(long appFileId) {
    }

    public static void addRsmUpdateOpRecord(DynamicObject[] appFiles, Map<String, List<Map<String, String>>> changeListMap) {
        try {
            List<Long> appFileIdList = Arrays.stream(appFiles).map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
            HashMap castMap = Maps.newHashMap(changeListMap);
            AppFileOpRecordService.getInstance().sendOpRecord(AppFileResManagerHelper.getRecRoleName(), OpDefEnum.TSIRM_UPDATE, appFileIdList, castMap);
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tsirm.appFileService.addRsmUpdateOpRecord error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
    }

    public static void addInviteRsmUpdateOpRecord(List<Long> appFileIdList) {
    }

    public static void mergeCandidate(long mergeToId, long mergeFromId) {
    }

    public static SaveAppFileResult saveAppFileOperation(DynamicObject appFile, DynamicObject position, AppResumeBo resumeBo) {
        SaveAppFileResult saveAppFileResult;
        try {
            saveAppFileResult = new SaveAppFileResult();
            AppFileRsmHelper.saveAppFileOperation(appFile, position, resumeBo);
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tsirm.appFileService.saveAppFile error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
        return saveAppFileResult;
    }

    public static void eliminateAppFile(DynamicObject[] appFiles, String type, Long reasonId, Map<String, String> detailedReason) {
        try {
            AppFileStatusHelper.eliminateAppFile(appFiles, type, reasonId, detailedReason);
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tsirm.appFileService.eliminateAppFile error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
    }

    public static DynamicObject getAppFileByStdRsmIdAndPositionId(Long stdRsmId, Long positionId, Date applyTime) {
        try {
            return AppFileStdRsmHelper.getAppFileByStdRsmIdAndPositionId(stdRsmId, positionId, applyTime);
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tsirm.appFileService.getAppFileByStdRsmIdAndPositionId error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
    }

    public static void updateStdRsmInfoPositionNum(Long stdRsmId, Map<String, String> stdRsmInfoMap) {
        try {
            AppFileStdRsmHelper.updateStdRsmInfo(stdRsmId, stdRsmInfoMap);
        }
        catch (RuntimeException ex) {
            LOG.error("AppFileMService=>tsc.tsirm.appFileService.updateStdRsmInfo error", (Throwable)ex);
            throw ex;
        }
    }

    public static void updateStdRsmInfoPositionNum(List<DynamicObject> stdRsmList, int positionSize) {
        stdRsmList.forEach(stdRsm -> {
            int positionNum = stdRsm.getInt("positionnum");
            stdRsm.set("positionnum", (Object)(positionSize + positionNum));
        });
        StdRsmServiceHelper.update(stdRsmList.toArray(new DynamicObject[0]));
    }

    public static void updateStdRsmInfo(Map<Long, Map<String, String>> stdRsmInfoMap) {
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        try (DataSet dataSet = APP_FILE_HELPER.queryDataSet("updateAppPosNumAndRecChlStdRsmInfo.positionnum", "stdrsm", new QFilter[]{new QFilter("stdrsm", "in", stdRsmInfoMap.keySet())});
             DataSet groupDataSet = dataSet.groupBy(new String[]{"stdrsm"}).count().finish();){
            for (Row row : groupDataSet) {
                result.put(row.getLong("stdrsm"), row.getInteger("count"));
            }
        }
        try {
            ArrayList stdRsmIdList = Lists.newArrayList(result.keySet());
            DynamicObject[] stdRsmDys = StdRsmServiceHelper.getCurrentOrHistoryStdRsm(stdRsmIdList);
            if (null == stdRsmDys) {
                return;
            }
            HashMap stdRsmUpdateMap = new HashMap();
            stdRsmInfoMap.forEach((stdRsmId, map) -> stdRsmUpdateMap.putAll(AppFileStdRsmHelper.updateStdRsmInfo(stdRsmId, map, result)));
            Arrays.stream(stdRsmDys).forEach(stdRsm -> {
                long stdRsmId = stdRsm.getLong("id");
                long boId = stdRsm.getLong("boid");
                Map updateMap = (Map)stdRsmUpdateMap.get(stdRsmId);
                Map boUpdateMap = (Map)stdRsmUpdateMap.get(boId);
                if (null == updateMap && boUpdateMap == null) {
                    return;
                }
                Optional.ofNullable(updateMap).ifPresent(map -> map.forEach((arg_0, arg_1) -> ((DynamicObject)stdRsm).set(arg_0, arg_1)));
                Optional.ofNullable(boUpdateMap).ifPresent(map -> map.forEach((arg_0, arg_1) -> ((DynamicObject)stdRsm).set(arg_0, arg_1)));
            });
            StdRsmServiceHelper.update(stdRsmDys);
        }
        catch (RuntimeException ex) {
            LOG.error("AppFileMService=>tsc.tsirm.appFileService.updateStdRsmInfo error", (Throwable)ex);
            throw ex;
        }
    }

    public static void afterAppFileSaveHandle(SaveCandidateResult result, DynamicObject positionDt, AppResumeBo resumeBo) {
        AppFileMService.afterAppFileSaveHandle(result.getAppFileId(), result.getRsmId(), positionDt, resumeBo);
    }

    public static void afterAppFileSaveHandle(Long appFileId, Long rsmId, DynamicObject positionDt, AppResumeBo resumeBo) {
        if (positionDt != null) {
            AddResumeService.updatePositionCandidateNumber(positionDt);
        }
        Long stdRsmId = resumeBo.getRsm().getLong("stdrsm");
        AppFileMService.updateStdRsmInfoPositionNum(appFileId, positionDt, resumeBo, stdRsmId);
    }

    private static void updateStdRsmInfoPositionNum(Long appFileId, DynamicObject positionDt, AppResumeBo resumeBo, Long stdRsmId) {
        try {
            HashMap stdRsmInfoMap = Maps.newHashMapWithExpectedSize((int)4);
            if (positionDt != null) {
                stdRsmInfoMap.put("position", positionDt.getString("id"));
                if (appFileId != null && appFileId != 0L) {
                    stdRsmInfoMap.put("appfile", String.valueOf(appFileId));
                }
            }
            Object recChannelObj = resumeBo.getDelivery().get("recruchnlnm");
            if (resumeBo.getDelivery().get("recruchnlnm") instanceof Long) {
                stdRsmInfoMap.put("recruchnlnm", ((Long)recChannelObj).toString());
            } else if (recChannelObj instanceof DynamicObject) {
                stdRsmInfoMap.put("recruchnlnm", ((DynamicObject)recChannelObj).getString("id"));
            }
            AppFileMService.updateStdRsmInfoPositionNum(stdRsmId, stdRsmInfoMap);
        }
        catch (Exception ex) {
            LOG.error("afterHandlerOperation.updateStdRsmInfo.error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
    }

    public static DynamicObject[] getAppFilesByStdRsmId(Long stdRsmId) {
        try {
            return AppFileHelper.queryAppFiles("id", new QFilter[]{new QFilter("stdrsm", "=", (Object)stdRsmId)});
        }
        catch (RuntimeException ex) {
            LOG.error("AppFileMService=>tsc.tsirm.appFileService.getAppFilesByStdRsmId error", (Throwable)ex);
            throw ex;
        }
    }

    public static HeaderService getAppFileHeaderService(String type) {
        try {
            return new AppFileHeaderService();
        }
        catch (RuntimeException ex) {
            LOG.error("AppFileMService=>tsc.tsirm.appFileService.getAppFileHeaderService error", (Throwable)ex);
            throw ex;
        }
    }

    public static void showAppFilePortraitForm(IFormView view, Long appFileId) {
        try {
            DynamicObject appFile = AppFileHelper.queryOne(appFileId);
            AppFileFormHelper.showAppFilePortraitForm(view, appFile, "labelshowflex", null);
        }
        catch (RuntimeException ex) {
            LOG.error("AppFileMService=>tsc.tsirm.appFileService.showAppFilePortraitForm error", (Throwable)ex);
            throw ex;
        }
    }

    public static DynamicObject[] getAppFilesByStdMidAndPositionId(List<Long> midList, List<Long> positionIdList, Date applyTime) {
        return AppFileStdRsmHelper.getAppFilesByStdMidAndPositionId(midList, positionIdList, applyTime);
    }
}

