/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.rsmupdate.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mhelper.RsmAppFileHelper;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsirm.common.constants.rsm.RsmAnalysisKDString;
import kd.tsc.tsirm.common.constants.rsm.sr.SrRsmKDString;
import kd.tsc.tsrbs.common.utils.EncryptionDecryptUtil;

public class InviteUpdateService {
    private InviteUpdateService() {
    }

    public static String checkEmailPhone(String phone, String email) {
        boolean checkPhone = HRStringUtils.isNotEmpty((String)phone) && ResumeAnalysisHelper.checkPhone(phone);
        boolean checkEmail = HRStringUtils.isNotEmpty((String)email) && ResumeAnalysisHelper.checkEmail(email);
        boolean checkPhoneEmail = checkPhone || checkEmail;
        String errorMsg = null;
        if (!checkPhoneEmail) {
            errorMsg = RsmAnalysisKDString.errorCPhoneEmail();
        } else if (!checkPhone) {
            errorMsg = RsmAnalysisKDString.errorCPhone();
        } else if (!checkEmail) {
            errorMsg = RsmAnalysisKDString.errorCEmail();
        }
        return errorMsg;
    }

    public static String checkEmail(String email) {
        boolean checkEmail;
        boolean bl = checkEmail = HRStringUtils.isNotEmpty((String)email) && ResumeAnalysisHelper.checkEmail(email);
        if (!checkEmail) {
            return RsmAnalysisKDString.errorCEmail();
        }
        return null;
    }

    public static String checkPhone(String phone) {
        boolean checkPhone;
        boolean bl = checkPhone = HRStringUtils.isNotEmpty((String)phone) && ResumeAnalysisHelper.checkPhone(phone);
        if (!checkPhone) {
            return RsmAnalysisKDString.errorCPhone();
        }
        return null;
    }

    public static String getRsmUpdateLink(long objId, String objType, String formId, Map<String, Object> params) {
        String base64Str = SerializationUtils.serializeToBase64((Object)(objId + "" + System.currentTimeMillis()));
        String token = EncryptionDecryptUtil.getEncryptStr((Object)base64Str);
        InviteUpdateService.setTokenCache(objId, objType, token, params);
        String accountId = RequestContext.get().getAccountId();
        String url = String.format("%s?userId=%s&accountId=%s&appNumber=tsc&formId=%s&id=%s", RequestContext.get().getClientFullContextPath(), "guest", accountId, formId, token);
        return url;
    }

    public static void setTokenCache(long objId, String objType, String token, Map<String, Object> params) {
        JSONObject cacheObj = new JSONObject();
        cacheObj.put("sendtime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()).getTime());
        cacheObj.put("updatestatus", (Object)0);
        cacheObj.put("objId", (Object)objId);
        cacheObj.put("objtype", (Object)objType);
        if (!params.isEmpty()) {
            cacheObj.putAll(params);
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        cache.put(InviteUpdateService.getTokenCacheKey(token), (Object)cacheObj.toJSONString(), 604800);
    }

    public static String getTokenCacheKey(String token) {
        return "token_cache_" + token;
    }

    public static String getObjCacheKey(String token) {
        return "bizobj_cache_" + token;
    }

    public static int getValidityTime(int days) {
        return days * 24 * 60 * 60;
    }

    public static boolean beforeSubmitDoOpCheck(IFormView view) {
        String selectProp;
        Long objId = view.getModel().getDataEntity().getLong("objId");
        DynamicObject[] rsmDyArr = RsmHelper.findRsmById(objId, selectProp = "id,fullname,phone,email,appfile");
        if (rsmDyArr == null || rsmDyArr.length == 0) {
            view.showTipNotification(SrRsmKDString.candidateNotExist());
            return false;
        }
        DynamicObject rsmDy = rsmDyArr[0];
        Long appFileId = rsmDy.getLong("appfile");
        DynamicObject appFileDy = RsmAppFileHelper.queryOneById(appFileId, "filestatus");
        if ("B".equals(appFileDy.getString("filestatus"))) {
            view.showTipNotification(SrRsmKDString.dataIsChange());
            return false;
        }
        String name = rsmDy.getString("fullname");
        view.getModel().setValue("fullname", (Object)name);
        String phone = rsmDy.getString("phone");
        String email = rsmDy.getString("email");
        String msgTmpPageId = view.getPageCache().get("temp_pageid");
        IFormView msgTmpView = view.getView(msgTmpPageId);
        String msgChannel = msgTmpView.getModel().getDataEntity().getString("msgchannellist");
        if (HRStringUtils.isNotEmpty((String)msgChannel)) {
            ArrayList msgChannelList = Lists.newArrayList((Object[])msgChannel.split(","));
            String errorMsg = "";
            if (msgChannelList.contains("475773782250774528") && msgChannelList.contains("475773159430184960")) {
                errorMsg = InviteUpdateService.checkEmailPhone(phone, email);
            } else if (msgChannelList.contains("475773782250774528")) {
                errorMsg = InviteUpdateService.checkEmail(email);
            } else if (msgChannelList.contains("475773159430184960")) {
                errorMsg = InviteUpdateService.checkPhone(phone);
            }
            if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                view.showTipNotification(String.format(Locale.ROOT, errorMsg, name));
                return false;
            }
        }
        return true;
    }

    public static boolean beforeCloseDoOpCheck(IFormView view, ConfirmCallBackListener confirmCallBackListener) {
        String msgTmpPageId = view.getPageCache().get("temp_pageid");
        IFormView msgTmpView = view.getView(msgTmpPageId);
        IDataModel msgTmpModel = msgTmpView.getModel();
        if (msgTmpModel.getDataChanged()) {
            String detailMsg = msgTmpModel.getChangeDesc();
            RsmHelper.showDataChangeForm(detailMsg, view, null, confirmCallBackListener);
            return false;
        }
        return true;
    }
}

