/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.rsmupdate.service;

import java.util.Locale;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.rsm.common.mhelper.RsmAppFileHelper;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsirm.common.constants.rsm.sr.SrRsmKDString;

public class RsmUpdateHeadService {
    private RsmUpdateHeadService() {
    }

    public static void setHeadData(IFormView view) {
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        DynamicObject parentDataEntity = parentModel.getDataEntity();
        String fullName = parentDataEntity.getString("fullname");
        RsmUpdateHeadService.setLabelText(view, "fullname", fullName);
        String gender = parentDataEntity.getString("gender");
        String genderDesc = ResumeAnalysisHelper.conversionGender(gender);
        RsmUpdateHeadService.setLabelText(view, "gender", genderDesc);
        int age = parentDataEntity.getInt("age");
        String ageStr = RsmUpdateHeadService.getAgeDesc(age);
        RsmUpdateHeadService.setLabelText(view, "age", ageStr);
        String nationStr = RsmUpdateHeadService.getNationDesc(parentDataEntity);
        RsmUpdateHeadService.setLabelText(view, "nation", nationStr);
        String natregStr = RsmUpdateHeadService.getNatregDesc(parentDataEntity);
        RsmUpdateHeadService.setLabelText(view, "natreg", natregStr);
        String phone = parentDataEntity.getString("phone");
        if (HRStringUtils.isNotEmpty((String)phone)) {
            phone = String.format(Locale.ROOT, SrRsmKDString.phone(), phone);
        }
        RsmUpdateHeadService.setLabelText(view, "phone", phone);
        String email = parentDataEntity.getString("email");
        if (HRStringUtils.isNotEmpty((String)email)) {
            email = String.format(Locale.ROOT, SrRsmKDString.email(), email);
        }
        RsmUpdateHeadService.setLabelText(view, "email", email);
        RsmUpdateHeadService.showPhoto(view, parentDataEntity);
        RsmUpdateHeadService.showPositionName(parentView, parentDataEntity, view);
        view.sendFormAction(parentView);
        String showWorkingYears = parentDataEntity.getString("showworkingyears");
        RsmUpdateHeadService.setLabelText(view, "showworkingyears", showWorkingYears);
        DynamicObject highestEducationDy = parentDataEntity.getDynamicObject("highesteducation");
        String highestEducationName = null;
        if (null != highestEducationDy) {
            highestEducationName = highestEducationDy.getString("name");
        }
        RsmUpdateHeadService.setLabelText(view, "highesteducation", highestEducationName);
        String highestSpecialty = parentDataEntity.getString("highestspecialty");
        RsmUpdateHeadService.setLabelText(view, "highestspecialty", highestSpecialty);
        String jobStatusName = null;
        DynamicObject jobStatusDy = parentDataEntity.getDynamicObject("jobstatus");
        if (null != jobStatusDy) {
            jobStatusName = jobStatusDy.getString("name");
        }
        RsmUpdateHeadService.setLabelText(view, "jobstatus", jobStatusName);
    }

    private static void showPhoto(IFormView view, DynamicObject parentDataEntity) {
        String imageUtrl = parentDataEntity.getString("photo");
        Image image = (Image)view.getControl("photo");
        if (HRStringUtils.isNotEmpty((String)imageUtrl)) {
            image.setUrl(HRImageUrlUtil.getImageFullUrl((String)imageUtrl));
        }
        if (view.getFormShowParameter().getStatusValue() != OperationStatus.VIEW.getValue()) {
            Tips imageTip = new Tips("text", null, new LocaleString(SrRsmKDString.clickUpImage()), false, null);
            imageTip.setShowIcon(false);
            image.addTips(imageTip);
        }
    }

    private static void showPositionName(IFormView parentView, DynamicObject parentDataEntity, IFormView view) {
        String objType = (String)parentView.getFormShowParameter().getCustomParam("objtype");
        if ("rsm".equals(objType)) {
            long appFileId = parentDataEntity.getLong("appfile");
            DynamicObject appFileDy = RsmAppFileHelper.queryOneById(appFileId);
            String positionName = null;
            if (appFileDy != null) {
                DynamicObject positionDy = appFileDy.getDynamicObject("position");
                positionName = positionDy.getString("name");
            }
            RsmUpdateHeadService.setLabelText(view, "positionname", positionName);
        } else {
            RsmUpdateHeadService.setLabelText(view, "positionlbl", null);
            RsmUpdateHeadService.setLabelText(view, "positionname", null);
        }
    }

    private static void setLabelText(IFormView view, String controlKey, String text) {
        if (HRStringUtils.isEmpty((String)text)) {
            view.setVisible(Boolean.FALSE, new String[]{controlKey});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{controlKey});
            Control control = view.getControl(controlKey);
            if (control instanceof Label) {
                ((Label)control).setText(text);
            }
        }
    }

    private static String getAgeDesc(int age) {
        if (age > 0) {
            return String.format(Locale.ROOT, SrRsmKDString.regAgeYear(), age);
        }
        return "";
    }

    private static String getNationDesc(DynamicObject parentDataEntity) {
        DynamicObject nationDy = parentDataEntity.getDynamicObject("nation");
        if (null == nationDy) {
            return "";
        }
        return nationDy.getString("name");
    }

    private static String getNatregDesc(DynamicObject parentDataEntity) {
        DynamicObject natregDy = parentDataEntity.getDynamicObject("natreg");
        if (null == natregDy) {
            return "";
        }
        return natregDy.getString("name");
    }
}

