/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.form.FieldTip;
import kd.bos.form.IPageCache;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.rsm.service.AdminDivisionHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.domain.rsmmetadata.service.ResumeMetadataService;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;

public class ResumeUtilsHelper {
    private static final Log logger = LogFactory.getLog(ResumeUtilsHelper.class);
    private static final Set<String> NOCHECKUPDATE = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"creator", "createtime", "modifier", "modifytime"}));

    public static HRBaseServiceHelper getServiceHelper(String pageKey) {
        return ServiceHelperCache.getHrBaseServiceHelper((String)pageKey);
    }

    public static List<Object> deserializeObject(IPageCache cache, String cacheKey) {
        String cacheValue = cache.get(cacheKey);
        if (HRStringUtils.isNotEmpty((String)cacheValue)) {
            return JSON.parseArray((String)cacheValue, Object.class);
        }
        return Lists.newArrayListWithExpectedSize((int)0);
    }

    public static List<DynamicObject> deserializeDynamicObject(IPageCache cache, String cacheKey) {
        String expCache = cache.get(cacheKey);
        DynamicObject[] expArr = null;
        if (HRStringUtils.isNotEmpty((String)expCache)) {
            expArr = (DynamicObject[])Arrays.stream(DynamicObjectSerializeUtil.deserialize((String)expCache, (DynamicObjectType)ResumeUtilsHelper.getServiceHelper(cacheKey).generateEmptyDynamicObject().getDynamicObjectType())).toArray(DynamicObject[]::new);
        }
        ArrayList expList = Lists.newArrayListWithCapacity((int)(expArr == null ? 0 : expArr.length));
        if (expArr != null) {
            expList.addAll(Arrays.asList(expArr));
        }
        return expList;
    }

    public static DynamicObject deserialize(IPageCache cache, String cacheKey, String entityId) {
        Object[] objArr;
        String expCache = cache.get(cacheKey);
        if (HRStringUtils.isNotEmpty((String)expCache) && (objArr = DynamicObjectSerializeUtil.deserialize((String)expCache, (DynamicObjectType)ResumeUtilsHelper.getServiceHelper(entityId).generateEmptyDynamicObject().getDynamicObjectType())) != null && objArr.length > 0) {
            return (DynamicObject)objArr[0];
        }
        return null;
    }

    public static void serialize(IPageCache cache, String cacheKey, DynamicObject exp) {
        if (exp == null) {
            return;
        }
        String expStr = DynamicObjectSerializeUtil.serialize((Object[])Lists.newArrayList((Object[])new DynamicObject[]{exp}).toArray(), (DynamicObjectType)exp.getDynamicObjectType());
        cache.put(cacheKey, expStr);
    }

    public static void serializeDynamicObject(IPageCache cache, String cacheKey, List<DynamicObject> expList) {
        if (expList == null || expList.isEmpty()) {
            return;
        }
        DynamicObjectType dot = ServiceHelperCache.getHrBaseServiceHelper((String)cacheKey).generateEmptyDynamicObject().getDynamicObjectType();
        String expStr = DynamicObjectSerializeUtil.serialize((Object[])expList.toArray(), (DynamicObjectType)dot);
        cache.put(cacheKey, expStr);
    }

    public static DynamicObject[] copyDynamicObject(DynamicObject[] objs, boolean isDeep) {
        DynamicObjectCollection coll = new DynamicObjectCollection();
        if (objs != null && objs.length > 0) {
            String entityName = objs[0].getDataEntityType().getName();
            for (DynamicObject obj : objs) {
                DynamicObject taObj = ResumeUtilsHelper.getServiceHelper(entityName).generateEmptyDynamicObject();
                DataEntityPropertyCollection dpc = obj.getDataEntityType().getProperties();
                dpc.forEach(prop -> {
                    Object value;
                    String propName = prop.getName();
                    if (!propName.endsWith("_id") && (value = obj.get(propName)) != null) {
                        if (value instanceof DynamicObject) {
                            DynamicObject dv = (DynamicObject)value;
                            taObj.set(propName, (Object)ResumeUtilsHelper.getServiceHelper(dv.getDynamicObjectType().getName()).loadDynamicObject(new QFilter("id", "=", dv.get("id"))));
                        } else {
                            taObj.set(propName, obj.get(propName));
                        }
                    }
                });
                coll.add((Object)taObj);
            }
        }
        return (DynamicObject[])coll.toArray((Object[])new DynamicObject[coll.size()]);
    }

    public static DynamicObject copyDynamicObject(DynamicObject obj) {
        if (null == obj) {
            return null;
        }
        return ResumeUtilsHelper.copyDynamicObject(new DynamicObject[]{obj}, false)[0];
    }

    public static List<DynamicObject> copyDynamicObject(List<DynamicObject> dys) {
        if (null == dys || dys.size() == 0) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        DynamicObject[] copyDys = ResumeUtilsHelper.copyDynamicObject(dys.toArray(new DynamicObject[dys.size()]), false);
        return Arrays.stream(copyDys).collect(Collectors.toList());
    }

    public static void setExpInfoRsmId(AppResumeBo resumeBo) {
        long rsmId = resumeBo.getRsm().getLong("id");
        for (String entityId : ResumeMetadataService.getAllEntry((String)"tsirm_srrsm", (String)"3")) {
            List dyList = resumeBo.getEntryListIR(entityId);
            if (null == dyList || dyList.size() <= 0) continue;
            dyList.stream().forEach(dy -> {
                dy.set("rsm", (Object)rsmId);
                dy.set("id", (Object)ID.genLongId());
            });
        }
    }

    public static void setModifierAndTime(DynamicObject dy) {
        if (dy != null) {
            Long userId = TSCRequestContext.getUserId();
            Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
            dy.set("modifier", (Object)userId);
            dy.set("modifytime", (Object)now);
        }
    }

    public static void setModifyTime(DynamicObject dy) {
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        dy.set("modifytime", (Object)now);
    }

    public static void setCreateTime(DynamicObject dy) {
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        dy.set("createtime", (Object)now);
        dy.set("modifytime", (Object)now);
    }

    public static AppResumeBo copyResumeBo(AppResumeBo resumeBo) {
        if (null == resumeBo) {
            return null;
        }
        DynamicObject rsm = resumeBo.getRsm();
        rsm = ResumeUtilsHelper.copyDynamicObject(rsm);
        DynamicObject deliveryDy = resumeBo.getDelivery();
        deliveryDy = ResumeUtilsHelper.copyDynamicObject(deliveryDy);
        AppResumeBo copyResumeBo = new AppResumeBo(rsm, deliveryDy);
        for (String pageKey : ResumeMetadataService.getAllEntry((String)"tsirm_srrsm", (String)"3")) {
            List<DynamicObject> rsmExps = resumeBo.getEntryListIR(pageKey);
            rsmExps = ResumeUtilsHelper.copyDynamicObject(rsmExps);
            copyResumeBo.setEntry(pageKey, rsmExps);
        }
        return copyResumeBo;
    }

    public static void copyObj(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys) {
        if (null == fromObj || null == toObj || null == ignoreKeys) {
            return;
        }
        HashSet dirtyIgnoreKeys = Sets.newHashSet(ignoreKeys);
        DataEntityPropertyCollection fromProp = fromObj.getDataEntityType().getProperties();
        DataEntityPropertyCollection toProp = toObj.getDataEntityType().getProperties();
        ignoreKeys.forEach(key -> {
            IDataEntityProperty prop = (IDataEntityProperty)fromProp.get(key);
            if (null == prop) {
                prop = (IDataEntityProperty)toProp.get(key);
            }
            if (null != prop && prop instanceof DynamicComplexProperty) {
                dirtyIgnoreKeys.add(key + "_id");
            }
        });
        HRDynamicObjectUtils.copy((DynamicObject)fromObj, (DynamicObject)toObj, (Set)dirtyIgnoreKeys);
    }

    public static boolean checkAdminDivision(long adminIdL, int adminLevel) {
        DynamicObject levelDy;
        int level;
        DynamicObject adminDivision = AdminDivisionHelper.getAdminDivisionById(adminIdL);
        return adminDivision != null && ((level = (levelDy = adminDivision.getDynamicObject("basedatafield")).getInt("level")) >= adminLevel || !AdminDivisionHelper.haveChildAdminDivision(adminIdL));
    }

    public static FieldTip createFieldTip(String tips, String fieldKey) {
        FieldTip fieldTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, fieldKey, tips);
        fieldTip.setDeleteRule(ResumeUtilsHelper.createDeleteRule(fieldKey));
        return fieldTip;
    }

    public static DeleteRule createDeleteRule(String ... fieldKey) {
        DeleteRule deleteRule = new DeleteRule();
        deleteRule.setAction("isChange");
        deleteRule.setFields(Arrays.asList(fieldKey));
        return deleteRule;
    }

    public static void log(AppResumeBo resumeBo, String method) {
    }

    public static long getId(DynamicObject dy, String propKey) {
        Object obj = dy.get(propKey);
        if (obj == null) {
            return 0L;
        }
        return ResumeUtilsHelper.getId(obj);
    }

    public static long getId(Object obj) {
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id");
        }
        return (Long)obj;
    }

    public static boolean dataIsChanged(DynamicObject oldDy, DynamicObject newDy, boolean emptyIsChanged) {
        if (null == oldDy) {
            return false;
        }
        if (newDy.getDataEntityState().isBizChanged()) {
            for (IDataEntityProperty prop : newDy.getDataEntityState().getBizChangedProperties()) {
                Object oldVal;
                Object val;
                if (HRStringUtils.isEmpty((String)prop.getAlias()) && prop.isDbIgnore() || NOCHECKUPDATE.contains(prop.getName()) || !(null == (val = newDy.get(prop)) || val instanceof String && HRStringUtils.isEmpty((String)((String)val)) || val instanceof Number && ((Number)val).intValue() == 0 ? emptyIsChanged : !Objects.equals(val, oldVal = oldDy.get(prop)))) continue;
                return true;
            }
        }
        return false;
    }
}

