/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.HRHttpResult;
import kd.hr.hbp.common.util.HRHttpClientUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.rsm.service.AnalysisService;
import kd.tsc.tsirm.common.constants.rsm.RsmAnalysisConstants;
import kd.tsc.tsrbs.business.domain.rsm.entity.ResumeInfo;
import kd.tsc.tsrbs.business.domain.rsm.entity.ResumeInvokeOutVo;
import org.apache.commons.io.IOUtils;

public class SHrAnalysisService
implements AnalysisService {
    private static final String REQUEST_URL = "http://wscloud.kingdee.com/ws_analysis/cloud_common/analysis_resume.do";
    private static final Log LOG = LogFactory.getLog(SHrAnalysisService.class);
    private static SHrAnalysisService ygysAnalysisService = new SHrAnalysisService();

    public static SHrAnalysisService getInstance() {
        return ygysAnalysisService;
    }

    private SHrAnalysisService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResumeInfo analysisRsmByFilePath(String path) throws IOException {
        ResumeInfo resumeInfo = null;
        String[] urlArr = path.split("/");
        String fileName = urlArr[urlArr.length - 1];
        InputStream in = null;
        try {
            FileService fs = FileServiceFactory.getAttachmentFileService();
            in = fs.getInputStream(path);
            String encoded = SHrAnalysisService.streamToBase64(in);
            SHrRequestParam sHrRequestParam = new SHrRequestParam();
            String[] fileNameAndExt = fileName.split("\\.");
            sHrRequestParam.setTitle(fileNameAndExt[0]);
            if (fileNameAndExt.length > 1) {
                sHrRequestParam.setExt(fileNameAndExt[1]);
            }
            sHrRequestParam.setIsBase64("1");
            sHrRequestParam.setBody(encoded);
            resumeInfo = this.invokeResumeAnalysis(sHrRequestParam);
            resumeInfo.setFileName(fileName);
            resumeInfo.setResumeStoAdd(path);
        }
        catch (Exception ex) {
            LOG.error("SHrAnalysisService.analysisRsmByFilePath.error", (Throwable)ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.error("SHrAnalysisService.analysisRsmByFilePath.error1", (Throwable)e);
                }
            }
        }
        return resumeInfo;
    }

    private ResumeInfo invokeResumeAnalysis(SHrRequestParam sHrRequestParam) {
        ResumeInvokeOutVo resumeInvokeOutVo = null;
        try {
            resumeInvokeOutVo = this.doPostAndAnalysisData(sHrRequestParam);
        }
        catch (Exception ex) {
            LOG.error("SHrAnalysisService.invokeResumeAnalysis.doPost.error", (Throwable)ex);
        }
        if (resumeInvokeOutVo == null) {
            ResumeInfo returnResumeInfo = new ResumeInfo();
            returnResumeInfo.setResult(RsmAnalysisConstants.RESULT_FALL);
            returnResumeInfo.setResultStatus(500);
            return returnResumeInfo;
        }
        if (resumeInvokeOutVo.getCode() != 0) {
            ResumeInfo returnResumeInfo = new ResumeInfo();
            returnResumeInfo.setResult(resumeInvokeOutVo.getInfo());
            returnResumeInfo.setResultStatus(500);
            return returnResumeInfo;
        }
        return this.generateResumeInfo(resumeInvokeOutVo);
    }

    private ResumeInvokeOutVo doPostAndAnalysisData(SHrRequestParam sHrRequestParam) {
        ResumeInvokeOutVo resumeInvokeOutVo = null;
        HashMap header = Maps.newHashMap();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        HashMap entityMap = Maps.newHashMap();
        entityMap.put("title", sHrRequestParam.getTitle());
        entityMap.put("ext", sHrRequestParam.getExt());
        entityMap.put("isBase64", sHrRequestParam.getIsBase64());
        entityMap.put("body", sHrRequestParam.getBody());
        HRHttpResult hrHttpResult = HRHttpClientUtil.doPost((String)REQUEST_URL, (Map)header, (Map)entityMap);
        if (hrHttpResult.getStatusCode() == 200) {
            Map dataToJson = null;
            try {
                dataToJson = (Map)JSON.parseObject((String)hrHttpResult.getResult(), Map.class);
                resumeInvokeOutVo = new ResumeInvokeOutVo();
                resumeInvokeOutVo.setCode(((Integer)dataToJson.get("code")).intValue());
                resumeInvokeOutVo.setData(JSON.toJSONString(dataToJson.get("data")));
                resumeInvokeOutVo.setInfo((String)dataToJson.get("info"));
            }
            catch (Exception e) {
                LOG.error("SHrAnalysisService.doPostAndAnalysisData.parseObject.error", (Throwable)e);
                return null;
            }
        }
        return resumeInvokeOutVo;
    }

    private static String streamToBase64(InputStream in) {
        byte[] bytes = new byte[]{};
        try {
            bytes = IOUtils.toByteArray((InputStream)in);
        }
        catch (IOException e) {
            LOG.error("streamToBase64.error", (Throwable)e);
        }
        return Base64.getEncoder().encodeToString(bytes);
    }

    private ResumeInfo generateResumeInfo(ResumeInvokeOutVo resumeInvokeOutVo) {
        ResumeInfo returnResumeInfo = new ResumeInfo();
        String resumeInfoStr = resumeInvokeOutVo.getData();
        if (HRStringUtils.isNotEmpty((String)resumeInfoStr)) {
            String resumeInfoJson = SHrAnalysisService.handleToResumeInfoData(resumeInfoStr);
            Gson gson = new Gson();
            try {
                returnResumeInfo = (ResumeInfo)gson.fromJson(resumeInfoJson, ResumeInfo.class);
                returnResumeInfo.setResult(RsmAnalysisConstants.RESULT_SUCCESS);
            }
            catch (JsonSyntaxException e) {
                LOG.error("SHrAnalysisService.resumeInfoStr2gson.error\uff1a", (Throwable)e);
                returnResumeInfo.setResult(RsmAnalysisConstants.RESULT_FALL);
                returnResumeInfo.setResultStatus(500);
            }
            if (HRStringUtils.isEmpty((String)returnResumeInfo.getName()) || HRStringUtils.isEmpty((String)returnResumeInfo.getEmail()) || HRStringUtils.isEmpty((String)returnResumeInfo.getPhone())) {
                returnResumeInfo.setResult(RsmAnalysisConstants.RESULT_NOTFULL);
            } else {
                returnResumeInfo.setResult(RsmAnalysisConstants.RESULT_SUCCESS);
            }
            returnResumeInfo.setResultStatus(200);
        } else {
            returnResumeInfo.setResult(RsmAnalysisConstants.RESULT_FALL);
            returnResumeInfo.setResultStatus(500);
        }
        return returnResumeInfo;
    }

    public static String handleToResumeInfoData(String resumeInvokeOutVoData) {
        if (HRStringUtils.isEmpty((String)resumeInvokeOutVoData)) {
            return "";
        }
        Map resumeInvokeDataMap = (Map)JSON.parseObject((String)resumeInvokeOutVoData, Map.class);
        Map baseInfo = (Map)resumeInvokeDataMap.get("base");
        Map careerInfo = (Map)resumeInvokeDataMap.get("career");
        resumeInvokeDataMap.remove("base");
        resumeInvokeDataMap.remove("career");
        if (baseInfo != null) {
            resumeInvokeDataMap.putAll(baseInfo);
        }
        if (careerInfo != null) {
            resumeInvokeDataMap.putAll(careerInfo);
        }
        return JSON.toJSONString((Object)resumeInvokeDataMap);
    }

    static class SHrRequestParam {
        private String title;
        private String ext;
        private String isBase64;
        private String body;

        SHrRequestParam() {
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getExt() {
            return this.ext;
        }

        public void setExt(String ext) {
            this.ext = ext;
        }

        public String getIsBase64() {
            return this.isBase64;
        }

        public void setIsBase64(String isBase64) {
            this.isBase64 = isBase64;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }
    }
}

