/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.service;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.rsm.service.AnalysisService;
import kd.tsc.tsirm.common.constants.rsm.RsmAnalysisConstants;
import kd.tsc.tsirm.common.constants.rsm.RsmAnalysisKDString;
import kd.tsc.tsrbs.business.domain.rsm.entity.ResumeInfo;
import kd.tsc.tsrbs.business.domain.rsm.entity.ResumeInvokeInVo;
import kd.tsc.tsrbs.business.domain.rsm.entity.ResumeInvokeOutVo;
import kd.tsc.tsrbs.common.enums.rsm.YGYSErrorTypeEnum;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jsoup.Jsoup;
import org.jsoup.select.Elements;

public class YGYSAnalysisService
implements AnalysisService {
    private static final String RETURNXMLNODE = "TransResumeByJsonStringForFileBase64PhotoResult";
    private static final Log LOG = LogFactory.getLog(YGYSAnalysisService.class);
    private static YGYSAnalysisService ygysAnalysisService = new YGYSAnalysisService();
    private static ThreadPool rsmFileThreadPool = ThreadPools.newCachedThreadPool((String)"rsmfile", (String)"tsirm");

    public static YGYSAnalysisService getInstance() {
        return ygysAnalysisService;
    }

    private YGYSAnalysisService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResumeInfo analysisRsmByFilePath(String path) {
        ResumeInfo resumeInfo = null;
        String[] urlArr = path.split("/");
        String fileName = urlArr[urlArr.length - 1];
        FileService fs = FileServiceFactory.getAttachmentFileService();
        InputStream in = null;
        try {
            in = fs.getInputStream(path);
            String encoded = YGYSAnalysisService.streamToBase64(in);
            ResumeInvokeInVo resumeInvokeInVo = new ResumeInvokeInVo();
            resumeInvokeInVo.setContent(encoded);
            resumeInvokeInVo.setExt(fileName.substring(fileName.lastIndexOf(46) + 1));
            resumeInfo = this.invokeResumeAnalysis(resumeInvokeInVo);
            resumeInfo.setFileName(fileName);
            resumeInfo.setResumeStoAdd(path);
            this.uploadRsmFile(SerializationUtils.toJsonString((Object)resumeInfo));
        }
        catch (Exception ex) {
            LOG.error("YGYSAnalysisService.analysisRsmByFilePath.error", (Throwable)ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.error("YGYSAnalysisService.analysisRsmByFilePath.error1", (Throwable)e);
                }
            }
        }
        return resumeInfo;
    }

    private ResumeInfo invokeResumeAnalysis(ResumeInvokeInVo resumeInvokeInVo) {
        ResumeInfo returnResumeInfo;
        ResumeInvokeOutVo resumeInvokeOutVo = null;
        try {
            resumeInvokeOutVo = this.doPost(resumeInvokeInVo);
        }
        catch (IOException e) {
            LOG.error("YGYSAnalysisService.invokeResumeAnalysis.doPost.error", (Throwable)e);
        }
        if (resumeInvokeOutVo == null) {
            ResumeInfo returnResumeInfo2 = new ResumeInfo();
            returnResumeInfo2.setResult(RsmAnalysisConstants.RESULT_FALL);
            returnResumeInfo2.setResultStatus(500);
            return returnResumeInfo2;
        }
        if (200 == resumeInvokeOutVo.getCode()) {
            LOG.error("YGYSAnalysisService.HttpStatus.SC_OK");
            returnResumeInfo = this.generateResumeInfo(resumeInvokeOutVo);
            int resultType = returnResumeInfo.getType();
            this.dealAfterSuccess(returnResumeInfo, resultType);
        } else {
            LOG.error("YGYSAnalysisService.HttpStatus.RESULT_FALL");
            returnResumeInfo = new ResumeInfo();
            returnResumeInfo.setResult(RsmAnalysisConstants.RESULT_FALL);
            returnResumeInfo.setResultStatus(500);
        }
        return returnResumeInfo;
    }

    private void dealAfterSuccess(ResumeInfo returnResumeInfo, int resultType) {
        if (0 == resultType) {
            String errorCode = returnResumeInfo.getName();
            YGYSErrorTypeEnum resultTypeEnum = YGYSErrorTypeEnum.valueOf((String)errorCode);
            if (HRStringUtils.equals((String)errorCode, (String)String.valueOf(YGYSErrorTypeEnum.E002.value()))) {
                returnResumeInfo.setResult(RsmAnalysisConstants.RESULT_FALL + "\uff0c" + resultTypeEnum.getDes());
            } else {
                String resuleMsg = RsmAnalysisKDString.failAndContact();
                resuleMsg = String.format(resuleMsg, RsmAnalysisConstants.RESULT_FALL, errorCode, resultTypeEnum.getDes());
                returnResumeInfo.setResult(resuleMsg);
            }
            returnResumeInfo.setResultStatus(500);
            returnResumeInfo.setName(null);
        } else {
            LOG.error("YGYSAnalysisService.returnResumeInfo.name{}", (Object)returnResumeInfo.getName());
            if (HRStringUtils.isEmpty((String)returnResumeInfo.getName()) || HRStringUtils.isEmpty((String)returnResumeInfo.getEmail()) || HRStringUtils.isEmpty((String)returnResumeInfo.getPhone())) {
                returnResumeInfo.setResult(RsmAnalysisConstants.RESULT_NOTFULL);
            } else {
                returnResumeInfo.setResult(RsmAnalysisConstants.RESULT_SUCCESS);
            }
            returnResumeInfo.setResultStatus(200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResumeInvokeOutVo doPost(ResumeInvokeInVo resumeInvokeInVo) throws IOException {
        ResumeInvokeOutVo resumeInvokeOutVo = new ResumeInvokeOutVo();
        String soap = this.getRequestPropertySoap(resumeInvokeInVo);
        if (HRStringUtils.isEmpty((String)soap)) {
            return null;
        }
        String domain = "http://10.244.4.52/ResumeService.asmx?op=";
        URL soapUrl = new URL(domain);
        URLConnection conn = soapUrl.openConnection();
        InputStream is = null;
        OutputStream os = null;
        if (conn == null) {
            return null;
        }
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Length", Integer.toString(soap.length()));
        conn.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
        conn.setRequestProperty("ResumeService", "TransResumeByJsonStringForFileBase64Photo");
        os = conn.getOutputStream();
        try (OutputStreamWriter osw = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
            osw.write(soap);
            osw.flush();
            is = conn.getInputStream();
            byte[] bytes = YGYSAnalysisService.readInputStream(is);
            String str = new String(bytes, StandardCharsets.UTF_8);
            this.uploadRsmFile(str);
            String result = this.format(str);
            resumeInvokeOutVo.setCode(200);
            resumeInvokeOutVo.setData(result);
            resumeInvokeOutVo.setInfo(RsmAnalysisConstants.RESULT_SUCCESS);
        }
        catch (Exception e) {
            LOG.error("YGYSAnalysisService.readBytes.error", (Throwable)e);
            resumeInvokeOutVo.setCode(500);
            resumeInvokeOutVo.setInfo(RsmAnalysisConstants.RESULT_FALL);
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
                if (null != os) {
                    os.close();
                }
            }
            catch (IOException e) {
                LOG.error("YGYSAnalysisService.release.resource.error", (Throwable)e);
            }
        }
        return resumeInvokeOutVo;
    }

    private String getRequestPropertySoap(ResumeInvokeInVo resumeInvokeInVo) {
        StringBuilder sendSoapString = new StringBuilder();
        sendSoapString.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        sendSoapString.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        sendSoapString.append("   <soap:Body>");
        sendSoapString.append("      <TransResumeByJsonStringForFileBase64Photo xmlns=\"http://tempuri.org/\">");
        sendSoapString.append("        <username>none</username>");
        sendSoapString.append("        <pwd>none</pwd>");
        sendSoapString.append("        <content>").append(resumeInvokeInVo.getContent()).append("</content>");
        sendSoapString.append("        <ext>").append(resumeInvokeInVo.getExt()).append("</ext>");
        sendSoapString.append("      </TransResumeByJsonStringForFileBase64Photo>");
        sendSoapString.append("   </soap:Body>");
        sendSoapString.append("</soap:Envelope>");
        return sendSoapString.toString();
    }

    private static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int len;
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    private String format(String str) {
        Elements el = Jsoup.parse((String)str).getElementsByTag(RETURNXMLNODE);
        return el.html();
    }

    private void uploadRsmFile(String resumeInfoStr) {
        rsmFileThreadPool.execute((Runnable)new RsmFileThread(resumeInfoStr));
    }

    public void doUploadRsmFile(String resumeInfoStr) {
        File file = new File(FileUtils.getTempDirectory(), UUID.randomUUID() + ".txt");
        try {
            FileUtils.writeStringToFile((File)file, (String)resumeInfoStr, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            LOG.error("doUploadRsmFile error", (Throwable)ex);
        }
        try (FileInputStream is = new FileInputStream(file);){
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(file.getName(), (InputStream)is, 5000);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private static String streamToBase64(InputStream in) {
        byte[] bytes = new byte[]{};
        try {
            bytes = IOUtils.toByteArray((InputStream)in);
        }
        catch (IOException e) {
            LOG.error("streamToBase64.error", (Throwable)e);
        }
        return Base64.getEncoder().encodeToString(bytes);
    }

    private ResumeInfo generateResumeInfo(ResumeInvokeOutVo resumeInvokeOutVo) {
        ResumeInfo returnResumeInfo = new ResumeInfo();
        String resumeInfoStr = resumeInvokeOutVo.getData();
        if (HRStringUtils.isNotEmpty((String)resumeInfoStr)) {
            Gson gson = new Gson();
            try {
                returnResumeInfo = (ResumeInfo)gson.fromJson(resumeInfoStr, ResumeInfo.class);
                returnResumeInfo.setResult(RsmAnalysisConstants.RESULT_SUCCESS);
            }
            catch (JsonSyntaxException e) {
                LOG.error("YGYSAnalysisService.resumeInfoStr2gson.error\uff1a", (Throwable)e);
                returnResumeInfo.setResult(RsmAnalysisConstants.RESULT_FALL);
                returnResumeInfo.setResultStatus(500);
            }
        } else {
            returnResumeInfo.setResult(RsmAnalysisConstants.RESULT_FALL);
            returnResumeInfo.setResultStatus(500);
        }
        return returnResumeInfo;
    }

    class RsmFileThread
    implements Runnable {
        private String resumeInfoStr;

        public RsmFileThread(String resumeInfoStr) {
            this.resumeInfoStr = resumeInfoStr;
        }

        @Override
        public void run() {
            YGYSAnalysisService.this.doUploadRsmFile(this.resumeInfoStr);
        }
    }
}

