/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.sr.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.intv.service.ai.InterviewAiService;
import kd.tsc.tsirm.business.domain.rsm.common.RsmCommonService;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RDeliveryHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.ResumeBoHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mhelper.RsmAppFileHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mhelper.RsmPositionHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tsirm.business.domain.rsm.sr.service.AddResumeService;
import kd.tsc.tsirm.business.domain.rsm.sr.service.AfterTransHandlerService;
import kd.tsc.tsirm.business.domain.rsm.sr.service.ResumeLockService;
import kd.tsc.tsirm.business.domain.stdrsm.handler.adapt.StdRsmAdapt;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tsirm.common.constants.rsm.ResumeConstants;
import kd.tsc.tsirm.common.constants.rsm.sr.SrRsmKDString;
import kd.tsc.tsirm.common.constants.talentpool.TSTPMTalentPoolConstants;
import kd.tsc.tsrbd.business.domain.rsmmetadata.service.ResumeMetadataService;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveAppFileResult;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;
import kd.tsc.tsrbs.common.enums.rsm.RsmSourceEnum;
import kd.tsc.tsrbs.common.exception.TSCBizException;

public class AddResumeHandleService {
    private static final Log logger = LogFactory.getLog(AddResumeHandleService.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"AddResumeHandleService", (int)2, (int)20, (String)"tsc");
    private static AddResumeHandleService addResumeHandleService = new AddResumeHandleService();
    private static final Set<String> RSM_SOURCE_NOT_UPDATE_STD = Sets.newHashSet((Object[])new String[]{RsmSourceEnum.TP.getCode(), RsmSourceEnum.RP.getCode()});

    public static AddResumeHandleService getInstance() {
        return addResumeHandleService;
    }

    public SaveCandidateResult handle(AppResumeBo resumeBo, DynamicObject positionDt, Boolean isLock) {
        return this.handle(resumeBo, positionDt, isLock, null);
    }

    public SaveCandidateResult handle(AppResumeBo resumeBo, DynamicObject positionDt, Boolean isLock, ResumeTypeEnum resumeTypeEnum) {
        SaveCandidateResult result;
        boolean isExist;
        DynamicObject rsm = resumeBo.getRsm();
        List<String> lockKeyList = null;
        TXHandle txHandle = TX.requiresNew();
        try {
            if (Boolean.TRUE.equals(isLock)) {
                lockKeyList = ResumeLockService.getLockKey(rsm);
                ResumeLockService.lock(lockKeyList);
            }
            rsm.getDataEntityState().setFromDatabase(false);
            ResumeUtilsHelper.log(resumeBo, "AddResumeHandleService.handle");
            DynamicObject stdRsmDy = AddResumeService.isExistStandResume(resumeBo);
            resumeBo.setPosition(positionDt);
            boolean bl = isExist = stdRsmDy != null;
            if (isExist) {
                Long candidateId = ResumeUtilsHelper.getId(stdRsmDy);
                resumeBo.getRsm().set("stdrsm", (Object)candidateId);
                result = this.handleHaveCandidate(resumeBo, positionDt, candidateId);
                if (!RSM_SOURCE_NOT_UPDATE_STD.contains(resumeBo.getRsm().getString("rsmsource")) && result.isSuccess()) {
                    AddResumeService.diffUpdateStandResume(candidateId, resumeBo, resumeTypeEnum);
                }
            } else {
                Map<String, Long> saveResult = AddResumeService.addStandResume(resumeBo, resumeTypeEnum);
                Long candidateId = saveResult.get("id");
                resumeBo.getRsm().set("stdrsm", (Object)candidateId);
                result = this.handleNotHaveCandidate(resumeBo, positionDt, candidateId);
            }
        }
        catch (Exception e) {
            logger.error("AddResumeHandleService.handle.error", (Throwable)e);
            txHandle.markRollback();
            throw new TSCBizException((Throwable)e);
        }
        finally {
            txHandle.close();
            if (null != lockKeyList) {
                ResumeLockService.unLock(lockKeyList);
            }
        }
        Long appFileId = result.getAppFileId();
        if (appFileId != null) {
            DynamicObject appFile = AppFileHelper.queryOne(appFileId);
            InterviewAiService.getInstance().updateAllAppFileAi(appFile);
        }
        AfterTransHandlerService handlerAfterAddRsm = new AfterTransHandlerService(result, positionDt, resumeBo, isExist);
        ResumeConstants.threadPool.execute((Runnable)handlerAfterAddRsm);
        if (!isExist) {
            StdRsmAdapt.engine(resumeBo);
        }
        return result;
    }

    public SaveCandidateResult handleNoUpdateStdRsm(AppResumeBo resumeBo, DynamicObject positionDt, Boolean isLock) {
        SaveCandidateResult saveCandidateResult;
        block8: {
            Long candidateId = resumeBo.getRsm().getLong("stdrsm");
            saveCandidateResult = null;
            List<String> lockKeyList = null;
            TXHandle tx = TX.required();
            try {
                if (Boolean.TRUE.equals(isLock)) {
                    lockKeyList = ResumeLockService.getLockKey(resumeBo.getRsm());
                    ResumeLockService.lock(lockKeyList);
                }
                logger.info("AddResumeService.manualSaveAppFile start");
                long start = System.currentTimeMillis();
                SaveAppFileResult saveAppFileRes = AddResumeService.manualSaveAppFile(candidateId, resumeBo, positionDt);
                logger.info("AddResumeService.manualSaveAppFile cost {}", (Object)(System.currentTimeMillis() - start));
                if (saveAppFileRes.isSuccess()) {
                    resumeBo.getRsm().set("appfile", (Object)saveAppFileRes.getAppFileId());
                    AddResumeService.saveAppRsm(resumeBo);
                    saveCandidateResult = this.initSaveCandidateResult(true, saveAppFileRes.getAppFileId(), resumeBo.getRsm().getLong("id"), candidateId);
                    break block8;
                }
                SaveCandidateResult saveCandidateResult2 = saveCandidateResult = this.initSaveCandidateResult(false, saveAppFileRes.getAppFileId(), resumeBo.getRsm().getLong("id"), candidateId);
                return saveCandidateResult2;
            }
            catch (Exception ex) {
                logger.error("AddResumeHandleService.handleNoUpdateStdRsm.error", (Throwable)ex);
                tx.markRollback();
                throw new TSCBizException((Throwable)ex);
            }
            finally {
                tx.close();
                if (null != lockKeyList) {
                    ResumeLockService.unLock(lockKeyList);
                }
            }
        }
        AfterTransHandlerService handlerAfterAddRsm = new AfterTransHandlerService(saveCandidateResult, positionDt, resumeBo, true);
        THREAD_POOL.execute((Runnable)handlerAfterAddRsm);
        return saveCandidateResult;
    }

    private SaveCandidateResult handleHaveCandidate(AppResumeBo resumeBo, DynamicObject positionDt, Long candidateId) {
        SaveCandidateResult result;
        String rsmSource = resumeBo.getRsm().getString("rsmsource");
        long rsmId = resumeBo.getRsm().getLong("id");
        if (positionDt != null) {
            SaveAppFileResult saveAppFileRes = AddResumeService.manualSaveAppFile(candidateId, resumeBo, positionDt);
            long appFileId = saveAppFileRes.getAppFileId();
            ResumeBoHelper.setDeliveryIsDisplayNew(appFileId, resumeBo);
            if (saveAppFileRes.isSuccess()) {
                resumeBo.getRsm().set("appfile", (Object)appFileId);
                AddResumeService.saveAppRsm(resumeBo);
                result = this.initSaveCandidateResult(true, appFileId, rsmId, candidateId);
            } else if (RsmSourceEnum.EMAIL.getCode().equals(rsmSource)) {
                AddResumeService.saveAppRsm(resumeBo);
                result = this.initSaveCandidateResult(true, appFileId, rsmId, candidateId);
            } else {
                logger.error("AddResumeHandleService.handleHaveCandidate add appfile fail");
                result = this.initSaveCandidateResult(false, appFileId, rsmId, candidateId);
            }
        } else {
            logger.error("AddResumeHandleService.handleHaveCandidate have no position");
            if (RsmSourceEnum.EMAIL.getCode().equals(rsmSource)) {
                logger.error("AddResumeHandleService.handleHaveCandidate have no position,Rsm Source Email");
                ResumeBoHelper.setDeliveryIsDisplayNew(0L, resumeBo);
                AddResumeService.saveAppRsm(resumeBo);
                logger.error("AddResumeHandleService.handleHaveCandidate have no position,Rsm Source Email handler Success");
            } else {
                resumeBo.getRsm().set("appfile", null);
                AddResumeService.saveAppRsm(resumeBo);
            }
            result = this.initSaveCandidateResult(true, null, rsmId, candidateId);
        }
        if (result.getAppFileId() != null && result.getRsmId() != null) {
            DynamicObject appFile = AppFileHelper.queryOne(result.getAppFileId());
            InterviewAiService.getInstance().updateAllAppFileAi(appFile);
        }
        return result;
    }

    private SaveCandidateResult handleNotHaveCandidate(AppResumeBo resumeBo, DynamicObject positionDt, Long candidateId) {
        Long appFileId = null;
        if (positionDt != null) {
            SaveAppFileResult saveAppFileRes = AddResumeService.manualSaveAppFile(candidateId, resumeBo, positionDt);
            appFileId = saveAppFileRes.getAppFileId();
            resumeBo.getRsm().set("appfile", (Object)saveAppFileRes.getAppFileId());
        } else {
            ResumeBoHelper.setDeliveryDisplayFalse(resumeBo);
        }
        AddResumeService.saveAppRsm(resumeBo);
        SaveCandidateResult result = this.initSaveCandidateResult(true, appFileId, resumeBo.getRsm().getLong("id"), candidateId);
        if (result.getAppFileId() != null && result.getRsmId() != null) {
            DynamicObject appFile = AppFileHelper.queryOne(result.getAppFileId());
            InterviewAiService.getInstance().updateAllAppFileAi(appFile);
        }
        return result;
    }

    private SaveCandidateResult initSaveCandidateResult(boolean isSuccess, Long appFileId, Long rsmId, Long stdRsmId) {
        SaveCandidateResult result = new SaveCandidateResult();
        if (isSuccess) {
            result.setMessage(SrRsmKDString.submitSuccess());
        } else {
            result.setMessage(SrRsmKDString.submitFailRepeat());
            result.setErrorType("C");
        }
        result.setSuccess(isSuccess);
        result.setAppFileId(appFileId);
        result.setRsmId(rsmId);
        result.setStdRsmId(stdRsmId);
        return result;
    }

    public List<SaveCandidateResult> handleUnAllocatedRsm(Long rsmId, List<Long> positionIds) {
        AppResumeBo appResumeBo = ResumeBoHelper.getAppResumeBo(rsmId);
        if (appResumeBo == null) {
            return Lists.newArrayList();
        }
        ResumeBoHelper.loadAllListData(appResumeBo);
        for (String pageKey : ResumeMetadataService.getAllEntry((String)"tsirm_srrsm", (String)"3")) {
            List<DynamicObject> rsmExps = appResumeBo.getEntryListIR(pageKey);
            rsmExps = ResumeUtilsHelper.copyDynamicObject(rsmExps);
            appResumeBo.setEntry(pageKey, rsmExps);
        }
        Long stdRsmId = appResumeBo.getRsm().getLong("stdrsm");
        DynamicObject[] positions = RsmPositionHelper.getPositionObjByPositionIds(positionIds);
        List positionList = positionIds.stream().map(id -> Arrays.stream(positions).filter(pos -> id.equals(pos.getLong("id"))).findFirst().orElse(null)).collect(Collectors.toList());
        appResumeBo.getDelivery().set("isfiledisplay", (Object)Boolean.TRUE);
        ArrayList appResumeBoList = Lists.newArrayList((Object[])new AppResumeBo[]{appResumeBo});
        for (int i = 1; i < positionList.size() - 1; ++i) {
            AppResumeBo copyResumeBo = ResumeBoHelper.copy(appResumeBo);
            copyResumeBo.getDelivery().set("applytime", appResumeBo.getDelivery().get("applytime"));
            appResumeBoList.add(copyResumeBo);
        }
        ArrayList<SaveCandidateResult> results = new ArrayList<SaveCandidateResult>(appResumeBoList.size());
        try (TXHandle tx = TX.required();){
            try {
                int index = 0;
                for (AppResumeBo resumeBo : appResumeBoList) {
                    resumeBo.getDelivery().set("assignstatus", (Object)"1");
                    SaveCandidateResult saveCandidateResult = this.handleHaveCandidate(resumeBo, (DynamicObject)positionList.get(index), stdRsmId);
                    results.add(saveCandidateResult);
                    AppFileMService.afterAppFileSaveHandle(saveCandidateResult, (DynamicObject)positionList.get(index), resumeBo);
                    ++index;
                }
            }
            catch (RuntimeException ex) {
                logger.error("handleUnAllocatedRsm.error", (Throwable)ex);
                tx.markRollback();
                throw ex;
            }
        }
        return results;
    }

    public static void rsmUpdate(AppResumeBo resumeBo) {
        DynamicObject rsmDy = resumeBo.getRsm();
        long rsmId = rsmDy.getLong("id");
        DynamicObject oldRsmDy = RsmHelper.findOne(rsmId);
        ResumeUtilsHelper.copyObj(rsmDy, oldRsmDy, Sets.newHashSet((Object[])new String[]{"id", "number", "createtime", "creator", "appfile", "delivery", "stdrsm", "rsmsource"}));
        resumeBo.setRsm(oldRsmDy);
        DynamicObject appFileDy = RsmAppFileHelper.findAppFileByRsmId(rsmId);
        RsmCommonService.updateAppFileByAppResume(appFileDy, resumeBo);
        ResumeUtilsHelper.setExpInfoRsmId(resumeBo);
        long stdRsmId = oldRsmDy.getLong("stdrsm");
        ResumeUtilsHelper.setModifyTime(rsmDy);
        AddResumeHandleService.rsmUpdateTx(appFileDy, resumeBo, stdRsmId, ResumeTypeEnum.INVITE_UPDATE, true);
        RsmCommonHelper.outTransaction(rsmId, Boolean.TRUE);
    }

    public static void stdRsmUpdate(AppResumeBo resumeBo) {
        DynamicObject rsmDy = resumeBo.getRsm();
        long stdRsmId = rsmDy.getLong("id");
        DynamicObject stdRsmDy = StandardResumeDataHelper.queryOne(stdRsmId);
        if (null != stdRsmDy) {
            stdRsmId = stdRsmDy.getLong("mid");
            DynamicObject deliveryDy = RDeliveryHelper.getLastDeliveryByStdRsmId(stdRsmId);
            resumeBo.setDelivery(deliveryDy);
            long rsmId = ID.genLongId();
            rsmDy.set("id", (Object)rsmId);
            rsmDy.set("delivery", (Object)deliveryDy);
            rsmDy.set("stdrsm", (Object)stdRsmId);
            ResumeUtilsHelper.setExpInfoRsmId(resumeBo);
            ResumeUtilsHelper.setCreateTime(rsmDy);
            AddResumeHandleService.rsmUpdateTx(null, resumeBo, stdRsmId, ResumeTypeEnum.INVITE_UPDATE, true);
            RsmCommonHelper.outTransaction(rsmId, Boolean.TRUE);
        }
    }

    public static void stdRsmDeliver(AppResumeBo resumeBo, Long positionId) {
        Long appFileId;
        DynamicObject rsmDy = resumeBo.getRsm();
        Long stdRsmId = resumeBo.getRsm().getLong("id");
        DynamicObject stdRsmDy = StandardResumeDataHelper.queryOne(stdRsmId);
        stdRsmId = stdRsmDy.getLong("mid");
        DynamicObject deliveryDy = RDeliveryHelper.getStdRsmDeliverDelivery();
        long rsmId = ID.genLongId();
        rsmDy.set("id", (Object)rsmId);
        rsmDy.set("delivery", (Object)deliveryDy);
        ResumeUtilsHelper.setExpInfoRsmId(resumeBo);
        ResumeUtilsHelper.setCreateTime(rsmDy);
        resumeBo.setDelivery(deliveryDy);
        DynamicObject positionDy = RsmPositionHelper.queryOneById(positionId);
        resumeBo.setPosition(positionDy);
        boolean isUpdate = true;
        try (TXHandle tx = TX.required();){
            String dataStatus = stdRsmDy.getString("datastatus");
            if (ResumeHisDataStatusEnum.DELETED.getStatus().equals(dataStatus)) {
                Map<String, Long> saveResult = AddResumeService.addStandResume(resumeBo, ResumeTypeEnum.INVITE);
                stdRsmId = saveResult.get("id");
                isUpdate = false;
            }
            rsmDy.set("stdrsm", (Object)stdRsmId);
            SaveAppFileResult saveAppFileResult = AddResumeService.saveNewAppFile(stdRsmId, resumeBo, positionDy);
            appFileId = saveAppFileResult.getAppFileId();
            rsmDy.set("appfile", (Object)appFileId);
            if (appFileId != null) {
                DynamicObject appFile = AppFileHelper.queryOne(appFileId);
                InterviewAiService.getInstance().updateAllAppFileAi(appFile);
            }
            AddResumeHandleService.rsmUpdateTx(null, resumeBo, stdRsmId, ResumeTypeEnum.INVITE, isUpdate);
        }
        if (!isUpdate) {
            ArrayList<Long> stdRsmIds = new ArrayList<Long>(1);
            stdRsmIds.add(stdRsmId);
            TalentListFunService.saveCandidate2UnClassFy(stdRsmIds, TSTPMTalentPoolConstants.ON_JOB_TP_ALLOCATED);
        }
        RsmCommonHelper.outTransaction(rsmId, Boolean.TRUE);
        if (appFileId != null) {
            AppFileMService.afterAppFileSaveHandle(appFileId, rsmId, positionDy, resumeBo);
        }
        StdRsmAdapt.engine(resumeBo);
    }

    private static void rsmUpdateTx(DynamicObject appFileDy, AppResumeBo resumeBo, long stdRsmId, ResumeTypeEnum resumeTypeEnum, boolean isUpdate) {
        try (TXHandle tx = TX.required();){
            RDeliveryHelper.saveDelivery(resumeBo.getDelivery());
            ResumeBoHelper.saveOneRsm(resumeBo.getRsm());
            ResumeBoHelper.handlerSubForm(resumeBo);
            if (null != appFileDy) {
                AppFileMService.save(new DynamicObject[]{appFileDy});
            }
            if (isUpdate) {
                resumeBo.getRsm().getDataEntityState().setFromDatabase(true);
                AddResumeService.diffUpdateStandResume(stdRsmId, resumeBo, resumeTypeEnum);
            }
        }
    }
}

