/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.sr.service;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tsirm.business.domain.rsm.common.RsmCommonService;
import kd.tsc.tsirm.business.domain.rsm.common.helper.ResumeBoHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mhelper.RsmAppFileHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mhelper.RsmPositionHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tsirm.business.domain.rsm.common.mservice.PositionMService;
import kd.tsc.tsirm.business.domain.stdrsm.handler.adapt.StdRsmAdapt;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveAppFileResult;
import kd.tsc.tsrbs.common.enums.rsm.YesOrNotEnum;

public class AddResumeService {
    private static final Log logger = LogFactory.getLog(AddResumeService.class);
    public static final String PROP_QUERY_APPFILE = "id,isbinddelyrec,highesteduschool,highesteducation,appres,modifier,modifytime,birthday,jobstatus,phone,email";

    public static DynamicObject isExistStandResume(AppResumeBo appResumeBo) {
        long stdRsmId = appResumeBo.getRsm().getLong("stdrsm");
        if (stdRsmId > 0L) {
            return StdRsmServiceHelper.getStdRsmByMid("tsirm_stdrsm", stdRsmId);
        }
        return StdRsmAdapt.isExistStandResume(appResumeBo);
    }

    public static Map<String, Long> addStandResume(AppResumeBo appResumeBo, ResumeTypeEnum resumeTypeEnum) {
        return StdRsmAdapt.addStandResume(appResumeBo, resumeTypeEnum);
    }

    public static void diffUpdateStandResume(Long stdRsmId, AppResumeBo appResumeBo) {
        AddResumeService.diffUpdateStandResume(stdRsmId, appResumeBo, ResumeTypeEnum.APP_FILE_UPDATE);
    }

    public static void diffUpdateStandResume(Long stdRsmId, AppResumeBo appResumeBo, ResumeTypeEnum resumeTypeEnum) {
        DynamicObject deliveryDy;
        Long appFileId;
        DynamicObject appFileDy;
        appResumeBo.getRsm().set("number", null);
        DynamicObject positionDy = appResumeBo.getPosition();
        if (HRObjectUtils.isEmpty((Object)positionDy) && !HRObjectUtils.isEmpty((Object)(appFileDy = RsmAppFileHelper.queryOneById(appFileId = Long.valueOf(appResumeBo.getRsm().getLong("appfile")))))) {
            positionDy = appFileDy.getDynamicObject("position");
            appResumeBo.setPosition(positionDy);
        }
        if (HRObjectUtils.isEmpty((Object)(deliveryDy = appResumeBo.getDelivery()))) {
            deliveryDy = RsmCommonService.getDelivery(appResumeBo.getRsm());
            appResumeBo.setDelivery(deliveryDy);
        }
        StdRsmAdapt.diffUpdateStandResume(stdRsmId, appResumeBo, resumeTypeEnum);
    }

    public static void updatePositionCandidateNumber(DynamicObject positionDt) {
        try {
            Long candidateNum = RsmPositionHelper.getCountBySinglePositionId(positionDt.getLong("id"));
            PositionMService.updateCandidateNumByPositionId(positionDt.getLong("id"), candidateNum);
        }
        catch (Exception e) {
            logger.error("AddResumeBizServiceHelper.AddResumeSaveThreadPool.updateCandidateNumByPositionId.error", (Throwable)e);
        }
    }

    public static DynamicObject generateDeliveryDt(Object media, Object appmthd, Object resacqMthd, Object recruchnlnm) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsirm_srrdelivery");
        DynamicObject deliveryDt = hrBaseServiceHelper.generateEmptyDynamicObject();
        Long userId = TSCRequestContext.getUserId();
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        deliveryDt.set("id", (Object)ID.genLongId());
        deliveryDt.set("applytime", (Object)nowTime);
        deliveryDt.set("recruchnlmedia", media);
        deliveryDt.set("appmthd", appmthd);
        deliveryDt.set("resacqmthd", resacqMthd);
        deliveryDt.set("recruchnlnm", recruchnlnm);
        deliveryDt.set("isfiledisplay", (Object)YesOrNotEnum.YES.toString());
        deliveryDt.set("deliveryper", (Object)userId);
        deliveryDt.set("creator", (Object)userId);
        deliveryDt.set("createtime", (Object)nowTime);
        deliveryDt.set("modifier", (Object)userId);
        deliveryDt.set("modifytime", (Object)nowTime);
        deliveryDt.set("assignstatus", (Object)"1");
        return deliveryDt;
    }

    public static SaveAppFileResult manualSaveAppFile(Long candidateId, AppResumeBo appResumeBo, DynamicObject positionDt) {
        logger.info("start to manualSaveAppFile getAppFileByStdRsmMidAndPositionId");
        long start = System.currentTimeMillis();
        DynamicObject appFileDt = RsmHelper.getAppFileByStdRsmMidAndPositionId(candidateId, positionDt.getLong("id"), ResumeBoHelper.getDelivery(appResumeBo).getDate("applytime"));
        logger.info("start to manualSaveAppFile getAppFileByStdRsmMidAndPositionId cost {}", (Object)(System.currentTimeMillis() - start));
        if (null == appFileDt) {
            return AddResumeService.saveNewAppFile(candidateId, appResumeBo, positionDt);
        }
        SaveAppFileResult result = new SaveAppFileResult();
        result.setSuccess(false);
        result.setAppFileId(Long.valueOf(appFileDt.getLong("id")));
        result.setNewAppFile(false);
        return result;
    }

    public static SaveAppFileResult saveNewAppFile(Long candidateId, AppResumeBo appResumeBo, DynamicObject positionDt) {
        SaveAppFileResult result = new SaveAppFileResult();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_appfile_view");
        DynamicObject appFileDt = helper.generateEmptyDynamicObject();
        result.setAppFileId(Long.valueOf(ORM.create().genLongId(helper.getEntityName())));
        result.setSuccess(true);
        result.setNewAppFile(true);
        appFileDt.set("id", (Object)result.getAppFileId());
        appFileDt.set("stdrsm", (Object)candidateId);
        appFileDt.set("deliveryrec", (Object)ResumeBoHelper.getDelivery(appResumeBo));
        appFileDt.set("position", (Object)positionDt);
        appFileDt.set("appres", (Object)appResumeBo.getRsm().getLong("id"));
        appFileDt.set("employeenum", (Object)appResumeBo.getRsm().getString("employeenum"));
        logger.info("saveNewAppFile saveAppFileOperation start ");
        long start = System.currentTimeMillis();
        AppFileMService.saveAppFileOperation(appFileDt, positionDt, appResumeBo);
        logger.info("saveNewAppFile saveAppFileOperation cost {} ", (Object)(System.currentTimeMillis() - start));
        return result;
    }

    public static void saveAppRsm(AppResumeBo appResumeBo) {
        ResumeBoHelper.save(appResumeBo);
    }

    private AddResumeService() {
    }
}

