/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.sr.service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeExpSortHelper;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tsirm.common.constants.rsm.sr.SrRsmKDString;

public class PreRsmService {
    private PreRsmService() {
        throw new IllegalStateException("Utility class");
    }

    public static void refreshPreViewOfBasic(IFormView view, IDataModel model) {
        IFormView parentView = view.getParentView();
        boolean preView = parentView.getEntityId().equals("tsirm_previewresume");
        if (preView) {
            String workingYears;
            BigDecimal bigDecimal;
            String age;
            String gender;
            IDataModel parentModel = parentView.getModel();
            DynamicObject rsmDy = model.getDataEntity();
            String fullName = rsmDy.getString("fullname");
            if (HRStringUtils.isNotEmpty((String)fullName)) {
                parentModel.setValue("fullname", (Object)fullName);
            }
            if (HRStringUtils.isNotEmpty((String)(gender = rsmDy.getString("gender")))) {
                ComboProp comboProp = (ComboProp)parentModel.getProperty("genderlist");
                gender = comboProp.getItemByName(gender);
                parentModel.setValue("gender", (Object)gender);
            }
            if (HRStringUtils.isNotEmpty((String)(age = String.valueOf(rsmDy.get("age")))) && !"0".equals(age)) {
                age = String.format(Locale.ROOT, SrRsmKDString.regAgeYear(), age);
                parentModel.setValue("age", (Object)age);
            }
            if ((bigDecimal = new BigDecimal(workingYears = Objects.toString(rsmDy.get("workingyears"), "0"))).compareTo(BigDecimal.ZERO) > 0) {
                int workingYearsInt = bigDecimal.intValue();
                workingYears = String.format(Locale.ROOT, SrRsmKDString.regWorkYearMonth(), ResumeAnalysisHelper.getWorkYearShow(workingYearsInt));
                parentModel.setValue("workingyears", (Object)workingYears);
            }
        }
    }

    public static void refreshPreViewOfEdu(IFormView view, IDataModel model) {
        DynamicObject rsmDy = model.getDataEntity();
        IFormView parentView = view.getParentView();
        boolean preView = parentView.getEntityId().equals("tsirm_previewresume");
        if (preView) {
            String specialtyName;
            DynamicObject highestEduCation;
            IDataModel parentModel = parentView.getModel();
            List<DynamicObject> cacheEduExps = ResumeUtilsHelper.deserializeDynamicObject(view.getPageCache(), "tsirm_srrsmeduexp");
            if (cacheEduExps.isEmpty()) {
                parentModel.setValue("schoolname", null);
                parentModel.setValue("education", null);
                parentModel.setValue("specialtyname", null);
                view.sendFormAction(view.getParentView());
                return;
            }
            List<DynamicObject> sortEduList = ResumeExpSortHelper.sortRsmEduExp(cacheEduExps);
            ResumeExpSortHelper.setHighestEduInfo(sortEduList.get(0), rsmDy);
            DynamicObject highestEduSchool = rsmDy.getDynamicObject("highesteduschool");
            if (highestEduSchool != null) {
                parentModel.setValue("schoolname", (Object)highestEduSchool.getString("name"));
            }
            if ((highestEduCation = rsmDy.getDynamicObject("highesteducation")) != null) {
                parentModel.setValue("education", (Object)highestEduCation.getString("name"));
            }
            if (HRStringUtils.isNotEmpty((String)(specialtyName = rsmDy.getString("highestspecialty")))) {
                parentModel.setValue("specialtyname", (Object)specialtyName);
            }
            view.sendFormAction(view.getParentView());
        }
    }

    public static void refreshPreViewOfWork(IFormView view, IDataModel model) {
        IFormView parentView = view.getParentView();
        boolean preView = parentView.getEntityId().equals("tsirm_previewresume");
        if (preView) {
            String position;
            IDataModel parentModel = parentView.getModel();
            DynamicObject rsmDy = model.getDataEntity();
            List<DynamicObject> cacheWorkExps = ResumeUtilsHelper.deserializeDynamicObject(view.getPageCache(), "tsirm_srrsmworkexp");
            if (cacheWorkExps.isEmpty()) {
                parentModel.setValue("companyname", null);
                parentModel.setValue("positionname", null);
                view.sendFormAction(view.getParentView());
                return;
            }
            List<DynamicObject> sortWorkList = ResumeExpSortHelper.sortRsmWorkExp(cacheWorkExps);
            ResumeExpSortHelper.setRecentWorkInfo(sortWorkList.get(0), rsmDy);
            String companyName = rsmDy.getString("recentcompany");
            if (HRStringUtils.isNotEmpty((String)companyName)) {
                parentModel.setValue("companyname", (Object)companyName);
            }
            if (HRStringUtils.isNotEmpty((String)(position = rsmDy.getString("recentposition")))) {
                parentModel.setValue("positionname", (Object)position);
            }
            view.sendFormAction(view.getParentView());
        }
    }
}

