/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.sr.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.domain.appfile.ChangeStageStatusHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileOpRecordService;
import kd.tsc.tsirm.business.domain.intv.service.ai.InterviewAiService;
import kd.tsc.tsirm.business.domain.rsm.common.helper.ResumeBoHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mhelper.RsmPositionHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tsirm.business.domain.rsm.service.AddResumeBizServiceHelper;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsirm.business.domain.rsm.sr.entity.RsmRecommend;
import kd.tsc.tsirm.business.domain.rsm.sr.service.AddResumeHandleService;
import kd.tsc.tsirm.business.domain.rsm.sr.service.AddResumeService;
import kd.tsc.tsirm.business.domain.stdrsm.handler.config.ResumeMapping;
import kd.tsc.tsirm.business.domain.stdrsm.helper.EventHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.StdRsmCommonService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.resume.IResumeService;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;
import kd.tsc.tsirm.common.constants.rsm.sr.SrRsmKDString;
import kd.tsc.tsirm.common.constants.talentpool.TSTPMTalentPoolConstants;
import kd.tsc.tsrbd.business.application.external.person.BizHRPIEmployeeService;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.domain.rsmmetadata.service.ResumeMetadataService;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.rsm.common.RsmCommonService;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;
import kd.tsc.tsrbs.common.enums.OpDefEnum;
import kd.tsc.tsrbs.common.enums.rsm.RsmSourceEnum;
import kd.tsc.tsrbs.common.enums.rsm.YesOrNotEnum;
import org.apache.commons.lang3.time.StopWatch;

public class RsmApiService {
    private static final Log LOG = LogFactory.getLog(RsmApiService.class);
    private AddResumeBizServiceHelper addResumeBizServiceHelper = AddResumeBizServiceHelper.getInstance();
    private AddResumeHandleService addResumeHandleService = new AddResumeHandleService();
    private static final HRBaseServiceHelper APP_FILE_HELPER = new HRBaseServiceHelper("tsirm_appfile_view");
    private static final HRBaseServiceHelper RSM_HELPER = new HRBaseServiceHelper("tsirm_rsm");
    private static final HRBaseServiceHelper SRDELIVER_HELPER = new HRBaseServiceHelper("tsirm_srrdelivery");
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"RecommendToPositionOtherOp", (int)10);
    private static final Set<String> RSM_EXP_NOT_COPY_PROP = Sets.newHashSet((Object[])new String[]{"showlengthofstudy", "showlengthofwork", "showprojectduration", "rsm", "operationstatus"});
    private static RsmApiService rsmApiService = new RsmApiService();

    public static RsmApiService getInstance() {
        return rsmApiService;
    }

    private RsmApiService() {
    }

    public void recommendPosition(RsmRecommend rsmRecommend) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        List<Long> positionIds = rsmRecommend.getPositionIds();
        List<Long> stdRsmIds = rsmRecommend.getStdRsmIds();
        if (positionIds.isEmpty() || stdRsmIds.isEmpty()) {
            return;
        }
        DynamicObject[] positionArr = RsmPositionHelper.getPositionObjByPositionIds(positionIds);
        Map<Long, DynamicObject> positionMap = this.transArrayToMap(positionArr);
        DynamicObject[] stdRsmArr = StdRsmServiceHelper.getStdRsmDys(stdRsmIds);
        Map<Long, DynamicObject> stdRsmMap = this.transArrayToMap(stdRsmArr);
        long start = System.currentTimeMillis();
        Map<Long, Map<Long, SaveCandidateResult>> futureMapMap = this.recommendPositionHandle(rsmRecommend, positionMap, stdRsmMap);
        LOG.info("recommend to position  recommendPositionHandle cost {} ", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.recommendPositionResultHandle(rsmRecommend, positionMap, stdRsmMap, futureMapMap);
        LOG.info("recommend to position recommendPositionResultHandle cost {} ", (Object)(System.currentTimeMillis() - start));
        stopWatch.stop();
    }

    private SaveCandidateResult initSaveCandidateResult(Long stdRsmId, String errorType) {
        SaveCandidateResult result = new SaveCandidateResult();
        result.setErrorType(errorType);
        result.setSuccess(false);
        result.setStdRsmId(stdRsmId);
        return result;
    }

    private List<SaveCandidateResult> recommendPositionCheck(DynamicObject[] stdRsmDys, DynamicObject[] positions, Map<String, List<DynamicObject>> passListMap) {
        ArrayList<SaveCandidateResult> results = new ArrayList<SaveCandidateResult>(stdRsmDys.length);
        Map<Long, Boolean> longBooleanMap = StdRsmCommonService.getInstance().queryStdRsmViewPermission(stdRsmDys);
        if (!longBooleanMap.containsValue(true)) {
            longBooleanMap.keySet().forEach(stdRsmId -> results.add(this.initSaveCandidateResult((Long)stdRsmId, "A")));
            return results;
        }
        ArrayList viewPermissionStdRsmIdList = new ArrayList();
        longBooleanMap.forEach((stdRsmId, pass) -> {
            if (pass.booleanValue()) {
                viewPermissionStdRsmIdList.add(stdRsmId);
            }
        });
        boolean exists = Arrays.stream(positions).map(dynamicObject -> dynamicObject.getString("positionstatus")).collect(Collectors.toList()).stream().anyMatch(positionStatus -> "A".equals(positionStatus) || "C".equals(positionStatus));
        if (!exists) {
            longBooleanMap.keySet().forEach(stdRsmId -> results.add(this.initSaveCandidateResult((Long)stdRsmId, "B")));
            return results;
        }
        List empIdList = Arrays.stream(stdRsmDys).filter(dynamicObject -> viewPermissionStdRsmIdList.contains(dynamicObject.getLong("id"))).filter(dynamicObject -> dynamicObject.getLong("empid") > 0L).map(dynamicObject -> dynamicObject.getLong("empid")).collect(Collectors.toList());
        Map<Long, DynamicObject> empStdRsmMap = Arrays.stream(stdRsmDys).filter(dynamicObject -> viewPermissionStdRsmIdList.contains(dynamicObject.getLong("id"))).filter(dynamicObject -> dynamicObject.getLong("empid") > 0L).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("empid"), dynamicObject -> dynamicObject, (v1, v2) -> v1));
        Map empStatusMap = BizHRPIEmployeeService.getEmployeeStatus(empIdList);
        HashMap<Long, Boolean> stdRsmOnJobMap = new HashMap<Long, Boolean>(empStdRsmMap.size());
        empStatusMap.forEach((empId, empInfo) -> {
            DynamicObject stdRsm = (DynamicObject)empStdRsmMap.get(empId);
            if (null == stdRsm) {
                return;
            }
            boolean isOutWork = null == empInfo || empInfo.getLong("labrelstatusprd_id") == Long.parseLong("1020");
            stdRsmOnJobMap.put(stdRsm.getLong("id"), isOutWork);
        });
        ArrayList outJobStdRsmIdList = new ArrayList();
        stdRsmOnJobMap.forEach((stdRsmId, outJob) -> {
            if (outJob.booleanValue()) {
                outJobStdRsmIdList.add(stdRsmId);
            }
        });
        ArrayList passStdRsmList = new ArrayList();
        ArrayList passPositionList = new ArrayList();
        longBooleanMap.forEach((stdRsmId, pass) -> {
            if (pass.booleanValue()) {
                if (((Boolean)stdRsmOnJobMap.get(stdRsmId)).booleanValue()) {
                    results.add(this.initSaveCandidateResult((Long)stdRsmId, "F"));
                    return;
                }
                Arrays.stream(positions).forEach(position -> {
                    passStdRsmList.addAll(Arrays.stream(stdRsmDys).filter(stdRsm -> stdRsmId.longValue() == stdRsm.getLong("id")).collect(Collectors.toList()));
                    String positionStatus = position.getString("positionstatus");
                    if (!"A".equals(positionStatus) && !"C".equals(positionStatus)) {
                        results.add(this.initSaveCandidateResult((Long)stdRsmId, "B"));
                        return;
                    }
                    passPositionList.add(position);
                });
            } else {
                results.add(this.initSaveCandidateResult((Long)stdRsmId, "A"));
            }
        });
        if (CollectionUtils.isNotEmpty(outJobStdRsmIdList)) {
            ThreadPools.executeOnce((String)"saveReserveRecord", () -> TalentListFunService.saveReserveRecord((List<Long>)outJobStdRsmIdList, TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED));
        }
        if (CollectionUtils.isNotEmpty(passPositionList)) {
            passListMap.put("tsirm_positiontpl", passPositionList);
        }
        if (CollectionUtils.isNotEmpty(passStdRsmList)) {
            passListMap.put("tsirm_stdrsm", passStdRsmList);
        }
        return results;
    }

    private Map<Long, List<Long>> getExistsPositionAndStdRsmMap(DynamicObject[] appFilesByStdMidAndPositions) {
        HashMap<Long, List<Long>> existsPositionAndStdRsmMap = new HashMap<Long, List<Long>>();
        Optional.ofNullable(appFilesByStdMidAndPositions).ifPresent(arrays -> Arrays.stream(arrays).forEach(dynamicObject -> {
            long positionId = dynamicObject.getLong("position.id");
            ArrayList<Long> stdIdList = (ArrayList<Long>)existsPositionAndStdRsmMap.get(positionId);
            if (CollectionUtils.isEmpty((Collection)stdIdList)) {
                stdIdList = new ArrayList<Long>();
            }
            long stdRsmId = dynamicObject.getLong("stdrsm.mid");
            stdIdList.add(stdRsmId);
            existsPositionAndStdRsmMap.put(positionId, stdIdList);
        }));
        return existsPositionAndStdRsmMap;
    }

    private SaveCandidateResult setSaveResult(String errorType, Long stdRsmId, String message, boolean success) {
        SaveCandidateResult result = new SaveCandidateResult();
        result.setMessage(message);
        if (HRStringUtils.isNotEmpty((String)errorType)) {
            result.setErrorType(errorType);
        }
        result.setSuccess(success);
        result.setStdRsmId(stdRsmId);
        return result;
    }

    private void doRecAndStg(Map<Long, Long> positionToRecMap, Map<Long, String> positionToStgAndJobStatusMap, List<Long> passPositionIds) {
        HRBaseServiceHelper posHelper = new HRBaseServiceHelper("tsirm_positionmanage");
        DynamicObject[] positionManages = posHelper.query("recruproc,recruproc.entryentity,recruproc.entryentity.subentryentity,position", new QFilter[]{new QFilter("position", "in", passPositionIds)});
        Optional.ofNullable(positionManages).ifPresent(positionManageArray -> {
            positionToRecMap.putAll(Arrays.stream(positionManageArray).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("position.id"), dynamicObject -> dynamicObject.getLong("recruproc.id"))));
            Arrays.stream(positionManageArray).forEach(positionManage -> {
                long currentPositionId = positionManage.getLong("position.id");
                DynamicObjectCollection stgCollection = positionManage.getDynamicObjectCollection("recruproc.entryentity");
                if (CollectionUtils.isEmpty((Collection)stgCollection)) {
                    return;
                }
                DynamicObject firstStg = (DynamicObject)stgCollection.get(0);
                if (firstStg.getDynamicObject("rqmtstg") == null) {
                    return;
                }
                long stgId = firstStg.getDynamicObject("rqmtstg").getLong("id");
                DynamicObjectCollection jobStatusCollection = firstStg.getDynamicObjectCollection("subentryentity");
                if (CollectionUtils.isEmpty((Collection)jobStatusCollection)) {
                    positionToStgAndJobStatusMap.put(currentPositionId, String.valueOf(stgId));
                    return;
                }
                if (((DynamicObject)jobStatusCollection.get(0)).getDynamicObject("jobstatus") == null) {
                    return;
                }
                long jobStatusId = ((DynamicObject)jobStatusCollection.get(0)).getDynamicObject("jobstatus").getLong("id");
                positionToStgAndJobStatusMap.put(currentPositionId, stgId + "," + jobStatusId);
            });
        });
    }

    private DynamicObject createDelivery(Date nowTime, Queue<Long> idsQueue) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsirm_srrdelivery");
        DynamicObject deliveryDt = hrBaseServiceHelper.generateEmptyDynamicObject();
        Long id = idsQueue.poll();
        if (null == id) {
            id = ID.genLongId();
        }
        deliveryDt.set("id", (Object)id);
        deliveryDt.set("applytime", (Object)nowTime);
        deliveryDt.set("recruchnlmedia", (Object)1010L);
        deliveryDt.set("appmthd", (Object)1040L);
        deliveryDt.set("resacqmthd", (Object)1080L);
        deliveryDt.set("recruchnlnm", (Object)1190L);
        deliveryDt.set("isfiledisplay", (Object)YesOrNotEnum.YES.toString());
        deliveryDt.set("deliveryper", (Object)TSCRequestContext.getUserId());
        deliveryDt.set("creator", (Object)TSCRequestContext.getUserId());
        deliveryDt.set("createtime", (Object)nowTime);
        deliveryDt.set("modifier", (Object)TSCRequestContext.getUserId());
        deliveryDt.set("modifytime", (Object)nowTime);
        return deliveryDt;
    }

    private DynamicObject createAppFile(Long stdRsmId, DynamicObject positionDy, DynamicObject deliveryDt, DynamicObject rsmDy, AppResumeBo resumeBo, Queue<Long> idsQueue) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_appfile_view");
        Long id = idsQueue.poll();
        long appFileId = id == null ? ORM.create().genLongId(helper.getEntityName()) : id.longValue();
        DynamicObject appFileDt = helper.generateEmptyDynamicObject();
        appFileDt.set("id", (Object)appFileId);
        appFileDt.set("stdrsm", (Object)stdRsmId);
        appFileDt.set("deliveryrec", (Object)deliveryDt);
        appFileDt.set("position", (Object)positionDy);
        appFileDt.set("appres", (Object)rsmDy.getLong("id"));
        appFileDt.set("employeenum", (Object)resumeBo.getRsm().getString("employeenum"));
        appFileDt.set("isbinddelyrec", (Object)"0");
        appFileDt.set("creator", (Object)TSCRequestContext.getUserId());
        appFileDt.set("createtime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        appFileDt.set("status", (Object)"C");
        appFileDt.set("masterid", (Object)appFileId);
        long creatOrgId = positionDy.getLong("createorg.id");
        appFileDt.set("createorg", (Object)creatOrgId);
        appFileDt.set("adminorg", (Object)positionDy.getLong("adminorg.id"));
        appFileDt.set("positionsnap", positionDy.get("vid"));
        appFileDt.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
        appFileDt.set("validrecruchnlnm", (Object)resumeBo.getDelivery().getLong("recruchnlnm.id"));
        RsmCommonService.updateAppFileByAppResume((DynamicObject)appFileDt, (AppResumeBo)resumeBo);
        RsmCommonService.updateAppFileDeliveryByAppResume((DynamicObject)appFileDt, (AppResumeBo)resumeBo);
        return appFileDt;
    }

    private void saveStageTrace(Map<String, List<DynamicObject>> stgJobStatusAppFileMap) {
        stgJobStatusAppFileMap.forEach((stgAndJobStatusStr, appFiles) -> {
            if (HRStringUtils.isBlank((CharSequence)stgAndJobStatusStr)) {
                return;
            }
            if (stgAndJobStatusStr.split(",").length != 2) {
                return;
            }
            String[] stgAndJobStatus = stgAndJobStatusStr.split(",");
            String stgIdStr = stgAndJobStatus[0];
            String jobStatusIdStr = stgAndJobStatus[1];
            ChangeStageStatusHelper.saveStageTraceNoUpdateAppFile(Long.parseLong(stgIdStr), Long.parseLong(jobStatusIdStr), 0L, appFiles.toArray(new DynamicObject[0]));
        });
    }

    private void dataCreate(RecommendParam recommendParam, List<DynamicObject> deliveryList, List<DynamicObject> rsmList, List<DynamicObject> appFileList, Map<Long, List<Long>> notPassPositionAndStdRsmMap, Date nowTime) {
        List<Long> positionIds = recommendParam.getPositionIds();
        Map<Long, DynamicObject> passPositionMap = recommendParam.getPassPositionMap();
        List<Long> stdRsmIds = recommendParam.getStdRsmIds();
        Map<Long, DynamicObject> passStdRsmMap = recommendParam.getPassStdRsmMap();
        Map<String, Map<Long, List<DynamicObject>>> stdRsmListMap = recommendParam.getStdRsmListMap();
        Map<String, String> resumeMapping = recommendParam.getResumeMapping();
        Map<Long, Long> positionToRecMap = recommendParam.getPositionToRecMap();
        Map<Long, String> positionToStgAndJobStatusMap = recommendParam.getPositionToStgAndJobStatusMap();
        String[] rsmEntryName = recommendParam.getRsmEntryName();
        Map<String, List<DynamicObject>> stgJobStatusAppFileMap = recommendParam.getStgJobStatusAppFileMap();
        Map<Long, Map<String, String>> stdRsmInfoMap = recommendParam.getStdRsmInfoMap();
        List<AppResumeBo> rsmSubEntryList = recommendParam.getRsmSubEntryList();
        long start = System.currentTimeMillis();
        int totalCount = positionIds.size() * stdRsmIds.size() * 10;
        ArrayBlockingQueue idsQueue = new ArrayBlockingQueue(totalCount);
        long[] longs = ID.genLongIds((int)totalCount);
        Arrays.stream(longs).forEach(idsQueue::add);
        LOG.info("recommend to position genLongIds cost {}", (Object)(System.currentTimeMillis() - start));
        positionIds.forEach(positionId -> {
            DynamicObject positionDy = (DynamicObject)passPositionMap.get(positionId);
            if (null == positionDy) {
                return;
            }
            List notPassStadRsmIdList = (List)notPassPositionAndStdRsmMap.get(positionId);
            stdRsmIds.forEach(stdRsmId -> {
                DynamicObject stdRsmDy = (DynamicObject)passStdRsmMap.get(stdRsmId);
                long start1 = System.currentTimeMillis();
                DynamicObject rsmDy = this.copyStdRsmToRsm(stdRsmDy, idsQueue);
                if (null == rsmDy) {
                    return;
                }
                LOG.info("recommend to position copyStdRsmToRsm cost {}", (Object)(System.currentTimeMillis() - start1));
                if (CollectionUtils.isNotEmpty((Collection)notPassStadRsmIdList) && notPassStadRsmIdList.contains(stdRsmId)) {
                    return;
                }
                rsmList.add(rsmDy);
                start1 = System.currentTimeMillis();
                DynamicObject deliveryDt = this.createDelivery(nowTime, idsQueue);
                LOG.info("recommend to position createDelivery cost {}", (Object)(System.currentTimeMillis() - start1));
                deliveryList.add(deliveryDt);
                AppResumeBo resumeBo = new AppResumeBo(rsmDy, deliveryDt);
                start1 = System.currentTimeMillis();
                this.deaiWithRsmExp(stdRsmListMap, rsmEntryName, resumeMapping, (Long)stdRsmId, rsmDy, resumeBo, idsQueue);
                LOG.info("recommend to position deaiWithRsmExp cost {}", (Object)(System.currentTimeMillis() - start1));
                start1 = System.currentTimeMillis();
                DynamicObject appFileDt = this.createAppFile((Long)stdRsmId, positionDy, deliveryDt, rsmDy, resumeBo, idsQueue);
                LOG.info("recommend to position createAppFile cost {}", (Object)(System.currentTimeMillis() - start1));
                rsmDy.set("appfile", (Object)appFileDt.getLong("id"));
                ResumeBoHelper.beforeSaveOpRsm(resumeBo);
                Long procId = (Long)positionToRecMap.get(positionId);
                if (procId == null) {
                    procId = 0L;
                }
                appFileDt.set("recruproc", (Object)procId);
                String stgAndJobStatusStr = (String)positionToStgAndJobStatusMap.get(positionId);
                HashMap stdInfoMap = Maps.newHashMapWithExpectedSize((int)4);
                if (HRStringUtils.isNotEmpty((String)stgAndJobStatusStr) && stgAndJobStatusStr.split(",").length == 2) {
                    ArrayList<DynamicObject> appFiles = (ArrayList<DynamicObject>)stgJobStatusAppFileMap.get(stgAndJobStatusStr);
                    if (CollectionUtils.isEmpty((Collection)appFiles)) {
                        appFiles = new ArrayList<DynamicObject>();
                    }
                    appFiles.add(appFileDt);
                    stgJobStatusAppFileMap.put(stgAndJobStatusStr, appFiles);
                    String[] stgAdnStatusArray = stgAndJobStatusStr.split(",");
                    appFileDt.set("recrustg", (Object)Long.parseLong(stgAdnStatusArray[0]));
                    appFileDt.set("recrustat", (Object)Long.parseLong(stgAdnStatusArray[1]));
                    stdInfoMap.put("recrustg", stgAdnStatusArray[0]);
                    stdInfoMap.put("recrustat", stgAdnStatusArray[1]);
                }
                appFileDt.set("enterlinktime", (Object)nowTime);
                appFileList.add(appFileDt);
                stdInfoMap.put("position", String.valueOf(positionId));
                stdInfoMap.put("appfile", String.valueOf(appFileDt.getLong("id")));
                stdInfoMap.put("recruchnlnm", "1190");
                stdRsmInfoMap.put((Long)stdRsmId, stdInfoMap);
                rsmSubEntryList.add(resumeBo);
            });
        });
        start = System.currentTimeMillis();
        this.batchSetNumber(appFileList, "tsirm_appfilemdl", String.valueOf(appFileList.get(0).getLong("createorg")));
        this.batchSetNumber(rsmList, "tsirm_rsm", null);
        LOG.info("recommend to position getBatchNumber cost {}", (Object)(System.currentTimeMillis() - start));
    }

    private void batchSetNumber(List<DynamicObject> list, String entity, String orgId) {
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)entity, (DynamicObject)list.get(0), (String)orgId, (int)list.size());
        for (int i = 0; i < batchNumber.length; ++i) {
            if (i == list.size()) continue;
            String number = batchNumber[i];
            DynamicObject dynamicObject = list.get(i);
            if (null == dynamicObject) continue;
            dynamicObject.set("number", (Object)number);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAfterCheckPass(IResumeService resumeService, RsmRecommend rsmRecommend, Map<Long, List<Long>> notPassPositionAndStdRsmMap, List<DynamicObject> positionList, List<DynamicObject> stdRsmList) {
        List<Long> positionIds = rsmRecommend.getPositionIds();
        List<Long> stdRsmIds = rsmRecommend.getStdRsmIds();
        long start = System.currentTimeMillis();
        String[] rsmEntryName = ResumeMetadataService.getAllEntry((String)"tsirm_srrsm", (String)"3").toArray(new String[0]);
        Map<String, String> resumeMapping = ResumeMapping.getResumeMapping();
        ArrayList<Long> passPositionIds = new ArrayList<Long>();
        HashMap<Long, DynamicObject> passPositionMap = new HashMap<Long, DynamicObject>();
        HashMap<String, Map<Long, List<DynamicObject>>> stdRsmListMap = new HashMap<String, Map<Long, List<DynamicObject>>>();
        HashMap<Long, DynamicObject> passStdRsmMap = new HashMap<Long, DynamicObject>();
        if (CollectionUtils.isNotEmpty(positionList)) {
            passPositionIds.addAll(positionList.stream().map(position -> position.getLong("id")).collect(Collectors.toList()));
            passPositionMap.putAll(positionList.stream().collect(Collectors.toMap(position -> position.getLong("id"), position -> position, (v1, v2) -> v1)));
        }
        if (CollectionUtils.isNotEmpty(stdRsmList)) {
            passStdRsmMap.putAll(stdRsmList.stream().collect(Collectors.toMap(stdRsm -> stdRsm.getLong("id"), stdRsm -> stdRsm, (v1, v2) -> v1)));
            stdRsmListMap.putAll(resumeService.getStdRsmList(passStdRsmMap.values().toArray(new DynamicObject[0])));
        }
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        HashMap<Long, Long> positionToRecMap = new HashMap<Long, Long>();
        HashMap<Long, String> positionToStgAndJobStatusMap = new HashMap<Long, String>();
        LOG.info("recommend to position beforeParam cost {}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.doRecAndStg(positionToRecMap, positionToStgAndJobStatusMap, passPositionIds);
        LOG.info("recommend to position doRecAndStg cost {}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        ArrayList<DynamicObject> deliveryList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> rsmList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> appFileList = new ArrayList<DynamicObject>();
        HashMap<String, List<DynamicObject>> stgJobStatusAppFileMap = new HashMap<String, List<DynamicObject>>();
        HashMap<Long, Map<String, String>> stdRsmInfoMap = new HashMap<Long, Map<String, String>>();
        ArrayList<AppResumeBo> rsmSubEntryList = new ArrayList<AppResumeBo>();
        RecommendParam instance = RecommendParam.getInstance();
        instance.setPassStdRsmMap(passStdRsmMap).setResumeMapping(resumeMapping).setRsmEntryName(rsmEntryName).setStdRsmIds(stdRsmIds).setStdRsmListMap(stdRsmListMap).setPositionToRecMap(positionToRecMap).setPositionToStgAndJobStatusMap(positionToStgAndJobStatusMap).setStgJobStatusAppFileMap(stgJobStatusAppFileMap).setPositionIds(positionIds).setPassPositionMap(passPositionMap).setStdRsmInfoMap(stdRsmInfoMap).setRsmSubEntryList(rsmSubEntryList);
        LOG.info("recommend to position recommendParam cost {}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.dataCreate(instance, deliveryList, rsmList, appFileList, notPassPositionAndStdRsmMap, nowTime);
        LOG.info("recommend to position dataCreate cost {}", (Object)(System.currentTimeMillis() - start));
        boolean commit = false;
        start = System.currentTimeMillis();
        try (TXHandle required = TX.required();){
            if (CollectionUtils.isNotEmpty(appFileList) && CollectionUtils.isNotEmpty(deliveryList) && CollectionUtils.isNotEmpty(rsmList)) {
                APP_FILE_HELPER.save(appFileList.toArray(new DynamicObject[0]));
                SRDELIVER_HELPER.save(deliveryList.toArray(new DynamicObject[0]));
                RSM_HELPER.save(rsmList.toArray(new DynamicObject[0]));
                ResumeBoHelper.batchHandlerSubForm(rsmSubEntryList, rsmEntryName);
                LOG.info("recommend to position batch save cost {}", (Object)(System.currentTimeMillis() - start));
                required.commit();
                commit = true;
            }
        }
        if (commit) {
            start = System.currentTimeMillis();
            AppFileMService.updateStdRsmInfoPositionNum(stdRsmList, positionList.size());
            LOG.info("recommend to position updateStdRsmInfoPositionNum cost {}", (Object)(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            positionList.forEach(position -> THREAD_POOL.execute(() -> AddResumeService.updatePositionCandidateNumber(position)));
            THREAD_POOL.execute(() -> {
                appFileList.forEach(appFile -> InterviewAiService.getInstance().updateAllAppFileAi((DynamicObject)appFile));
                AppFileMService.updateStdRsmInfo(stdRsmInfoMap);
                this.saveStageTrace(stgJobStatusAppFileMap);
                AppFileOpRecordService.getInstance().sendOpRecord(AppFileResManagerHelper.getRecRoleName(), OpDefEnum.TSIRM_CREATE, appFileList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList()), null);
            });
            LOG.info("recommend to position other ThreadPools cost {}", (Object)(System.currentTimeMillis() - start));
        }
    }

    private Map<Long, Map<Long, SaveCandidateResult>> recommendPositionHandle(RsmRecommend rsmRecommend, Map<Long, DynamicObject> positionMap, Map<Long, DynamicObject> stdRsmMap) {
        LOG.info("recommendPositionHandle set param start ");
        List<Long> positionIds = rsmRecommend.getPositionIds();
        IResumeService resumeService = new IResumeService();
        resumeService.setMainEntryNumber("tsirm_stdrsm");
        HashMap futureMapMap = Maps.newHashMapWithExpectedSize((int)positionIds.size());
        HashMap<String, List<DynamicObject>> passList = new HashMap<String, List<DynamicObject>>();
        long start = System.currentTimeMillis();
        List<SaveCandidateResult> results = this.recommendPositionCheck(stdRsmMap.values().toArray(new DynamicObject[0]), positionMap.values().toArray(new DynamicObject[0]), passList);
        LOG.info("recommend to position recommendPositionCheck cost {}", (Object)(System.currentTimeMillis() - start));
        boolean allNotHaveViewRight = !results.isEmpty() && results.stream().map(SaveCandidateResult::getErrorType).allMatch("A"::equals);
        boolean allPositionStatusNotRight = !results.isEmpty() && results.stream().map(SaveCandidateResult::getErrorType).allMatch("B"::equals);
        List positionList = (List)passList.get("tsirm_positiontpl");
        List stdRsmList = (List)passList.get("tsirm_stdrsm");
        if (allNotHaveViewRight || allPositionStatusNotRight || positionList.isEmpty() && stdRsmList.isEmpty()) {
            positionIds.forEach(positionId -> results.forEach(result -> {
                HashMap<Long, SaveCandidateResult> map = new HashMap<Long, SaveCandidateResult>();
                map.put(result.getStdRsmId(), (SaveCandidateResult)result);
                futureMapMap.put(positionId, map);
            }));
            return futureMapMap;
        }
        List<Long> passPositionIdList = positionList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        List<Long> passStdRsmIdList = stdRsmList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        start = System.currentTimeMillis();
        DynamicObject[] appFilesByStdMidAndPositions = RsmHelper.getAppFilesByStdMidAndPositionId(passStdRsmIdList, passPositionIdList, HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        Map<Long, List<Long>> existsPositionAndStdRsmMap = this.getExistsPositionAndStdRsmMap(appFilesByStdMidAndPositions);
        HashMap<Long, List<Long>> notPassPositionAndStdRsmMap = new HashMap<Long, List<Long>>();
        ArrayList passOrNotList = new ArrayList(passPositionIdList.size() * passStdRsmIdList.size());
        passPositionIdList.forEach(positionId -> {
            List existsStdRsmIdList = (List)existsPositionAndStdRsmMap.get(positionId);
            passStdRsmIdList.forEach(stdRsmId -> {
                if (CollectionUtils.isNotEmpty((Collection)existsStdRsmIdList) && existsStdRsmIdList.contains(stdRsmId)) {
                    ArrayList<Long> notPassStdRsmIdList = (ArrayList<Long>)notPassPositionAndStdRsmMap.get(positionId);
                    if (CollectionUtils.isEmpty((Collection)notPassStdRsmIdList)) {
                        notPassStdRsmIdList = new ArrayList<Long>();
                    }
                    notPassStdRsmIdList.add((Long)stdRsmId);
                    SaveCandidateResult result = this.setSaveResult("C", (Long)stdRsmId, SrRsmKDString.submitFailRepeat(), false);
                    HashMap<Long, SaveCandidateResult> map = (HashMap<Long, SaveCandidateResult>)futureMapMap.get(positionId);
                    if (HRMapUtils.isEmpty((Map)map)) {
                        map = new HashMap<Long, SaveCandidateResult>();
                    }
                    map.put(result.getStdRsmId(), result);
                    futureMapMap.put(positionId, map);
                    notPassPositionAndStdRsmMap.put((Long)positionId, (List<Long>)notPassStdRsmIdList);
                    passOrNotList.add(false);
                } else {
                    SaveCandidateResult result = this.setSaveResult(null, (Long)stdRsmId, SrRsmKDString.submitSuccess(), true);
                    HashMap<Long, SaveCandidateResult> map = (HashMap<Long, SaveCandidateResult>)futureMapMap.get(positionId);
                    if (HRMapUtils.isEmpty((Map)map)) {
                        map = new HashMap<Long, SaveCandidateResult>();
                    }
                    map.put(result.getStdRsmId(), result);
                    futureMapMap.put(positionId, map);
                    passOrNotList.add(true);
                }
            });
        });
        LOG.info("recommend to position exist appFile cost {}", (Object)(System.currentTimeMillis() - start));
        if (!passOrNotList.contains(true)) {
            return futureMapMap;
        }
        passOrNotList.clear();
        start = System.currentTimeMillis();
        this.doAfterCheckPass(resumeService, rsmRecommend, notPassPositionAndStdRsmMap, positionList, stdRsmList);
        LOG.info("recommend to position doAfterCheckPass cost {}", (Object)(System.currentTimeMillis() - start));
        return futureMapMap;
    }

    private void deaiWithRsmExp(Map<String, Map<Long, List<DynamicObject>>> stdRsmList, String[] rsmEntryName, Map<String, String> resumeMapping, Long stdRsmId, DynamicObject rsmDy, AppResumeBo resumeBo, Queue<Long> idsQueue) {
        for (String entryNumber : rsmEntryName) {
            String stdEntryNumber = resumeMapping.get(entryNumber);
            Map<Long, List<DynamicObject>> listMap = stdRsmList.get(stdEntryNumber);
            if (Objects.isNull(stdEntryNumber) || listMap.isEmpty()) continue;
            List<DynamicObject> rsmEntryDys = this.copyStdExpToRsmExp(listMap.get(stdRsmId), rsmDy.getLong("id"), entryNumber, idsQueue);
            resumeBo.setEntry(entryNumber, rsmEntryDys);
        }
    }

    private void recommendPositionResultHandle(RsmRecommend rsmRecommend, Map<Long, DynamicObject> positionMap, Map<Long, DynamicObject> stdRsmMap, Map<Long, Map<Long, SaveCandidateResult>> futureMapMap) {
        List<Long> positionIds = rsmRecommend.getPositionIds();
        List<Long> stdRsmIds = rsmRecommend.getStdRsmIds();
        ArrayList failPositions = Lists.newArrayListWithExpectedSize((int)positionIds.size());
        for (Long positionId : positionIds) {
            RsmRecommend.FailPosition failPosition = new RsmRecommend.FailPosition();
            DynamicObject positionDy = positionMap.get(positionId);
            failPosition.setPositionDy(positionDy);
            Map<Long, SaveCandidateResult> futureMap = futureMapMap.get(positionId);
            for (Long stdRsmId : stdRsmIds) {
                RsmApiService.getFutureResult(stdRsmMap, stdRsmId, futureMap, failPosition);
            }
            if (failPosition.getStdRsmDys().isEmpty()) continue;
            failPositions.add(failPosition);
        }
        rsmRecommend.setFailPositions(failPositions);
    }

    private static void getFutureResult(Map<Long, DynamicObject> stdRsmMap, Long stdRsmId, Map<Long, SaveCandidateResult> futureMap, RsmRecommend.FailPosition failPosition) {
        DynamicObject stdRsmDy = stdRsmMap.get(stdRsmId);
        try {
            LOG.info("getFutureResult get future start ");
            long start = System.currentTimeMillis();
            SaveCandidateResult saveResult = futureMap.get(stdRsmId);
            LOG.info("getFutureResult get future cost {}", (Object)(System.currentTimeMillis() - start));
            if (!saveResult.isSuccess()) {
                failPosition.addFailStdRsm(stdRsmDy);
                failPosition.getCandidateErrorTypeMap().put(stdRsmId, saveResult.getErrorType());
            }
        }
        catch (Exception ex) {
            LOG.error("recommendPosition error", (Throwable)ex);
            failPosition.addFailStdRsm(stdRsmDy);
        }
    }

    public static void publishRsmMsgToAILabel(Long rsmId) {
        DynamicObject[] rsmDy = RsmHelper.findRsmById(rsmId, "stdrsm");
        Long stdRsmId = rsmDy[0].getLong("stdrsm");
        DynamicObject event = EventHelper.queryBoEvent(stdRsmId, "1");
    }

    private List<DynamicObject> copyStdExpToRsmExp(List<DynamicObject> stdExpDyList, Long rsmId, String entityId, Queue<Long> idsQueue) {
        if (stdExpDyList == null || stdExpDyList.isEmpty()) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        ArrayList rsmExpDyList = Lists.newArrayListWithExpectedSize((int)stdExpDyList.size());
        for (DynamicObject stdExpDy : stdExpDyList) {
            DynamicObject rsmExpDy = ServiceHelperCache.getHrBaseServiceHelper((String)entityId).generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)stdExpDy, (DynamicObject)rsmExpDy, RSM_EXP_NOT_COPY_PROP);
            rsmExpDy.set("rsm", (Object)rsmId);
            Long id = idsQueue.poll();
            if (null == id) {
                id = ID.genLongId();
            }
            rsmExpDy.set("id", (Object)id);
            rsmExpDyList.add(rsmExpDy);
        }
        return rsmExpDyList;
    }

    private DynamicObject copyStdRsmToRsm(DynamicObject stdRsmDy, Queue<Long> idsQueue) {
        if (stdRsmDy == null) {
            return null;
        }
        DynamicObject rsmDy = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_rsm").generateEmptyDynamicObject();
        Set rsmPropNameList = rsmDy.getDataEntityType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
        Set stdRsmPropNameList = stdRsmDy.getDataEntityType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
        for (String propName : rsmPropNameList) {
            if (!stdRsmPropNameList.contains(propName)) continue;
            rsmDy.set(propName, stdRsmDy.get(propName));
        }
        Long id = idsQueue.poll();
        if (null == id) {
            id = ID.genLongId();
        }
        rsmDy.set("id", (Object)id);
        rsmDy.set("stdrsm", stdRsmDy.get("id"));
        rsmDy.set("rsmsource", (Object)RsmSourceEnum.RP.getCode());
        ResumeAnalysisHelper.setCreatorAndTime(rsmDy);
        return rsmDy;
    }

    private Map<Long, DynamicObject> transArrayToMap(DynamicObject[] dyArr) {
        if (dyArr == null || dyArr.length == 0) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap dyMap = Maps.newHashMapWithExpectedSize((int)dyArr.length);
        for (DynamicObject dy : dyArr) {
            dyMap.put(dy.getLong("id"), dy);
        }
        return dyMap;
    }

    private static class RecommendParam {
        private List<Long> positionIds;
        private Map<Long, DynamicObject> passPositionMap;
        private List<Long> stdRsmIds;
        private Map<Long, DynamicObject> passStdRsmMap;
        private Map<String, Map<Long, List<DynamicObject>>> stdRsmListMap;
        private String[] rsmEntryName;
        private Map<String, String> resumeMapping;
        private Map<Long, Long> positionToRecMap;
        private Map<Long, String> positionToStgAndJobStatusMap;
        private Map<String, List<DynamicObject>> stgJobStatusAppFileMap;
        private Map<Long, Map<String, String>> stdRsmInfoMap;
        private List<AppResumeBo> rsmSubEntryList;

        private RecommendParam() {
        }

        public static RecommendParam getInstance() {
            return new RecommendParam();
        }

        public RecommendParam setStdRsmInfoMap(Map<Long, Map<String, String>> stdRsmInfoMap) {
            this.stdRsmInfoMap = stdRsmInfoMap;
            return this;
        }

        public RecommendParam setPositionIds(List<Long> positionIds) {
            this.positionIds = positionIds;
            return this;
        }

        public RecommendParam setPassPositionMap(Map<Long, DynamicObject> passPositionMap) {
            this.passPositionMap = passPositionMap;
            return this;
        }

        public RecommendParam setStdRsmIds(List<Long> stdRsmIds) {
            this.stdRsmIds = stdRsmIds;
            return this;
        }

        public RecommendParam setPassStdRsmMap(Map<Long, DynamicObject> passStdRsmMap) {
            this.passStdRsmMap = passStdRsmMap;
            return this;
        }

        public RecommendParam setStdRsmListMap(Map<String, Map<Long, List<DynamicObject>>> stdRsmListMap) {
            this.stdRsmListMap = stdRsmListMap;
            return this;
        }

        public RecommendParam setRsmEntryName(String[] rsmEntryName) {
            this.rsmEntryName = rsmEntryName;
            return this;
        }

        public RecommendParam setResumeMapping(Map<String, String> resumeMapping) {
            this.resumeMapping = resumeMapping;
            return this;
        }

        public RecommendParam setPositionToRecMap(Map<Long, Long> positionToRecMap) {
            this.positionToRecMap = positionToRecMap;
            return this;
        }

        public RecommendParam setPositionToStgAndJobStatusMap(Map<Long, String> positionToStgAndJobStatusMap) {
            this.positionToStgAndJobStatusMap = positionToStgAndJobStatusMap;
            return this;
        }

        public RecommendParam setStgJobStatusAppFileMap(Map<String, List<DynamicObject>> stgJobStatusAppFileMap) {
            this.stgJobStatusAppFileMap = stgJobStatusAppFileMap;
            return this;
        }

        public List<Long> getPositionIds() {
            return this.positionIds;
        }

        public Map<Long, DynamicObject> getPassPositionMap() {
            return this.passPositionMap;
        }

        public List<Long> getStdRsmIds() {
            return this.stdRsmIds;
        }

        public Map<Long, DynamicObject> getPassStdRsmMap() {
            return this.passStdRsmMap;
        }

        public Map<String, Map<Long, List<DynamicObject>>> getStdRsmListMap() {
            return this.stdRsmListMap;
        }

        public String[] getRsmEntryName() {
            return this.rsmEntryName;
        }

        public Map<String, String> getResumeMapping() {
            return this.resumeMapping;
        }

        public Map<Long, Long> getPositionToRecMap() {
            return this.positionToRecMap;
        }

        public Map<Long, String> getPositionToStgAndJobStatusMap() {
            return this.positionToStgAndJobStatusMap;
        }

        public Map<String, List<DynamicObject>> getStgJobStatusAppFileMap() {
            return this.stgJobStatusAppFileMap;
        }

        public Map<Long, Map<String, String>> getStdRsmInfoMap() {
            return this.stdRsmInfoMap;
        }

        public List<AppResumeBo> getRsmSubEntryList() {
            return this.rsmSubEntryList;
        }

        public RecommendParam setRsmSubEntryList(List<AppResumeBo> rsmSubEntryList) {
            this.rsmSubEntryList = rsmSubEntryList;
            return this;
        }
    }
}

