/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.sr.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeExpSortHelper;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tsirm.common.constants.rsm.sr.RsmConstants;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.domain.rsmmetadata.service.ResumeMetadataService;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import org.apache.commons.lang3.StringUtils;

public class RsmService {
    private RsmService() {
    }

    public static void resetRsmInfo(IFormView view) {
        RsmService.resetPreInfo(view);
        RsmService.resetConInfo(view);
        RsmService.resetJobIntention(view);
        RsmService.resetSelfDesc(view);
    }

    public static void resetPreInfo(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String cachePreInfoStr = pageCache.get("preinfo_data_cache");
        if (HRStringUtils.isNotEmpty((String)cachePreInfoStr)) {
            JSONObject preInfoJson = JSON.parseObject((String)cachePreInfoStr);
            IDataModel model = view.getModel();
            model.beginInit();
            for (String field : RsmConstants.KEY_PREINFO_FIELDS) {
                Object ov = preInfoJson.get((Object)field);
                if (StringUtils.equalsAny((CharSequence)field, (CharSequence[])new CharSequence[]{"rgstprmtrsd", "nativeplace"}) && "".equals(ov)) {
                    model.setValue(field, null);
                } else if (HRStringUtils.equals((String)"birthday", (String)field) || HRStringUtils.equals((String)"partwt", (String)field)) {
                    String time = preInfoJson.getString(field);
                    if (HRStringUtils.isNotEmpty((String)time)) {
                        model.setValue(field, (Object)new Date(Long.parseLong(time)));
                    } else {
                        model.setValue(field, null);
                    }
                } else {
                    model.setValue(field, ov);
                }
                view.updateView(field);
            }
            model.endInit();
            pageCache.remove("preinfo_data_cache");
        }
    }

    public static void resetConInfo(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String cacheConInfoStr = pageCache.get("coninfo_data_cache");
        if (StringUtils.isNotBlank((CharSequence)cacheConInfoStr)) {
            JSONObject conInfoJson = JSON.parseObject((String)cacheConInfoStr);
            IDataModel model = view.getModel();
            model.setValue("phone", conInfoJson.get((Object)"phone"));
            model.setValue("email", conInfoJson.get((Object)"email"));
            model.setDataChanged(false);
            pageCache.remove("coninfo_data_cache");
        }
    }

    public static void resetJobIntention(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String cacheConInfoStr = pageCache.get("jobintentioninfo_data_cache");
        if (StringUtils.isNotBlank((CharSequence)cacheConInfoStr)) {
            JSONObject conInfoJson = JSON.parseObject((String)cacheConInfoStr);
            IDataModel model = view.getModel();
            model.setValue("expccity", conInfoJson.get((Object)"expccity"));
            model.setValue("expcfunction", conInfoJson.get((Object)"expcfunction"));
            model.setValue("iscompemp", conInfoJson.get((Object)"iscompemp"));
            model.setValue("accplacechange", conInfoJson.get((Object)"accplacechange"));
            model.setDataChanged(false);
            pageCache.remove("jobintentioninfo_data_cache");
        }
    }

    public static void resetSelfDesc(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String selfDescCache = pageCache.get("selfdesc_data_cache");
        if (StringUtils.isNotBlank((CharSequence)selfDescCache)) {
            JSONObject conInfoJson = JSON.parseObject((String)selfDescCache);
            IDataModel model = view.getModel();
            model.setValue("selfevaluation", conInfoJson.get((Object)"selfevaluation"));
            model.setDataChanged(false);
            pageCache.remove("selfdesc_data_cache");
        }
    }

    public static void selectedPositionClosedCallBack(IFormView view, Object returnData) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
        if (null != selectedRows && !selectedRows.isEmpty()) {
            ListSelectedRow selectedRow = selectedRows.get(0);
            IDataModel model = view.getModel();
            model.setValue("position", (Object)selectedRow.getName());
            model.setValue("positionid", selectedRow.getPrimaryKeyValue());
        }
    }

    public static void openPositionF7Click(IFormView view, CloseCallBack closeCallBack) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"tsirm_position", (boolean)false, (int)0, (boolean)true);
        listShowParameter.setCloseCallBack(closeCallBack);
        view.showForm((FormShowParameter)listShowParameter);
    }

    public static void setPositionData(IFormView view) {
        Object positionId = view.getFormShowParameter().getCustomParam("positionid");
        if (!HRObjectUtils.isEmpty((Object)positionId)) {
            String positionName = (String)view.getFormShowParameter().getCustomParam("name");
            view.getModel().setValue("position", (Object)positionName);
            view.getModel().setValue("positionid", positionId);
        }
    }

    public static void refreshAppFileHeader(DynamicObject rsmDy, IFormView appFileView, IFormView currentView) {
        String headViewPageId = appFileView.getPageCache().get("tsirm_head_templatepageid");
        IFormView headView = appFileView.getView(headViewPageId);
        headView.invokeOperation("refresh");
        currentView.sendFormAction(headView);
        AppFileMService.showAppFilePortraitForm(appFileView, rsmDy.getLong("appfile"));
        currentView.sendFormAction(appFileView);
    }

    public static void handlerRsmExpInfo(AppResumeBo rsmBo, IPageCache pageCache) {
        for (String entityName : ResumeMetadataService.getAllEntry((String)"tsirm_srrsm", (String)"3")) {
            Object[] rsmExpArr = RsmService.getExpVeriableVlue(entityName, pageCache);
            ArrayList rsmExpList = Lists.newArrayList((Object[])rsmExpArr);
            List<DynamicObject> rsmExpSortList = RsmService.sortExpAndSetRsmInfo(rsmExpList, entityName, rsmBo);
            RsmService.setExpInfo(rsmBo, rsmExpSortList, entityName);
        }
    }

    public static void handlerRsmExpInfo(AppResumeBo rsmBo) {
        for (String entityName : ResumeMetadataService.getAllEntry((String)"tsirm_srrsm", (String)"3")) {
            List rsmExpList = rsmBo.getEntryListIR(entityName);
            List<DynamicObject> rsmExpSortList = RsmService.sortExpAndSetRsmInfo(rsmExpList, entityName, rsmBo);
            RsmService.setExpInfo(rsmBo, rsmExpSortList, entityName);
        }
    }

    private static List<DynamicObject> sortExpAndSetRsmInfo(List<DynamicObject> rsmExpList, String entityName, AppResumeBo rsmBo) {
        List<DynamicObject> rsmExpSortList = RsmCommonHelper.getAllExpSortList(0L, rsmExpList, entityName);
        if (rsmExpSortList != null && !rsmExpSortList.isEmpty()) {
            if ("tsirm_srrsmeduexp".equals(entityName)) {
                ResumeExpSortHelper.setHighestEduInfo(rsmExpSortList.get(0), rsmBo.getRsm());
            } else if ("tsirm_srrsmworkexp".equals(entityName)) {
                ResumeExpSortHelper.setRecentWorkInfo(rsmExpSortList.get(0), rsmBo.getRsm());
            }
        }
        return rsmExpSortList;
    }

    private static DynamicObject[] getExpVeriableVlue(String entityName, IPageCache pageCache) {
        String rsmExpStr = pageCache.get(entityName);
        if (HRStringUtils.isNotEmpty((String)rsmExpStr)) {
            DynamicObject[] rsmExpArr = (DynamicObject[])Arrays.stream(DynamicObjectSerializeUtil.deserialize((String)rsmExpStr, (DynamicObjectType)ServiceHelperCache.getHrBaseServiceHelper((String)entityName).generateEmptyDynamicObject().getDynamicObjectType())).toArray(DynamicObject[]::new);
            return ResumeUtilsHelper.copyDynamicObject(rsmExpArr, false);
        }
        return new DynamicObject[0];
    }

    public static void setExpInfo(AppResumeBo resumeBo, List<DynamicObject> expList, String entityName) {
        if (expList != null && !expList.isEmpty()) {
            DynamicObjectCollection expColl = new DynamicObjectCollection();
            long rsmId = resumeBo.getRsm().getLong("id");
            for (DynamicObject exp : expList) {
                exp.set("rsm", (Object)rsmId);
                exp.set("id", (Object)ID.genLongId());
                expColl.add((Object)exp);
            }
            resumeBo.setEntry(entityName, expColl);
        }
    }

    public static void cleanEntryData(IDataModel model) {
        DataEntityPropertyCollection depc = model.getDataEntityType().getProperties();
        for (IDataEntityProperty idep : depc) {
            String propName = idep.getName();
            if (propName.equals("resumelistlentryentity")) {
                int entrySize = model.getEntryEntity("resumelistlentryentity").size();
                int[] rows = new int[entrySize];
                for (int i = 0; i < entrySize; ++i) {
                    rows[i] = i;
                }
                model.deleteEntryRows("resumelistlentryentity", rows);
                continue;
            }
            model.setValue(propName, null);
        }
    }

    public static void previewResumeExit(IFormView view, JSONObject map) {
        String btnSign = map.getString("btnsign");
        if (HRStringUtils.equals((String)btnSign, (String)"btn_exit")) {
            String pageCacheId = map.getString("pagecacheid");
            int rowIndex = Integer.parseInt(map.getString("rowIndex"));
            String resume = view.getPageCache().get(pageCacheId);
            if (HRStringUtils.isNotEmpty((String)resume)) {
                IDataModel model = view.getModel();
                AppResumeBo resumeBo = (AppResumeBo)SerializationUtils.deSerializeFromBase64((String)resume);
                DynamicObject resumeDt = resumeBo.getRsm();
                model.setValue("pagecacheid", (Object)pageCacheId, rowIndex);
                model.setValue("fullname", (Object)resumeDt.getString("fullname"), rowIndex);
                model.setValue("phone", (Object)resumeDt.getString("phone"), rowIndex);
                model.setValue("email", (Object)resumeDt.getString("email"), rowIndex);
            }
        }
    }

    public static void previewResumeDelete(IFormView view, JSONObject map) {
        String btnSign = map.getString("btnsign");
        if (HRStringUtils.equals((String)btnSign, (String)"btn_delete")) {
            IDataModel model = view.getModel();
            String pageCacheId = map.getString("pagecacheid");
            int rowIndex = Integer.parseInt(map.getString("rowIndex"));
            model.deleteEntryRow("resumelistlentryentity", rowIndex);
            view.getPageCache().remove(pageCacheId);
            String resumePath = map.getString("resumestoadd");
            FileService fs = FileServiceFactory.getAttachmentFileService();
            fs.delete(resumePath);
        }
    }
}

