/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.rsm.unallocate;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mservice.PositionMService;
import kd.tsc.tsirm.business.domain.stdrsm.helper.BlacklistHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.StdRsmCommonService;
import kd.tsc.tsrbd.business.domain.label.service.LabelDataHelper;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbd.common.kdstring.TSCBaseKDString;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;

public class UnAllocateRsmHelper {
    private UnAllocateRsmHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static QFilter getUnAllocatedQFilter() {
        QFilter qFilter = new QFilter("delivery.assignstatus", "=", (Object)"0");
        if (!PermissionServiceHelper.isSuperUser((long)TSCRequestContext.getUserId())) {
            List<Long> hashPermPositionIds = PositionMService.getHashPermPositionIds();
            if (!hashPermPositionIds.isEmpty()) {
                String mailInfoSql = String.format(Locale.ROOT, "( select fmailinfoid from t_tsirm_posmailrel where fpositionid in (%s))", hashPermPositionIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
                QFilter positionMailQFilter = QFilter.sqlExpress((String)"delivery.emailsource", (String)"in", (String)mailInfoSql);
                qFilter.and(positionMailQFilter);
            } else {
                qFilter.and("1", "<>", (Object)1);
            }
        }
        String deleteStdRsmSql = String.format(Locale.ROOT, "(select fid from t_tsirm_stdrsm_a where fdatastatus <> '%s')", ResumeHisDataStatusEnum.DELETED.getStatus());
        qFilter.and(QFilter.sqlExpress((String)"stdrsm", (String)"in", (String)deleteStdRsmSql));
        return qFilter;
    }

    public static QFilter handleLinkWayFilter(Object linkWayValue) {
        if (linkWayValue instanceof String) {
            return UnAllocateRsmHelper.getLinkWayQFilter((String)linkWayValue);
        }
        if (linkWayValue instanceof List) {
            List linkWays = (List)linkWayValue;
            return linkWays.stream().map(UnAllocateRsmHelper::getLinkWayQFilter).reduce((q1, q2) -> q1.or(q2)).orElse(null);
        }
        return null;
    }

    private static QFilter getLinkWayQFilter(String linkWay) {
        switch (linkWay) {
            case "1": {
                return new QFilter("phone", "<>", (Object)"");
            }
            case "2": {
                return new QFilter("phone", "=", (Object)"");
            }
            case "3": {
                return new QFilter("email", "<>", (Object)"");
            }
            case "4": {
                return new QFilter("email", "=", (Object)"");
            }
        }
        return null;
    }

    public static void setCommonLabelQFilter(SetFilterEvent setFilterEvent, List<Object> rsmLabels) {
        String labelIdStr = rsmLabels.stream().map(Object::toString).filter(HRStringUtils::isNotEmpty).collect(Collectors.joining(","));
        String labelRangeResumeSQL = " ( select ftagobjid from t_tsirm_rsmlabel where flabelid in (" + labelIdStr + ") and ftagobjtypeid = " + LabelTagObjTypeEnum.IN_RESUME.getId() + " )";
        QFilter labelQFilter = QFilter.sqlExpress((String)"id", (String)"in", (String)labelRangeResumeSQL);
        setFilterEvent.getQFilters().add(labelQFilter);
    }

    public static QFilter getSchemaLabelQFilter(QFilter qFilter) {
        QFilter newCandidateSchameQfilter;
        qFilter.__setProperty("name");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbd_label");
        qFilter.and(LabelDataHelper.getLabelQfilter((List)Lists.newArrayList((Object[])new Long[]{LabelTagObjTypeEnum.IN_APPFILE.getId(), LabelTagObjTypeEnum.IN_RESUME.getId()})));
        DynamicObjectCollection labelColl = helper.queryOriginalCollection("id", qFilter.toArray());
        if (labelColl.isEmpty()) {
            newCandidateSchameQfilter = new QFilter("1", "!=", (Object)1);
        } else {
            String labelIdStr = labelColl.stream().map(dyo -> dyo.getString("id")).collect(Collectors.joining(","));
            String labelRangeResumeSQL = " ( select ftagobjid from t_tsirm_rsmlabel where flabelid in (" + labelIdStr + ") and ftagobjtypeid = " + LabelTagObjTypeEnum.IN_RESUME.getId() + " )";
            newCandidateSchameQfilter = QFilter.sqlExpress((String)"id", (String)"in", (String)labelRangeResumeSQL);
        }
        return newCandidateSchameQfilter;
    }

    public static void handleClosedCallback(AbstractFormPlugin plugin, ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        String actionId = closedCallBackEvent.getActionId();
        if ("tsirm_assignposition".equals(actionId)) {
            Object returnData2 = closedCallBackEvent.getReturnData();
            if (returnData2 != null && ((Boolean)returnData2).booleanValue()) {
                plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u804c\u4f4d\u6210\u529f\u3002", (String)"UnAllocateRsmHelper_2", (String)"tsc-tsirm-business", (Object[])new Object[0]));
                plugin.getView().invokeOperation("refresh");
            }
        } else if ("savetalent".equals(closedCallBackEvent.getActionId())) {
            List returnData3 = (List)closedCallBackEvent.getReturnData();
            if (returnData3 != null) {
                List<Long> candidateIds = returnData3.stream().map(Object::toString).map(Long::valueOf).collect(Collectors.toList());
                StdRsmCommonService.getInstance().selectTalentPool(plugin, candidateIds);
            }
        } else if ("tsirm_talenttreelistf7".equals(closedCallBackEvent.getActionId()) && (returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            StdRsmCommonService.getInstance().saveTalent(plugin, returnData);
        }
    }

    public static Set<Long> getBlackListSet(List<Long> rsmIdList) {
        Map<Long, String> stdRsmStatusMap = UnAllocateRsmHelper.getStdRsmStatusMap(rsmIdList);
        return stdRsmStatusMap.entrySet().stream().filter(entry -> ResumeHisDataStatusEnum.BLACK_LIST.getStatus().equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public static Map<Long, String> getStdRsmStatusMap(List<Long> rsmIdList) {
        QFilter qFilter = new QFilter("id", "in", rsmIdList);
        HRBaseServiceHelper rsmHelper = new HRBaseServiceHelper("tsirm_rsm");
        DynamicObjectCollection rsmColl = rsmHelper.queryOriginalCollection("id,stdrsm", qFilter.toArray());
        Map<Long, String> stdRsmDataStatusMap = StdRsmCommonService.getInstance().getStdRsmDataStatus(rsmColl.stream().map(dyo -> dyo.getLong("stdrsm")).collect(Collectors.toSet()));
        return rsmColl.stream().collect(Collectors.toMap(dyo -> dyo.getLong("id"), dyo -> (String)stdRsmDataStatusMap.get(dyo.getLong("stdrsm"))));
    }

    public static void showBlackListDetailPage(Long rsmId, IFormView view) {
        DynamicObject rsm = RsmHelper.findOne(rsmId);
        long stdRsmId = rsm.getLong("stdrsm");
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy(stdRsmId);
        BlacklistHelper.showBlacklistDetail(stdRsmDy.getLong("mid"), view);
    }

    public static void validateTalentRight(AbstractFormPlugin plugin, List<Long> selectPkIds, String pageNumber, String opSavetalent) {
        Map<Long, String> stdRsmStatusMap = UnAllocateRsmHelper.getStdRsmStatusMap(selectPkIds);
        if (!stdRsmStatusMap.containsValue(ResumeHisDataStatusEnum.DELETED.getStatus())) {
            StdRsmCommonService.getInstance().validateTalentRight(plugin, selectPkIds, pageNumber, opSavetalent);
        } else if (plugin instanceof AbstractListPlugin) {
            plugin.getView().showErrorNotification(TSCBaseKDString.dataChangedTip());
        } else {
            plugin.getView().getParentView().showErrorNotification(UnAllocateRsmHelper.getStdRsmChangeTip());
            plugin.getView().sendFormAction(plugin.getView().getParentView());
            plugin.getView().close();
        }
    }

    public static void assignPosition(List<Long> rsmIDList, AbstractFormPlugin plugin) {
        if (rsmIDList.isEmpty()) {
            return;
        }
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>(1);
        params.put("rsmIDList", rsmIDList);
        FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateFormShowParameter((String)"tsirm_assignposition", (boolean)true, params, (ShowType)ShowType.Modal, (CloseCallBack)new CloseCallBack((IFormPlugin)plugin, "tsirm_assignposition"));
        plugin.getView().showForm(formShowParameter);
    }

    public static String getStdRsmChangeTip() {
        return ResManager.loadKDString((String)"\u60a8\u65e0\u6cd5\u64cd\u4f5c\uff0c\u6807\u51c6\u7b80\u5386\u5df2\u5220\u9664\u3002", (String)"UnAllocateRsmHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]);
    }

    public static boolean validateIsRsmDelete(List<Long> rsmIdList, IFormView view, String errorTip) {
        Map<Long, String> stdRsmStatusMap = UnAllocateRsmHelper.getStdRsmStatusMap(rsmIdList);
        if (stdRsmStatusMap.containsValue(ResumeHisDataStatusEnum.DELETED.getStatus())) {
            if (HRStringUtils.isNotEmpty((String)errorTip)) {
                view.showErrorNotification(errorTip);
            }
            return true;
        }
        return false;
    }
}

