/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.detail;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.tsc.tsirm.business.domain.stdrsm.helper.ResumeAttentionHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.SimilarServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmBusiAppHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.util.CandidateDetailPageHelper;
import kd.tsc.tsirm.common.enums.stdrsm.ResumeAttentionEnum;
import kd.tsc.tsrbd.business.domain.headtemplate.AbstractHeaderService;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class StdRsmHeadService
extends AbstractHeaderService
implements Serializable {
    private static final long serialVersionUID = 1485513698899138090L;

    public List<String> getHideItemList(IFormView view) {
        view.setEnable(Boolean.valueOf(false), new String[]{"photo"});
        this.setPhotoHide(view, false);
        ArrayList hideItemList = Lists.newArrayList((Object[])new String[]{"flexpanelap14", "flexpanelap71", "flexpanelap711", "flexpanelap12", "flexpanelap13", "labelap3", "applyposition", "flexpanelap9", "flexpanelap7111"});
        Object stdRsmIdObj = view.getFormShowParameter().getCustomParam("id");
        Long stdRsmId = stdRsmIdObj == null ? null : Long.valueOf(Long.parseLong(stdRsmIdObj.toString()));
        List<Long> similars = SimilarServiceHelper.querySimilarList(stdRsmId);
        String isSimpleStdRsm = Optional.ofNullable(view.getFormShowParameter().getCustomParam("isSimpleStdRsm")).map(Object::toString).orElse(null);
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmByMid("tsirm_stdrsm", stdRsmId);
        String dataStatus = stdRsmDy.getString("datastatus");
        view.setVisible(Boolean.TRUE, new String[]{"flexpanelap7"});
        if (similars == null || similars.size() == 0 || null != isSimpleStdRsm) {
            hideItemList.add("flexpanelap7");
        } else {
            super.setStdRsmInfo(view, stdRsmId);
        }
        String resumeType = ResumeAttentionEnum.getNumberByName((String)"tsirm_candidate_detail");
        boolean isAttention = ResumeAttentionHelper.isAttention(stdRsmId, resumeType);
        HashMap ctrl = Maps.newHashMapWithExpectedSize((int)1);
        ctrl.put("vi", isAttention && null == isSimpleStdRsm);
        view.updateControlMetadata("flexpanelap73", (Map)ctrl);
        if (isSimpleStdRsm == null || !StringUtils.equals((CharSequence)ResumeHisDataStatusEnum.BLACK_LIST.getStatus(), (CharSequence)dataStatus)) {
            hideItemList.add("flexpanelap71");
        }
        if (StringUtils.equals((CharSequence)ResumeHisDataStatusEnum.BLACK_LIST.getStatus(), (CharSequence)dataStatus) || isSimpleStdRsm != null) {
            Image photo = (Image)view.getControl("photo");
            photo.hideTips();
            view.setEnable(Boolean.FALSE, new String[]{"photo"});
            hideItemList.add("flexpanelap10");
            hideItemList.add("labelap6");
        }
        return hideItemList;
    }

    public List<String> getClickListeners() {
        ArrayList clickItemList = Lists.newArrayList((Object[])new String[]{"flexpanelap7", "labelap", "vectorap", "flexpanelap10", "vectorap5", "flexpanelap71", "labelap1", "vectorap1"});
        return clickItemList;
    }

    public List<String> getItemClickListeners() {
        return null;
    }

    public void initData(IFormView view) {
        Long objId = (Long)view.getFormShowParameter().getCustomParam("id");
        CandidateDetailPageHelper.setHeaderInfo(view, objId);
        DynamicObject deliveryRecord = StdRsmBusiAppHelper.queryLatestDeliveryByStdRsmId(objId);
        if (ObjectUtils.isNotEmpty((Object)deliveryRecord)) {
            Date applyTime = deliveryRecord.getDate("applytime");
            DynamicObject recruChnlnm = deliveryRecord.getDynamicObject("recruchnlnm");
            view.getModel().getDataEntity().set("dlychannel", (Object)(recruChnlnm != null ? recruChnlnm.getString("name") : ""));
            String applyTimeStr = HRInteDateTimeUtil.formatDate((String)"tsirm_rdelivery", (String)"applytime", (Date)applyTime);
            view.getModel().getDataEntity().set("applytime", (Object)applyTimeStr);
        }
    }

    public void click(IFormView view, String key) {
        if (StringUtils.equals((CharSequence)"vectorap5", (CharSequence)key)) {
            this.openHeadInfoEditPage(view);
        } else if (StringUtils.equals((CharSequence)"labelap", (CharSequence)key) || StringUtils.equals((CharSequence)"vectorap", (CharSequence)key)) {
            this.openSuspectedPage(view);
        } else if (StringUtils.equals((CharSequence)"vectorap1", (CharSequence)key) || StringUtils.equals((CharSequence)"labelap1", (CharSequence)key)) {
            this.openBlacklistInfoPage(view);
        }
    }

    public void savePhoto(Object objId, String url) {
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy((Long)objId);
        stdRsmDy.set("photo", (Object)url);
        OperationServiceHelper.executeOperate((String)"customsave", (String)"tsirm_stdrsm", (DynamicObject[])new DynamicObject[]{stdRsmDy}, (OperateOption)OperateOption.create());
    }

    private void openHeadInfoEditPage(IFormView view) {
        Object stdRsmIdObj = view.getFormShowParameter().getCustomParam("id");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsirm_headedit");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("stdRsmId", stdRsmIdObj);
        view.showForm(showParameter);
    }

    private void openSuspectedPage(IFormView view) {
        Object stdRsmIdObj = view.getFormShowParameter().getCustomParam("id");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setPageId(view.getPageId() + "tsirm_suspected");
        formShowParameter.setFormId("tsirm_suspected");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("id", stdRsmIdObj);
        view.showForm(formShowParameter);
    }

    private void openBlacklistInfoPage(IFormView view) {
        Object stdRsmIdObj = view.getFormShowParameter().getCustomParam("id");
        Long stdRsmId = stdRsmIdObj == null ? null : Long.valueOf(Long.parseLong(stdRsmIdObj.toString()));
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("tsirm_blacklistdetail");
        fsp.setCaption(ResManager.loadKDString((String)"\u9ed1\u540d\u5355\u8be6\u60c5", (String)"StdRsmHeadService_0", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        fsp.getOpenStyle().setShowType(ShowType.NonModal);
        fsp.setCustomParam("stdrsm.id", (Object)stdRsmId);
        view.showForm(fsp);
    }
}

